/**
* katran API generated from katran.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


// TODO: Modify these methods with your own implementation


#include "Vip.h"
#include "Katran.h"

bool compareEndpoints(const katran::Endpoint& a, const katran::Endpoint& b) {
  return a.hash < b.hash;
};

using Guard = std::lock_guard<std::mutex>;

Vip::Vip(Katran &parent, uint32_t vipNum, const VipJsonObject &conf, const katran::KatranConfig &katranConfig)
    : VipBase(parent), vipNum_(vipNum), flagsAreSet_(false), vipFlags_(0), 
    chRingSize_(katranConfig.chRingSize),
    chRing_(katranConfig.chRingSize, -1) {
  
  if (conf.flagsIsSet()) {
    flagsAreSet_ = true;
    vipFlags_ = conf.getFlags();
  }

  address_ = conf.getAddress();
  port_ = conf.getPort();
  proto_ = conf.getProto();

  chash_ = katran::CHFactory::make(katranConfig.hashFunction);
  //addRealList(conf.getReal());
}

Vip::~Vip() {}

void Vip::updateVipMap(const ModifyAction &action) {
  auto vip_addr = katran::IpHelpers::parseAddrToBe(address_);
  katran::vip_definition vip_def = {};
  katran::vip_meta meta = {};

  meta.flags = vipFlags_;
  meta.vip_num = vipNum_;

  // if ((vip_addr.flags & katran::V6DADDR) > 0) {
  //   std::memcpy(vip_def.vipv6, vip_addr.v6daddr, 16);
  // } else {
    vip_def.vip = vip_addr.daddr;
  // }
  vip_def.port = folly::Endian::big(port_);
  vip_def.proto = Katran::vipProtoEnumToProtocolNumber(proto_);
  auto vipMapTable = parent_.get_hash_table<katran::vip_definition, katran::vip_meta>("vip_map");
  if (action == ModifyAction::ADD) {
    vipMapTable.set(vip_def, meta);
  } else {
    vipMapTable.remove(vip_def);
  }
}

std::string Vip::getAddress() {
  return address_;
}

uint16_t Vip::getPort() {
  return port_;
}

VipProtoEnum Vip::getProto() {
  return proto_;
}

uint32_t Vip::getFlags() {
  return vipFlags_;
}

uint32_t Vip::getVipNum() {
  return vipNum_;
}

void Vip::setFlags(const uint32_t &value) {
  throw std::runtime_error("Vip::setFlags: Method not implemented");
}

std::shared_ptr<VipReal> Vip::getReal(const std::string &address) {
  if (parent_.config_.disableForwarding) {
    logger()->error("Ignoring getReal call on non-forwarding instance");
    throw std::runtime_error("Ignoring getReal call on non-forwarding instance");
  }

  auto vip_reals_ids = getRealsAndWeight();
  int i = 0;

  std::shared_ptr<VipReal> vipReal = nullptr;
  for (auto real_id : vip_reals_ids) {
    folly::IPAddress addr(address);
    if (parent_.numToReals_[real_id.num] == addr) {
      VipRealJsonObject conf;
      conf.setIp(parent_.numToReals_[real_id.num].str());
      conf.setWeight(real_id.weight);
      conf.setFlags(parent_.reals_[parent_.numToReals_[real_id.num]].flags);

      vipReal = std::shared_ptr<VipReal>(new VipReal(*this, conf));
      break;
    }
    ++i;
  }

  if (vipReal == nullptr) {
    logger()->error("Unable to find a backend for this VIP with the requested address");
    throw std::runtime_error("Unable to find a backend for this VIP with the requested address");
  } else {
    return vipReal;
  }
}

std::vector<std::shared_ptr<VipReal>> Vip::getRealList() {
  if (parent_.config_.disableForwarding) {
    logger()->error("Ignoring getRealList call on non-forwarding instance");
    throw std::runtime_error("Ignoring getRealList call on non-forwarding instance");
  }

  auto vip_reals_ids = getRealsAndWeight();
  int i = 0;

  std::vector<std::shared_ptr<VipReal>> vipRealList(vip_reals_ids.size());
  for (auto real_id : vip_reals_ids) {
    VipRealJsonObject conf;
    conf.setIp(parent_.numToReals_[real_id.num].str());
    conf.setWeight(real_id.weight);
    conf.setFlags(parent_.reals_[parent_.numToReals_[real_id.num]].flags);

    vipRealList[i] = std::shared_ptr<VipReal>(new VipReal(*this, conf));
    ++i;
  }

  return vipRealList;
}

void Vip::addReal(const std::string &ip, const VipRealJsonObject &conf) {
  if (parent_.config_.disableForwarding) {
    logger()->error("Ignoring addReal call on non-forwarding instance");
    throw std::runtime_error("Ignoring addReal call on non-forwarding instance");
  }

  katran::NewReal real;
  real.address = ip;
  real.weight = conf.getWeight();
  real.flags = conf.getFlags();

  std::vector<katran::NewReal> reals;
  reals.push_back(real);

  modifyRealsForVip(ModifyAction::ADD, reals);
}

void Vip::delReal(const std::string &address) {
  if (parent_.config_.disableForwarding) {
    logger()->error("Ignoring delReal call on non-forwarding instance");
    throw std::runtime_error("Ignoring delReal call on non-forwarding instance");
  }

  katran::NewReal real;
  real.address = address;

  std::vector<katran::NewReal> reals;
  reals.push_back(real);

  modifyRealsForVip(ModifyAction::DEL, reals);
}

bool Vip::modifyRealsForVip(const ModifyAction &action, const std::vector<katran::NewReal>& reals) {
  Guard lock(parent_.giant_);

  UpdateReal ureal;
  std::vector<UpdateReal> ureals;
  ureal.action = action;

  auto cur_reals = getReals();

  for (const auto& real : reals) {
    folly::IPAddress raddr(real.address);
    logger()->info("Modifying real: {} with weight {} for vip {}:{}:{}",
        real.address,
        real.weight,
        address_,
        port_,
        VipJsonObject::VipProtoEnum_to_string(proto_));

    if (action == ModifyAction::DEL) {
      auto real_iter = parent_.reals_.find(raddr);
      if (real_iter == parent_.reals_.end()) {
        logger()->error("Trying to delete non-existing real");
        continue;
      }
      if (std::find(cur_reals.begin(), cur_reals.end(), real_iter->second.num) ==
          cur_reals.end()) {
        // this real doesn't belong to this vip
        logger()->info("Trying to delete non-existing real for the VIP: {}", address_);
        continue;
      }
      ureal.updatedReal.num = real_iter->second.num;
      parent_.decreaseRefCountForReal(raddr);
    } else {
      auto real_iter = parent_.reals_.find(raddr);
      if (real_iter != parent_.reals_.end()) {
        if (std::find(cur_reals.begin(), cur_reals.end(), real_iter->second.num) ==
            cur_reals.end()) {
          // increment ref count if it's a new real for this vip
          parent_.increaseRefCountForReal(raddr, real.flags);
          cur_reals.push_back(real_iter->second.num);
        }
        ureal.updatedReal.num = real_iter->second.num;
      } else {
        auto rnum = parent_.increaseRefCountForReal(raddr, real.flags);
        if (rnum == parent_.config_.maxReals) {
          logger()->info("Exhausted real's space");
          continue;
        }
        ureal.updatedReal.num = rnum;
      }
      ureal.updatedReal.weight = real.weight;
      ureal.updatedReal.hash = raddr.hash();
    }
    ureals.push_back(ureal);
  }

  auto ch_positions = batchRealsUpdate(ureals);
  auto vip_num = getVipNum();
  programHashRing(ch_positions, vip_num);
  return true;
}

void Vip::programHashRing(const std::vector<RealPos>& chPositions, const uint32_t vipNum) {
  if (!parent_.config_.testing) {
    auto chRingsTable = parent_.get_array_table<uint32_t>("ch_rings");
    uint32_t key;
    int res;
    for (auto pos : chPositions) {
      key = vipNum * parent_.config_.chRingSize + pos.pos;
      chRingsTable.set(key, pos.real);
    }
  }
}

std::vector<uint32_t> Vip::getReals() {
  std::vector<uint32_t> realNums(reals_.size());
  int i = 0;
  for (auto& r : reals_) {
    realNums[i++] = r.first;
  }
  return realNums;
}

std::vector<katran::Endpoint> Vip::getRealsAndWeight() {
  std::vector<katran::Endpoint> endpoints(reals_.size());
  katran::Endpoint endpoint;
  int i = 0;
  for (auto& r : reals_) {
    endpoint.num = r.first;
    endpoint.weight = r.second.weight;
    endpoint.hash = r.second.hash;
    endpoints[i++] = endpoint;
  }
  std::sort(endpoints.begin(), endpoints.end(), compareEndpoints);
  return endpoints;
}

std::vector<RealPos> Vip::batchRealsUpdate(std::vector<UpdateReal>& ureals) {
  auto endpoints = getEndpoints(ureals);
  return calculateHashRing(endpoints);
}

std::vector<RealPos> Vip::calculateHashRing(std::vector<katran::Endpoint> endpoints) {
  std::vector<RealPos> delta;
  RealPos new_pos;
  if (endpoints.size() != 0) {
    auto new_ch_ring = chash_->generateHashRing(endpoints, chRingSize_);

    // compare new and old ch rings. send back only delta between em.
    for (int i = 0; i < chRingSize_; i++) {
      if (new_ch_ring[i] != chRing_[i]) {
        new_pos.pos = i;
        new_pos.real = new_ch_ring[i];
        delta.push_back(new_pos);
        chRing_[i] = new_ch_ring[i];
      }
    }
  }
  return delta;
}

std::vector<katran::Endpoint> Vip::getEndpoints(std::vector<UpdateReal>& ureals) {
  katran::Endpoint endpoint;
  std::vector<katran::Endpoint> endpoints;
  bool reals_changed = false;

  for (auto& ureal : ureals) {
    if (ureal.action == ModifyAction::DEL) {
      reals_.erase(ureal.updatedReal.num);
      reals_changed = true;
    } else {
      auto cur_weight = reals_[ureal.updatedReal.num].weight;
      if (cur_weight != ureal.updatedReal.weight) {
        reals_[ureal.updatedReal.num].weight = ureal.updatedReal.weight;
        reals_[ureal.updatedReal.num].hash = ureal.updatedReal.hash;
        reals_changed = true;
      }
    }
  }

  if (reals_changed) {
    for (auto& real : reals_) {
      // skipping 0 weight
      if (real.second.weight != 0) {
        endpoint.num = real.first;
        endpoint.weight = real.second.weight;
        endpoint.hash = real.second.hash;
        endpoints.push_back(endpoint);
      };
    }
    std::sort(endpoints.begin(), endpoints.end(), compareEndpoints);
  }
  return endpoints;
};

// Basic default implementation, place your extension here (if needed)
void Vip::addRealList(const std::vector<VipRealJsonObject> &conf) {
  // call default implementation in base class
  VipBase::addRealList(conf);
}

// Basic default implementation, place your extension here (if needed)
void Vip::replaceReal(const std::string &ip, const VipRealJsonObject &conf) {
  // call default implementation in base class
  VipBase::replaceReal(ip, conf);
}

// Basic default implementation, place your extension here (if needed)
void Vip::delRealList() {
  // call default implementation in base class
  VipBase::delRealList();
}


