/**
* katran API generated from katran.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


#pragma once


#include "../base/KatranBase.h"

#include "Ports.h"
#include "Vip.h"

#include "BalancerStructs.h"
#include "KatranLbStructs.h"
#include <deque>
#include <unordered_map>

#include <folly/IPAddress.h>

namespace katran {
/**
 * position of elements inside control vector
 */
constexpr int kMacAddrPos = 0;
constexpr int kIpv4TunPos = 1;
constexpr int kIpv6TunPos = 2;
constexpr int kMainIntfPos = 3;
constexpr int kHcIntfPos = 4;
constexpr int kIntrospectionGkPos = 5;

/**
 * constants are from balancer_consts.h
 */
constexpr uint32_t kLruCntrOffset = 0;
constexpr uint32_t kLruMissOffset = 1;
constexpr uint32_t kLruFallbackOffset = 3;
constexpr uint32_t kIcmpTooBigOffset = 4;
constexpr uint32_t kLpmSrcOffset = 5;
constexpr uint32_t kInlineDecapOffset = 6;
constexpr uint32_t kQuicRoutingOffset = 7;
constexpr uint32_t kQuicCidVersionOffset = 8;
constexpr uint32_t kQuicCidDropOffset = 9;

/**
 * LRU map related constants
 */
constexpr int kFallbackLruSize = 1024;
constexpr int kMapNoFlags = 0;
constexpr int kMapNumaNode = 4;
constexpr int kNoNuma = -1;
}

using namespace polycube::service::model;

class Katran : public KatranBase {
  friend class Vip;
  friend class GeneralStats;
 public:
  Katran(const std::string name, const KatranJsonObject &conf);
  virtual ~Katran();

  void packet_in(Ports &port,
                 polycube::service::PacketInMetadata &md,
                 const std::vector<uint8_t> &packet) override;

  bool getDynOpt() override;

  /// <summary>
  /// Entry of the ports table
  /// </summary>
  std::shared_ptr<Ports> getPorts(const std::string &name) override;
  std::vector<std::shared_ptr<Ports>> getPortsList() override;
  void addPorts(const std::string &name, const PortsJsonObject &conf) override;
  void addPortsList(const std::vector<PortsJsonObject> &conf) override;
  void replacePorts(const std::string &name, const PortsJsonObject &conf) override;
  void delPorts(const std::string &name) override;
  void delPortsList() override;

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<GeneralStats> getGeneralStats() override;
  void addGeneralStats(const GeneralStatsJsonObject &value) override;
  void replaceGeneralStats(const GeneralStatsJsonObject &conf) override;
  void delGeneralStats() override;


  /// <summary>
  /// mac address of default router. katran &#39;offloads&#39; forwarding to the top of the rack switch (by simply sending everything to it by default).
  /// </summary>
  std::string getDefaultMac() override;
  void setDefaultMac(const std::string &value) override;

  /// <summary>
  /// Flag to indicate if healthchecking forwarding plane should be enabled or not.
  /// </summary>
  bool getEnableHc() override;
  void setEnableHc(const bool &value) override;

  /// <summary>
  /// Maximum number of VIPs supported by katran. It must be in sync with configuration of forwarding plane
  /// </summary>
  uint32_t getMaxVips() override;
  void setMaxVips(const uint32_t &value) override;

  /// <summary>
  /// Maximum number of Real servers. It must be in sync w/ configuration of forwarding plane.
  /// </summary>
  uint32_t getMaxReals() override;
  void setMaxReals(const uint32_t &value) override;

  /// <summary>
  /// Maximum number of Real servers. It must be in sync w/ configuration of forwarding plane.
  /// </summary>
  uint32_t getChRingSize() override;
  void setChRingSize(const uint32_t &value) override;

  /// <summary>
  /// ID of cpu cores which are responsible for the packet forwarding
  /// </summary>
  std::string getForwardingCores() override;
  void setForwardingCores(const std::string &value) override;

  /// <summary>
  /// ID of the numa node associated to the forwarding cores
  /// </summary>
  std::string getNumaNodes() override;
  void setNumaNodes(const std::string &value) override;

  /// <summary>
  /// The size of connection table (number of flows which we are going to track)
  /// </summary>
  uint64_t getLruSize() override;
  void setLruSize(const uint64_t &value) override;

  /// <summary>
  /// Services (i.e., virtual ip:protocol:port) exported to the client
  /// </summary>
  std::shared_ptr<Vip> getVip(const std::string &address, const uint16_t &port, const VipProtoEnum &proto) override;
  std::vector<std::shared_ptr<Vip>> getVipList() override;
  void addVip(const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const VipJsonObject &conf) override;
  void addVipList(const std::vector<VipJsonObject> &conf) override;
  void replaceVip(const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const VipJsonObject &conf) override;
  void delVip(const std::string &address, const uint16_t &port, const VipProtoEnum &proto) override;
  void delVipList() override;

  private:
  void configureBpfProgram();
  void initLrus();
  int createLruMap(int size, int flags, int numaNode, int core);
  void featureDiscovering();
  void setupGueEnvironment();
  void setMacInBPFProg();
  void attachLrus();
  void loadProgramWithNewSettings();
  static uint8_t vipProtoEnumToProtocolNumber(const VipProtoEnum &proto);
  static VipProtoEnum protocolNumberToVipProtoEnum(const uint8_t &proto);
  void decreaseRefCountForReal(const folly::IPAddress& real);
  uint32_t increaseRefCountForReal(const folly::IPAddress& real, uint8_t flags);
  void updateRealsMap(const folly::IPAddress& real, uint32_t num, uint8_t flags);
  void destroyFakeLru();
  std::vector<int32_t> parseIntLine(const std::string& line);

  private:
  static std::vector<std::string> COMPILE_FLAGS;

  bool alreadyConfigured_;


  unsigned int per_core_lru_size_;

  /**
   * main configurations of katran
   */
  katran::KatranConfig config_;

  /**
   * enabled optional features
   */
  katran::KatranFeatures features_;

  /**
   * vector of unused possitions for vips and reals. for each element
   * we are going to pop position's num from the vector. for deleted one -
   * push it back (so it could be reused in future)
   */
  std::deque<uint32_t> vipNums_;
  std::deque<uint32_t> realNums_;

  /**
   * vector of control elements (such as default's mac; ifindexes etc)
   */
  std::vector<katran::ctl_value> ctlValues_;

  /**
   * vector of LRU maps descriptors;
   */
  std::vector<int> lruMapsFd_;

  std::mutex giant_;

  std::unordered_map<katran::VipKey, Vip, katran::VipKeyHasher> vips_;

  /**
   * for reverse real's lookup. get real by num.
   * used when we are going to delete vip and coresponding reals.
   */
  std::unordered_map<uint32_t, folly::IPAddress> numToReals_;

  std::unordered_map<folly::IPAddress, katran::RealMeta> reals_;

  std::shared_ptr<GeneralStats> generalStats_;
};
