/**
* katran API generated from katran.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


// TODO: Modify these methods with your own implementation


#include "Katran.h"
#include "Katran_dp.h"
#include "Katran_dp_empty.h"
#include "Katran_config.h"
#include "BalancerStructs.h"
#include "libbpf.h"
#include "MacHelpers.h"

#include <algorithm>
#include <array>
#include <iterator>
#include <stdexcept>

#include <folly/Conv.h>
#include <folly/String.h>
#include <folly/init/Init.h>

std::vector<std::string> Katran::COMPILE_FLAGS = {
    std::string("-I") + std::string(KATRAN_EBPF_INCLUDE_PATH),
    std::string("-I") + std::string(LINUX_INCLUDE),
    std::string("-Wno-compare-distinct-pointer-types")
};

namespace {
constexpr uint8_t V6DADDR = 1;
constexpr int kDeleteXdpProg = -1;
constexpr int kMacBytes = 6;
constexpr int kCtlMapSize = 16;
constexpr int kLruPrototypePos = 0;
constexpr int kMaxForwardingCores = 128;
constexpr int kFirstElem = 0;
constexpr int kError = -1;
constexpr uint32_t kMaxQuicId = 0x00fffffe; // 2^24-1
constexpr uint32_t kDefaultStatsIndex = 0;
constexpr uint32_t kSrcV4Pos = 0;
constexpr uint32_t kSrcV6Pos = 1;
constexpr uint32_t kRecirculationIndex = 0;
constexpr uint32_t kHcSrcMacPos = 0;
constexpr uint32_t kHcDstMacPos = 1;
} // namespace

using Guard = std::lock_guard<std::mutex>;

Katran::Katran(const std::string name, const KatranJsonObject &conf)
  : Cube(conf.getBase(), { katran_code_empty }, {}, { }),
    KatranBase(name), alreadyConfigured_(false), ctlValues_(kCtlMapSize),
    lruMapsFd_(kMaxForwardingCores), per_core_lru_size_(katran::kDefaultLruSize),
    generalStats_(nullptr) {
  logger()->info("Creating Katran instance");

  //FIXME: This feature discovery is not working properly.
  // I need to change the way maps are checked into the DP
  //featureDiscovering();
  
  addPortsList(conf.getPorts());
  setDefaultMac(conf.getDefaultMac());
  //setEnableHc(conf.getEnableHc());
  setEnableHc(false);

  if (conf.maxVipsIsSet()) {
    setMaxVips(conf.getMaxVips());
  }

  if (conf.maxRealsIsSet()) {
    setMaxReals(conf.getMaxReals());
  }

  if (conf.chRingSizeIsSet()) {
    setChRingSize(conf.getChRingSize());
  }

  logger()->info("Setting forwarding cores");
  setForwardingCores(conf.getForwardingCores());
  if (conf.lruSizeIsSet()) {
    setLruSize(conf.getLruSize());
  }

  logger()->info("Forwarding cores set");

  GeneralStatsJsonObject emptyConfig;
  addGeneralStats(emptyConfig);

  if (conf.numaNodesIsSet()) {
    setNumaNodes(conf.getNumaNodes());
  } else {
    std::vector<int32_t> numa;
    config_.numaNodes = std::move(numa);
  }

  config_.hashFunction = katran::HashFunction::MaglevV2;

  configureBpfProgram();
  //addVipList(conf.getVip());
  loadProgramWithNewSettings();
  //destroyFakeLru();

  alreadyConfigured_ = true;
}


Katran::~Katran() {
  logger()->info("Destroying Katran instance");
}

void Katran::featureDiscovering() {
  try {
    auto table = get_hash_table<katran::v4_lpm_key, uint32_t>("routing_table");
    table.get_all();

    features_.srcRouting = true;
  } catch (std::exception &e){
    features_.srcRouting = false;
  }

  try {
    auto table = get_hash_table<katran::address, uint32_t>("decap_dst");
    table.get_all();

    features_.inlineDecap  = true;
  } catch (std::exception &e){
    features_.inlineDecap = false;
  }

  //FIXME: introspection is always disabled in this prototype
  features_.introspection = false;

  try {
    auto table = get_array_table<katran::real_definition>("pckt_srcs");
    table.get_all();

    features_.gueEncap = true;
  } catch (std::exception &e){
    features_.gueEncap = false;
  }

  features_.directHealthchecking = false;
}

void Katran::configureBpfProgram() {
  int res;

  if (!config_.disableForwarding) {
    initLrus();
  }

  if (!config_.disableForwarding && features_.gueEncap) {
    setupGueEnvironment();
  }
}

void Katran::loadProgramWithNewSettings() {
  std::vector<std::string> custom_cflags(Katran::COMPILE_FLAGS);
  std::string new_katran_code = katran_code;

  polycube::service::utils::replaceAll(new_katran_code, "_FAKE_LRU_SIZE_PLACEHOLDER_", std::to_string(per_core_lru_size_));
  polycube::service::utils::replaceAll(new_katran_code, "_DEFAULT_LRU_SIZE_PLACEHOLDER_", std::to_string(config_.LruSize));

  set_cflags(custom_cflags);
  reload(new_katran_code, 0, polycube::service::ProgramType::INGRESS);

  if (!config_.disableForwarding) {
    setMacInBPFProg();
  }

  // if (config_.enableHc) {
  //   std::vector<uint32_t> hc_ctl_keys = {katran::kMainIntfPos};
  //   if (config_.tunnelBasedHCEncap) {
  //     hc_ctl_keys.push_back(kIpv4TunPos);
  //     hc_ctl_keys.push_back(kIpv6TunPos);
  //   }
  //   for (auto ctl_key : hc_ctl_keys) {
  //     res = bpfAdapter_.bpfUpdateMap(
  //         bpfAdapter_.getMapFdByName("hc_ctrl_map"),
  //         &ctl_key,
  //         &ctlValues_[ctl_key].ifindex);

  //     if (res != 0) {
  //       throw std::invalid_argument(folly::sformat(
  //           "can't update ctrl map for hc program, error: {}",
  //           folly::errnoStr(errno)));
  //     }
  //   }
  //   if (features_.directHealthchecking) {
  //     setupHcEnvironment();
  //   }
  // }

  if (!config_.disableForwarding) {
    attachLrus();
  }

}

void Katran::attachLrus() {
  int map_fd, res, key;
  auto lruMappingTable = get_map_in_map_table("lru_mapping");
  for (const auto& core : config_.forwardingCores) {
    map_fd = lruMapsFd_[core];
    logger()->info("Setting core {0} with FD {1} in map in map", core, map_fd);
    bool res = lruMappingTable.update(core, map_fd);
    if (!res) {
      logger()->error("Error updating value of map {0}, reason {1}", lruMappingTable.get_fd(), std::strerror(errno));
      throw std::runtime_error("Error updating map value of lru_mapping");
    }
  }
}

void Katran::destroyFakeLru() {
  auto fakeLruMap = get_raw_table("fake_lru_map");

  if (close(fakeLruMap.get_fd()) < 0) {
    logger()->error("Unable to close fake_lru_map");
    throw std::runtime_error("Unable to close fake_lru_map");
  }
}

void Katran::setupGueEnvironment() {
  if (config_.katranSrcV4.empty() && config_.katranSrcV6.empty()) {
    throw std::runtime_error(
        "No source address provided to use as source GUE encapsulation");
  }
  if (!config_.katranSrcV4.empty()) {
    katran::real_definition value;

    value.dst = polycube::service::utils::ip_string_to_nbo_uint(config_.katranSrcV4);

    auto pcktSrcsTable = get_array_table<katran::real_definition>("pckt_srcs");
    pcktSrcsTable.set(kSrcV4Pos, value);
  } else {
    logger()->error("Empty IPV4 address provided to use as source in GUE encap");
  }

  if (!config_.katranSrcV6.empty()) {
    throw std::runtime_error("We do not support IPv6 right now");
  }
}

void Katran::packet_in(Ports &port,
    polycube::service::PacketInMetadata &md,
    const std::vector<uint8_t> &packet) {
  logger()->debug("Packet received from port {0}", port.name());
}

// Basic default implementation, place your extension here (if needed)
std::shared_ptr<Ports> Katran::getPorts(const std::string &name) {
  // call default implementation in base class
  return KatranBase::getPorts(name);
}

// Basic default implementation, place your extension here (if needed)
std::vector<std::shared_ptr<Ports>> Katran::getPortsList() {
  // call default implementation in base class
  return KatranBase::getPortsList();
}

// Basic default implementation, place your extension here (if needed)
void Katran::addPorts(const std::string &name, const PortsJsonObject &conf) {
  KatranBase::addPorts(name, conf);
}

// Basic default implementation, place your extension here (if needed)
void Katran::addPortsList(const std::vector<PortsJsonObject> &conf) {
  // call default implementation in base class
  KatranBase::addPortsList(conf);
}

// Basic default implementation, place your extension here (if needed)
void Katran::replacePorts(const std::string &name, const PortsJsonObject &conf) {
  // call default implementation in base class
  KatranBase::replacePorts(name, conf);
}

// Basic default implementation, place your extension here (if needed)
void Katran::delPorts(const std::string &name) {
  // call default implementation in base class
  KatranBase::delPorts(name);
}

// Basic default implementation, place your extension here (if needed)
void Katran::delPortsList() {
  // call default implementation in base class
  KatranBase::delPortsList();
}

std::string Katran::getDefaultMac() {
  return katran::convertMacToString(config_.defaultMac);
}

void Katran::setDefaultMac(const std::string &value) {
  config_.defaultMac = katran::convertMacToUint(value);
  katran::ctl_value ctl;

  for (int i = 0; i < 6; i++) {
      ctl.mac[i] = config_.defaultMac[i];
  }
  ctlValues_[katran::kMacAddrPos] = ctl;
  
  if (alreadyConfigured_) {
    setMacInBPFProg();
  }
}

void Katran::setMacInBPFProg() {
  katran::ctl_value &ctl = ctlValues_[katran::kMacAddrPos];
  if (!config_.disableForwarding) {
    auto ctlArrayTable = get_array_table<katran::ctl_value>("ctl_array");
    ctlArrayTable.set(katran::kMacAddrPos, ctl);
  }

  if (features_.directHealthchecking) {
    katran::hc_mac value;
    std::copy(std::begin(ctl.mac), std::end(ctl.mac), std::begin(value.mac));
    auto ctlArrayTable = get_array_table<katran::hc_mac>("hc_pckt_macs");
    ctlArrayTable.set(kHcDstMacPos, value);
  }
}

bool Katran::getEnableHc() {
  return config_.enableHc;
}

void Katran::setEnableHc(const bool &value) {
  if (value == true) {
    throw std::runtime_error("hc is not supported");
  } 
  config_.enableHc = false;
}

uint32_t Katran::getMaxVips() {
  return config_.maxVips;
}

bool Katran::getDynOpt() {
  return Cube::get_dyn_opt_enabled();
}

void Katran::setMaxVips(const uint32_t &value) {
  if (alreadyConfigured_) {
    throw std::runtime_error("It is not possible to change maxVips at runtime");
  }
  config_.maxVips = value;
  for (uint32_t i = 0; i < config_.maxVips; i++) {
    vipNums_.push_back(i);
  }
}

uint32_t Katran::getMaxReals() {
  return config_.maxReals;
}

void Katran::setMaxReals(const uint32_t &value) {
  if (alreadyConfigured_) {
    throw std::runtime_error("It is not possible to change maxReals at runtime");
  }
  config_.maxReals = value;
  for (uint32_t i = 0; i < config_.maxReals; i++) {
    realNums_.push_back(i);
  }
}

uint32_t Katran::getChRingSize() {
  return config_.chRingSize;
}

void Katran::setChRingSize(const uint32_t &value) {
  if (alreadyConfigured_) {
    throw std::runtime_error("It is not possible to change maxReals at runtime");
  }
  config_.chRingSize = value;
}

std::string Katran::getForwardingCores() {
  std::stringstream result;
  std::copy(config_.forwardingCores.begin(), config_.forwardingCores.end(), std::ostream_iterator<uint32_t>(result, ","));
  return result.str();
}

void Katran::setForwardingCores(const std::string &value) {
  if (alreadyConfigured_) {
    throw std::runtime_error("It is not possible to change forwardingCores at runtime");
  }
  config_.forwardingCores = parseIntLine(value);
}

std::string Katran::getNumaNodes() {
  std::stringstream result;
  std::copy(config_.numaNodes.begin(), config_.numaNodes.end(), std::ostream_iterator<uint32_t>(result, ","));
  return result.str();
}

void Katran::setNumaNodes(const std::string &value) {
  if (alreadyConfigured_) {
    throw std::runtime_error("It is not possible to change numaNodes at runtime");
  }
  config_.numaNodes = parseIntLine(value);
}

std::vector<int32_t> Katran::parseIntLine(const std::string& line) {
  std::vector<int32_t> nums;
  if (!line.empty()) {
    std::vector<std::string> splitedLine;
    folly::split(",", line, splitedLine);
    for (const auto& num_str : splitedLine) {
      auto num = folly::to<int32_t>(num_str);
      nums.push_back(num);
    }
  }
  return nums;
}

uint64_t Katran::getLruSize() {
  return config_.LruSize;
}

void Katran::setLruSize(const uint64_t &value) {
  if (alreadyConfigured_) {
    throw std::runtime_error("It is not possible to change forwardingCores at runtime");
  }
  config_.LruSize = value;
}

std::shared_ptr<Vip> Katran::getVip(const std::string &address, const uint16_t &port, const VipProtoEnum &proto) {  
  katran::VipKey key;
  key.address = address;
  key.port = port;
  key.proto = vipProtoEnumToProtocolNumber(proto);

  auto vip_iter = vips_.find(key);
  if (vip_iter == vips_.end()) {
    logger()->error("Trying to modify reals for non existing vip: {0}", key.address);
    throw std::runtime_error("Trying to modify reals for non existing vip");
  }

  return std::shared_ptr<Vip>(&vips_.at(key), [](Vip *) {});
}

std::vector<std::shared_ptr<Vip>> Katran::getVipList() {
  std::vector<std::shared_ptr<Vip>> vips_vect;

  for (auto &it : vips_) {
    katran::VipKey key = it.first;
    vips_vect.push_back(
        getVip(key.address, key.port, Katran::protocolNumberToVipProtoEnum(key.proto)));
  }

  return vips_vect;
}

uint8_t Katran::vipProtoEnumToProtocolNumber(const VipProtoEnum &proto) {
  switch (proto)
  {
  case VipProtoEnum::TCP:
    return 6;
  case VipProtoEnum::UDP:
    return 17;
  case VipProtoEnum::ICMP:
    return 1;
  default:
    return 255;
  }
}

VipProtoEnum Katran::protocolNumberToVipProtoEnum(const uint8_t &proto) {
  switch (proto) {
    case 6:
      return VipProtoEnum::TCP;
    case 17:
      return VipProtoEnum::UDP;
    case 1:
      return VipProtoEnum::ICMP;
    default:
      return VipProtoEnum::ALL;
  }
}

void Katran::addVip(const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const VipJsonObject &conf) {
  if (config_.disableForwarding) {
    logger()->error("Ignoring addVip call on non-forwarding instance");
    throw std::runtime_error("Ignoring addVip call on non-forwarding instance");
  }
  
  katran::VipKey key;
  key.address = address;
  key.port = port;
  key.proto = vipProtoEnumToProtocolNumber(proto);

  try {
    Guard lock(giant_);

    if (vipNums_.size() == 0) {
      logger()->error("Exhausted vip's space");
      throw std::runtime_error("Exhausted vip's space");
    }

    if (vips_.find(key) != vips_.end()) {
      logger()->error("Trying to add already existing vip");
      throw std::runtime_error("Trying to add already existing vip");
    }

    auto vip_num = vipNums_[0];
    vipNums_.pop_front();

    std::unordered_map<katran::VipKey, Vip, katran::VipKeyHasher>::iterator iter;
    bool inserted;

    std::tie(iter, inserted) =
        vips_.emplace(std::piecewise_construct, std::forward_as_tuple(key),
                            std::forward_as_tuple(*this, vip_num, conf, config_));
    if (!inserted) {
      throw std::runtime_error("Unable to create vip instance");
    }

    if (!config_.testing) {
      auto vip_iter = vips_.find(key);

      if (vip_iter == vips_.end()) {
        logger()->error("Trying to access a non-existing vip: {0}", key.address);
        throw std::runtime_error("Trying to access a non-existing vip");
      }
      vip_iter->second.updateVipMap(ModifyAction::ADD);

      logger()->info("Adding VIP {}:{}:{}",
        key.address,
        key.port,
        VipJsonObject::VipProtoEnum_to_string(proto));
    }
  } catch (const std::exception &e) {
    logger()->error("Exception while adding new vip: {0}", e.what());
    throw std::runtime_error("Error while adding a new vip: " + std::string(e.what()));
  }
}

void Katran::delVip(const std::string &address, const uint16_t &port, const VipProtoEnum &proto) {
  if (config_.disableForwarding) {
    logger()->error("Ignoring delVip call on non-forwarding instance");
    throw std::runtime_error("Ignoring delVip call on non-forwarding instance");
  }

  katran::VipKey key;
  key.address = address;
  key.port = port;
  key.proto = vipProtoEnumToProtocolNumber(proto);

  try {
    Guard lock(giant_);

    auto vip_iter = vips_.find(key);
    if (vip_iter == vips_.end()) {
      logger()->error("Trying to delete a non-existing vip: {0}", key.address);
      throw std::runtime_error("Trying to delete a non-existing vip");
    }

    auto vip_reals = vip_iter->second.getReals();
    // decreasing ref count for reals. delete em if it became 0
    for (auto& vip_real : vip_reals) {
      auto real_name = numToReals_[vip_real];
      decreaseRefCountForReal(real_name);
    }
    vipNums_.push_back(vip_iter->second.getVipNum());

    if (!config_.testing) {
      vip_iter->second.updateVipMap(ModifyAction::DEL);
    }

    vips_.erase(vip_iter);
    logger()->info("Remove VIP {}:{}:{}", key.address, key.port, VipJsonObject::VipProtoEnum_to_string(proto));
  } catch (const std::exception &e) {
    logger()->error("Exception while removing vip: {0}", e.what());
    throw std::runtime_error("Error while removing vip: " + std::string(e.what()));
  }
}

void Katran::decreaseRefCountForReal(const folly::IPAddress& real) {
  auto real_iter = reals_.find(real);
  if (real_iter == reals_.end()) {
    return;
  }
  real_iter->second.refCount--;
  if (real_iter->second.refCount == 0) {
    auto num = real_iter->second.num;
    // no more vips using this real
    realNums_.push_back(num);
    reals_.erase(real_iter);
    numToReals_.erase(num);
  }
}

uint32_t Katran::increaseRefCountForReal(const folly::IPAddress& real, uint8_t flags) {
  auto real_iter = reals_.find(real);
  flags &= ~katran::V6DADDR; // to keep IPv4/IPv6 specific flag
  if (real_iter != reals_.end()) {
    real_iter->second.refCount++;
    return real_iter->second.num;
  } else {
    if (realNums_.size() == 0) {
      return config_.maxReals;
    }
    katran::RealMeta rmeta;
    auto rnum = realNums_[0];
    realNums_.pop_front();
    numToReals_[rnum] = real;
    rmeta.refCount = 1;
    rmeta.num = rnum;
    rmeta.flags = flags;
    reals_[real] = rmeta;
    if (!config_.testing) {
      updateRealsMap(real, rnum, flags);
    }
    return rnum;
  }
}

void Katran::updateRealsMap(const folly::IPAddress& real, uint32_t num, uint8_t flags) {
  auto real_addr = katran::IpHelpers::parseAddrToBe(real);
  flags &= ~katran::V6DADDR; // to keep IPv4/IPv6 specific flag
  real_addr.flags |= flags;

  katran::real_definition real_def;
  real_def.flags = real_addr.flags;
  // if ((real_addr.flags & katran::V6DADDR) > 0) {
  //   std::memcpy(real_def.dstv6, real_addr.v6daddr, 16);
  // } else {
  real_def.dst = real_addr.daddr;
  // }

  auto realsTable = get_array_table<katran::real_definition>("reals");
  realsTable.set(num, real_def);
};

// Basic default implementation, place your extension here (if needed)
void Katran::addVipList(const std::vector<VipJsonObject> &conf) {
  // call default implementation in base class
  KatranBase::addVipList(conf);
}

// Basic default implementation, place your extension here (if needed)
void Katran::replaceVip(const std::string &address, const uint16_t &port, const VipProtoEnum &proto, const VipJsonObject &conf) {
  // call default implementation in base class
  KatranBase::replaceVip(address, port, proto, conf);
}

// Basic default implementation, place your extension here (if needed)
void Katran::delVipList() {
  // call default implementation in base class
  KatranBase::delVipList();
}


void Katran::initLrus() {
  bool forwarding_cores_specified{false};
  bool numa_mapping_specified{false};
  int lru_map_flags = 0;
  int res;
  if (config_.forwardingCores.size() != 0) {
    if (config_.numaNodes.size() != 0) {
      if (config_.numaNodes.size() != config_.forwardingCores.size()) {
        throw std::runtime_error(
            "numaNodes size mut be equal to forwardingCores");
      }
      numa_mapping_specified = true;
    }
    int lru_fd, numa_node;
    per_core_lru_size_ = config_.LruSize / config_.forwardingCores.size();
    logger()->info("per core lru size: {0}", per_core_lru_size_);
    for (int i = 0; i < config_.forwardingCores.size(); i++) {
      auto core = config_.forwardingCores[i];
      if ((core > kMaxForwardingCores) || core < 0) {
        logger()->critical("got core# {0}, which is not in supported range: [ 0: {1} ]", core, kMaxForwardingCores);
        throw std::runtime_error("unsuported number of forwarding cores");
      }
      if (numa_mapping_specified) {
        numa_node = config_.numaNodes[i];
        logger()->trace("Setting map to numa node: {0}", numa_node);
        lru_map_flags |= katran::kMapNumaNode;
      } else {
        numa_node = katran::kNoNuma;
      }
      logger()->trace("Create LRU map for core {0}", core);
      lru_fd = createLruMap(per_core_lru_size_, lru_map_flags, numa_node, core);
      logger()->info("Created LRU map for core {0} with fd {1}", core, lru_fd);
      if (lru_fd < 0) {
        logger()->critical("can't creat lru for core: {0}", core);
        throw std::runtime_error("can't create LRU for forwarding core");
      }
      lruMapsFd_[core] = lru_fd;
    }
    forwarding_cores_specified = true;
  }
}

int Katran::createLruMap(int size, int flags, int numaNode, int core) {
  std::string name = "katran_lru" + core;
  return bcc_create_map_node(BPF_MAP_TYPE_LRU_HASH, 
                             name.c_str(), 
                             sizeof(katran::flow_key), 
                             sizeof(katran::real_pos_lru),
                             size,
                             flags,
                             numaNode);
}

std::shared_ptr<GeneralStats> Katran::getGeneralStats() {
  //This object is only used to call the methods inside
  return generalStats_;
}

void Katran::addGeneralStats(const GeneralStatsJsonObject &value) {
  if (generalStats_ == nullptr) {
    generalStats_ = std::shared_ptr<GeneralStats>(new GeneralStats(*this, value));
  }
}

// Basic default implementation, place your extension here (if needed)
void Katran::replaceGeneralStats(const GeneralStatsJsonObject &conf) {
  // call default implementation in base class
  KatranBase::replaceGeneralStats(conf);
}

void Katran::delGeneralStats() {
  throw std::runtime_error("Katran::delGeneralStats: method not implemented");
}