/**
* k8switch API
* k8switch API generated from k8switch.yang
*
* OpenAPI spec version: 1.0.0
*
* NOTE: This class is auto generated by the swagger code generator program.
* https://github.com/polycube-network/swagger-codegen.git
* branch polycube
*/


/* Do not edit this file manually */

/*
* K8switchInterface.h
*
*
*/

#pragma once

#include "../serializer/K8switchJsonObject.h"

#include "../FwdTable.h"
#include "../Ports.h"
#include "../Service.h"

using namespace io::swagger::server::model;

class K8switchInterface {
public:

  virtual void update(const K8switchJsonObject &conf) = 0;
  virtual K8switchJsonObject toJsonObject() = 0;

  /// <summary>
  /// Entry of the ports table
  /// </summary>
  virtual std::shared_ptr<Ports> getPorts(const std::string &name) = 0;
  virtual std::vector<std::shared_ptr<Ports>> getPortsList() = 0;
  virtual void addPorts(const std::string &name, const PortsJsonObject &conf) = 0;
  virtual void addPortsList(const std::vector<PortsJsonObject> &conf) = 0;
  virtual void replacePorts(const std::string &name, const PortsJsonObject &conf) = 0;
  virtual void delPorts(const std::string &name) = 0;
  virtual void delPortsList() = 0;

  /// <summary>
  /// Range of VIPs where clusterIP services are exposed
  /// </summary>
  virtual std::string getClusterIpSubnet() = 0;
  virtual void setClusterIpSubnet(const std::string &value) = 0;

  /// <summary>
  /// Range of IPs of pods in this node
  /// </summary>
  virtual std::string getClientSubnet() = 0;
  virtual void setClientSubnet(const std::string &value) = 0;

  /// <summary>
  /// Range where client&#39;s IPs are mapped into
  /// </summary>
  virtual std::string getVirtualClientSubnet() = 0;
  virtual void setVirtualClientSubnet(const std::string &value) = 0;

  /// <summary>
  /// Services (i.e., virtual ip:protocol:port) exported to the client
  /// </summary>
  virtual std::shared_ptr<Service> getService(const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto) = 0;
  virtual std::vector<std::shared_ptr<Service>> getServiceList() = 0;
  virtual void addService(const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const ServiceJsonObject &conf) = 0;
  virtual void addServiceList(const std::vector<ServiceJsonObject> &conf) = 0;
  virtual void replaceService(const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const ServiceJsonObject &conf) = 0;
  virtual void delService(const std::string &vip,const uint16_t &vport,const ServiceProtoEnum &proto) = 0;
  virtual void delServiceList() = 0;

  /// <summary>
  /// Entry associated with the forwarding table
  /// </summary>
  virtual std::shared_ptr<FwdTable> getFwdTable(const std::string &address) = 0;
  virtual std::vector<std::shared_ptr<FwdTable>> getFwdTableList() = 0;
  virtual void addFwdTable(const std::string &address, const FwdTableJsonObject &conf) = 0;
  virtual void addFwdTableList(const std::vector<FwdTableJsonObject> &conf) = 0;
  virtual void replaceFwdTable(const std::string &address, const FwdTableJsonObject &conf) = 0;
  virtual void delFwdTable(const std::string &address) = 0;
  virtual void delFwdTableList() = 0;
};

