/**
* k8switch API
* k8switch API generated from k8switch.yang
*
* OpenAPI spec version: 1.0.0
*
* NOTE: This class is auto generated by the swagger code generator program.
* https://github.com/polycube-network/swagger-codegen.git
* branch polycube
*/


/* Do not edit this file manually */


#include "K8switchApiImpl.h"

namespace io {
namespace swagger {
namespace server {
namespace api {

using namespace io::swagger::server::model;

namespace K8switchApiImpl {
namespace {
std::unordered_map<std::string, std::shared_ptr<K8switch>> cubes;
std::mutex cubes_mutex;

std::shared_ptr<K8switch> get_cube(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  auto iter = cubes.find(name);
  if (iter == cubes.end()) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }

  return iter->second;
}

}

void create_k8switch_by_id(const std::string &name, const K8switchJsonObject &jsonObject) {
  {
    // check if name is valid before creating it
    std::lock_guard<std::mutex> guard(cubes_mutex);
    if (cubes.count(name) != 0) {
      throw std::runtime_error("There is already a cube with name " + name);
    }
  }
  auto ptr = std::make_shared<K8switch>(name, jsonObject);
  std::unordered_map<std::string, std::shared_ptr<K8switch>>::iterator iter;
  bool inserted;

  std::lock_guard<std::mutex> guard(cubes_mutex);
  std::tie(iter, inserted) = cubes.emplace(name, std::move(ptr));

  if (!inserted) {
    throw std::runtime_error("There is already a cube with name " + name);
  }
}

void replace_k8switch_by_id(const std::string &name, const K8switchJsonObject &bridge){
  throw std::runtime_error("Method not supported!");
}

void delete_k8switch_by_id(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  if (cubes.count(name) == 0) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }
  cubes.erase(name);
}

std::vector<K8switchJsonObject> read_k8switch_list_by_id() {
  std::vector<K8switchJsonObject> jsonObject_vect;
  for(auto &i : cubes) {
    auto m = get_cube(i.first);
    jsonObject_vect.push_back(m->toJsonObject());
  }
  return jsonObject_vect;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_k8switch_list_by_id_get_list() {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  for (auto &x : cubes) {
    nlohmann::fifo_map<std::string, std::string> m;
    m["name"] = x.first;
    r.push_back(std::move(m));
  }
  return r;
}

/**
* @brief   Create fwd-table by ID
*
* Create operation of resource: fwd-table*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] value fwd-tablebody object
*
* Responses:
*
*/
void
create_k8switch_fwd_table_by_id(const std::string &name, const std::string &address, const FwdTableJsonObject &value) {
  auto k8switch = get_cube(name);

  k8switch->addFwdTable(address, value);
}

/**
* @brief   Create fwd-table by ID
*
* Create operation of resource: fwd-table*
*
* @param[in] name ID of name
* @param[in] value fwd-tablebody object
*
* Responses:
*
*/
void
create_k8switch_fwd_table_list_by_id(const std::string &name, const std::vector<FwdTableJsonObject> &value) {
  auto k8switch = get_cube(name);
  k8switch->addFwdTableList(value);
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_k8switch_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto k8switch = get_cube(name);

  k8switch->addPorts(portsName, value);
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_k8switch_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  auto k8switch = get_cube(name);
  k8switch->addPortsList(value);
}

/**
* @brief   Create backend by ID
*
* Create operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] port ID of port
* @param[in] value backendbody object
*
* Responses:
*
*/
void
create_k8switch_service_backend_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const uint16_t &port, const ServiceBackendJsonObject &value) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);

  service->addBackend(ip, port, value);
}

/**
* @brief   Create backend by ID
*
* Create operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] value backendbody object
*
* Responses:
*
*/
void
create_k8switch_service_backend_list_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::vector<ServiceBackendJsonObject> &value) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);
  service->addBackendList(value);
}

/**
* @brief   Create service by ID
*
* Create operation of resource: service*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] value servicebody object
*
* Responses:
*
*/
void
create_k8switch_service_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const ServiceJsonObject &value) {
  auto k8switch = get_cube(name);

  k8switch->addService(vip, vport, proto, value);
}

/**
* @brief   Create service by ID
*
* Create operation of resource: service*
*
* @param[in] name ID of name
* @param[in] value servicebody object
*
* Responses:
*
*/
void
create_k8switch_service_list_by_id(const std::string &name, const std::vector<ServiceJsonObject> &value) {
  auto k8switch = get_cube(name);
  k8switch->addServiceList(value);
}

/**
* @brief   Delete fwd-table by ID
*
* Delete operation of resource: fwd-table*
*
* @param[in] name ID of name
* @param[in] address ID of address
*
* Responses:
*
*/
void
delete_k8switch_fwd_table_by_id(const std::string &name, const std::string &address) {
  auto k8switch = get_cube(name);

  k8switch->delFwdTable(address);
}

/**
* @brief   Delete fwd-table by ID
*
* Delete operation of resource: fwd-table*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_k8switch_fwd_table_list_by_id(const std::string &name) {
  auto k8switch = get_cube(name);
  k8switch->delFwdTableList();
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
*
*/
void
delete_k8switch_ports_by_id(const std::string &name, const std::string &portsName) {
  auto k8switch = get_cube(name);

  k8switch->delPorts(portsName);
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_k8switch_ports_list_by_id(const std::string &name) {
  auto k8switch = get_cube(name);
  k8switch->delPortsList();
}

/**
* @brief   Delete backend by ID
*
* Delete operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] port ID of port
*
* Responses:
*
*/
void
delete_k8switch_service_backend_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const uint16_t &port) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);

  service->delBackend(ip, port);
}

/**
* @brief   Delete backend by ID
*
* Delete operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
*
* Responses:
*
*/
void
delete_k8switch_service_backend_list_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);
  service->delBackendList();
}

/**
* @brief   Delete service by ID
*
* Delete operation of resource: service*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
*
* Responses:
*
*/
void
delete_k8switch_service_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto) {
  auto k8switch = get_cube(name);

  k8switch->delService(vip, vport, proto);
}

/**
* @brief   Delete service by ID
*
* Delete operation of resource: service*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_k8switch_service_list_by_id(const std::string &name) {
  auto k8switch = get_cube(name);
  k8switch->delServiceList();
}

/**
* @brief   Read k8switch by ID
*
* Read operation of resource: k8switch*
*
* @param[in] name ID of name
*
* Responses:
* K8switchJsonObject
*/
K8switchJsonObject
read_k8switch_by_id(const std::string &name) {
  return get_cube(name)->toJsonObject();

}

/**
* @brief   Read client-subnet by ID
*
* Read operation of resource: client-subnet*
*
* @param[in] name ID of name
*
* Responses:
* std::string
*/
std::string
read_k8switch_client_subnet_by_id(const std::string &name) {
  auto k8switch = get_cube(name);
  return k8switch->getClientSubnet();

}

/**
* @brief   Read cluster-ip-subnet by ID
*
* Read operation of resource: cluster-ip-subnet*
*
* @param[in] name ID of name
*
* Responses:
* std::string
*/
std::string
read_k8switch_cluster_ip_subnet_by_id(const std::string &name) {
  auto k8switch = get_cube(name);
  return k8switch->getClusterIpSubnet();

}

/**
* @brief   Read fwd-table by ID
*
* Read operation of resource: fwd-table*
*
* @param[in] name ID of name
* @param[in] address ID of address
*
* Responses:
* FwdTableJsonObject
*/
FwdTableJsonObject
read_k8switch_fwd_table_by_id(const std::string &name, const std::string &address) {
  auto k8switch = get_cube(name);
  return k8switch->getFwdTable(address)->toJsonObject();

}

/**
* @brief   Read fwd-table by ID
*
* Read operation of resource: fwd-table*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<FwdTableJsonObject>
*/
std::vector<FwdTableJsonObject>
read_k8switch_fwd_table_list_by_id(const std::string &name) {
  auto k8switch = get_cube(name);
  auto &&fwdTable = k8switch->getFwdTableList();
  std::vector<FwdTableJsonObject> m;
  for(auto &i : fwdTable)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read mac by ID
*
* Read operation of resource: mac*
*
* @param[in] name ID of name
* @param[in] address ID of address
*
* Responses:
* std::string
*/
std::string
read_k8switch_fwd_table_mac_by_id(const std::string &name, const std::string &address) {
  auto k8switch = get_cube(name);
  auto fwdTable = k8switch->getFwdTable(address);
  return fwdTable->getMac();

}

/**
* @brief   Read port by ID
*
* Read operation of resource: port*
*
* @param[in] name ID of name
* @param[in] address ID of address
*
* Responses:
* std::string
*/
std::string
read_k8switch_fwd_table_port_by_id(const std::string &name, const std::string &address) {
  auto k8switch = get_cube(name);
  auto fwdTable = k8switch->getFwdTable(address);
  return fwdTable->getPort();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsJsonObject
*/
PortsJsonObject
read_k8switch_ports_by_id(const std::string &name, const std::string &portsName) {
  auto k8switch = get_cube(name);
  return k8switch->getPorts(portsName)->toJsonObject();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<PortsJsonObject>
*/
std::vector<PortsJsonObject>
read_k8switch_ports_list_by_id(const std::string &name) {
  auto k8switch = get_cube(name);
  auto &&ports = k8switch->getPortsList();
  std::vector<PortsJsonObject> m;
  for(auto &i : ports)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read type by ID
*
* Read operation of resource: type*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsTypeEnum
*/
PortsTypeEnum
read_k8switch_ports_type_by_id(const std::string &name, const std::string &portsName) {
  auto k8switch = get_cube(name);
  auto ports = k8switch->getPorts(portsName);
  return ports->getType();

}

/**
* @brief   Read backend by ID
*
* Read operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] port ID of port
*
* Responses:
* ServiceBackendJsonObject
*/
ServiceBackendJsonObject
read_k8switch_service_backend_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const uint16_t &port) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);
  return service->getBackend(ip, port)->toJsonObject();

}

/**
* @brief   Read backend by ID
*
* Read operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
*
* Responses:
* std::vector<ServiceBackendJsonObject>
*/
std::vector<ServiceBackendJsonObject>
read_k8switch_service_backend_list_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);
  auto &&backend = service->getBackendList();
  std::vector<ServiceBackendJsonObject> m;
  for(auto &i : backend)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read name by ID
*
* Read operation of resource: name*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] port ID of port
*
* Responses:
* std::string
*/
std::string
read_k8switch_service_backend_name_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const uint16_t &port) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);
  auto backend = service->getBackend(ip, port);
  return backend->getName();

}

/**
* @brief   Read weight by ID
*
* Read operation of resource: weight*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] port ID of port
*
* Responses:
* uint16_t
*/
uint16_t
read_k8switch_service_backend_weight_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const uint16_t &port) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);
  auto backend = service->getBackend(ip, port);
  return backend->getWeight();

}

/**
* @brief   Read service by ID
*
* Read operation of resource: service*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
*
* Responses:
* ServiceJsonObject
*/
ServiceJsonObject
read_k8switch_service_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto) {
  auto k8switch = get_cube(name);
  return k8switch->getService(vip, vport, proto)->toJsonObject();

}

/**
* @brief   Read service by ID
*
* Read operation of resource: service*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<ServiceJsonObject>
*/
std::vector<ServiceJsonObject>
read_k8switch_service_list_by_id(const std::string &name) {
  auto k8switch = get_cube(name);
  auto &&service = k8switch->getServiceList();
  std::vector<ServiceJsonObject> m;
  for(auto &i : service)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read name by ID
*
* Read operation of resource: name*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
*
* Responses:
* std::string
*/
std::string
read_k8switch_service_name_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);
  return service->getName();

}

/**
* @brief   Read virtual-client-subnet by ID
*
* Read operation of resource: virtual-client-subnet*
*
* @param[in] name ID of name
*
* Responses:
* std::string
*/
std::string
read_k8switch_virtual_client_subnet_by_id(const std::string &name) {
  auto k8switch = get_cube(name);
  return k8switch->getVirtualClientSubnet();

}

/**
* @brief   Replace fwd-table by ID
*
* Replace operation of resource: fwd-table*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] value fwd-tablebody object
*
* Responses:
*
*/
void
replace_k8switch_fwd_table_by_id(const std::string &name, const std::string &address, const FwdTableJsonObject &value) {
  auto k8switch = get_cube(name);

  k8switch->replaceFwdTable(address, value);
}

/**
* @brief   Replace fwd-table by ID
*
* Replace operation of resource: fwd-table*
*
* @param[in] name ID of name
* @param[in] value fwd-tablebody object
*
* Responses:
*
*/
void
replace_k8switch_fwd_table_list_by_id(const std::string &name, const std::vector<FwdTableJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_k8switch_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto k8switch = get_cube(name);

  k8switch->replacePorts(portsName, value);
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_k8switch_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace backend by ID
*
* Replace operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] port ID of port
* @param[in] value backendbody object
*
* Responses:
*
*/
void
replace_k8switch_service_backend_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const uint16_t &port, const ServiceBackendJsonObject &value) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);

  service->replaceBackend(ip, port, value);
}

/**
* @brief   Replace backend by ID
*
* Replace operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] value backendbody object
*
* Responses:
*
*/
void
replace_k8switch_service_backend_list_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::vector<ServiceBackendJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace service by ID
*
* Replace operation of resource: service*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] value servicebody object
*
* Responses:
*
*/
void
replace_k8switch_service_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const ServiceJsonObject &value) {
  auto k8switch = get_cube(name);

  k8switch->replaceService(vip, vport, proto, value);
}

/**
* @brief   Replace service by ID
*
* Replace operation of resource: service*
*
* @param[in] name ID of name
* @param[in] value servicebody object
*
* Responses:
*
*/
void
replace_k8switch_service_list_by_id(const std::string &name, const std::vector<ServiceJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update k8switch by ID
*
* Update operation of resource: k8switch*
*
* @param[in] name ID of name
* @param[in] value k8switchbody object
*
* Responses:
*
*/
void
update_k8switch_by_id(const std::string &name, const K8switchJsonObject &value) {
  auto k8switch = get_cube(name);

  k8switch->update(value);
}

/**
* @brief   Update client-subnet by ID
*
* Update operation of resource: client-subnet*
*
* @param[in] name ID of name
* @param[in] value Range of IPs of pods in this node
*
* Responses:
*
*/
void
update_k8switch_client_subnet_by_id(const std::string &name, const std::string &value) {
  auto k8switch = get_cube(name);

  k8switch->setClientSubnet(value);
}

/**
* @brief   Update cluster-ip-subnet by ID
*
* Update operation of resource: cluster-ip-subnet*
*
* @param[in] name ID of name
* @param[in] value Range of VIPs where clusterIP services are exposed
*
* Responses:
*
*/
void
update_k8switch_cluster_ip_subnet_by_id(const std::string &name, const std::string &value) {
  auto k8switch = get_cube(name);

  k8switch->setClusterIpSubnet(value);
}

/**
* @brief   Update fwd-table by ID
*
* Update operation of resource: fwd-table*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] value fwd-tablebody object
*
* Responses:
*
*/
void
update_k8switch_fwd_table_by_id(const std::string &name, const std::string &address, const FwdTableJsonObject &value) {
  auto k8switch = get_cube(name);
  auto fwdTable = k8switch->getFwdTable(address);

  fwdTable->update(value);
}

/**
* @brief   Update fwd-table by ID
*
* Update operation of resource: fwd-table*
*
* @param[in] name ID of name
* @param[in] value fwd-tablebody object
*
* Responses:
*
*/
void
update_k8switch_fwd_table_list_by_id(const std::string &name, const std::vector<FwdTableJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update mac by ID
*
* Update operation of resource: mac*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] value Destination MAC address
*
* Responses:
*
*/
void
update_k8switch_fwd_table_mac_by_id(const std::string &name, const std::string &address, const std::string &value) {
  auto k8switch = get_cube(name);
  auto fwdTable = k8switch->getFwdTable(address);

  fwdTable->setMac(value);
}

/**
* @brief   Update port by ID
*
* Update operation of resource: port*
*
* @param[in] name ID of name
* @param[in] address ID of address
* @param[in] value Port where this entry is present
*
* Responses:
*
*/
void
update_k8switch_fwd_table_port_by_id(const std::string &name, const std::string &address, const std::string &value) {
  auto k8switch = get_cube(name);
  auto fwdTable = k8switch->getFwdTable(address);

  fwdTable->setPort(value);
}

/**
* @brief   Update k8switch by ID
*
* Update operation of resource: k8switch*
*
* @param[in] value k8switchbody object
*
* Responses:
*
*/
void
update_k8switch_list_by_id(const std::vector<K8switchJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_k8switch_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto k8switch = get_cube(name);
  auto ports = k8switch->getPorts(portsName);

  ports->update(value);
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_k8switch_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update backend by ID
*
* Update operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] port ID of port
* @param[in] value backendbody object
*
* Responses:
*
*/
void
update_k8switch_service_backend_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const uint16_t &port, const ServiceBackendJsonObject &value) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);
  auto backend = service->getBackend(ip, port);

  backend->update(value);
}

/**
* @brief   Update backend by ID
*
* Update operation of resource: backend*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] value backendbody object
*
* Responses:
*
*/
void
update_k8switch_service_backend_list_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::vector<ServiceBackendJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update name by ID
*
* Update operation of resource: name*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] port ID of port
* @param[in] value name
*
* Responses:
*
*/
void
update_k8switch_service_backend_name_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const uint16_t &port, const std::string &value) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);
  auto backend = service->getBackend(ip, port);

  backend->setName(value);
}

/**
* @brief   Update weight by ID
*
* Update operation of resource: weight*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] ip ID of ip
* @param[in] port ID of port
* @param[in] value Weight of the backend in the pool
*
* Responses:
*
*/
void
update_k8switch_service_backend_weight_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &ip, const uint16_t &port, const uint16_t &value) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);
  auto backend = service->getBackend(ip, port);

  backend->setWeight(value);
}

/**
* @brief   Update service by ID
*
* Update operation of resource: service*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] value servicebody object
*
* Responses:
*
*/
void
update_k8switch_service_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const ServiceJsonObject &value) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);

  service->update(value);
}

/**
* @brief   Update service by ID
*
* Update operation of resource: service*
*
* @param[in] name ID of name
* @param[in] value servicebody object
*
* Responses:
*
*/
void
update_k8switch_service_list_by_id(const std::string &name, const std::vector<ServiceJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update name by ID
*
* Update operation of resource: name*
*
* @param[in] name ID of name
* @param[in] vip ID of vip
* @param[in] vport ID of vport
* @param[in] proto ID of proto
* @param[in] value Service name related to the backend server of the pool is connected to
*
* Responses:
*
*/
void
update_k8switch_service_name_by_id(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto, const std::string &value) {
  auto k8switch = get_cube(name);
  auto service = k8switch->getService(vip, vport, proto);

  service->setName(value);
}

/**
* @brief   Update virtual-client-subnet by ID
*
* Update operation of resource: virtual-client-subnet*
*
* @param[in] name ID of name
* @param[in] value Range where client&#39;s IPs are mapped into
*
* Responses:
*
*/
void
update_k8switch_virtual_client_subnet_by_id(const std::string &name, const std::string &value) {
  auto k8switch = get_cube(name);

  k8switch->setVirtualClientSubnet(value);
}



/*
 * help related
 */

std::vector<nlohmann::fifo_map<std::string, std::string>> read_k8switch_fwd_table_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&k8switch = get_cube(name);

  auto &&fwdTable = k8switch->getFwdTableList();
  for(auto &i : fwdTable) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["address"] = i->getAddress();

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_k8switch_ports_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&k8switch = get_cube(name);

  auto &&ports = k8switch->getPortsList();
  for(auto &i : ports) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["name"] = i->getName();

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_k8switch_service_backend_list_by_id_get_list(const std::string &name, const std::string &vip, const uint16_t &vport, const ServiceProtoEnum &proto) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&k8switch = get_cube(name);
  auto &&service = k8switch->getService(vip, vport, proto);

  auto &&backend = service->getBackendList();
  for(auto &i : backend) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["ip"] = i->getIp();
    keys["port"] = std::to_string(i->getPort());

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_k8switch_service_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&k8switch = get_cube(name);

  auto &&service = k8switch->getServiceList();
  for(auto &i : service) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["vip"] = i->getVip();
    keys["vport"] = std::to_string(i->getVport());
    keys["proto"] = ServiceJsonObject::ServiceProtoEnum_to_string(i->getProto());

    r.push_back(keys);
  }
  return r;
}


}

}
}
}
}

