/**
* k8switch API
* k8switch API generated from k8switch.yang
*
* OpenAPI spec version: 1.0.0
*
* NOTE: This class is auto generated by the swagger code generator program.
* https://github.com/polycube-network/swagger-codegen.git
* branch polycube
*/


/* Do not edit this file manually */


#include "K8switchApi.h"
#include "K8switchApiImpl.h"

using namespace io::swagger::server::model;
using namespace io::swagger::server::api::K8switchApiImpl;

#ifdef __cplusplus
extern "C" {
#endif

Response create_k8switch_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    K8switchJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    create_k8switch_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_k8switch_fwd_table_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    FwdTableJsonObject unique_value { request_body };

    unique_value.setAddress(unique_address);
    create_k8switch_fwd_table_by_id(unique_name, unique_address, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_k8switch_fwd_table_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<FwdTableJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<FwdTableJsonObject> unique_value;
    for (auto &j : request_body) {
      FwdTableJsonObject a { j };
      unique_value.push_back(a);
    }
    create_k8switch_fwd_table_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_k8switch_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    create_k8switch_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_k8switch_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    create_k8switch_ports_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_k8switch_service_backend_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ServiceBackendJsonObject unique_value { request_body };

    unique_value.setIp(unique_ip);
    unique_value.setPort(unique_port);
    create_k8switch_service_backend_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_port, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_k8switch_service_backend_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  // Getting the body param
  std::vector<ServiceBackendJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ServiceBackendJsonObject> unique_value;
    for (auto &j : request_body) {
      ServiceBackendJsonObject a { j };
      unique_value.push_back(a);
    }
    create_k8switch_service_backend_list_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_k8switch_service_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ServiceJsonObject unique_value { request_body };

    unique_value.setVip(unique_vip);
    unique_value.setVport(unique_vport);
    unique_value.setProto(unique_proto_);
    create_k8switch_service_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_k8switch_service_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<ServiceJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ServiceJsonObject> unique_value;
    for (auto &j : request_body) {
      ServiceJsonObject a { j };
      unique_value.push_back(a);
    }
    create_k8switch_service_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_k8switch_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_k8switch_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_k8switch_fwd_table_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    delete_k8switch_fwd_table_by_id(unique_name, unique_address);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_k8switch_fwd_table_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_k8switch_fwd_table_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_k8switch_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    delete_k8switch_ports_by_id(unique_name, unique_portsName);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_k8switch_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_k8switch_ports_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_k8switch_service_backend_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }


  try {
    delete_k8switch_service_backend_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_port);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_k8switch_service_backend_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {
    delete_k8switch_service_backend_list_by_id(unique_name, unique_vip, unique_vport, unique_proto_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_k8switch_service_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {
    delete_k8switch_service_by_id(unique_name, unique_vip, unique_vport, unique_proto_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_k8switch_service_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_k8switch_service_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_k8switch_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_client_subnet_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_k8switch_client_subnet_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_cluster_ip_subnet_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_k8switch_cluster_ip_subnet_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_fwd_table_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_k8switch_fwd_table_by_id(unique_name, unique_address);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_fwd_table_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_k8switch_fwd_table_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_fwd_table_mac_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_k8switch_fwd_table_mac_by_id(unique_name, unique_address);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_fwd_table_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_k8switch_fwd_table_port_by_id(unique_name, unique_address);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {


  try {

    auto x = read_k8switch_list_by_id();
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_k8switch_ports_by_id(unique_name, unique_portsName);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_k8switch_ports_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_ports_type_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_k8switch_ports_type_by_id(unique_name, unique_portsName);
    nlohmann::json response_body;
    response_body = PortsJsonObject::PortsTypeEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_service_backend_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }


  try {

    auto x = read_k8switch_service_backend_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_port);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_service_backend_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {

    auto x = read_k8switch_service_backend_list_by_id(unique_name, unique_vip, unique_vport, unique_proto_);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_service_backend_name_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }


  try {

    auto x = read_k8switch_service_backend_name_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_port);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_service_backend_weight_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }


  try {

    auto x = read_k8switch_service_backend_weight_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_port);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_service_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {

    auto x = read_k8switch_service_by_id(unique_name, unique_vip, unique_vport, unique_proto_);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_service_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_k8switch_service_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_service_name_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {

    auto x = read_k8switch_service_name_by_id(unique_name, unique_vip, unique_vport, unique_proto_);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_k8switch_virtual_client_subnet_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_k8switch_virtual_client_subnet_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_k8switch_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    K8switchJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    replace_k8switch_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_k8switch_fwd_table_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    FwdTableJsonObject unique_value { request_body };

    unique_value.setAddress(unique_address);
    replace_k8switch_fwd_table_by_id(unique_name, unique_address, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_k8switch_fwd_table_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<FwdTableJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<FwdTableJsonObject> unique_value;
    for (auto &j : request_body) {
      FwdTableJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_k8switch_fwd_table_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_k8switch_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    replace_k8switch_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_k8switch_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_k8switch_ports_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_k8switch_service_backend_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ServiceBackendJsonObject unique_value { request_body };

    unique_value.setIp(unique_ip);
    unique_value.setPort(unique_port);
    replace_k8switch_service_backend_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_port, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_k8switch_service_backend_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  // Getting the body param
  std::vector<ServiceBackendJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ServiceBackendJsonObject> unique_value;
    for (auto &j : request_body) {
      ServiceBackendJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_k8switch_service_backend_list_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_k8switch_service_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ServiceJsonObject unique_value { request_body };

    unique_value.setVip(unique_vip);
    unique_value.setVport(unique_vport);
    unique_value.setProto(unique_proto_);
    replace_k8switch_service_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_k8switch_service_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<ServiceJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ServiceJsonObject> unique_value;
    for (auto &j : request_body) {
      ServiceJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_k8switch_service_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    K8switchJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    update_k8switch_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_client_subnet_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_k8switch_client_subnet_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_cluster_ip_subnet_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_k8switch_cluster_ip_subnet_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_fwd_table_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    FwdTableJsonObject unique_value { request_body };

    unique_value.setAddress(unique_address);
    update_k8switch_fwd_table_by_id(unique_name, unique_address, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_fwd_table_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<FwdTableJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<FwdTableJsonObject> unique_value;
    for (auto &j : request_body) {
      FwdTableJsonObject a { j };
      unique_value.push_back(a);
    }
    update_k8switch_fwd_table_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_fwd_table_mac_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_k8switch_fwd_table_mac_by_id(unique_name, unique_address, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_fwd_table_port_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_address;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "address")) {
      unique_address = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_k8switch_fwd_table_port_by_id(unique_name, unique_address, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {

  // Getting the body param
  std::vector<K8switchJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<K8switchJsonObject> unique_value;
    for (auto &j : request_body) {
      K8switchJsonObject a { j };
      unique_value.push_back(a);
    }
    update_k8switch_list_by_id(unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    update_k8switch_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    update_k8switch_ports_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}


Response update_k8switch_service_backend_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ServiceBackendJsonObject unique_value { request_body };

    unique_value.setIp(unique_ip);
    unique_value.setPort(unique_port);
    update_k8switch_service_backend_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_port, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_service_backend_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  // Getting the body param
  std::vector<ServiceBackendJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ServiceBackendJsonObject> unique_value;
    for (auto &j : request_body) {
      ServiceBackendJsonObject a { j };
      unique_value.push_back(a);
    }
    update_k8switch_service_backend_list_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_service_backend_name_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_k8switch_service_backend_name_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_port, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_service_backend_weight_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  std::string unique_ip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ip")) {
      unique_ip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_port;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "port")) {
      unique_port = keys[i].value.uint16;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    uint16_t unique_value = request_body;
    update_k8switch_service_backend_weight_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_ip, unique_port, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_service_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ServiceJsonObject unique_value { request_body };

    unique_value.setVip(unique_vip);
    unique_value.setVport(unique_vport);
    unique_value.setProto(unique_proto_);
    update_k8switch_service_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_service_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<ServiceJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ServiceJsonObject> unique_value;
    for (auto &j : request_body) {
      ServiceJsonObject a { j };
      unique_value.push_back(a);
    }
    update_k8switch_service_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_service_name_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_k8switch_service_name_by_id(unique_name, unique_vip, unique_vport, unique_proto_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_k8switch_virtual_client_subnet_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_k8switch_virtual_client_subnet_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}


Response k8switch_fwd_table_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_k8switch_fwd_table_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response k8switch_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {

  nlohmann::json val = read_k8switch_list_by_id_get_list();

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response k8switch_ports_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_k8switch_ports_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response k8switch_service_backend_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_vip;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vip")) {
      unique_vip = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_vport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "vport")) {
      unique_vport = keys[i].value.uint16;
      break;
    }
  }

  std::string unique_proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "proto")) {
      unique_proto = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_proto_ = ServiceJsonObject::string_to_ServiceProtoEnum(unique_proto);

  nlohmann::json val = read_k8switch_service_backend_list_by_id_get_list(unique_name, unique_vip, unique_vport, unique_proto_);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response k8switch_service_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_k8switch_service_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

#ifdef __cplusplus
}
#endif

