/**
* k8sfilter API
* k8sfilter API generated from k8sfilter.yang
*
* OpenAPI spec version: 1.0.0
*
* NOTE: This class is auto generated by the swagger code generator program.
* https://github.com/polycube-network/swagger-codegen.git
* branch polycube
*/


/* Do not edit this file manually */


#include "K8sfilterApiImpl.h"

namespace io {
namespace swagger {
namespace server {
namespace api {

using namespace io::swagger::server::model;

namespace K8sfilterApiImpl {
namespace {
std::unordered_map<std::string, std::shared_ptr<K8sfilter>> cubes;
std::mutex cubes_mutex;

std::shared_ptr<K8sfilter> get_cube(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  auto iter = cubes.find(name);
  if (iter == cubes.end()) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }

  return iter->second;
}

}

void create_k8sfilter_by_id(const std::string &name, const K8sfilterJsonObject &jsonObject) {
  {
    // check if name is valid before creating it
    std::lock_guard<std::mutex> guard(cubes_mutex);
    if (cubes.count(name) != 0) {
      throw std::runtime_error("There is already a cube with name " + name);
    }
  }
  auto ptr = std::make_shared<K8sfilter>(name, jsonObject);
  std::unordered_map<std::string, std::shared_ptr<K8sfilter>>::iterator iter;
  bool inserted;

  std::lock_guard<std::mutex> guard(cubes_mutex);
  std::tie(iter, inserted) = cubes.emplace(name, std::move(ptr));

  if (!inserted) {
    throw std::runtime_error("There is already a cube with name " + name);
  }
}

void replace_k8sfilter_by_id(const std::string &name, const K8sfilterJsonObject &bridge){
  throw std::runtime_error("Method not supported!");
}

void delete_k8sfilter_by_id(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  if (cubes.count(name) == 0) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }
  cubes.erase(name);
}

std::vector<K8sfilterJsonObject> read_k8sfilter_list_by_id() {
  std::vector<K8sfilterJsonObject> jsonObject_vect;
  for(auto &i : cubes) {
    auto m = get_cube(i.first);
    jsonObject_vect.push_back(m->toJsonObject());
  }
  return jsonObject_vect;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_k8sfilter_list_by_id_get_list() {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  for (auto &x : cubes) {
    nlohmann::fifo_map<std::string, std::string> m;
    m["name"] = x.first;
    r.push_back(std::move(m));
  }
  return r;
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_k8sfilter_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto k8sfilter = get_cube(name);

  k8sfilter->addPorts(portsName, value);
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_k8sfilter_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  auto k8sfilter = get_cube(name);
  k8sfilter->addPortsList(value);
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
*
*/
void
delete_k8sfilter_ports_by_id(const std::string &name, const std::string &portsName) {
  auto k8sfilter = get_cube(name);

  k8sfilter->delPorts(portsName);
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_k8sfilter_ports_list_by_id(const std::string &name) {
  auto k8sfilter = get_cube(name);
  k8sfilter->delPortsList();
}

/**
* @brief   Read k8sfilter by ID
*
* Read operation of resource: k8sfilter*
*
* @param[in] name ID of name
*
* Responses:
* K8sfilterJsonObject
*/
K8sfilterJsonObject
read_k8sfilter_by_id(const std::string &name) {
  return get_cube(name)->toJsonObject();

}

/**
* @brief   Read nodeport-range by ID
*
* Read operation of resource: nodeport-range*
*
* @param[in] name ID of name
*
* Responses:
* std::string
*/
std::string
read_k8sfilter_nodeport_range_by_id(const std::string &name) {
  auto k8sfilter = get_cube(name);
  return k8sfilter->getNodeportRange();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsJsonObject
*/
PortsJsonObject
read_k8sfilter_ports_by_id(const std::string &name, const std::string &portsName) {
  auto k8sfilter = get_cube(name);
  return k8sfilter->getPorts(portsName)->toJsonObject();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<PortsJsonObject>
*/
std::vector<PortsJsonObject>
read_k8sfilter_ports_list_by_id(const std::string &name) {
  auto k8sfilter = get_cube(name);
  auto &&ports = k8sfilter->getPortsList();
  std::vector<PortsJsonObject> m;
  for(auto &i : ports)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read type by ID
*
* Read operation of resource: type*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsTypeEnum
*/
PortsTypeEnum
read_k8sfilter_ports_type_by_id(const std::string &name, const std::string &portsName) {
  auto k8sfilter = get_cube(name);
  auto ports = k8sfilter->getPorts(portsName);
  return ports->getType();

}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_k8sfilter_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto k8sfilter = get_cube(name);

  k8sfilter->replacePorts(portsName, value);
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_k8sfilter_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update k8sfilter by ID
*
* Update operation of resource: k8sfilter*
*
* @param[in] name ID of name
* @param[in] value k8sfilterbody object
*
* Responses:
*
*/
void
update_k8sfilter_by_id(const std::string &name, const K8sfilterJsonObject &value) {
  auto k8sfilter = get_cube(name);

  k8sfilter->update(value);
}

/**
* @brief   Update k8sfilter by ID
*
* Update operation of resource: k8sfilter*
*
* @param[in] value k8sfilterbody object
*
* Responses:
*
*/
void
update_k8sfilter_list_by_id(const std::vector<K8sfilterJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update nodeport-range by ID
*
* Update operation of resource: nodeport-range*
*
* @param[in] name ID of name
* @param[in] value Port range used for NodePort services
*
* Responses:
*
*/
void
update_k8sfilter_nodeport_range_by_id(const std::string &name, const std::string &value) {
  auto k8sfilter = get_cube(name);

  k8sfilter->setNodeportRange(value);
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_k8sfilter_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto k8sfilter = get_cube(name);
  auto ports = k8sfilter->getPorts(portsName);

  ports->update(value);
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_k8sfilter_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}



/*
 * help related
 */

std::vector<nlohmann::fifo_map<std::string, std::string>> read_k8sfilter_ports_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&k8sfilter = get_cube(name);

  auto &&ports = k8sfilter->getPortsList();
  for(auto &i : ports) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["name"] = i->getName();

    r.push_back(keys);
  }
  return r;
}


}

}
}
}
}

