/**
* iptables API generated from iptables.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */



#include "IptablesJsonObject.h"
#include <regex>

namespace polycube {
namespace service {
namespace model {

IptablesJsonObject::IptablesJsonObject() {
  m_nameIsSet = false;
  m_dynOpt = false;
  m_dynOptIsSet = true;
  m_portsIsSet = false;
  m_interactive = true;
  m_interactiveIsSet = true;
  m_conntrackIsSet = false;
  m_horusIsSet = false;
  m_sessionTableIsSet = false;
  m_chainIsSet = false;
}

IptablesJsonObject::IptablesJsonObject(const nlohmann::json &val) :
  JsonObjectBase(val) {
  m_nameIsSet = false;
  m_dynOptIsSet = false;
  m_portsIsSet = false;
  m_interactiveIsSet = false;
  m_conntrackIsSet = false;
  m_horusIsSet = false;
  m_sessionTableIsSet = false;
  m_chainIsSet = false;


  if (val.count("name")) {
    setName(val.at("name").get<std::string>());
  }

  if (val.count("dyn-opt")) {
    setDynOpt(val.at("dyn-opt").get<bool>());
  }

  if (val.count("ports")) {
    for (auto& item : val["ports"]) {
      PortsJsonObject newItem{ item };
      m_ports.push_back(newItem);
    }

    m_portsIsSet = true;
  }

  if (val.count("interactive")) {
    setInteractive(val.at("interactive").get<bool>());
  }

  if (val.count("conntrack")) {
    setConntrack(string_to_IptablesConntrackEnum(val.at("conntrack").get<std::string>()));
  }

  if (val.count("horus")) {
    setHorus(string_to_IptablesHorusEnum(val.at("horus").get<std::string>()));
  }

  if (val.count("session-table")) {
    for (auto& item : val["session-table"]) {
      SessionTableJsonObject newItem{ item };
      m_sessionTable.push_back(newItem);
    }

    m_sessionTableIsSet = true;
  }

  if (val.count("chain")) {
    for (auto& item : val["chain"]) {
      ChainJsonObject newItem{ item };
      m_chain.push_back(newItem);
    }

    m_chainIsSet = true;
  }
}

nlohmann::json IptablesJsonObject::toJson() const {
  nlohmann::json val = nlohmann::json::object();
  if (!getBase().is_null()) {
    val.update(getBase());
  }

  if (m_nameIsSet) {
    val["name"] = m_name;
  }

  if (m_dynOptIsSet) {
    val["dyn-opt"] = m_dynOpt;
  }

  {
    nlohmann::json jsonArray;
    for (auto& item : m_ports) {
      jsonArray.push_back(JsonObjectBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      val["ports"] = jsonArray;
    }
  }

  if (m_interactiveIsSet) {
    val["interactive"] = m_interactive;
  }

  if (m_conntrackIsSet) {
    val["conntrack"] = IptablesConntrackEnum_to_string(m_conntrack);
  }

  if (m_horusIsSet) {
    val["horus"] = IptablesHorusEnum_to_string(m_horus);
  }

  {
    nlohmann::json jsonArray;
    for (auto& item : m_sessionTable) {
      jsonArray.push_back(JsonObjectBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      val["session-table"] = jsonArray;
    }
  }

  {
    nlohmann::json jsonArray;
    for (auto& item : m_chain) {
      jsonArray.push_back(JsonObjectBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      val["chain"] = jsonArray;
    }
  }

  return val;
}

std::string IptablesJsonObject::getName() const {
  return m_name;
}

void IptablesJsonObject::setName(std::string value) {
  m_name = value;
  m_nameIsSet = true;
}

bool IptablesJsonObject::nameIsSet() const {
  return m_nameIsSet;
}



bool IptablesJsonObject::getDynOpt() const {
  return m_dynOpt;
}

void IptablesJsonObject::setDynOpt(bool value) {
  m_dynOpt = value;
  m_dynOptIsSet = true;
}

bool IptablesJsonObject::dynOptIsSet() const {
  return m_dynOptIsSet;
}

void IptablesJsonObject::unsetDynOpt() {
  m_dynOptIsSet = false;
}

const std::vector<PortsJsonObject>& IptablesJsonObject::getPorts() const{
  return m_ports;
}

void IptablesJsonObject::addPorts(PortsJsonObject value) {
  m_ports.push_back(value);
  m_portsIsSet = true;
}


bool IptablesJsonObject::portsIsSet() const {
  return m_portsIsSet;
}

void IptablesJsonObject::unsetPorts() {
  m_portsIsSet = false;
}

bool IptablesJsonObject::getInteractive() const {
  return m_interactive;
}

void IptablesJsonObject::setInteractive(bool value) {
  m_interactive = value;
  m_interactiveIsSet = true;
}

bool IptablesJsonObject::interactiveIsSet() const {
  return m_interactiveIsSet;
}

void IptablesJsonObject::unsetInteractive() {
  m_interactiveIsSet = false;
}

IptablesConntrackEnum IptablesJsonObject::getConntrack() const {
  return m_conntrack;
}

void IptablesJsonObject::setConntrack(IptablesConntrackEnum value) {
  m_conntrack = value;
  m_conntrackIsSet = true;
}

bool IptablesJsonObject::conntrackIsSet() const {
  return m_conntrackIsSet;
}

void IptablesJsonObject::unsetConntrack() {
  m_conntrackIsSet = false;
}

std::string IptablesJsonObject::IptablesConntrackEnum_to_string(const IptablesConntrackEnum &value){
  switch(value) {
    case IptablesConntrackEnum::ON:
      return std::string("on");
    case IptablesConntrackEnum::OFF:
      return std::string("off");
    default:
      throw std::runtime_error("Bad Iptables conntrack");
  }
}

IptablesConntrackEnum IptablesJsonObject::string_to_IptablesConntrackEnum(const std::string &str){
  if (JsonObjectBase::iequals("on", str))
    return IptablesConntrackEnum::ON;
  if (JsonObjectBase::iequals("off", str))
    return IptablesConntrackEnum::OFF;
  throw std::runtime_error("Iptables conntrack is invalid");
}
IptablesHorusEnum IptablesJsonObject::getHorus() const {
  return m_horus;
}

void IptablesJsonObject::setHorus(IptablesHorusEnum value) {
  m_horus = value;
  m_horusIsSet = true;
}

bool IptablesJsonObject::horusIsSet() const {
  return m_horusIsSet;
}

void IptablesJsonObject::unsetHorus() {
  m_horusIsSet = false;
}

std::string IptablesJsonObject::IptablesHorusEnum_to_string(const IptablesHorusEnum &value){
  switch(value) {
    case IptablesHorusEnum::ON:
      return std::string("on");
    case IptablesHorusEnum::OFF:
      return std::string("off");
    default:
      throw std::runtime_error("Bad Iptables horus");
  }
}

IptablesHorusEnum IptablesJsonObject::string_to_IptablesHorusEnum(const std::string &str){
  if (JsonObjectBase::iequals("on", str))
    return IptablesHorusEnum::ON;
  if (JsonObjectBase::iequals("off", str))
    return IptablesHorusEnum::OFF;
  throw std::runtime_error("Iptables horus is invalid");
}
const std::vector<SessionTableJsonObject>& IptablesJsonObject::getSessionTable() const{
  return m_sessionTable;
}

void IptablesJsonObject::addSessionTable(SessionTableJsonObject value) {
  m_sessionTable.push_back(value);
  m_sessionTableIsSet = true;
}


bool IptablesJsonObject::sessionTableIsSet() const {
  return m_sessionTableIsSet;
}

void IptablesJsonObject::unsetSessionTable() {
  m_sessionTableIsSet = false;
}

const std::vector<ChainJsonObject>& IptablesJsonObject::getChain() const{
  return m_chain;
}

void IptablesJsonObject::addChain(ChainJsonObject value) {
  m_chain.push_back(value);
  m_chainIsSet = true;
}


bool IptablesJsonObject::chainIsSet() const {
  return m_chainIsSet;
}

void IptablesJsonObject::unsetChain() {
  m_chainIsSet = false;
}


}
}
}

