/**
* iptables API generated from iptables.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */

/*
* IptablesBase.h
*
*
*/

#pragma once

#include "../serializer/IptablesJsonObject.h"

#include "../Chain.h"
#include "../Ports.h"
#include "../SessionTable.h"

#include "polycube/services/cube.h"
#include "polycube/services/port.h"



#include "polycube/services/utils.h"
#include "polycube/services/fifo_map.hpp"

#include <spdlog/spdlog.h>

using namespace polycube::service::model;


class IptablesBase: public virtual polycube::service::Cube<Ports> {
 public:
  IptablesBase(const std::string name);
  
  virtual ~IptablesBase();
  virtual void update(const IptablesJsonObject &conf);
  virtual IptablesJsonObject toJsonObject();

  /// <summary>
  /// Defines if the service should be automatically optimized by Morpheus
  /// </summary>
  virtual bool getDynOpt() = 0;

  /// <summary>
  /// Entry of the ports table
  /// </summary>
  virtual std::shared_ptr<Ports> getPorts(const std::string &name);
  virtual std::vector<std::shared_ptr<Ports>> getPortsList();
  virtual void addPorts(const std::string &name, const PortsJsonObject &conf);
  virtual void addPortsList(const std::vector<PortsJsonObject> &conf);
  virtual void replacePorts(const std::string &name, const PortsJsonObject &conf);
  virtual void delPorts(const std::string &name);
  virtual void delPortsList();

  /// <summary>
  /// Interactive mode applies new rules immediately; if &#39;false&#39;, the command &#39;apply-rules&#39; has to be used to apply all the rules at once. Default is TRUE.
  /// </summary>
  virtual bool getInteractive() = 0;
  virtual void setInteractive(const bool &value) = 0;

  /// <summary>
  /// Enables the Connection Tracking module. Mandatory if connection tracking rules are needed. Default is ON.
  /// </summary>
  virtual IptablesConntrackEnum getConntrack() = 0;
  virtual void setConntrack(const IptablesConntrackEnum &value) = 0;

  /// <summary>
  /// Enables the HORUS optimization. Default is OFF.
  /// </summary>
  virtual IptablesHorusEnum getHorus() = 0;
  virtual void setHorus(const IptablesHorusEnum &value) = 0;

  /// <summary>
  ///
  /// </summary>
  virtual std::shared_ptr<SessionTable> getSessionTable(const std::string &src, const std::string &dst, const std::string &l4proto, const uint16_t &sport, const uint16_t &dport) = 0;
  virtual std::vector<std::shared_ptr<SessionTable>> getSessionTableList() = 0;
  virtual void addSessionTable(const std::string &src, const std::string &dst, const std::string &l4proto, const uint16_t &sport, const uint16_t &dport, const SessionTableJsonObject &conf) = 0;
  virtual void addSessionTableList(const std::vector<SessionTableJsonObject> &conf);
  virtual void replaceSessionTable(const std::string &src, const std::string &dst, const std::string &l4proto, const uint16_t &sport, const uint16_t &dport, const SessionTableJsonObject &conf);
  virtual void delSessionTable(const std::string &src,const std::string &dst,const std::string &l4proto,const uint16_t &sport,const uint16_t &dport) = 0;
  virtual void delSessionTableList();

  /// <summary>
  ///
  /// </summary>
  virtual std::shared_ptr<Chain> getChain(const ChainNameEnum &name) = 0;
  virtual std::vector<std::shared_ptr<Chain>> getChainList() = 0;
  virtual void addChain(const ChainNameEnum &name, const ChainJsonObject &conf) = 0;
  virtual void addChainList(const std::vector<ChainJsonObject> &conf);
  virtual void replaceChain(const ChainNameEnum &name, const ChainJsonObject &conf);
  virtual void delChain(const ChainNameEnum &name) = 0;
  virtual void delChainList();
};
