/**
* iptables API generated from iptables.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "IptablesBase.h"

IptablesBase::IptablesBase(const std::string name) {
  logger()->set_pattern("[%Y-%m-%d %H:%M:%S.%e] [Iptables] [%n] [%l] %v");
}



IptablesBase::~IptablesBase() {}

void IptablesBase::update(const IptablesJsonObject &conf) {
  set_conf(conf.getBase());

  if (conf.portsIsSet()) {
    for (auto &i : conf.getPorts()) {
      auto name = i.getName();
      auto m = getPorts(name);
      m->update(i);
    }
  }
  if (conf.interactiveIsSet()) {
    setInteractive(conf.getInteractive());
  }
  if (conf.conntrackIsSet()) {
    setConntrack(conf.getConntrack());
  }
  if (conf.horusIsSet()) {
    setHorus(conf.getHorus());
  }
  if (conf.sessionTableIsSet()) {
    for (auto &i : conf.getSessionTable()) {
      auto src = i.getSrc();
      auto dst = i.getDst();
      auto l4proto = i.getL4proto();
      auto sport = i.getSport();
      auto dport = i.getDport();
      auto m = getSessionTable(src, dst, l4proto, sport, dport);
      m->update(i);
    }
  }
  if (conf.chainIsSet()) {
    for (auto &i : conf.getChain()) {
      auto name = i.getName();
      auto m = getChain(name);
      m->update(i);
    }
  }
}

IptablesJsonObject IptablesBase::toJsonObject() {
  IptablesJsonObject conf;
  conf.setBase(to_json());

  conf.setName(getName());
  conf.setDynOpt(getDynOpt());
  for (auto &i : getPortsList()) {
    conf.addPorts(i->toJsonObject());
  }
  conf.setInteractive(getInteractive());
  conf.setConntrack(getConntrack());
  conf.setHorus(getHorus());
  for(auto &i : getSessionTableList()) {
    conf.addSessionTable(i->toJsonObject());
  }
  for(auto &i : getChainList()) {
    conf.addChain(i->toJsonObject());
  }

  return conf;
}
void IptablesBase::addPortsList(const std::vector<PortsJsonObject> &conf) {
  for (auto &i : conf) {
    std::string name_ = i.getName();
    addPorts(name_, i);
  }
}

void IptablesBase::replacePorts(const std::string &name, const PortsJsonObject &conf) {
  delPorts(name);
  std::string name_ = conf.getName();
  addPorts(name_, conf);
}

void IptablesBase::delPortsList() {
  auto elements = getPortsList();
  for (auto &i : elements) {
    std::string name_ = i->getName();
    delPorts(name_);
  }
}

void IptablesBase::addPorts(const std::string &name, const PortsJsonObject &conf) {
  add_port<PortsJsonObject>(name, conf);
}

void IptablesBase::delPorts(const std::string &name) {
  remove_port(name);
}

std::shared_ptr<Ports> IptablesBase::getPorts(const std::string &name) {
  return get_port(name);
}

std::vector<std::shared_ptr<Ports>> IptablesBase::getPortsList() {
  return get_ports();
}
void IptablesBase::addSessionTableList(const std::vector<SessionTableJsonObject> &conf) {
  for (auto &i : conf) {
    std::string src_ = i.getSrc();
    std::string dst_ = i.getDst();
    std::string l4proto_ = i.getL4proto();
    uint16_t sport_ = i.getSport();
    uint16_t dport_ = i.getDport();
    addSessionTable(src_, dst_, l4proto_, sport_, dport_, i);
  }
}

void IptablesBase::replaceSessionTable(const std::string &src, const std::string &dst, const std::string &l4proto, const uint16_t &sport, const uint16_t &dport, const SessionTableJsonObject &conf) {
  delSessionTable(src, dst, l4proto, sport, dport);
  std::string src_ = conf.getSrc();
  std::string dst_ = conf.getDst();
  std::string l4proto_ = conf.getL4proto();
  uint16_t sport_ = conf.getSport();
  uint16_t dport_ = conf.getDport();
  addSessionTable(src_, dst_, l4proto_, sport_, dport_, conf);
}

void IptablesBase::delSessionTableList() {
  auto elements = getSessionTableList();
  for (auto &i : elements) {
    std::string src_ = i->getSrc();
    std::string dst_ = i->getDst();
    std::string l4proto_ = i->getL4proto();
    uint16_t sport_ = i->getSport();
    uint16_t dport_ = i->getDport();
    delSessionTable(src_, dst_, l4proto_, sport_, dport_);
  }
}
void IptablesBase::addChainList(const std::vector<ChainJsonObject> &conf) {
  for (auto &i : conf) {
    ChainNameEnum name_ = i.getName();
    addChain(name_, i);
  }
}

void IptablesBase::replaceChain(const ChainNameEnum &name, const ChainJsonObject &conf) {
  delChain(name);
  ChainNameEnum name_ = conf.getName();
  addChain(name_, conf);
}

void IptablesBase::delChainList() {
  auto elements = getChainList();
  for (auto &i : elements) {
    ChainNameEnum name_ = i->getName();
    delChain(name_);
  }
}


