/**
* iptables API generated from iptables.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "ChainBase.h"
#include "../Iptables.h"


ChainBase::ChainBase(Iptables &parent)
    : parent_(parent) {}

ChainBase::~ChainBase() {}

void ChainBase::update(const ChainJsonObject &conf) {

  if (conf.defaultIsSet()) {
    setDefault(conf.getDefault());
  }
  if (conf.statsIsSet()) {
    for (auto &i : conf.getStats()) {
      auto id = i.getId();
      auto m = getStats(id);
      m->update(i);
    }
  }
  if (conf.ruleIsSet()) {
    for (auto &i : conf.getRule()) {
      auto id = i.getId();
      auto m = getRule(id);
      m->update(i);
    }
  }
}

ChainJsonObject ChainBase::toJsonObject() {
  ChainJsonObject conf;

  conf.setName(getName());
  conf.setDefault(getDefault());
  for(auto &i : getStatsList()) {
    conf.addChainStats(i->toJsonObject());
  }
  for(auto &i : getRuleList()) {
    conf.addChainRule(i->toJsonObject());
  }

  return conf;
}
void ChainBase::addStatsList(const std::vector<ChainStatsJsonObject> &conf) {
  for (auto &i : conf) {
    uint32_t id_ = i.getId();
    addStats(id_, i);
  }
}

void ChainBase::replaceStats(const uint32_t &id, const ChainStatsJsonObject &conf) {
  delStats(id);
  uint32_t id_ = conf.getId();
  addStats(id_, conf);
}

void ChainBase::delStatsList() {
  auto elements = getStatsList();
  for (auto &i : elements) {
    uint32_t id_ = i->getId();
    delStats(id_);
  }
}
void ChainBase::addRuleList(const std::vector<ChainRuleJsonObject> &conf) {
  for (auto &i : conf) {
    uint32_t id_ = i.getId();
    addRule(id_, i);
  }
}

void ChainBase::replaceRule(const uint32_t &id, const ChainRuleJsonObject &conf) {
  delRule(id);
  uint32_t id_ = conf.getId();
  addRule(id_, conf);
}

void ChainBase::delRuleList() {
  auto elements = getRuleList();
  for (auto &i : elements) {
    uint32_t id_ = i->getId();
    delRule(id_);
  }
}

std::shared_ptr<spdlog::logger> ChainBase::logger() {
  return parent_.logger();
}

