/**
* iptables API generated from iptables.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "IptablesApi.h"
#include "IptablesApiImpl.h"

using namespace polycube::service::model;
using namespace polycube::service::api::IptablesApiImpl;

#ifdef __cplusplus
extern "C" {
#endif

Response create_iptables_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    IptablesJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    create_iptables_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_iptables_chain_append_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainAppendInputJsonObject unique_value { request_body };


    auto x = create_iptables_chain_append_by_id(unique_name, unique_chainName_, unique_value);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_iptables_chain_apply_rules_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {

    auto x = create_iptables_chain_apply_rules_by_id(unique_name, unique_chainName_);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_iptables_chain_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainJsonObject unique_value { request_body };

    unique_value.setName(unique_chainName_);
    create_iptables_chain_by_id(unique_name, unique_chainName_, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_iptables_chain_insert_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainInsertInputJsonObject unique_value { request_body };


    auto x = create_iptables_chain_insert_by_id(unique_name, unique_chainName_, unique_value);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_iptables_chain_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<ChainJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ChainJsonObject> unique_value;
    for (auto &j : request_body) {
      ChainJsonObject a { j };
      unique_value.push_back(a);
    }
    create_iptables_chain_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_iptables_chain_remove_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainRemoveInputJsonObject unique_value { request_body };

    create_iptables_chain_remove_by_id(unique_name, unique_chainName_, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_iptables_chain_reset_counters_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {

    auto x = create_iptables_chain_reset_counters_by_id(unique_name, unique_chainName_);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_iptables_chain_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainRuleJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    create_iptables_chain_rule_by_id(unique_name, unique_chainName_, unique_id, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_iptables_chain_rule_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  // Getting the body param
  std::vector<ChainRuleJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ChainRuleJsonObject> unique_value;
    for (auto &j : request_body) {
      ChainRuleJsonObject a { j };
      unique_value.push_back(a);
    }
    create_iptables_chain_rule_list_by_id(unique_name, unique_chainName_, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_iptables_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    create_iptables_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_iptables_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    create_iptables_ports_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_iptables_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_iptables_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_iptables_chain_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    delete_iptables_chain_by_id(unique_name, unique_chainName_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_iptables_chain_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_iptables_chain_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_iptables_chain_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    delete_iptables_chain_rule_by_id(unique_name, unique_chainName_, unique_id);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_iptables_chain_rule_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    delete_iptables_chain_rule_list_by_id(unique_name, unique_chainName_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_iptables_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    delete_iptables_ports_by_id(unique_name, unique_portsName);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_iptables_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_iptables_ports_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_iptables_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {

    auto x = read_iptables_chain_by_id(unique_name, unique_chainName_);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_default_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {

    auto x = read_iptables_chain_default_by_id(unique_name, unique_chainName_);
    nlohmann::json response_body;
    response_body = ChainJsonObject::ActionEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_iptables_chain_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_rule_action_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_rule_action_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = ChainRuleJsonObject::ActionEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_rule_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_rule_conntrack_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_rule_conntrack_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = ChainRuleJsonObject::ConntrackstatusEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_rule_dport_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_rule_dport_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_rule_dst_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_rule_dst_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_rule_in_iface_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_rule_in_iface_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_rule_l4proto_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_rule_l4proto_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_rule_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {

    auto x = read_iptables_chain_rule_list_by_id(unique_name, unique_chainName_);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_rule_out_iface_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_rule_out_iface_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_rule_sport_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_rule_sport_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_rule_src_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_rule_src_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_rule_tcpflags_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_rule_tcpflags_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_stats_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_stats_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_stats_bytes_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_stats_bytes_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_stats_description_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_stats_description_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_stats_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {

    auto x = read_iptables_chain_stats_list_by_id(unique_name, unique_chainName_);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_chain_stats_pkts_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_iptables_chain_stats_pkts_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_conntrack_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_iptables_conntrack_by_id(unique_name);
    nlohmann::json response_body;
    response_body = IptablesJsonObject::IptablesConntrackEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_dyn_opt_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_iptables_dyn_opt_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_horus_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_iptables_horus_by_id(unique_name);
    nlohmann::json response_body;
    response_body = IptablesJsonObject::IptablesHorusEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_interactive_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_iptables_interactive_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {


  try {

    auto x = read_iptables_list_by_id();
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {

    auto x = read_iptables_ports_by_id(unique_name, unique_portsName);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_iptables_ports_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_session_table_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_src;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "src")) {
      unique_src = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_dst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "dst")) {
      unique_dst = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_l4proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "l4proto")) {
      unique_l4proto = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_sport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "sport")) {
      unique_sport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_dport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "dport")) {
      unique_dport = keys[i].value.uint16;
      break;
    }
  }


  try {

    auto x = read_iptables_session_table_by_id(unique_name, unique_src, unique_dst, unique_l4proto, unique_sport, unique_dport);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_session_table_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_iptables_session_table_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_iptables_session_table_state_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_src;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "src")) {
      unique_src = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_dst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "dst")) {
      unique_dst = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_l4proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "l4proto")) {
      unique_l4proto = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_sport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "sport")) {
      unique_sport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_dport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "dport")) {
      unique_dport = keys[i].value.uint16;
      break;
    }
  }


  try {

    auto x = read_iptables_session_table_state_by_id(unique_name, unique_src, unique_dst, unique_l4proto, unique_sport, unique_dport);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_iptables_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    IptablesJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    replace_iptables_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_iptables_chain_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainJsonObject unique_value { request_body };

    unique_value.setName(unique_chainName_);
    replace_iptables_chain_by_id(unique_name, unique_chainName_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_iptables_chain_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<ChainJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ChainJsonObject> unique_value;
    for (auto &j : request_body) {
      ChainJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_iptables_chain_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_iptables_chain_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainRuleJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    replace_iptables_chain_rule_by_id(unique_name, unique_chainName_, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_iptables_chain_rule_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  // Getting the body param
  std::vector<ChainRuleJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ChainRuleJsonObject> unique_value;
    for (auto &j : request_body) {
      ChainRuleJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_iptables_chain_rule_list_by_id(unique_name, unique_chainName_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_iptables_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    replace_iptables_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_iptables_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_iptables_ports_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    IptablesJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    update_iptables_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainJsonObject unique_value { request_body };

    unique_value.setName(unique_chainName_);
    update_iptables_chain_by_id(unique_name, unique_chainName_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_default_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    ActionEnum unique_value_ = ChainJsonObject::string_to_ActionEnum(request_body);
    update_iptables_chain_default_by_id(unique_name, unique_chainName_, unique_value_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<ChainJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ChainJsonObject> unique_value;
    for (auto &j : request_body) {
      ChainJsonObject a { j };
      unique_value.push_back(a);
    }
    update_iptables_chain_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_rule_action_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    ActionEnum unique_value_ = ChainRuleJsonObject::string_to_ActionEnum(request_body);
    update_iptables_chain_rule_action_by_id(unique_name, unique_chainName_, unique_id, unique_value_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainRuleJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    update_iptables_chain_rule_by_id(unique_name, unique_chainName_, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_rule_conntrack_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    ConntrackstatusEnum unique_value_ = ChainRuleJsonObject::string_to_ConntrackstatusEnum(request_body);
    update_iptables_chain_rule_conntrack_by_id(unique_name, unique_chainName_, unique_id, unique_value_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_rule_dport_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_iptables_chain_rule_dport_by_id(unique_name, unique_chainName_, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_rule_dst_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_iptables_chain_rule_dst_by_id(unique_name, unique_chainName_, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_rule_in_iface_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_iptables_chain_rule_in_iface_by_id(unique_name, unique_chainName_, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_rule_l4proto_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_iptables_chain_rule_l4proto_by_id(unique_name, unique_chainName_, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_rule_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  // Getting the body param
  std::vector<ChainRuleJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ChainRuleJsonObject> unique_value;
    for (auto &j : request_body) {
      ChainRuleJsonObject a { j };
      unique_value.push_back(a);
    }
    update_iptables_chain_rule_list_by_id(unique_name, unique_chainName_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_rule_out_iface_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_iptables_chain_rule_out_iface_by_id(unique_name, unique_chainName_, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_rule_sport_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_iptables_chain_rule_sport_by_id(unique_name, unique_chainName_, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_rule_src_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_iptables_chain_rule_src_by_id(unique_name, unique_chainName_, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_chain_rule_tcpflags_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    std::string unique_value = request_body;
    update_iptables_chain_rule_tcpflags_by_id(unique_name, unique_chainName_, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_conntrack_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    IptablesConntrackEnum unique_value_ = IptablesJsonObject::string_to_IptablesConntrackEnum(request_body);
    update_iptables_conntrack_by_id(unique_name, unique_value_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_horus_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    IptablesHorusEnum unique_value_ = IptablesJsonObject::string_to_IptablesHorusEnum(request_body);
    update_iptables_horus_by_id(unique_name, unique_value_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_interactive_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // The conversion is done automatically by the json library
    bool unique_value = request_body;
    update_iptables_interactive_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {

  // Getting the body param
  std::vector<IptablesJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<IptablesJsonObject> unique_value;
    for (auto &j : request_body) {
      IptablesJsonObject a { j };
      unique_value.push_back(a);
    }
    update_iptables_list_by_id(unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_ports_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_portsName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "ports_name")) {
      unique_portsName = std::string { keys[i].value.string };
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    PortsJsonObject unique_value { request_body };

    unique_value.setName(unique_portsName);
    update_iptables_ports_by_id(unique_name, unique_portsName, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_iptables_ports_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<PortsJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<PortsJsonObject> unique_value;
    for (auto &j : request_body) {
      PortsJsonObject a { j };
      unique_value.push_back(a);
    }
    update_iptables_ports_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}


Response iptables_chain_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_iptables_chain_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response iptables_chain_rule_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  nlohmann::json val = read_iptables_chain_rule_list_by_id_get_list(unique_name, unique_chainName_);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response iptables_chain_stats_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  nlohmann::json val = read_iptables_chain_stats_list_by_id_get_list(unique_name, unique_chainName_);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response iptables_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {

  nlohmann::json val = read_iptables_list_by_id_get_list();

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response iptables_ports_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_iptables_ports_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response iptables_session_table_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_iptables_session_table_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

#ifdef __cplusplus
}
#endif

