/**
* helloworld API generated from helloworld.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "HelloworldApiImpl.h"

namespace polycube {
namespace service {
namespace api {

using namespace polycube::service::model;

namespace HelloworldApiImpl {
namespace {
std::unordered_map<std::string, std::shared_ptr<Helloworld>> cubes;
std::mutex cubes_mutex;

std::shared_ptr<Helloworld> get_cube(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  auto iter = cubes.find(name);
  if (iter == cubes.end()) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }

  return iter->second;
}

}

void create_helloworld_by_id(const std::string &name, const HelloworldJsonObject &jsonObject) {
  {
    // check if name is valid before creating it
    std::lock_guard<std::mutex> guard(cubes_mutex);
    if (cubes.count(name) != 0) {
      throw std::runtime_error("There is already a cube with name " + name);
    }
  }
  auto ptr = std::make_shared<Helloworld>(name, jsonObject);
  std::unordered_map<std::string, std::shared_ptr<Helloworld>>::iterator iter;
  bool inserted;

  std::lock_guard<std::mutex> guard(cubes_mutex);
  std::tie(iter, inserted) = cubes.emplace(name, std::move(ptr));

  if (!inserted) {
    throw std::runtime_error("There is already a cube with name " + name);
  }
}

void replace_helloworld_by_id(const std::string &name, const HelloworldJsonObject &bridge){
  throw std::runtime_error("Method not supported!");
}

void delete_helloworld_by_id(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  if (cubes.count(name) == 0) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }
  cubes.erase(name);
}

std::vector<HelloworldJsonObject> read_helloworld_list_by_id() {
  std::vector<HelloworldJsonObject> jsonObject_vect;
  for(auto &i : cubes) {
    auto m = get_cube(i.first);
    jsonObject_vect.push_back(m->toJsonObject());
  }
  return jsonObject_vect;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_helloworld_list_by_id_get_list() {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  for (auto &x : cubes) {
    nlohmann::fifo_map<std::string, std::string> m;
    m["name"] = x.first;
    r.push_back(std::move(m));
  }
  return r;
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_helloworld_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto helloworld = get_cube(name);

  helloworld->addPorts(portsName, value);
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_helloworld_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  auto helloworld = get_cube(name);
  helloworld->addPortsList(value);
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
*
*/
void
delete_helloworld_ports_by_id(const std::string &name, const std::string &portsName) {
  auto helloworld = get_cube(name);

  helloworld->delPorts(portsName);
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_helloworld_ports_list_by_id(const std::string &name) {
  auto helloworld = get_cube(name);
  helloworld->delPortsList();
}

/**
* @brief   Read action by ID
*
* Read operation of resource: action*
*
* @param[in] name ID of name
*
* Responses:
* HelloworldActionEnum
*/
HelloworldActionEnum
read_helloworld_action_by_id(const std::string &name) {
  auto helloworld = get_cube(name);
  return helloworld->getAction();

}

/**
* @brief   Read helloworld by ID
*
* Read operation of resource: helloworld*
*
* @param[in] name ID of name
*
* Responses:
* HelloworldJsonObject
*/
HelloworldJsonObject
read_helloworld_by_id(const std::string &name) {
  return get_cube(name)->toJsonObject();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsJsonObject
*/
PortsJsonObject
read_helloworld_ports_by_id(const std::string &name, const std::string &portsName) {
  auto helloworld = get_cube(name);
  return helloworld->getPorts(portsName)->toJsonObject();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<PortsJsonObject>
*/
std::vector<PortsJsonObject>
read_helloworld_ports_list_by_id(const std::string &name) {
  auto helloworld = get_cube(name);
  auto &&ports = helloworld->getPortsList();
  std::vector<PortsJsonObject> m;
  for(auto &i : ports)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_helloworld_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto helloworld = get_cube(name);

  helloworld->replacePorts(portsName, value);
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_helloworld_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update action by ID
*
* Update operation of resource: action*
*
* @param[in] name ID of name
* @param[in] value Action performed on the received packet (i.e., DROP, SLOWPATH, or FORWARD; default: DROP)
*
* Responses:
*
*/
void
update_helloworld_action_by_id(const std::string &name, const HelloworldActionEnum &value) {
  auto helloworld = get_cube(name);

  helloworld->setAction(value);
}

/**
* @brief   Update helloworld by ID
*
* Update operation of resource: helloworld*
*
* @param[in] name ID of name
* @param[in] value helloworldbody object
*
* Responses:
*
*/
void
update_helloworld_by_id(const std::string &name, const HelloworldJsonObject &value) {
  auto helloworld = get_cube(name);

  helloworld->update(value);
}

/**
* @brief   Update helloworld by ID
*
* Update operation of resource: helloworld*
*
* @param[in] value helloworldbody object
*
* Responses:
*
*/
void
update_helloworld_list_by_id(const std::vector<HelloworldJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_helloworld_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto helloworld = get_cube(name);
  auto ports = helloworld->getPorts(portsName);

  ports->update(value);
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_helloworld_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}



/*
 * help related
 */

std::vector<nlohmann::fifo_map<std::string, std::string>> read_helloworld_ports_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&helloworld = get_cube(name);

  auto &&ports = helloworld->getPortsList();
  for(auto &i : ports) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["name"] = i->getName();

    r.push_back(keys);
  }
  return r;
}


}

}
}
}

