/**
* firewall API generated from firewall.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */



#include "FirewallJsonObject.h"
#include <regex>

namespace polycube {
namespace service {
namespace model {

FirewallJsonObject::FirewallJsonObject() {
  m_nameIsSet = false;
  m_conntrackIsSet = false;
  m_acceptEstablishedIsSet = false;
  m_sessionTableIsSet = false;
  m_chainIsSet = false;
}

FirewallJsonObject::FirewallJsonObject(const nlohmann::json &val) :
  JsonObjectBase(val) {
  m_nameIsSet = false;
  m_conntrackIsSet = false;
  m_acceptEstablishedIsSet = false;
  m_sessionTableIsSet = false;
  m_chainIsSet = false;


  if (val.count("name")) {
    setName(val.at("name").get<std::string>());
  }

  if (val.count("conntrack")) {
    setConntrack(string_to_FirewallConntrackEnum(val.at("conntrack").get<std::string>()));
  }

  if (val.count("accept-established")) {
    setAcceptEstablished(string_to_FirewallAcceptEstablishedEnum(val.at("accept-established").get<std::string>()));
  }

  if (val.count("session-table")) {
    for (auto& item : val["session-table"]) {
      SessionTableJsonObject newItem{ item };
      m_sessionTable.push_back(newItem);
    }

    m_sessionTableIsSet = true;
  }

  if (val.count("chain")) {
    for (auto& item : val["chain"]) {
      ChainJsonObject newItem{ item };
      m_chain.push_back(newItem);
    }

    m_chainIsSet = true;
  }
}

nlohmann::json FirewallJsonObject::toJson() const {
  nlohmann::json val = nlohmann::json::object();
  if (!getBase().is_null()) {
    val.update(getBase());
  }

  if (m_nameIsSet) {
    val["name"] = m_name;
  }

  if (m_conntrackIsSet) {
    val["conntrack"] = FirewallConntrackEnum_to_string(m_conntrack);
  }

  if (m_acceptEstablishedIsSet) {
    val["accept-established"] = FirewallAcceptEstablishedEnum_to_string(m_acceptEstablished);
  }

  {
    nlohmann::json jsonArray;
    for (auto& item : m_sessionTable) {
      jsonArray.push_back(JsonObjectBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      val["session-table"] = jsonArray;
    }
  }

  {
    nlohmann::json jsonArray;
    for (auto& item : m_chain) {
      jsonArray.push_back(JsonObjectBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      val["chain"] = jsonArray;
    }
  }

  return val;
}

std::string FirewallJsonObject::getName() const {
  return m_name;
}

void FirewallJsonObject::setName(std::string value) {
  m_name = value;
  m_nameIsSet = true;
}

bool FirewallJsonObject::nameIsSet() const {
  return m_nameIsSet;
}



FirewallConntrackEnum FirewallJsonObject::getConntrack() const {
  return m_conntrack;
}

void FirewallJsonObject::setConntrack(FirewallConntrackEnum value) {
  m_conntrack = value;
  m_conntrackIsSet = true;
}

bool FirewallJsonObject::conntrackIsSet() const {
  return m_conntrackIsSet;
}

void FirewallJsonObject::unsetConntrack() {
  m_conntrackIsSet = false;
}

std::string FirewallJsonObject::FirewallConntrackEnum_to_string(const FirewallConntrackEnum &value){
  switch(value) {
    case FirewallConntrackEnum::ON:
      return std::string("on");
    case FirewallConntrackEnum::OFF:
      return std::string("off");
    default:
      throw std::runtime_error("Bad Firewall conntrack");
  }
}

FirewallConntrackEnum FirewallJsonObject::string_to_FirewallConntrackEnum(const std::string &str){
  if (JsonObjectBase::iequals("on", str))
    return FirewallConntrackEnum::ON;
  if (JsonObjectBase::iequals("off", str))
    return FirewallConntrackEnum::OFF;
  throw std::runtime_error("Firewall conntrack is invalid");
}
FirewallAcceptEstablishedEnum FirewallJsonObject::getAcceptEstablished() const {
  return m_acceptEstablished;
}

void FirewallJsonObject::setAcceptEstablished(FirewallAcceptEstablishedEnum value) {
  m_acceptEstablished = value;
  m_acceptEstablishedIsSet = true;
}

bool FirewallJsonObject::acceptEstablishedIsSet() const {
  return m_acceptEstablishedIsSet;
}

void FirewallJsonObject::unsetAcceptEstablished() {
  m_acceptEstablishedIsSet = false;
}

std::string FirewallJsonObject::FirewallAcceptEstablishedEnum_to_string(const FirewallAcceptEstablishedEnum &value){
  switch(value) {
    case FirewallAcceptEstablishedEnum::ON:
      return std::string("on");
    case FirewallAcceptEstablishedEnum::OFF:
      return std::string("off");
    default:
      throw std::runtime_error("Bad Firewall acceptEstablished");
  }
}

FirewallAcceptEstablishedEnum FirewallJsonObject::string_to_FirewallAcceptEstablishedEnum(const std::string &str){
  if (JsonObjectBase::iequals("on", str))
    return FirewallAcceptEstablishedEnum::ON;
  if (JsonObjectBase::iequals("off", str))
    return FirewallAcceptEstablishedEnum::OFF;
  throw std::runtime_error("Firewall acceptEstablished is invalid");
}

const std::vector<SessionTableJsonObject>& FirewallJsonObject::getSessionTable() const{
  return m_sessionTable;
}

void FirewallJsonObject::addSessionTable(SessionTableJsonObject value) {
  m_sessionTable.push_back(value);
  m_sessionTableIsSet = true;
}


bool FirewallJsonObject::sessionTableIsSet() const {
  return m_sessionTableIsSet;
}

void FirewallJsonObject::unsetSessionTable() {
  m_sessionTableIsSet = false;
}

const std::vector<ChainJsonObject>& FirewallJsonObject::getChain() const{
  return m_chain;
}

void FirewallJsonObject::addChain(ChainJsonObject value) {
  m_chain.push_back(value);
  m_chainIsSet = true;
}


bool FirewallJsonObject::chainIsSet() const {
  return m_chainIsSet;
}

void FirewallJsonObject::unsetChain() {
  m_chainIsSet = false;
}


}
}
}

