/**
* firewall API generated from firewall.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */

/*
* FirewallBase.h
*
*
*/

#pragma once

#include "../serializer/FirewallJsonObject.h"

#include "polycube/services/transparent_cube.h"
#include "polycube/services/utils.h"
#include "polycube/services/fifo_map.hpp"

#include <spdlog/spdlog.h>

class Chain;
class SessionTable;

using namespace polycube::service::model;

class FirewallBase : public virtual polycube::service::TransparentCube {
 public:
  FirewallBase(const std::string name);

  virtual ~FirewallBase();
  virtual void update(const FirewallJsonObject &conf);
  virtual FirewallJsonObject toJsonObject();

  /// <summary>
  /// Enables the Connection Tracking module. Mandatory if connection tracking rules are needed. Default is ON.
  /// </summary>
  virtual FirewallConntrackEnum getConntrack() = 0;
  virtual void setConntrack(const FirewallConntrackEnum &value) = 0;

  /// <summary>
  /// If Connection Tracking is enabled, all packets belonging to ESTABLISHED connections will be accepted automatically. Default is ON.
  /// </summary>
  virtual FirewallAcceptEstablishedEnum getAcceptEstablished() = 0;
  virtual void setAcceptEstablished(const FirewallAcceptEstablishedEnum &value) = 0;

  /// <summary>
  ///
  /// </summary>
  virtual std::shared_ptr<SessionTable> getSessionTable(const std::string &src, const std::string &dst, const std::string &l4proto, const uint16_t &sport, const uint16_t &dport) = 0;
  virtual std::vector<std::shared_ptr<SessionTable>> getSessionTableList() = 0;
  virtual void addSessionTable(const std::string &src, const std::string &dst, const std::string &l4proto, const uint16_t &sport, const uint16_t &dport, const SessionTableJsonObject &conf) = 0;
  virtual void addSessionTableList(const std::vector<SessionTableJsonObject> &conf);
  virtual void replaceSessionTable(const std::string &src, const std::string &dst, const std::string &l4proto, const uint16_t &sport, const uint16_t &dport, const SessionTableJsonObject &conf);
  virtual void delSessionTable(const std::string &src,const std::string &dst,const std::string &l4proto,const uint16_t &sport,const uint16_t &dport) = 0;
  virtual void delSessionTableList();

  /// <summary>
  ///
  /// </summary>
  virtual std::shared_ptr<Chain> getChain(const ChainNameEnum &name) = 0;
  virtual std::vector<std::shared_ptr<Chain>> getChainList() = 0;
  virtual void addChain(const ChainNameEnum &name, const ChainJsonObject &conf) = 0;
  virtual void addChainList(const std::vector<ChainJsonObject> &conf);
  virtual void replaceChain(const ChainNameEnum &name, const ChainJsonObject &conf);
  virtual void delChain(const ChainNameEnum &name) = 0;
  virtual void delChainList();
};
