/**
* firewall API generated from firewall.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */

#include "FirewallBase.h"

#include "../Chain.h"
#include "../SessionTable.h"

FirewallBase::FirewallBase(const std::string name) {
  logger()->set_pattern("[%Y-%m-%d %H:%M:%S.%e] [Firewall] [%n] [%l] %v");
}

FirewallBase::~FirewallBase() {}

void FirewallBase::update(const FirewallJsonObject &conf) {
  TransparentCube::set_conf(conf.getBase());

  if (conf.conntrackIsSet()) {
    setConntrack(conf.getConntrack());
  }
  if (conf.acceptEstablishedIsSet()) {
    setAcceptEstablished(conf.getAcceptEstablished());
  }
  if (conf.sessionTableIsSet()) {
    for (auto &i : conf.getSessionTable()) {
      auto src = i.getSrc();
      auto dst = i.getDst();
      auto l4proto = i.getL4proto();
      auto sport = i.getSport();
      auto dport = i.getDport();
      auto m = getSessionTable(src, dst, l4proto, sport, dport);
      m->update(i);
    }
  }
  if (conf.chainIsSet()) {
    for (auto &i : conf.getChain()) {
      auto name = i.getName();
      auto m = getChain(name);
      m->update(i);
    }
  }
}

FirewallJsonObject FirewallBase::toJsonObject() {
  FirewallJsonObject conf;
  conf.setBase(TransparentCube::to_json());

  conf.setName(getName());
  conf.setConntrack(getConntrack());
  conf.setAcceptEstablished(getAcceptEstablished());
  for(auto &i : getSessionTableList()) {
    conf.addSessionTable(i->toJsonObject());
  }
  for(auto &i : getChainList()) {
    conf.addChain(i->toJsonObject());
  }

  return conf;
}
void FirewallBase::addSessionTableList(const std::vector<SessionTableJsonObject> &conf) {
  for (auto &i : conf) {
    std::string src_ = i.getSrc();
    std::string dst_ = i.getDst();
    std::string l4proto_ = i.getL4proto();
    uint16_t sport_ = i.getSport();
    uint16_t dport_ = i.getDport();
    addSessionTable(src_, dst_, l4proto_, sport_, dport_, i);
  }
}

void FirewallBase::replaceSessionTable(const std::string &src, const std::string &dst, const std::string &l4proto, const uint16_t &sport, const uint16_t &dport, const SessionTableJsonObject &conf) {
  delSessionTable(src, dst, l4proto, sport, dport);
  std::string src_ = conf.getSrc();
  std::string dst_ = conf.getDst();
  std::string l4proto_ = conf.getL4proto();
  uint16_t sport_ = conf.getSport();
  uint16_t dport_ = conf.getDport();
  addSessionTable(src_, dst_, l4proto_, sport_, dport_, conf);
}

void FirewallBase::delSessionTableList() {
  auto elements = getSessionTableList();
  for (auto &i : elements) {
    std::string src_ = i->getSrc();
    std::string dst_ = i->getDst();
    std::string l4proto_ = i->getL4proto();
    uint16_t sport_ = i->getSport();
    uint16_t dport_ = i->getDport();
    delSessionTable(src_, dst_, l4proto_, sport_, dport_);
  }
}
void FirewallBase::addChainList(const std::vector<ChainJsonObject> &conf) {
  for (auto &i : conf) {
    ChainNameEnum name_ = i.getName();
    addChain(name_, i);
  }
}

void FirewallBase::replaceChain(const ChainNameEnum &name, const ChainJsonObject &conf) {
  delChain(name);
  ChainNameEnum name_ = conf.getName();
  addChain(name_, conf);
}

void FirewallBase::delChainList() {
  auto elements = getChainList();
  for (auto &i : elements) {
    ChainNameEnum name_ = i->getName();
    delChain(name_);
  }
}


