/**
* firewall API generated from firewall.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */

/*
* ChainStatsBase.h
*
*
*/

#pragma once

#include "../serializer/ChainStatsJsonObject.h"



#include <spdlog/spdlog.h>

using namespace polycube::service::model;

class Chain;

class ChainStatsBase {
 public:

  ChainStatsBase(Chain &parent);

  virtual ~ChainStatsBase();
  virtual void update(const ChainStatsJsonObject &conf);
  virtual ChainStatsJsonObject toJsonObject();

  /// <summary>
  /// Rule Identifier
  /// </summary>
  virtual uint32_t getId() = 0;

  /// <summary>
  /// Number of packets matching the rule
  /// </summary>
  virtual uint64_t getPkts() = 0;

  /// <summary>
  /// Number of bytes matching the rule
  /// </summary>
  virtual uint64_t getBytes() = 0;

  /// <summary>
  /// Source IP Address.
  /// </summary>
  virtual std::string getSrc() = 0;

  /// <summary>
  /// Destination IP Address.
  /// </summary>
  virtual std::string getDst() = 0;

  /// <summary>
  /// Level 4 Protocol.
  /// </summary>
  virtual std::string getL4proto() = 0;

  /// <summary>
  /// Source L4 Port
  /// </summary>
  virtual uint16_t getSport() = 0;

  /// <summary>
  /// Destination L4 Port
  /// </summary>
  virtual uint16_t getDport() = 0;

  /// <summary>
  /// TCP flags. Allowed values: SYN, FIN, ACK, RST, PSH, URG, CWR, ECE. ! means set to 0.
  /// </summary>
  virtual std::string getTcpflags() = 0;

  /// <summary>
  /// Connection status (NEW, ESTABLISHED, RELATED, INVALID)
  /// </summary>
  virtual ConntrackstatusEnum getConntrack() = 0;

  /// <summary>
  /// Action if the rule matches. Default is DROP.
  /// </summary>
  virtual ActionEnum getAction() = 0;

  /// <summary>
  /// Description of the rule.
  /// </summary>
  virtual std::string getDescription() = 0;

  std::shared_ptr<spdlog::logger> logger();
 protected:
  Chain &parent_;
};
