/**
* firewall API generated from firewall.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */

/*
* FirewallApiImpl.h
*
*
*/

#pragma once


#include <memory>
#include <map>
#include <mutex>
#include "../Firewall.h"

#include "ChainBatchInputJsonObject.h"
#include "ChainJsonObject.h"
#include "ChainAppendInputJsonObject.h"
#include "ChainAppendOutputJsonObject.h"
#include "ChainDeleteInputJsonObject.h"
#include "ChainInsertInputJsonObject.h"
#include "ChainInsertOutputJsonObject.h"
#include "ChainResetCountersOutputJsonObject.h"
#include "ChainRuleJsonObject.h"
#include "ChainStatsJsonObject.h"
#include "FirewallJsonObject.h"
#include "SessionTableJsonObject.h"
#include <vector>

namespace polycube {
namespace service {
namespace api {

using namespace polycube::service::model;

namespace FirewallApiImpl {
  void create_firewall_by_id(const std::string &name, const FirewallJsonObject &value);
  ChainAppendOutputJsonObject create_firewall_chain_append_by_id(const std::string &name, const ChainNameEnum &chainName, const ChainAppendInputJsonObject &value);
  void create_firewall_chain_batch_by_id(const std::string &name, const ChainNameEnum &chainName, const ChainBatchInputJsonObject &value);
  void create_firewall_chain_by_id(const std::string &name, const ChainNameEnum &chainName, const ChainJsonObject &value);
  void create_firewall_chain_delete_by_id(const std::string &name, const ChainNameEnum &chainName, const ChainDeleteInputJsonObject &value);
  ChainInsertOutputJsonObject create_firewall_chain_insert_by_id(const std::string &name, const ChainNameEnum &chainName, const ChainInsertInputJsonObject &value);
  void create_firewall_chain_list_by_id(const std::string &name, const std::vector<ChainJsonObject> &value);
  ChainResetCountersOutputJsonObject create_firewall_chain_reset_counters_by_id(const std::string &name, const ChainNameEnum &chainName);
  void create_firewall_chain_rule_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id, const ChainRuleJsonObject &value);
  void create_firewall_chain_rule_list_by_id(const std::string &name, const ChainNameEnum &chainName, const std::vector<ChainRuleJsonObject> &value);
  void delete_firewall_by_id(const std::string &name);
  void delete_firewall_chain_by_id(const std::string &name, const ChainNameEnum &chainName);
  void delete_firewall_chain_list_by_id(const std::string &name);
  void delete_firewall_chain_rule_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  void delete_firewall_chain_rule_list_by_id(const std::string &name, const ChainNameEnum &chainName);
  FirewallAcceptEstablishedEnum read_firewall_accept_established_by_id(const std::string &name);
  FirewallJsonObject read_firewall_by_id(const std::string &name);
  ChainJsonObject read_firewall_chain_by_id(const std::string &name, const ChainNameEnum &chainName);
  ActionEnum read_firewall_chain_default_by_id(const std::string &name, const ChainNameEnum &chainName);
  std::vector<ChainJsonObject> read_firewall_chain_list_by_id(const std::string &name);
  ActionEnum read_firewall_chain_rule_action_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  ChainRuleJsonObject read_firewall_chain_rule_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  ConntrackstatusEnum read_firewall_chain_rule_conntrack_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  std::string read_firewall_chain_rule_description_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  uint16_t read_firewall_chain_rule_dport_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  std::string read_firewall_chain_rule_dst_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  std::string read_firewall_chain_rule_l4proto_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  std::vector<ChainRuleJsonObject> read_firewall_chain_rule_list_by_id(const std::string &name, const ChainNameEnum &chainName);
  uint16_t read_firewall_chain_rule_sport_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  std::string read_firewall_chain_rule_src_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  std::string read_firewall_chain_rule_tcpflags_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  ActionEnum read_firewall_chain_stats_action_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  ChainStatsJsonObject read_firewall_chain_stats_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  uint64_t read_firewall_chain_stats_bytes_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  ConntrackstatusEnum read_firewall_chain_stats_conntrack_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  std::string read_firewall_chain_stats_description_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  uint16_t read_firewall_chain_stats_dport_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  std::string read_firewall_chain_stats_dst_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  std::string read_firewall_chain_stats_l4proto_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  std::vector<ChainStatsJsonObject> read_firewall_chain_stats_list_by_id(const std::string &name, const ChainNameEnum &chainName);
  uint64_t read_firewall_chain_stats_pkts_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  uint16_t read_firewall_chain_stats_sport_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  std::string read_firewall_chain_stats_src_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  std::string read_firewall_chain_stats_tcpflags_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id);
  FirewallConntrackEnum read_firewall_conntrack_by_id(const std::string &name);
  std::vector<FirewallJsonObject> read_firewall_list_by_id();
  SessionTableJsonObject read_firewall_session_table_by_id(const std::string &name, const std::string &src, const std::string &dst, const std::string &l4proto, const uint16_t &sport, const uint16_t &dport);
  uint32_t read_firewall_session_table_eta_by_id(const std::string &name, const std::string &src, const std::string &dst, const std::string &l4proto, const uint16_t &sport, const uint16_t &dport);
  std::vector<SessionTableJsonObject> read_firewall_session_table_list_by_id(const std::string &name);
  std::string read_firewall_session_table_state_by_id(const std::string &name, const std::string &src, const std::string &dst, const std::string &l4proto, const uint16_t &sport, const uint16_t &dport);
  void replace_firewall_by_id(const std::string &name, const FirewallJsonObject &value);
  void replace_firewall_chain_by_id(const std::string &name, const ChainNameEnum &chainName, const ChainJsonObject &value);
  void replace_firewall_chain_list_by_id(const std::string &name, const std::vector<ChainJsonObject> &value);
  void replace_firewall_chain_rule_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id, const ChainRuleJsonObject &value);
  void replace_firewall_chain_rule_list_by_id(const std::string &name, const ChainNameEnum &chainName, const std::vector<ChainRuleJsonObject> &value);
  void update_firewall_accept_established_by_id(const std::string &name, const FirewallAcceptEstablishedEnum &value);
  void update_firewall_by_id(const std::string &name, const FirewallJsonObject &value);
  void update_firewall_chain_by_id(const std::string &name, const ChainNameEnum &chainName, const ChainJsonObject &value);
  void update_firewall_chain_default_by_id(const std::string &name, const ChainNameEnum &chainName, const ActionEnum &value);
  void update_firewall_chain_list_by_id(const std::string &name, const std::vector<ChainJsonObject> &value);
  void update_firewall_chain_rule_by_id(const std::string &name, const ChainNameEnum &chainName, const uint32_t &id, const ChainRuleJsonObject &value);
  void update_firewall_chain_rule_list_by_id(const std::string &name, const ChainNameEnum &chainName, const std::vector<ChainRuleJsonObject> &value);
  void update_firewall_conntrack_by_id(const std::string &name, const FirewallConntrackEnum &value);
  void update_firewall_list_by_id(const std::vector<FirewallJsonObject> &value);

  /* help related */
  std::vector<nlohmann::fifo_map<std::string, std::string>> read_firewall_chain_list_by_id_get_list(const std::string &name);
  std::vector<nlohmann::fifo_map<std::string, std::string>> read_firewall_chain_rule_list_by_id_get_list(const std::string &name, const ChainNameEnum &chainName);
  std::vector<nlohmann::fifo_map<std::string, std::string>> read_firewall_chain_stats_list_by_id_get_list(const std::string &name, const ChainNameEnum &chainName);
  std::vector<nlohmann::fifo_map<std::string, std::string>> read_firewall_list_by_id_get_list();
  std::vector<nlohmann::fifo_map<std::string, std::string>> read_firewall_session_table_list_by_id_get_list(const std::string &name);

}
}
}
}

