/**
* firewall API generated from firewall.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "FirewallApi.h"
#include "FirewallApiImpl.h"

using namespace polycube::service::model;
using namespace polycube::service::api::FirewallApiImpl;

#ifdef __cplusplus
extern "C" {
#endif

Response create_firewall_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    FirewallJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    create_firewall_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_firewall_chain_append_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainAppendInputJsonObject unique_value { request_body };


    auto x = create_firewall_chain_append_by_id(unique_name, unique_chainName_, unique_value);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_firewall_chain_batch_by_id_handler(
    const char *name, const Key *keys,
    size_t num_keys ,
    const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainBatchInputJsonObject unique_value { request_body };

    create_firewall_chain_batch_by_id(unique_name, unique_chainName_, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_firewall_chain_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainJsonObject unique_value { request_body };

    unique_value.setName(unique_chainName_);
    create_firewall_chain_by_id(unique_name, unique_chainName_, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_firewall_chain_delete_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainDeleteInputJsonObject unique_value { request_body };

    create_firewall_chain_delete_by_id(unique_name, unique_chainName_, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_firewall_chain_insert_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainInsertInputJsonObject unique_value { request_body };


    auto x = create_firewall_chain_insert_by_id(unique_name, unique_chainName_, unique_value);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_firewall_chain_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<ChainJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ChainJsonObject> unique_value;
    for (auto &j : request_body) {
      ChainJsonObject a { j };
      unique_value.push_back(a);
    }
    create_firewall_chain_list_by_id(unique_name, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_firewall_chain_reset_counters_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {

    auto x = create_firewall_chain_reset_counters_by_id(unique_name, unique_chainName_);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kCreated, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_firewall_chain_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainRuleJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    create_firewall_chain_rule_by_id(unique_name, unique_chainName_, unique_id, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response create_firewall_chain_rule_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  // Getting the body param
  std::vector<ChainRuleJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ChainRuleJsonObject> unique_value;
    for (auto &j : request_body) {
      ChainRuleJsonObject a { j };
      unique_value.push_back(a);
    }
    create_firewall_chain_rule_list_by_id(unique_name, unique_chainName_, unique_value);
    return { kCreated, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_firewall_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_firewall_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_firewall_chain_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    delete_firewall_chain_by_id(unique_name, unique_chainName_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_firewall_chain_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {
    delete_firewall_chain_list_by_id(unique_name);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_firewall_chain_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    delete_firewall_chain_rule_by_id(unique_name, unique_chainName_, unique_id);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response delete_firewall_chain_rule_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    delete_firewall_chain_rule_list_by_id(unique_name, unique_chainName_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_accept_established_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_firewall_accept_established_by_id(unique_name);
    nlohmann::json response_body;
    response_body = FirewallJsonObject::FirewallAcceptEstablishedEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_firewall_by_id(unique_name);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {

    auto x = read_firewall_chain_by_id(unique_name, unique_chainName_);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_default_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {

    auto x = read_firewall_chain_default_by_id(unique_name, unique_chainName_);
    nlohmann::json response_body;
    response_body = ChainJsonObject::ActionEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_firewall_chain_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_rule_action_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_rule_action_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = ChainRuleJsonObject::ActionEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_rule_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_rule_conntrack_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_rule_conntrack_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = ChainRuleJsonObject::ConntrackstatusEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_rule_description_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_rule_description_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_rule_dport_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_rule_dport_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_rule_dst_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_rule_dst_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_rule_l4proto_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_rule_l4proto_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_rule_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {

    auto x = read_firewall_chain_rule_list_by_id(unique_name, unique_chainName_);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_rule_sport_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_rule_sport_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_rule_src_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_rule_src_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_rule_tcpflags_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_rule_tcpflags_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_stats_action_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_stats_action_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = ChainStatsJsonObject::ActionEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_stats_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_stats_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_stats_bytes_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_stats_bytes_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_stats_conntrack_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_stats_conntrack_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = ChainStatsJsonObject::ConntrackstatusEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_stats_description_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_stats_description_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_stats_dport_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_stats_dport_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_stats_dst_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_stats_dst_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_stats_l4proto_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_stats_l4proto_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_stats_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {

    auto x = read_firewall_chain_stats_list_by_id(unique_name, unique_chainName_);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_stats_pkts_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_stats_pkts_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_stats_sport_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_stats_sport_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_stats_src_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_stats_src_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_chain_stats_tcpflags_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {

    auto x = read_firewall_chain_stats_tcpflags_by_id(unique_name, unique_chainName_, unique_id);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_conntrack_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_firewall_conntrack_by_id(unique_name);
    nlohmann::json response_body;
    response_body = FirewallJsonObject::FirewallConntrackEnum_to_string(x);
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {


  try {

    auto x = read_firewall_list_by_id();
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_session_table_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_src;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "src")) {
      unique_src = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_dst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "dst")) {
      unique_dst = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_l4proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "l4proto")) {
      unique_l4proto = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_sport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "sport")) {
      unique_sport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_dport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "dport")) {
      unique_dport = keys[i].value.uint16;
      break;
    }
  }


  try {

    auto x = read_firewall_session_table_by_id(unique_name, unique_src, unique_dst, unique_l4proto, unique_sport, unique_dport);
    nlohmann::json response_body;
    response_body = x.toJson();
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_session_table_eta_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_src;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "src")) {
      unique_src = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_dst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "dst")) {
      unique_dst = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_l4proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "l4proto")) {
      unique_l4proto = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_sport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "sport")) {
      unique_sport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_dport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "dport")) {
      unique_dport = keys[i].value.uint16;
      break;
    }
  }


  try {

    auto x = read_firewall_session_table_eta_by_id(unique_name, unique_src, unique_dst, unique_l4proto, unique_sport, unique_dport);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_session_table_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };

  try {

    auto x = read_firewall_session_table_list_by_id(unique_name);
    nlohmann::json response_body;
    for (auto &i : x) {
      response_body += i.toJson();
    }
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response read_firewall_session_table_state_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_src;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "src")) {
      unique_src = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_dst;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "dst")) {
      unique_dst = std::string { keys[i].value.string };
      break;
    }
  }

  std::string unique_l4proto;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "l4proto")) {
      unique_l4proto = std::string { keys[i].value.string };
      break;
    }
  }

  uint16_t unique_sport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "sport")) {
      unique_sport = keys[i].value.uint16;
      break;
    }
  }

  uint16_t unique_dport;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "dport")) {
      unique_dport = keys[i].value.uint16;
      break;
    }
  }


  try {

    auto x = read_firewall_session_table_state_by_id(unique_name, unique_src, unique_dst, unique_l4proto, unique_sport, unique_dport);
    nlohmann::json response_body;
    response_body = x;
    return { kOk, ::strdup(response_body.dump().c_str()) };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_firewall_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    FirewallJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    replace_firewall_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_firewall_chain_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainJsonObject unique_value { request_body };

    unique_value.setName(unique_chainName_);
    replace_firewall_chain_by_id(unique_name, unique_chainName_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_firewall_chain_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<ChainJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ChainJsonObject> unique_value;
    for (auto &j : request_body) {
      ChainJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_firewall_chain_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_firewall_chain_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainRuleJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    replace_firewall_chain_rule_by_id(unique_name, unique_chainName_, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response replace_firewall_chain_rule_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  // Getting the body param
  std::vector<ChainRuleJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ChainRuleJsonObject> unique_value;
    for (auto &j : request_body) {
      ChainRuleJsonObject a { j };
      unique_value.push_back(a);
    }
    replace_firewall_chain_rule_list_by_id(unique_name, unique_chainName_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_firewall_accept_established_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    FirewallAcceptEstablishedEnum unique_value_ = FirewallJsonObject::string_to_FirewallAcceptEstablishedEnum(request_body);
    update_firewall_accept_established_by_id(unique_name, unique_value_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_firewall_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    FirewallJsonObject unique_value { request_body };

    unique_value.setName(unique_name);
    update_firewall_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_firewall_chain_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainJsonObject unique_value { request_body };

    unique_value.setName(unique_chainName_);
    update_firewall_chain_by_id(unique_name, unique_chainName_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_firewall_chain_default_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    ActionEnum unique_value_ = ChainJsonObject::string_to_ActionEnum(request_body);
    update_firewall_chain_default_by_id(unique_name, unique_chainName_, unique_value_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_firewall_chain_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  // Getting the body param
  std::vector<ChainJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ChainJsonObject> unique_value;
    for (auto &j : request_body) {
      ChainJsonObject a { j };
      unique_value.push_back(a);
    }
    update_firewall_chain_list_by_id(unique_name, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_firewall_chain_rule_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  uint32_t unique_id;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "id")) {
      unique_id = keys[i].value.uint32;
      break;
    }
  }


  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    ChainRuleJsonObject unique_value { request_body };

    unique_value.setId(unique_id);
    update_firewall_chain_rule_by_id(unique_name, unique_chainName_, unique_id, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_firewall_chain_rule_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  // Getting the body param
  std::vector<ChainRuleJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<ChainRuleJsonObject> unique_value;
    for (auto &j : request_body) {
      ChainRuleJsonObject a { j };
      unique_value.push_back(a);
    }
    update_firewall_chain_rule_list_by_id(unique_name, unique_chainName_, unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_firewall_conntrack_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {
  // Getting the path params
  std::string unique_name { name };

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    FirewallConntrackEnum unique_value_ = FirewallJsonObject::string_to_FirewallConntrackEnum(request_body);
    update_firewall_conntrack_by_id(unique_name, unique_value_);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response update_firewall_list_by_id_handler(
  const char *name, const Key *keys,
  size_t num_keys ,
  const char *value) {

  // Getting the body param
  std::vector<FirewallJsonObject> unique_value;

  try {
    auto request_body = nlohmann::json::parse(std::string { value });
    // Getting the body param
    std::vector<FirewallJsonObject> unique_value;
    for (auto &j : request_body) {
      FirewallJsonObject a { j };
      unique_value.push_back(a);
    }
    update_firewall_list_by_id(unique_value);
    return { kOk, nullptr };
  } catch(const std::exception &e) {
    return { kGenericError, ::strdup(e.what()) };
  }
}

Response firewall_chain_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_firewall_chain_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response firewall_chain_rule_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  nlohmann::json val = read_firewall_chain_rule_list_by_id_get_list(unique_name, unique_chainName_);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response firewall_chain_stats_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  std::string unique_chainName;
  for (size_t i = 0; i < num_keys; ++i) {
    if (!strcmp(keys[i].name, "chain_name")) {
      unique_chainName = std::string { keys[i].value.string };
      break;
    }
  }
  auto unique_chainName_ = ChainJsonObject::string_to_ChainNameEnum(unique_chainName);

  nlohmann::json val = read_firewall_chain_stats_list_by_id_get_list(unique_name, unique_chainName_);

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response firewall_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {

  nlohmann::json val = read_firewall_list_by_id_get_list();

  return { kOk, ::strdup(val.dump().c_str()) };
}

Response firewall_session_table_list_by_id_help(
  const char *name, const Key *keys, size_t num_keys) {
  // Getting the path params
  std::string unique_name { name };
  nlohmann::json val = read_firewall_session_table_list_by_id_get_list(unique_name);

  return { kOk, ::strdup(val.dump().c_str()) };
}

#ifdef __cplusplus
}
#endif

