/**
* ddosmitigator API
* ddosmitigator API generated from ddosmitigator.yang
*
* OpenAPI spec version: 1.0.0
*
* NOTE: This class is auto generated by the swagger code generator program.
* https://github.com/polycube-network/swagger-codegen.git
* branch polycube
*/


/* Do not edit this file manually */


#include "DdosmitigatorApiImpl.h"

namespace io {
namespace swagger {
namespace server {
namespace api {

using namespace io::swagger::server::model;

namespace DdosmitigatorApiImpl {
namespace {
std::unordered_map<std::string, std::shared_ptr<Ddosmitigator>> cubes;
std::mutex cubes_mutex;

std::shared_ptr<Ddosmitigator> get_cube(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  auto iter = cubes.find(name);
  if (iter == cubes.end()) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }

  return iter->second;
}

}

void create_ddosmitigator_by_id(const std::string &name, const DdosmitigatorJsonObject &jsonObject) {
  {
    // check if name is valid before creating it
    std::lock_guard<std::mutex> guard(cubes_mutex);
    if (cubes.count(name) != 0) {
      throw std::runtime_error("There is already a cube with name " + name);
    }
  }
  auto ptr = std::make_shared<Ddosmitigator>(name, jsonObject);
  std::unordered_map<std::string, std::shared_ptr<Ddosmitigator>>::iterator iter;
  bool inserted;

  std::lock_guard<std::mutex> guard(cubes_mutex);
  std::tie(iter, inserted) = cubes.emplace(name, std::move(ptr));

  if (!inserted) {
    throw std::runtime_error("There is already a cube with name " + name);
  }
}

void replace_ddosmitigator_by_id(const std::string &name, const DdosmitigatorJsonObject &bridge){
  throw std::runtime_error("Method not supported!");
}

void delete_ddosmitigator_by_id(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  if (cubes.count(name) == 0) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }
  cubes.erase(name);
}

std::vector<DdosmitigatorJsonObject> read_ddosmitigator_list_by_id() {
  std::vector<DdosmitigatorJsonObject> jsonObject_vect;
  for(auto &i : cubes) {
    auto m = get_cube(i.first);
    jsonObject_vect.push_back(m->toJsonObject());
  }
  return jsonObject_vect;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_ddosmitigator_list_by_id_get_list() {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  for (auto &x : cubes) {
    nlohmann::fifo_map<std::string, std::string> m;
    m["name"] = x.first;
    r.push_back(std::move(m));
  }
  return r;
}

/**
* @brief   Create blacklist-dst by ID
*
* Create operation of resource: blacklist-dst*
*
* @param[in] name ID of name
* @param[in] ip ID of ip
* @param[in] value blacklist-dstbody object
*
* Responses:
*
*/
void
create_ddosmitigator_blacklist_dst_by_id(const std::string &name, const std::string &ip, const BlacklistDstJsonObject &value) {
  auto ddosmitigator = get_cube(name);

  ddosmitigator->addBlacklistDst(ip, value);
}

/**
* @brief   Create blacklist-dst by ID
*
* Create operation of resource: blacklist-dst*
*
* @param[in] name ID of name
* @param[in] value blacklist-dstbody object
*
* Responses:
*
*/
void
create_ddosmitigator_blacklist_dst_list_by_id(const std::string &name, const std::vector<BlacklistDstJsonObject> &value) {
  auto ddosmitigator = get_cube(name);
  ddosmitigator->addBlacklistDstList(value);
}

/**
* @brief   Create blacklist-src by ID
*
* Create operation of resource: blacklist-src*
*
* @param[in] name ID of name
* @param[in] ip ID of ip
* @param[in] value blacklist-srcbody object
*
* Responses:
*
*/
void
create_ddosmitigator_blacklist_src_by_id(const std::string &name, const std::string &ip, const BlacklistSrcJsonObject &value) {
  auto ddosmitigator = get_cube(name);

  ddosmitigator->addBlacklistSrc(ip, value);
}

/**
* @brief   Create blacklist-src by ID
*
* Create operation of resource: blacklist-src*
*
* @param[in] name ID of name
* @param[in] value blacklist-srcbody object
*
* Responses:
*
*/
void
create_ddosmitigator_blacklist_src_list_by_id(const std::string &name, const std::vector<BlacklistSrcJsonObject> &value) {
  auto ddosmitigator = get_cube(name);
  ddosmitigator->addBlacklistSrcList(value);
}

/**
* @brief   Delete blacklist-dst by ID
*
* Delete operation of resource: blacklist-dst*
*
* @param[in] name ID of name
* @param[in] ip ID of ip
*
* Responses:
*
*/
void
delete_ddosmitigator_blacklist_dst_by_id(const std::string &name, const std::string &ip) {
  auto ddosmitigator = get_cube(name);

  ddosmitigator->delBlacklistDst(ip);
}

/**
* @brief   Delete blacklist-dst by ID
*
* Delete operation of resource: blacklist-dst*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_ddosmitigator_blacklist_dst_list_by_id(const std::string &name) {
  auto ddosmitigator = get_cube(name);
  ddosmitigator->delBlacklistDstList();
}

/**
* @brief   Delete blacklist-src by ID
*
* Delete operation of resource: blacklist-src*
*
* @param[in] name ID of name
* @param[in] ip ID of ip
*
* Responses:
*
*/
void
delete_ddosmitigator_blacklist_src_by_id(const std::string &name, const std::string &ip) {
  auto ddosmitigator = get_cube(name);

  ddosmitigator->delBlacklistSrc(ip);
}

/**
* @brief   Delete blacklist-src by ID
*
* Delete operation of resource: blacklist-src*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_ddosmitigator_blacklist_src_list_by_id(const std::string &name) {
  auto ddosmitigator = get_cube(name);
  ddosmitigator->delBlacklistSrcList();
}

/**
* @brief   Read blacklist-dst by ID
*
* Read operation of resource: blacklist-dst*
*
* @param[in] name ID of name
* @param[in] ip ID of ip
*
* Responses:
* BlacklistDstJsonObject
*/
BlacklistDstJsonObject
read_ddosmitigator_blacklist_dst_by_id(const std::string &name, const std::string &ip) {
  auto ddosmitigator = get_cube(name);
  return ddosmitigator->getBlacklistDst(ip)->toJsonObject();

}

/**
* @brief   Read drop-pkts by ID
*
* Read operation of resource: drop-pkts*
*
* @param[in] name ID of name
* @param[in] ip ID of ip
*
* Responses:
* uint64_t
*/
uint64_t
read_ddosmitigator_blacklist_dst_drop_pkts_by_id(const std::string &name, const std::string &ip) {
  auto ddosmitigator = get_cube(name);
  auto blacklistDst = ddosmitigator->getBlacklistDst(ip);
  return blacklistDst->getDropPkts();

}

/**
* @brief   Read blacklist-dst by ID
*
* Read operation of resource: blacklist-dst*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<BlacklistDstJsonObject>
*/
std::vector<BlacklistDstJsonObject>
read_ddosmitigator_blacklist_dst_list_by_id(const std::string &name) {
  auto ddosmitigator = get_cube(name);
  auto &&blacklistDst = ddosmitigator->getBlacklistDstList();
  std::vector<BlacklistDstJsonObject> m;
  for(auto &i : blacklistDst)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read blacklist-src by ID
*
* Read operation of resource: blacklist-src*
*
* @param[in] name ID of name
* @param[in] ip ID of ip
*
* Responses:
* BlacklistSrcJsonObject
*/
BlacklistSrcJsonObject
read_ddosmitigator_blacklist_src_by_id(const std::string &name, const std::string &ip) {
  auto ddosmitigator = get_cube(name);
  return ddosmitigator->getBlacklistSrc(ip)->toJsonObject();

}

/**
* @brief   Read drop-pkts by ID
*
* Read operation of resource: drop-pkts*
*
* @param[in] name ID of name
* @param[in] ip ID of ip
*
* Responses:
* uint64_t
*/
uint64_t
read_ddosmitigator_blacklist_src_drop_pkts_by_id(const std::string &name, const std::string &ip) {
  auto ddosmitigator = get_cube(name);
  auto blacklistSrc = ddosmitigator->getBlacklistSrc(ip);
  return blacklistSrc->getDropPkts();

}

/**
* @brief   Read blacklist-src by ID
*
* Read operation of resource: blacklist-src*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<BlacklistSrcJsonObject>
*/
std::vector<BlacklistSrcJsonObject>
read_ddosmitigator_blacklist_src_list_by_id(const std::string &name) {
  auto ddosmitigator = get_cube(name);
  auto &&blacklistSrc = ddosmitigator->getBlacklistSrcList();
  std::vector<BlacklistSrcJsonObject> m;
  for(auto &i : blacklistSrc)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read ddosmitigator by ID
*
* Read operation of resource: ddosmitigator*
*
* @param[in] name ID of name
*
* Responses:
* DdosmitigatorJsonObject
*/
DdosmitigatorJsonObject
read_ddosmitigator_by_id(const std::string &name) {
  return get_cube(name)->toJsonObject();

}

/**
* @brief   Read stats by ID
*
* Read operation of resource: stats*
*
* @param[in] name ID of name
*
* Responses:
* StatsJsonObject
*/
StatsJsonObject
read_ddosmitigator_stats_by_id(const std::string &name) {
  auto ddosmitigator = get_cube(name);
  return ddosmitigator->getStats()->toJsonObject();

}

/**
* @brief   Read pkts by ID
*
* Read operation of resource: pkts*
*
* @param[in] name ID of name
*
* Responses:
* uint64_t
*/
uint64_t
read_ddosmitigator_stats_pkts_by_id(const std::string &name) {
  auto ddosmitigator = get_cube(name);
  auto stats = ddosmitigator->getStats();
  return stats->getPkts();

}

/**
* @brief   Read pps by ID
*
* Read operation of resource: pps*
*
* @param[in] name ID of name
*
* Responses:
* uint64_t
*/
uint64_t
read_ddosmitigator_stats_pps_by_id(const std::string &name) {
  auto ddosmitigator = get_cube(name);
  auto stats = ddosmitigator->getStats();
  return stats->getPps();

}

/**
* @brief   Replace blacklist-dst by ID
*
* Replace operation of resource: blacklist-dst*
*
* @param[in] name ID of name
* @param[in] ip ID of ip
* @param[in] value blacklist-dstbody object
*
* Responses:
*
*/
void
replace_ddosmitigator_blacklist_dst_by_id(const std::string &name, const std::string &ip, const BlacklistDstJsonObject &value) {
  auto ddosmitigator = get_cube(name);

  ddosmitigator->replaceBlacklistDst(ip, value);
}

/**
* @brief   Replace blacklist-dst by ID
*
* Replace operation of resource: blacklist-dst*
*
* @param[in] name ID of name
* @param[in] value blacklist-dstbody object
*
* Responses:
*
*/
void
replace_ddosmitigator_blacklist_dst_list_by_id(const std::string &name, const std::vector<BlacklistDstJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace blacklist-src by ID
*
* Replace operation of resource: blacklist-src*
*
* @param[in] name ID of name
* @param[in] ip ID of ip
* @param[in] value blacklist-srcbody object
*
* Responses:
*
*/
void
replace_ddosmitigator_blacklist_src_by_id(const std::string &name, const std::string &ip, const BlacklistSrcJsonObject &value) {
  auto ddosmitigator = get_cube(name);

  ddosmitigator->replaceBlacklistSrc(ip, value);
}

/**
* @brief   Replace blacklist-src by ID
*
* Replace operation of resource: blacklist-src*
*
* @param[in] name ID of name
* @param[in] value blacklist-srcbody object
*
* Responses:
*
*/
void
replace_ddosmitigator_blacklist_src_list_by_id(const std::string &name, const std::vector<BlacklistSrcJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update blacklist-dst by ID
*
* Update operation of resource: blacklist-dst*
*
* @param[in] name ID of name
* @param[in] ip ID of ip
* @param[in] value blacklist-dstbody object
*
* Responses:
*
*/
void
update_ddosmitigator_blacklist_dst_by_id(const std::string &name, const std::string &ip, const BlacklistDstJsonObject &value) {
  auto ddosmitigator = get_cube(name);
  auto blacklistDst = ddosmitigator->getBlacklistDst(ip);

  blacklistDst->update(value);
}

/**
* @brief   Update blacklist-dst by ID
*
* Update operation of resource: blacklist-dst*
*
* @param[in] name ID of name
* @param[in] value blacklist-dstbody object
*
* Responses:
*
*/
void
update_ddosmitigator_blacklist_dst_list_by_id(const std::string &name, const std::vector<BlacklistDstJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update blacklist-src by ID
*
* Update operation of resource: blacklist-src*
*
* @param[in] name ID of name
* @param[in] ip ID of ip
* @param[in] value blacklist-srcbody object
*
* Responses:
*
*/
void
update_ddosmitigator_blacklist_src_by_id(const std::string &name, const std::string &ip, const BlacklistSrcJsonObject &value) {
  auto ddosmitigator = get_cube(name);
  auto blacklistSrc = ddosmitigator->getBlacklistSrc(ip);

  blacklistSrc->update(value);
}

/**
* @brief   Update blacklist-src by ID
*
* Update operation of resource: blacklist-src*
*
* @param[in] name ID of name
* @param[in] value blacklist-srcbody object
*
* Responses:
*
*/
void
update_ddosmitigator_blacklist_src_list_by_id(const std::string &name, const std::vector<BlacklistSrcJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update ddosmitigator by ID
*
* Update operation of resource: ddosmitigator*
*
* @param[in] name ID of name
* @param[in] value ddosmitigatorbody object
*
* Responses:
*
*/
void
update_ddosmitigator_by_id(const std::string &name, const DdosmitigatorJsonObject &value) {
  auto ddosmitigator = get_cube(name);

  ddosmitigator->update(value);
}

/**
* @brief   Update ddosmitigator by ID
*
* Update operation of resource: ddosmitigator*
*
* @param[in] value ddosmitigatorbody object
*
* Responses:
*
*/
void
update_ddosmitigator_list_by_id(const std::vector<DdosmitigatorJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}



/*
 * help related
 */

std::vector<nlohmann::fifo_map<std::string, std::string>> read_ddosmitigator_blacklist_dst_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&ddosmitigator = get_cube(name);

  auto &&blacklistDst = ddosmitigator->getBlacklistDstList();
  for(auto &i : blacklistDst) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["ip"] = i->getIp();

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_ddosmitigator_blacklist_src_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&ddosmitigator = get_cube(name);

  auto &&blacklistSrc = ddosmitigator->getBlacklistSrcList();
  for(auto &i : blacklistSrc) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["ip"] = i->getIp();

    r.push_back(keys);
  }
  return r;
}


}

}
}
}
}

