/**
* bridge API generated from bridge.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */



#include "PortsStpJsonObject.h"
#include <regex>

namespace polycube {
namespace service {
namespace model {

PortsStpJsonObject::PortsStpJsonObject() {
  m_vlanIsSet = false;
  m_stateIsSet = false;
  m_pathCostIsSet = false;
  m_portPriorityIsSet = false;
}

PortsStpJsonObject::PortsStpJsonObject(const nlohmann::json &val) :
  JsonObjectBase(val) {
  m_vlanIsSet = false;
  m_stateIsSet = false;
  m_pathCostIsSet = false;
  m_portPriorityIsSet = false;


  if (val.count("vlan")) {
    setVlan(val.at("vlan").get<uint16_t>());
  }

  if (val.count("state")) {
    setState(string_to_PortsStpStateEnum(val.at("state").get<std::string>()));
  }

  if (val.count("path-cost")) {
    setPathCost(val.at("path-cost").get<uint32_t>());
  }

  if (val.count("port-priority")) {
    setPortPriority(val.at("port-priority").get<uint8_t>());
  }
}

nlohmann::json PortsStpJsonObject::toJson() const {
  nlohmann::json val = nlohmann::json::object();
  if (!getBase().is_null()) {
    val.update(getBase());
  }

  if (m_vlanIsSet) {
    val["vlan"] = m_vlan;
  }

  if (m_stateIsSet) {
    val["state"] = PortsStpStateEnum_to_string(m_state);
  }

  if (m_pathCostIsSet) {
    val["path-cost"] = m_pathCost;
  }

  if (m_portPriorityIsSet) {
    val["port-priority"] = m_portPriority;
  }

  return val;
}

uint16_t PortsStpJsonObject::getVlan() const {
  return m_vlan;
}

void PortsStpJsonObject::setVlan(uint16_t value) {
  m_vlan = value;
  m_vlanIsSet = true;
}

bool PortsStpJsonObject::vlanIsSet() const {
  return m_vlanIsSet;
}



PortsStpStateEnum PortsStpJsonObject::getState() const {
  return m_state;
}

void PortsStpJsonObject::setState(PortsStpStateEnum value) {
  m_state = value;
  m_stateIsSet = true;
}

bool PortsStpJsonObject::stateIsSet() const {
  return m_stateIsSet;
}

void PortsStpJsonObject::unsetState() {
  m_stateIsSet = false;
}

std::string PortsStpJsonObject::PortsStpStateEnum_to_string(const PortsStpStateEnum &value){
  switch(value) {
    case PortsStpStateEnum::DISABLED:
      return std::string("disabled");
    case PortsStpStateEnum::BLOCKING:
      return std::string("blocking");
    case PortsStpStateEnum::LISTENING:
      return std::string("listening");
    case PortsStpStateEnum::LEARNING:
      return std::string("learning");
    case PortsStpStateEnum::FORWARDING:
      return std::string("forwarding");
    default:
      throw std::runtime_error("Bad PortsStp state");
  }
}

PortsStpStateEnum PortsStpJsonObject::string_to_PortsStpStateEnum(const std::string &str){
  if (JsonObjectBase::iequals("disabled", str))
    return PortsStpStateEnum::DISABLED;
  if (JsonObjectBase::iequals("blocking", str))
    return PortsStpStateEnum::BLOCKING;
  if (JsonObjectBase::iequals("listening", str))
    return PortsStpStateEnum::LISTENING;
  if (JsonObjectBase::iequals("learning", str))
    return PortsStpStateEnum::LEARNING;
  if (JsonObjectBase::iequals("forwarding", str))
    return PortsStpStateEnum::FORWARDING;
  throw std::runtime_error("PortsStp state is invalid");
}
uint32_t PortsStpJsonObject::getPathCost() const {
  return m_pathCost;
}

void PortsStpJsonObject::setPathCost(uint32_t value) {
  m_pathCost = value;
  m_pathCostIsSet = true;
}

bool PortsStpJsonObject::pathCostIsSet() const {
  return m_pathCostIsSet;
}

void PortsStpJsonObject::unsetPathCost() {
  m_pathCostIsSet = false;
}

uint8_t PortsStpJsonObject::getPortPriority() const {
  return m_portPriority;
}

void PortsStpJsonObject::setPortPriority(uint8_t value) {
  m_portPriority = value;
  m_portPriorityIsSet = true;
}

bool PortsStpJsonObject::portPriorityIsSet() const {
  return m_portPriorityIsSet;
}

void PortsStpJsonObject::unsetPortPriority() {
  m_portPriorityIsSet = false;
}


}
}
}

