/**
* bridge API generated from bridge.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */



#include "FdbEntryJsonObject.h"
#include <regex>

namespace polycube {
namespace service {
namespace model {

FdbEntryJsonObject::FdbEntryJsonObject() {
  m_vlanIsSet = false;
  m_macIsSet = false;
  m_type = FdbEntryTypeEnum::STATIC;
  m_typeIsSet = true;
  m_portIsSet = false;
  m_ageIsSet = false;
}

FdbEntryJsonObject::FdbEntryJsonObject(const nlohmann::json &val) :
  JsonObjectBase(val) {
  m_vlanIsSet = false;
  m_macIsSet = false;
  m_typeIsSet = false;
  m_portIsSet = false;
  m_ageIsSet = false;


  if (val.count("vlan")) {
    setVlan(val.at("vlan").get<uint16_t>());
  }

  if (val.count("mac")) {
    setMac(val.at("mac").get<std::string>());
  }

  if (val.count("type")) {
    setType(string_to_FdbEntryTypeEnum(val.at("type").get<std::string>()));
  }

  if (val.count("port")) {
    setPort(val.at("port").get<std::string>());
  }

  if (val.count("age")) {
    setAge(val.at("age").get<uint32_t>());
  }
}

nlohmann::json FdbEntryJsonObject::toJson() const {
  nlohmann::json val = nlohmann::json::object();
  if (!getBase().is_null()) {
    val.update(getBase());
  }

  if (m_vlanIsSet) {
    val["vlan"] = m_vlan;
  }

  if (m_macIsSet) {
    val["mac"] = m_mac;
  }

  if (m_typeIsSet) {
    val["type"] = FdbEntryTypeEnum_to_string(m_type);
  }

  if (m_portIsSet) {
    val["port"] = m_port;
  }

  if (m_ageIsSet) {
    val["age"] = m_age;
  }

  return val;
}

uint16_t FdbEntryJsonObject::getVlan() const {
  return m_vlan;
}

void FdbEntryJsonObject::setVlan(uint16_t value) {
  m_vlan = value;
  m_vlanIsSet = true;
}

bool FdbEntryJsonObject::vlanIsSet() const {
  return m_vlanIsSet;
}



std::string FdbEntryJsonObject::getMac() const {
  return m_mac;
}

void FdbEntryJsonObject::setMac(std::string value) {
  m_mac = value;
  m_macIsSet = true;
}

bool FdbEntryJsonObject::macIsSet() const {
  return m_macIsSet;
}



FdbEntryTypeEnum FdbEntryJsonObject::getType() const {
  return m_type;
}

void FdbEntryJsonObject::setType(FdbEntryTypeEnum value) {
  m_type = value;
  m_typeIsSet = true;
}

bool FdbEntryJsonObject::typeIsSet() const {
  return m_typeIsSet;
}

void FdbEntryJsonObject::unsetType() {
  m_typeIsSet = false;
}

std::string FdbEntryJsonObject::FdbEntryTypeEnum_to_string(const FdbEntryTypeEnum &value){
  switch(value) {
    case FdbEntryTypeEnum::STATIC:
      return std::string("static");
    case FdbEntryTypeEnum::DYNAMIC:
      return std::string("dynamic");
    default:
      throw std::runtime_error("Bad FdbEntry type");
  }
}

FdbEntryTypeEnum FdbEntryJsonObject::string_to_FdbEntryTypeEnum(const std::string &str){
  if (JsonObjectBase::iequals("static", str))
    return FdbEntryTypeEnum::STATIC;
  if (JsonObjectBase::iequals("dynamic", str))
    return FdbEntryTypeEnum::DYNAMIC;
  throw std::runtime_error("FdbEntry type is invalid");
}
std::string FdbEntryJsonObject::getPort() const {
  return m_port;
}

void FdbEntryJsonObject::setPort(std::string value) {
  m_port = value;
  m_portIsSet = true;
}

bool FdbEntryJsonObject::portIsSet() const {
  return m_portIsSet;
}



uint32_t FdbEntryJsonObject::getAge() const {
  return m_age;
}

void FdbEntryJsonObject::setAge(uint32_t value) {
  m_age = value;
  m_ageIsSet = true;
}

bool FdbEntryJsonObject::ageIsSet() const {
  return m_ageIsSet;
}

void FdbEntryJsonObject::unsetAge() {
  m_ageIsSet = false;
}


}
}
}

