/**
 * bridge API generated from bridge.yang
 *
 * NOTE: This file is auto generated by polycube-codegen
 * https://github.com/polycube-network/polycube-codegen
 */

/* Do not edit this file manually */

#include "PortsTrunkBase.h"
#include "../Bridge.h"

PortsTrunkBase::PortsTrunkBase(Ports &parent) : parent_(parent) {}

PortsTrunkBase::~PortsTrunkBase() {}

void PortsTrunkBase::update(const PortsTrunkJsonObject &conf) {
  if (conf.allowedIsSet()) {
    for (auto &i : conf.getAllowed()) {
      auto vlanid = i.getVlanid();
      auto m = getAllowed(vlanid);
      m->update(i);
    }
  }
  if (conf.nativeVlanEnabledIsSet()) {
    setNativeVlanEnabled(conf.getNativeVlanEnabled());
  }
  if (conf.nativeVlanIsSet()) {
    setNativeVlan(conf.getNativeVlan());
  }
}

PortsTrunkJsonObject PortsTrunkBase::toJsonObject() {
  PortsTrunkJsonObject conf;

  for (auto &i : getAllowedList()) {
    conf.addPortsTrunkAllowed(i->toJsonObject());
  }
  conf.setNativeVlanEnabled(getNativeVlanEnabled());
  conf.setNativeVlan(getNativeVlan());

  return conf;
}
void PortsTrunkBase::addAllowedList(
    const std::vector<PortsTrunkAllowedJsonObject> &conf) {
  for (auto &i : conf) {
    uint16_t vlanid_ = i.getVlanid();
    addAllowed(vlanid_, i);
  }
}

void PortsTrunkBase::replaceAllowed(const uint16_t &vlanid,
                                    const PortsTrunkAllowedJsonObject &conf) {
  delAllowed(vlanid);
  uint16_t vlanid_ = conf.getVlanid();
  addAllowed(vlanid_, conf);
}

void PortsTrunkBase::delAllowedList() {
  auto elements = getAllowedList();
  for (auto &i : elements) {
    uint16_t vlanid_ = i->getVlanid();
    delAllowed(vlanid_);
  }
}

std::shared_ptr<spdlog::logger> PortsTrunkBase::logger() {
  return parent_.logger();
}
