/**
 * bridge API generated from bridge.yang
 *
 * NOTE: This file is auto generated by polycube-codegen
 * https://github.com/polycube-network/polycube-codegen
 */

/* Do not edit this file manually */

/*
 * PortsBase.h
 *
 *
 */

#pragma once

#include "../serializer/PortsJsonObject.h"

#include "../PortsAccess.h"
#include "../PortsStp.h"
#include "../PortsTrunk.h"

#include "polycube/services/cube.h"
#include "polycube/services/fifo_map.hpp"
#include "polycube/services/port.h"
#include "polycube/services/utils.h"

#include <spdlog/spdlog.h>

using namespace polycube::service::model;

class Bridge;
class Ports;

class PortsBase : public polycube::service::Port {
 public:
  PortsBase(polycube::service::Cube<Ports> &parent,
            std::shared_ptr<polycube::service::PortIface> port);

  virtual ~PortsBase();
  virtual void update(const PortsJsonObject &conf);
  virtual PortsJsonObject toJsonObject();

  /// <summary>
  /// MAC address of the port
  /// </summary>
  virtual std::string getMac() = 0;

  /// <summary>
  /// Type of bridge interface: access/trunk
  /// </summary>
  virtual PortsModeEnum getMode() = 0;
  virtual void setMode(const PortsModeEnum &value) = 0;

  /// <summary>
  ///
  /// </summary>
  virtual std::shared_ptr<PortsAccess> getAccess() = 0;
  virtual void addAccess(const PortsAccessJsonObject &value) = 0;
  virtual void replaceAccess(const PortsAccessJsonObject &conf);
  virtual void delAccess() = 0;

  /// <summary>
  ///
  /// </summary>
  virtual std::shared_ptr<PortsTrunk> getTrunk() = 0;
  virtual void addTrunk(const PortsTrunkJsonObject &value) = 0;
  virtual void replaceTrunk(const PortsTrunkJsonObject &conf);
  virtual void delTrunk() = 0;

  /// <summary>
  /// Per-vlan Spanning Tree Protocol Port Configuration
  /// </summary>
  virtual std::shared_ptr<PortsStp> getStp(const uint16_t &vlan) = 0;
  virtual std::vector<std::shared_ptr<PortsStp>> getStpList() = 0;
  virtual void addStp(const uint16_t &vlan, const PortsStpJsonObject &conf) = 0;
  virtual void addStpList(const std::vector<PortsStpJsonObject> &conf);
  virtual void replaceStp(const uint16_t &vlan, const PortsStpJsonObject &conf);
  virtual void delStp(const uint16_t &vlan) = 0;
  virtual void delStpList();

  std::shared_ptr<spdlog::logger> logger();

 protected:
  Bridge &parent_;
};
