/**
 * bridge API generated from bridge.yang
 *
 * NOTE: This file is auto generated by polycube-codegen
 * https://github.com/polycube-network/polycube-codegen
 */

/* Do not edit this file manually */

#include "PortsBase.h"
#include "../Bridge.h"

PortsBase::PortsBase(polycube::service::Cube<Ports> &parent,
                     std::shared_ptr<polycube::service::PortIface> port)
    : Port(port), parent_(dynamic_cast<Bridge &>(parent)) {}

PortsBase::~PortsBase() {}

void PortsBase::update(const PortsJsonObject &conf) {
  Port::set_conf(conf.getBase());

  if (conf.modeIsSet()) {
    setMode(conf.getMode());
  }
  if (conf.accessIsSet()) {
    auto m = getAccess();
    m->update(conf.getAccess());
  }
  if (conf.trunkIsSet()) {
    auto m = getTrunk();
    m->update(conf.getTrunk());
  }
  if (conf.stpIsSet()) {
    for (auto &i : conf.getStp()) {
      auto vlan = i.getVlan();
      auto m = getStp(vlan);
      m->update(i);
    }
  }
}

PortsJsonObject PortsBase::toJsonObject() {
  PortsJsonObject conf;
  conf.setBase(Port::to_json());

  conf.setName(getName());
  conf.setMac(getMac());
  conf.setMode(getMode());
  conf.setAccess(getAccess()->toJsonObject());
  conf.setTrunk(getTrunk()->toJsonObject());
  for (auto &i : getStpList()) {
    conf.addPortsStp(i->toJsonObject());
  }

  return conf;
}

void PortsBase::replaceAccess(const PortsAccessJsonObject &conf) {
  // TODO: This is a basic default implementation, maybe you want to improve it
  delAccess();
  addAccess(conf);
}

void PortsBase::replaceTrunk(const PortsTrunkJsonObject &conf) {
  // TODO: This is a basic default implementation, maybe you want to improve it
  delTrunk();
  addTrunk(conf);
}
void PortsBase::addStpList(const std::vector<PortsStpJsonObject> &conf) {
  for (auto &i : conf) {
    uint16_t vlan_ = i.getVlan();
    addStp(vlan_, i);
  }
}

void PortsBase::replaceStp(const uint16_t &vlan,
                           const PortsStpJsonObject &conf) {
  delStp(vlan);
  uint16_t vlan_ = conf.getVlan();
  addStp(vlan_, conf);
}

void PortsBase::delStpList() {
  auto elements = getStpList();
  for (auto &i : elements) {
    uint16_t vlan_ = i->getVlan();
    delStp(vlan_);
  }
}

std::shared_ptr<spdlog::logger> PortsBase::logger() {
  return parent_.logger();
}
