/**
 * bridge API generated from bridge.yang
 *
 * NOTE: This file is auto generated by polycube-codegen
 * https://github.com/polycube-network/polycube-codegen
 */

/* Do not edit this file manually */

#include "FdbBase.h"
#include "../Bridge.h"

FdbBase::FdbBase(Bridge &parent) : parent_(parent) {}

FdbBase::~FdbBase() {}

void FdbBase::update(const FdbJsonObject &conf) {
  if (conf.agingTimeIsSet()) {
    setAgingTime(conf.getAgingTime());
  }
  if (conf.entryIsSet()) {
    for (auto &i : conf.getEntry()) {
      auto vlan = i.getVlan();
      auto mac = i.getMac();
      auto m = getEntry(vlan, mac);
      m->update(i);
    }
  }
}

FdbJsonObject FdbBase::toJsonObject() {
  FdbJsonObject conf;

  conf.setAgingTime(getAgingTime());
  for (auto &i : getEntryList()) {
    conf.addFdbEntry(i->toJsonObject());
  }

  return conf;
}
void FdbBase::addEntryList(const std::vector<FdbEntryJsonObject> &conf) {
  for (auto &i : conf) {
    uint16_t vlan_ = i.getVlan();
    std::string mac_ = i.getMac();
    addEntry(vlan_, mac_, i);
  }
}

void FdbBase::replaceEntry(const uint16_t &vlan, const std::string &mac,
                           const FdbEntryJsonObject &conf) {
  delEntry(vlan, mac);
  uint16_t vlan_ = conf.getVlan();
  std::string mac_ = conf.getMac();
  addEntry(vlan_, mac_, conf);
}

void FdbBase::delEntryList() {
  auto elements = getEntryList();
  for (auto &i : elements) {
    uint16_t vlan_ = i->getVlan();
    std::string mac_ = i->getMac();
    delEntry(vlan_, mac_);
  }
}

std::shared_ptr<spdlog::logger> FdbBase::logger() {
  return parent_.logger();
}
