/**
 * bridge API generated from bridge.yang
 *
 * NOTE: This file is auto generated by polycube-codegen
 * https://github.com/polycube-network/polycube-codegen
 */

/* Do not edit this file manually */

/*
 * BridgeBase.h
 *
 *
 */

#pragma once

#include "../serializer/BridgeJsonObject.h"

#include "../Fdb.h"
#include "../Ports.h"
#include "../Stp.h"

#include "polycube/services/cube.h"
#include "polycube/services/fifo_map.hpp"
#include "polycube/services/port.h"
#include "polycube/services/utils.h"

#include <spdlog/spdlog.h>

using namespace polycube::service::model;

class BridgeBase : public virtual polycube::service::Cube<Ports> {
 public:
  BridgeBase(const std::string name);

  virtual ~BridgeBase();
  virtual void update(const BridgeJsonObject &conf);
  virtual BridgeJsonObject toJsonObject();

  /// <summary>
  /// Entry of the ports table
  /// </summary>
  virtual std::shared_ptr<Ports> getPorts(const std::string &name);
  virtual std::vector<std::shared_ptr<Ports>> getPortsList();
  virtual void addPorts(const std::string &name, const PortsJsonObject &conf);
  virtual void addPortsList(const std::vector<PortsJsonObject> &conf);
  virtual void replacePorts(const std::string &name,
                            const PortsJsonObject &conf);
  virtual void delPorts(const std::string &name);
  virtual void delPortsList();

  /// <summary>
  ///
  /// </summary>
  virtual std::shared_ptr<Fdb> getFdb() = 0;
  virtual void addFdb(const FdbJsonObject &value) = 0;
  virtual void replaceFdb(const FdbJsonObject &conf);
  virtual void delFdb() = 0;

  /// <summary>
  /// Enable/Disable the STP protocol of the bridge
  /// </summary>
  virtual bool getStpEnabled() = 0;
  virtual void setStpEnabled(const bool &value) = 0;

  /// <summary>
  /// Main MAC address of the bridge used by the STP
  /// </summary>
  virtual std::string getMac() = 0;
  virtual void setMac(const std::string &value) = 0;

  /// <summary>
  /// Per-vlan Spanning Tree Protocol Configuration
  /// </summary>
  virtual std::shared_ptr<Stp> getStp(const uint16_t &vlan) = 0;
  virtual std::vector<std::shared_ptr<Stp>> getStpList() = 0;
  virtual void addStp(const uint16_t &vlan, const StpJsonObject &conf) = 0;
  virtual void addStpList(const std::vector<StpJsonObject> &conf);
  virtual void replaceStp(const uint16_t &vlan, const StpJsonObject &conf);
  virtual void delStp(const uint16_t &vlan) = 0;
  virtual void delStpList();
};
