/**
 * bridge API generated from bridge.yang
 *
 * NOTE: This file is auto generated by polycube-codegen
 * https://github.com/polycube-network/polycube-codegen
 */

/* Do not edit this file manually */

#include "BridgeBase.h"

BridgeBase::BridgeBase(const std::string name) {
  logger()->set_pattern("[%Y-%m-%d %H:%M:%S.%e] [Bridge] [%n] [%l] %v");
}

BridgeBase::~BridgeBase() {}

void BridgeBase::update(const BridgeJsonObject &conf) {
  Cube::set_conf(conf.getBase());

  if (conf.portsIsSet()) {
    for (auto &i : conf.getPorts()) {
      auto name = i.getName();
      auto m = getPorts(name);
      m->update(i);
    }
  }
  if (conf.fdbIsSet()) {
    auto m = getFdb();
    m->update(conf.getFdb());
  }
  if (conf.stpEnabledIsSet()) {
    setStpEnabled(conf.getStpEnabled());
  }
  if (conf.macIsSet()) {
    setMac(conf.getMac());
  }
  if (conf.stpIsSet()) {
    for (auto &i : conf.getStp()) {
      auto vlan = i.getVlan();
      auto m = getStp(vlan);
      m->update(i);
    }
  }
}

BridgeJsonObject BridgeBase::toJsonObject() {
  BridgeJsonObject conf;
  conf.setBase(Cube::to_json());

  conf.setName(getName());
  for (auto &i : getPortsList()) {
    conf.addPorts(i->toJsonObject());
  }
  conf.setFdb(getFdb()->toJsonObject());
  conf.setStpEnabled(getStpEnabled());
  conf.setMac(getMac());
  for (auto &i : getStpList()) {
    conf.addStp(i->toJsonObject());
  }

  return conf;
}
void BridgeBase::addPortsList(const std::vector<PortsJsonObject> &conf) {
  for (auto &i : conf) {
    std::string name_ = i.getName();
    addPorts(name_, i);
  }
}

void BridgeBase::replacePorts(const std::string &name,
                              const PortsJsonObject &conf) {
  delPorts(name);
  std::string name_ = conf.getName();
  addPorts(name_, conf);
}

void BridgeBase::delPortsList() {
  auto elements = getPortsList();
  for (auto &i : elements) {
    std::string name_ = i->getName();
    delPorts(name_);
  }
}

void BridgeBase::addPorts(const std::string &name,
                          const PortsJsonObject &conf) {
  add_port<PortsJsonObject>(name, conf);
}

void BridgeBase::delPorts(const std::string &name) {
  remove_port(name);
}

std::shared_ptr<Ports> BridgeBase::getPorts(const std::string &name) {
  return get_port(name);
}

std::vector<std::shared_ptr<Ports>> BridgeBase::getPortsList() {
  return get_ports();
}

void BridgeBase::replaceFdb(const FdbJsonObject &conf) {
  // TODO: This is a basic default implementation, maybe you want to improve it
  delFdb();
  addFdb(conf);
}
void BridgeBase::addStpList(const std::vector<StpJsonObject> &conf) {
  for (auto &i : conf) {
    uint16_t vlan_ = i.getVlan();
    addStp(vlan_, i);
  }
}

void BridgeBase::replaceStp(const uint16_t &vlan, const StpJsonObject &conf) {
  delStp(vlan);
  uint16_t vlan_ = conf.getVlan();
  addStp(vlan_, conf);
}

void BridgeBase::delStpList() {
  auto elements = getStpList();
  for (auto &i : elements) {
    uint16_t vlan_ = i->getVlan();
    delStp(vlan_);
  }
}
