/**
* bridge API generated from bridge.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */

/*
* BridgeApiImpl.h
*
*
*/

#pragma once


#include <memory>
#include <map>
#include <mutex>
#include "../Bridge.h"

#include "BridgeJsonObject.h"
#include "FdbJsonObject.h"
#include "FdbEntryJsonObject.h"
#include "PortsJsonObject.h"
#include "PortsAccessJsonObject.h"
#include "PortsStpJsonObject.h"
#include "PortsTrunkJsonObject.h"
#include "PortsTrunkAllowedJsonObject.h"
#include "StpJsonObject.h"
#include <vector>

namespace polycube {
namespace service {
namespace api {

using namespace polycube::service::model;

namespace BridgeApiImpl {
  void create_bridge_by_id(const std::string &name, const BridgeJsonObject &value);
  void create_bridge_fdb_by_id(const std::string &name, const FdbJsonObject &value);
  void create_bridge_fdb_entry_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac, const FdbEntryJsonObject &value);
  void create_bridge_fdb_entry_list_by_id(const std::string &name, const std::vector<FdbEntryJsonObject> &value);
  void create_bridge_fdb_flush_by_id(const std::string &name);
  void create_bridge_ports_access_by_id(const std::string &name, const std::string &portsName, const PortsAccessJsonObject &value);
  void create_bridge_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value);
  void create_bridge_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value);
  void create_bridge_ports_stp_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan, const PortsStpJsonObject &value);
  void create_bridge_ports_stp_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsStpJsonObject> &value);
  void create_bridge_ports_trunk_allowed_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlanid, const PortsTrunkAllowedJsonObject &value);
  void create_bridge_ports_trunk_allowed_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsTrunkAllowedJsonObject> &value);
  void create_bridge_ports_trunk_by_id(const std::string &name, const std::string &portsName, const PortsTrunkJsonObject &value);
  void create_bridge_stp_by_id(const std::string &name, const uint16_t &vlan, const StpJsonObject &value);
  void create_bridge_stp_list_by_id(const std::string &name, const std::vector<StpJsonObject> &value);
  void delete_bridge_by_id(const std::string &name);
  void delete_bridge_fdb_by_id(const std::string &name);
  void delete_bridge_fdb_entry_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac);
  void delete_bridge_fdb_entry_list_by_id(const std::string &name);
  void delete_bridge_ports_access_by_id(const std::string &name, const std::string &portsName);
  void delete_bridge_ports_by_id(const std::string &name, const std::string &portsName);
  void delete_bridge_ports_list_by_id(const std::string &name);
  void delete_bridge_ports_stp_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan);
  void delete_bridge_ports_stp_list_by_id(const std::string &name, const std::string &portsName);
  void delete_bridge_ports_trunk_allowed_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlanid);
  void delete_bridge_ports_trunk_allowed_list_by_id(const std::string &name, const std::string &portsName);
  void delete_bridge_ports_trunk_by_id(const std::string &name, const std::string &portsName);
  void delete_bridge_stp_by_id(const std::string &name, const uint16_t &vlan);
  void delete_bridge_stp_list_by_id(const std::string &name);
  BridgeJsonObject read_bridge_by_id(const std::string &name);
  uint32_t read_bridge_fdb_aging_time_by_id(const std::string &name);
  FdbJsonObject read_bridge_fdb_by_id(const std::string &name);
  uint32_t read_bridge_fdb_entry_age_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac);
  FdbEntryJsonObject read_bridge_fdb_entry_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac);
  std::vector<FdbEntryJsonObject> read_bridge_fdb_entry_list_by_id(const std::string &name);
  std::string read_bridge_fdb_entry_port_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac);
  FdbEntryTypeEnum read_bridge_fdb_entry_type_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac);
  std::vector<BridgeJsonObject> read_bridge_list_by_id();
  std::string read_bridge_mac_by_id(const std::string &name);
  PortsAccessJsonObject read_bridge_ports_access_by_id(const std::string &name, const std::string &portsName);
  uint16_t read_bridge_ports_access_vlanid_by_id(const std::string &name, const std::string &portsName);
  PortsJsonObject read_bridge_ports_by_id(const std::string &name, const std::string &portsName);
  std::vector<PortsJsonObject> read_bridge_ports_list_by_id(const std::string &name);
  std::string read_bridge_ports_mac_by_id(const std::string &name, const std::string &portsName);
  PortsModeEnum read_bridge_ports_mode_by_id(const std::string &name, const std::string &portsName);
  PortsStpJsonObject read_bridge_ports_stp_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan);
  std::vector<PortsStpJsonObject> read_bridge_ports_stp_list_by_id(const std::string &name, const std::string &portsName);
  uint32_t read_bridge_ports_stp_path_cost_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan);
  uint8_t read_bridge_ports_stp_port_priority_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan);
  PortsStpStateEnum read_bridge_ports_stp_state_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan);
  PortsTrunkAllowedJsonObject read_bridge_ports_trunk_allowed_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlanid);
  std::vector<PortsTrunkAllowedJsonObject> read_bridge_ports_trunk_allowed_list_by_id(const std::string &name, const std::string &portsName);
  PortsTrunkJsonObject read_bridge_ports_trunk_by_id(const std::string &name, const std::string &portsName);
  uint16_t read_bridge_ports_trunk_native_vlan_by_id(const std::string &name, const std::string &portsName);
  bool read_bridge_ports_trunk_native_vlan_enabled_by_id(const std::string &name, const std::string &portsName);
  StpJsonObject read_bridge_stp_by_id(const std::string &name, const uint16_t &vlan);
  bool read_bridge_stp_enabled_by_id(const std::string &name);
  uint32_t read_bridge_stp_forward_delay_by_id(const std::string &name, const uint16_t &vlan);
  uint32_t read_bridge_stp_hello_time_by_id(const std::string &name, const uint16_t &vlan);
  std::vector<StpJsonObject> read_bridge_stp_list_by_id(const std::string &name);
  uint32_t read_bridge_stp_max_message_age_by_id(const std::string &name, const uint16_t &vlan);
  uint16_t read_bridge_stp_priority_by_id(const std::string &name, const uint16_t &vlan);
  void replace_bridge_by_id(const std::string &name, const BridgeJsonObject &value);
  void replace_bridge_fdb_by_id(const std::string &name, const FdbJsonObject &value);
  void replace_bridge_fdb_entry_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac, const FdbEntryJsonObject &value);
  void replace_bridge_fdb_entry_list_by_id(const std::string &name, const std::vector<FdbEntryJsonObject> &value);
  void replace_bridge_ports_access_by_id(const std::string &name, const std::string &portsName, const PortsAccessJsonObject &value);
  void replace_bridge_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value);
  void replace_bridge_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value);
  void replace_bridge_ports_stp_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan, const PortsStpJsonObject &value);
  void replace_bridge_ports_stp_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsStpJsonObject> &value);
  void replace_bridge_ports_trunk_allowed_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlanid, const PortsTrunkAllowedJsonObject &value);
  void replace_bridge_ports_trunk_allowed_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsTrunkAllowedJsonObject> &value);
  void replace_bridge_ports_trunk_by_id(const std::string &name, const std::string &portsName, const PortsTrunkJsonObject &value);
  void replace_bridge_stp_by_id(const std::string &name, const uint16_t &vlan, const StpJsonObject &value);
  void replace_bridge_stp_list_by_id(const std::string &name, const std::vector<StpJsonObject> &value);
  void update_bridge_by_id(const std::string &name, const BridgeJsonObject &value);
  void update_bridge_fdb_aging_time_by_id(const std::string &name, const uint32_t &value);
  void update_bridge_fdb_by_id(const std::string &name, const FdbJsonObject &value);
  void update_bridge_fdb_entry_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac, const FdbEntryJsonObject &value);
  void update_bridge_fdb_entry_list_by_id(const std::string &name, const std::vector<FdbEntryJsonObject> &value);
  void update_bridge_fdb_entry_port_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac, const std::string &value);
  void update_bridge_list_by_id(const std::vector<BridgeJsonObject> &value);
  void update_bridge_mac_by_id(const std::string &name, const std::string &value);
  void update_bridge_ports_access_by_id(const std::string &name, const std::string &portsName, const PortsAccessJsonObject &value);
  void update_bridge_ports_access_vlanid_by_id(const std::string &name, const std::string &portsName, const uint16_t &value);
  void update_bridge_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value);
  void update_bridge_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value);
  void update_bridge_ports_mode_by_id(const std::string &name, const std::string &portsName, const PortsModeEnum &value);
  void update_bridge_ports_stp_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan, const PortsStpJsonObject &value);
  void update_bridge_ports_stp_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsStpJsonObject> &value);
  void update_bridge_ports_stp_path_cost_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan, const uint32_t &value);
  void update_bridge_ports_stp_port_priority_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan, const uint8_t &value);
  void update_bridge_ports_trunk_allowed_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlanid, const PortsTrunkAllowedJsonObject &value);
  void update_bridge_ports_trunk_allowed_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsTrunkAllowedJsonObject> &value);
  void update_bridge_ports_trunk_by_id(const std::string &name, const std::string &portsName, const PortsTrunkJsonObject &value);
  void update_bridge_ports_trunk_native_vlan_by_id(const std::string &name, const std::string &portsName, const uint16_t &value);
  void update_bridge_ports_trunk_native_vlan_enabled_by_id(const std::string &name, const std::string &portsName, const bool &value);
  void update_bridge_stp_by_id(const std::string &name, const uint16_t &vlan, const StpJsonObject &value);
  void update_bridge_stp_enabled_by_id(const std::string &name, const bool &value);
  void update_bridge_stp_forward_delay_by_id(const std::string &name, const uint16_t &vlan, const uint32_t &value);
  void update_bridge_stp_hello_time_by_id(const std::string &name, const uint16_t &vlan, const uint32_t &value);
  void update_bridge_stp_list_by_id(const std::string &name, const std::vector<StpJsonObject> &value);
  void update_bridge_stp_max_message_age_by_id(const std::string &name, const uint16_t &vlan, const uint32_t &value);
  void update_bridge_stp_priority_by_id(const std::string &name, const uint16_t &vlan, const uint16_t &value);

  /* help related */
  std::vector<nlohmann::fifo_map<std::string, std::string>> read_bridge_fdb_entry_list_by_id_get_list(const std::string &name);
  std::vector<nlohmann::fifo_map<std::string, std::string>> read_bridge_list_by_id_get_list();
  std::vector<nlohmann::fifo_map<std::string, std::string>> read_bridge_ports_list_by_id_get_list(const std::string &name);
  std::vector<nlohmann::fifo_map<std::string, std::string>> read_bridge_ports_stp_list_by_id_get_list(const std::string &name, const std::string &portsName);
  std::vector<nlohmann::fifo_map<std::string, std::string>> read_bridge_ports_trunk_allowed_list_by_id_get_list(const std::string &name, const std::string &portsName);
  std::vector<nlohmann::fifo_map<std::string, std::string>> read_bridge_stp_list_by_id_get_list(const std::string &name);

}
}
}
}

