/**
* bridge API generated from bridge.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "BridgeApiImpl.h"

namespace polycube {
namespace service {
namespace api {

using namespace polycube::service::model;

namespace BridgeApiImpl {
namespace {
std::unordered_map<std::string, std::shared_ptr<Bridge>> cubes;
std::mutex cubes_mutex;

std::shared_ptr<Bridge> get_cube(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  auto iter = cubes.find(name);
  if (iter == cubes.end()) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }

  return iter->second;
}

}

void create_bridge_by_id(const std::string &name, const BridgeJsonObject &jsonObject) {
  {
    // check if name is valid before creating it
    std::lock_guard<std::mutex> guard(cubes_mutex);
    if (cubes.count(name) != 0) {
      throw std::runtime_error("There is already a cube with name " + name);
    }
  }
  auto ptr = std::make_shared<Bridge>(name, jsonObject);
  std::unordered_map<std::string, std::shared_ptr<Bridge>>::iterator iter;
  bool inserted;

  std::lock_guard<std::mutex> guard(cubes_mutex);
  std::tie(iter, inserted) = cubes.emplace(name, std::move(ptr));

  if (!inserted) {
    throw std::runtime_error("There is already a cube with name " + name);
  }
}

void replace_bridge_by_id(const std::string &name, const BridgeJsonObject &bridge){
  throw std::runtime_error("Method not supported!");
}

void delete_bridge_by_id(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  if (cubes.count(name) == 0) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }
  cubes.erase(name);
}

std::vector<BridgeJsonObject> read_bridge_list_by_id() {
  std::vector<BridgeJsonObject> jsonObject_vect;
  for(auto &i : cubes) {
    auto m = get_cube(i.first);
    jsonObject_vect.push_back(m->toJsonObject());
  }
  return jsonObject_vect;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_bridge_list_by_id_get_list() {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  for (auto &x : cubes) {
    nlohmann::fifo_map<std::string, std::string> m;
    m["name"] = x.first;
    r.push_back(std::move(m));
  }
  return r;
}

/**
* @brief   Create fdb by ID
*
* Create operation of resource: fdb*
*
* @param[in] name ID of name
* @param[in] value fdbbody object
*
* Responses:
*
*/
void
create_bridge_fdb_by_id(const std::string &name, const FdbJsonObject &value) {
  auto bridge = get_cube(name);

  return bridge->addFdb(value);
}

/**
* @brief   Create entry by ID
*
* Create operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] mac ID of mac
* @param[in] value entrybody object
*
* Responses:
*
*/
void
create_bridge_fdb_entry_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac, const FdbEntryJsonObject &value) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();

  return fdb->addEntry(vlan, mac, value);
}

/**
* @brief   Create entry by ID
*
* Create operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
create_bridge_fdb_entry_list_by_id(const std::string &name, const std::vector<FdbEntryJsonObject> &value) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();
  fdb->addEntryList(value);
}

/**
* @brief   Create flush by ID
*
* Create operation of resource: flush*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
create_bridge_fdb_flush_by_id(const std::string &name) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();

  return fdb->flush();
}

/**
* @brief   Create access by ID
*
* Create operation of resource: access*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value accessbody object
*
* Responses:
*
*/
void
create_bridge_ports_access_by_id(const std::string &name, const std::string &portsName, const PortsAccessJsonObject &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);

  return ports->addAccess(value);
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_bridge_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto bridge = get_cube(name);

  return bridge->addPorts(portsName, value);
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_bridge_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  auto bridge = get_cube(name);
  bridge->addPortsList(value);
}

/**
* @brief   Create stp by ID
*
* Create operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlan ID of vlan
* @param[in] value stpbody object
*
* Responses:
*
*/
void
create_bridge_ports_stp_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan, const PortsStpJsonObject &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);

  return ports->addStp(vlan, value);
}

/**
* @brief   Create stp by ID
*
* Create operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value stpbody object
*
* Responses:
*
*/
void
create_bridge_ports_stp_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsStpJsonObject> &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  ports->addStpList(value);
}

/**
* @brief   Create allowed by ID
*
* Create operation of resource: allowed*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlanid ID of vlanid
* @param[in] value allowedbody object
*
* Responses:
*
*/
void
create_bridge_ports_trunk_allowed_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlanid, const PortsTrunkAllowedJsonObject &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto trunk = ports->getTrunk();

  return trunk->addAllowed(vlanid, value);
}

/**
* @brief   Create allowed by ID
*
* Create operation of resource: allowed*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value allowedbody object
*
* Responses:
*
*/
void
create_bridge_ports_trunk_allowed_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsTrunkAllowedJsonObject> &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto trunk = ports->getTrunk();
  trunk->addAllowedList(value);
}

/**
* @brief   Create trunk by ID
*
* Create operation of resource: trunk*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value trunkbody object
*
* Responses:
*
*/
void
create_bridge_ports_trunk_by_id(const std::string &name, const std::string &portsName, const PortsTrunkJsonObject &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);

  return ports->addTrunk(value);
}

/**
* @brief   Create stp by ID
*
* Create operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] value stpbody object
*
* Responses:
*
*/
void
create_bridge_stp_by_id(const std::string &name, const uint16_t &vlan, const StpJsonObject &value) {
  auto bridge = get_cube(name);

  return bridge->addStp(vlan, value);
}

/**
* @brief   Create stp by ID
*
* Create operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] value stpbody object
*
* Responses:
*
*/
void
create_bridge_stp_list_by_id(const std::string &name, const std::vector<StpJsonObject> &value) {
  auto bridge = get_cube(name);
  bridge->addStpList(value);
}

/**
* @brief   Delete fdb by ID
*
* Delete operation of resource: fdb*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_bridge_fdb_by_id(const std::string &name) {
  auto bridge = get_cube(name);

  return bridge->delFdb();
}

/**
* @brief   Delete entry by ID
*
* Delete operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] mac ID of mac
*
* Responses:
*
*/
void
delete_bridge_fdb_entry_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();

  return fdb->delEntry(vlan, mac);
}

/**
* @brief   Delete entry by ID
*
* Delete operation of resource: entry*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_bridge_fdb_entry_list_by_id(const std::string &name) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();
  fdb->delEntryList();
}

/**
* @brief   Delete access by ID
*
* Delete operation of resource: access*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
*
*/
void
delete_bridge_ports_access_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);

  return ports->delAccess();
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
*
*/
void
delete_bridge_ports_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);

  return bridge->delPorts(portsName);
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_bridge_ports_list_by_id(const std::string &name) {
  auto bridge = get_cube(name);
  bridge->delPortsList();
}

/**
* @brief   Delete stp by ID
*
* Delete operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlan ID of vlan
*
* Responses:
*
*/
void
delete_bridge_ports_stp_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);

  return ports->delStp(vlan);
}

/**
* @brief   Delete stp by ID
*
* Delete operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
*
*/
void
delete_bridge_ports_stp_list_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  ports->delStpList();
}

/**
* @brief   Delete allowed by ID
*
* Delete operation of resource: allowed*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlanid ID of vlanid
*
* Responses:
*
*/
void
delete_bridge_ports_trunk_allowed_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlanid) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto trunk = ports->getTrunk();

  return trunk->delAllowed(vlanid);
}

/**
* @brief   Delete allowed by ID
*
* Delete operation of resource: allowed*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
*
*/
void
delete_bridge_ports_trunk_allowed_list_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto trunk = ports->getTrunk();
  trunk->delAllowedList();
}

/**
* @brief   Delete trunk by ID
*
* Delete operation of resource: trunk*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
*
*/
void
delete_bridge_ports_trunk_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);

  return ports->delTrunk();
}

/**
* @brief   Delete stp by ID
*
* Delete operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
*
* Responses:
*
*/
void
delete_bridge_stp_by_id(const std::string &name, const uint16_t &vlan) {
  auto bridge = get_cube(name);

  return bridge->delStp(vlan);
}

/**
* @brief   Delete stp by ID
*
* Delete operation of resource: stp*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_bridge_stp_list_by_id(const std::string &name) {
  auto bridge = get_cube(name);
  bridge->delStpList();
}

/**
* @brief   Read bridge by ID
*
* Read operation of resource: bridge*
*
* @param[in] name ID of name
*
* Responses:
* BridgeJsonObject
*/
BridgeJsonObject
read_bridge_by_id(const std::string &name) {
  return get_cube(name)->toJsonObject();

}

/**
* @brief   Read aging-time by ID
*
* Read operation of resource: aging-time*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_bridge_fdb_aging_time_by_id(const std::string &name) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();
  return fdb->getAgingTime();

}

/**
* @brief   Read fdb by ID
*
* Read operation of resource: fdb*
*
* @param[in] name ID of name
*
* Responses:
* FdbJsonObject
*/
FdbJsonObject
read_bridge_fdb_by_id(const std::string &name) {
  auto bridge = get_cube(name);
  return bridge->getFdb()->toJsonObject();

}

/**
* @brief   Read age by ID
*
* Read operation of resource: age*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] mac ID of mac
*
* Responses:
* uint32_t
*/
uint32_t
read_bridge_fdb_entry_age_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();
  auto entry = fdb->getEntry(vlan, mac);
  return entry->getAge();

}

/**
* @brief   Read entry by ID
*
* Read operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] mac ID of mac
*
* Responses:
* FdbEntryJsonObject
*/
FdbEntryJsonObject
read_bridge_fdb_entry_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();
  return fdb->getEntry(vlan, mac)->toJsonObject();

}

/**
* @brief   Read entry by ID
*
* Read operation of resource: entry*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<FdbEntryJsonObject>
*/
std::vector<FdbEntryJsonObject>
read_bridge_fdb_entry_list_by_id(const std::string &name) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();
  auto &&entry = fdb->getEntryList();
  std::vector<FdbEntryJsonObject> m;
  for(auto &i : entry)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read port by ID
*
* Read operation of resource: port*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] mac ID of mac
*
* Responses:
* std::string
*/
std::string
read_bridge_fdb_entry_port_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();
  auto entry = fdb->getEntry(vlan, mac);
  return entry->getPort();

}

/**
* @brief   Read type by ID
*
* Read operation of resource: type*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] mac ID of mac
*
* Responses:
* FdbEntryTypeEnum
*/
FdbEntryTypeEnum
read_bridge_fdb_entry_type_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();
  auto entry = fdb->getEntry(vlan, mac);
  return entry->getType();

}

/**
* @brief   Read mac by ID
*
* Read operation of resource: mac*
*
* @param[in] name ID of name
*
* Responses:
* std::string
*/
std::string
read_bridge_mac_by_id(const std::string &name) {
  auto bridge = get_cube(name);
  return bridge->getMac();

}

/**
* @brief   Read access by ID
*
* Read operation of resource: access*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsAccessJsonObject
*/
PortsAccessJsonObject
read_bridge_ports_access_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  return ports->getAccess()->toJsonObject();

}

/**
* @brief   Read vlanid by ID
*
* Read operation of resource: vlanid*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* uint16_t
*/
uint16_t
read_bridge_ports_access_vlanid_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto access = ports->getAccess();
  return access->getVlanid();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsJsonObject
*/
PortsJsonObject
read_bridge_ports_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);
  return bridge->getPorts(portsName)->toJsonObject();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<PortsJsonObject>
*/
std::vector<PortsJsonObject>
read_bridge_ports_list_by_id(const std::string &name) {
  auto bridge = get_cube(name);
  auto &&ports = bridge->getPortsList();
  std::vector<PortsJsonObject> m;
  for(auto &i : ports)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read mac by ID
*
* Read operation of resource: mac*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* std::string
*/
std::string
read_bridge_ports_mac_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  return ports->getMac();

}

/**
* @brief   Read mode by ID
*
* Read operation of resource: mode*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsModeEnum
*/
PortsModeEnum
read_bridge_ports_mode_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  return ports->getMode();

}

/**
* @brief   Read stp by ID
*
* Read operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlan ID of vlan
*
* Responses:
* PortsStpJsonObject
*/
PortsStpJsonObject
read_bridge_ports_stp_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  return ports->getStp(vlan)->toJsonObject();

}

/**
* @brief   Read stp by ID
*
* Read operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* std::vector<PortsStpJsonObject>
*/
std::vector<PortsStpJsonObject>
read_bridge_ports_stp_list_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto &&stp = ports->getStpList();
  std::vector<PortsStpJsonObject> m;
  for(auto &i : stp)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read path-cost by ID
*
* Read operation of resource: path-cost*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlan ID of vlan
*
* Responses:
* uint32_t
*/
uint32_t
read_bridge_ports_stp_path_cost_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto stp = ports->getStp(vlan);
  return stp->getPathCost();

}

/**
* @brief   Read port-priority by ID
*
* Read operation of resource: port-priority*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlan ID of vlan
*
* Responses:
* uint8_t
*/
uint8_t
read_bridge_ports_stp_port_priority_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto stp = ports->getStp(vlan);
  return stp->getPortPriority();

}

/**
* @brief   Read state by ID
*
* Read operation of resource: state*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlan ID of vlan
*
* Responses:
* PortsStpStateEnum
*/
PortsStpStateEnum
read_bridge_ports_stp_state_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto stp = ports->getStp(vlan);
  return stp->getState();

}

/**
* @brief   Read allowed by ID
*
* Read operation of resource: allowed*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlanid ID of vlanid
*
* Responses:
* PortsTrunkAllowedJsonObject
*/
PortsTrunkAllowedJsonObject
read_bridge_ports_trunk_allowed_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlanid) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto trunk = ports->getTrunk();
  return trunk->getAllowed(vlanid)->toJsonObject();

}

/**
* @brief   Read allowed by ID
*
* Read operation of resource: allowed*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* std::vector<PortsTrunkAllowedJsonObject>
*/
std::vector<PortsTrunkAllowedJsonObject>
read_bridge_ports_trunk_allowed_list_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto trunk = ports->getTrunk();
  auto &&allowed = trunk->getAllowedList();
  std::vector<PortsTrunkAllowedJsonObject> m;
  for(auto &i : allowed)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read trunk by ID
*
* Read operation of resource: trunk*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsTrunkJsonObject
*/
PortsTrunkJsonObject
read_bridge_ports_trunk_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  return ports->getTrunk()->toJsonObject();

}

/**
* @brief   Read native-vlan by ID
*
* Read operation of resource: native-vlan*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* uint16_t
*/
uint16_t
read_bridge_ports_trunk_native_vlan_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto trunk = ports->getTrunk();
  return trunk->getNativeVlan();

}

/**
* @brief   Read native-vlan-enabled by ID
*
* Read operation of resource: native-vlan-enabled*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* bool
*/
bool
read_bridge_ports_trunk_native_vlan_enabled_by_id(const std::string &name, const std::string &portsName) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto trunk = ports->getTrunk();
  return trunk->getNativeVlanEnabled();

}

/**
* @brief   Read stp by ID
*
* Read operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
*
* Responses:
* StpJsonObject
*/
StpJsonObject
read_bridge_stp_by_id(const std::string &name, const uint16_t &vlan) {
  auto bridge = get_cube(name);
  return bridge->getStp(vlan)->toJsonObject();

}

/**
* @brief   Read stp-enabled by ID
*
* Read operation of resource: stp-enabled*
*
* @param[in] name ID of name
*
* Responses:
* bool
*/
bool
read_bridge_stp_enabled_by_id(const std::string &name) {
  auto bridge = get_cube(name);
  return bridge->getStpEnabled();

}

/**
* @brief   Read forward-delay by ID
*
* Read operation of resource: forward-delay*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
*
* Responses:
* uint32_t
*/
uint32_t
read_bridge_stp_forward_delay_by_id(const std::string &name, const uint16_t &vlan) {
  auto bridge = get_cube(name);
  auto stp = bridge->getStp(vlan);
  return stp->getForwardDelay();

}

/**
* @brief   Read hello-time by ID
*
* Read operation of resource: hello-time*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
*
* Responses:
* uint32_t
*/
uint32_t
read_bridge_stp_hello_time_by_id(const std::string &name, const uint16_t &vlan) {
  auto bridge = get_cube(name);
  auto stp = bridge->getStp(vlan);
  return stp->getHelloTime();

}

/**
* @brief   Read stp by ID
*
* Read operation of resource: stp*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<StpJsonObject>
*/
std::vector<StpJsonObject>
read_bridge_stp_list_by_id(const std::string &name) {
  auto bridge = get_cube(name);
  auto &&stp = bridge->getStpList();
  std::vector<StpJsonObject> m;
  for(auto &i : stp)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read max-message-age by ID
*
* Read operation of resource: max-message-age*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
*
* Responses:
* uint32_t
*/
uint32_t
read_bridge_stp_max_message_age_by_id(const std::string &name, const uint16_t &vlan) {
  auto bridge = get_cube(name);
  auto stp = bridge->getStp(vlan);
  return stp->getMaxMessageAge();

}

/**
* @brief   Read priority by ID
*
* Read operation of resource: priority*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
*
* Responses:
* uint16_t
*/
uint16_t
read_bridge_stp_priority_by_id(const std::string &name, const uint16_t &vlan) {
  auto bridge = get_cube(name);
  auto stp = bridge->getStp(vlan);
  return stp->getPriority();

}

/**
* @brief   Replace fdb by ID
*
* Replace operation of resource: fdb*
*
* @param[in] name ID of name
* @param[in] value fdbbody object
*
* Responses:
*
*/
void
replace_bridge_fdb_by_id(const std::string &name, const FdbJsonObject &value) {
  auto bridge = get_cube(name);

  return bridge->replaceFdb(value);
}

/**
* @brief   Replace entry by ID
*
* Replace operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] mac ID of mac
* @param[in] value entrybody object
*
* Responses:
*
*/
void
replace_bridge_fdb_entry_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac, const FdbEntryJsonObject &value) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();

  return fdb->replaceEntry(vlan, mac, value);
}

/**
* @brief   Replace entry by ID
*
* Replace operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
replace_bridge_fdb_entry_list_by_id(const std::string &name, const std::vector<FdbEntryJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace access by ID
*
* Replace operation of resource: access*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value accessbody object
*
* Responses:
*
*/
void
replace_bridge_ports_access_by_id(const std::string &name, const std::string &portsName, const PortsAccessJsonObject &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);

  return ports->replaceAccess(value);
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_bridge_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto bridge = get_cube(name);

  return bridge->replacePorts(portsName, value);
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_bridge_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace stp by ID
*
* Replace operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlan ID of vlan
* @param[in] value stpbody object
*
* Responses:
*
*/
void
replace_bridge_ports_stp_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan, const PortsStpJsonObject &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);

  return ports->replaceStp(vlan, value);
}

/**
* @brief   Replace stp by ID
*
* Replace operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value stpbody object
*
* Responses:
*
*/
void
replace_bridge_ports_stp_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsStpJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace allowed by ID
*
* Replace operation of resource: allowed*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlanid ID of vlanid
* @param[in] value allowedbody object
*
* Responses:
*
*/
void
replace_bridge_ports_trunk_allowed_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlanid, const PortsTrunkAllowedJsonObject &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto trunk = ports->getTrunk();

  return trunk->replaceAllowed(vlanid, value);
}

/**
* @brief   Replace allowed by ID
*
* Replace operation of resource: allowed*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value allowedbody object
*
* Responses:
*
*/
void
replace_bridge_ports_trunk_allowed_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsTrunkAllowedJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace trunk by ID
*
* Replace operation of resource: trunk*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value trunkbody object
*
* Responses:
*
*/
void
replace_bridge_ports_trunk_by_id(const std::string &name, const std::string &portsName, const PortsTrunkJsonObject &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);

  return ports->replaceTrunk(value);
}

/**
* @brief   Replace stp by ID
*
* Replace operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] value stpbody object
*
* Responses:
*
*/
void
replace_bridge_stp_by_id(const std::string &name, const uint16_t &vlan, const StpJsonObject &value) {
  auto bridge = get_cube(name);

  return bridge->replaceStp(vlan, value);
}

/**
* @brief   Replace stp by ID
*
* Replace operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] value stpbody object
*
* Responses:
*
*/
void
replace_bridge_stp_list_by_id(const std::string &name, const std::vector<StpJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update bridge by ID
*
* Update operation of resource: bridge*
*
* @param[in] name ID of name
* @param[in] value bridgebody object
*
* Responses:
*
*/
void
update_bridge_by_id(const std::string &name, const BridgeJsonObject &value) {
  auto bridge = get_cube(name);

  return bridge->update(value);
}

/**
* @brief   Update aging-time by ID
*
* Update operation of resource: aging-time*
*
* @param[in] name ID of name
* @param[in] value Aging time of the filtering database (in seconds)
*
* Responses:
*
*/
void
update_bridge_fdb_aging_time_by_id(const std::string &name, const uint32_t &value) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();

  return fdb->setAgingTime(value);
}

/**
* @brief   Update fdb by ID
*
* Update operation of resource: fdb*
*
* @param[in] name ID of name
* @param[in] value fdbbody object
*
* Responses:
*
*/
void
update_bridge_fdb_by_id(const std::string &name, const FdbJsonObject &value) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();

  return fdb->update(value);
}

/**
* @brief   Update entry by ID
*
* Update operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] mac ID of mac
* @param[in] value entrybody object
*
* Responses:
*
*/
void
update_bridge_fdb_entry_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac, const FdbEntryJsonObject &value) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();
  auto entry = fdb->getEntry(vlan, mac);

  return entry->update(value);
}

/**
* @brief   Update entry by ID
*
* Update operation of resource: entry*
*
* @param[in] name ID of name
* @param[in] value entrybody object
*
* Responses:
*
*/
void
update_bridge_fdb_entry_list_by_id(const std::string &name, const std::vector<FdbEntryJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update port by ID
*
* Update operation of resource: port*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] mac ID of mac
* @param[in] value Output port name
*
* Responses:
*
*/
void
update_bridge_fdb_entry_port_by_id(const std::string &name, const uint16_t &vlan, const std::string &mac, const std::string &value) {
  auto bridge = get_cube(name);
  auto fdb = bridge->getFdb();
  auto entry = fdb->getEntry(vlan, mac);

  return entry->setPort(value);
}

/**
* @brief   Update bridge by ID
*
* Update operation of resource: bridge*
*
* @param[in] value bridgebody object
*
* Responses:
*
*/
void
update_bridge_list_by_id(const std::vector<BridgeJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update mac by ID
*
* Update operation of resource: mac*
*
* @param[in] name ID of name
* @param[in] value Main MAC address of the bridge used by the STP
*
* Responses:
*
*/
void
update_bridge_mac_by_id(const std::string &name, const std::string &value) {
  auto bridge = get_cube(name);

  return bridge->setMac(value);
}

/**
* @brief   Update access by ID
*
* Update operation of resource: access*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value accessbody object
*
* Responses:
*
*/
void
update_bridge_ports_access_by_id(const std::string &name, const std::string &portsName, const PortsAccessJsonObject &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto access = ports->getAccess();

  return access->update(value);
}

/**
* @brief   Update vlanid by ID
*
* Update operation of resource: vlanid*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value VLAN associated with this interface
*
* Responses:
*
*/
void
update_bridge_ports_access_vlanid_by_id(const std::string &name, const std::string &portsName, const uint16_t &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto access = ports->getAccess();

  return access->setVlanid(value);
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_bridge_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);

  return ports->update(value);
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_bridge_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update mode by ID
*
* Update operation of resource: mode*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value Type of bridge interface: access/trunk
*
* Responses:
*
*/
void
update_bridge_ports_mode_by_id(const std::string &name, const std::string &portsName, const PortsModeEnum &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);

  return ports->setMode(value);
}

/**
* @brief   Update stp by ID
*
* Update operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlan ID of vlan
* @param[in] value stpbody object
*
* Responses:
*
*/
void
update_bridge_ports_stp_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan, const PortsStpJsonObject &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto stp = ports->getStp(vlan);

  return stp->update(value);
}

/**
* @brief   Update stp by ID
*
* Update operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value stpbody object
*
* Responses:
*
*/
void
update_bridge_ports_stp_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsStpJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update path-cost by ID
*
* Update operation of resource: path-cost*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlan ID of vlan
* @param[in] value STP cost associated with this interface
*
* Responses:
*
*/
void
update_bridge_ports_stp_path_cost_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan, const uint32_t &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto stp = ports->getStp(vlan);

  return stp->setPathCost(value);
}

/**
* @brief   Update port-priority by ID
*
* Update operation of resource: port-priority*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlan ID of vlan
* @param[in] value Port priority of this interface
*
* Responses:
*
*/
void
update_bridge_ports_stp_port_priority_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlan, const uint8_t &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto stp = ports->getStp(vlan);

  return stp->setPortPriority(value);
}

/**
* @brief   Update allowed by ID
*
* Update operation of resource: allowed*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] vlanid ID of vlanid
* @param[in] value allowedbody object
*
* Responses:
*
*/
void
update_bridge_ports_trunk_allowed_by_id(const std::string &name, const std::string &portsName, const uint16_t &vlanid, const PortsTrunkAllowedJsonObject &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto trunk = ports->getTrunk();
  auto allowed = trunk->getAllowed(vlanid);

  return allowed->update(value);
}

/**
* @brief   Update allowed by ID
*
* Update operation of resource: allowed*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value allowedbody object
*
* Responses:
*
*/
void
update_bridge_ports_trunk_allowed_list_by_id(const std::string &name, const std::string &portsName, const std::vector<PortsTrunkAllowedJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update trunk by ID
*
* Update operation of resource: trunk*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value trunkbody object
*
* Responses:
*
*/
void
update_bridge_ports_trunk_by_id(const std::string &name, const std::string &portsName, const PortsTrunkJsonObject &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto trunk = ports->getTrunk();

  return trunk->update(value);
}

/**
* @brief   Update native-vlan by ID
*
* Update operation of resource: native-vlan*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value VLAN that is not tagged in this trunk port
*
* Responses:
*
*/
void
update_bridge_ports_trunk_native_vlan_by_id(const std::string &name, const std::string &portsName, const uint16_t &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto trunk = ports->getTrunk();

  return trunk->setNativeVlan(value);
}

/**
* @brief   Update native-vlan-enabled by ID
*
* Update operation of resource: native-vlan-enabled*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value Enable/Disable the native vlan feature in this trunk port
*
* Responses:
*
*/
void
update_bridge_ports_trunk_native_vlan_enabled_by_id(const std::string &name, const std::string &portsName, const bool &value) {
  auto bridge = get_cube(name);
  auto ports = bridge->getPorts(portsName);
  auto trunk = ports->getTrunk();

  return trunk->setNativeVlanEnabled(value);
}

/**
* @brief   Update stp by ID
*
* Update operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] value stpbody object
*
* Responses:
*
*/
void
update_bridge_stp_by_id(const std::string &name, const uint16_t &vlan, const StpJsonObject &value) {
  auto bridge = get_cube(name);
  auto stp = bridge->getStp(vlan);

  return stp->update(value);
}

/**
* @brief   Update stp-enabled by ID
*
* Update operation of resource: stp-enabled*
*
* @param[in] name ID of name
* @param[in] value Enable/Disable the STP protocol of the bridge
*
* Responses:
*
*/
void
update_bridge_stp_enabled_by_id(const std::string &name, const bool &value) {
  auto bridge = get_cube(name);

  return bridge->setStpEnabled(value);
}

/**
* @brief   Update forward-delay by ID
*
* Update operation of resource: forward-delay*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] value Delay used by STP bridges for port state transition
*
* Responses:
*
*/
void
update_bridge_stp_forward_delay_by_id(const std::string &name, const uint16_t &vlan, const uint32_t &value) {
  auto bridge = get_cube(name);
  auto stp = bridge->getStp(vlan);

  return stp->setForwardDelay(value);
}

/**
* @brief   Update hello-time by ID
*
* Update operation of resource: hello-time*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] value Interval between transmissions of BPDU messages
*
* Responses:
*
*/
void
update_bridge_stp_hello_time_by_id(const std::string &name, const uint16_t &vlan, const uint32_t &value) {
  auto bridge = get_cube(name);
  auto stp = bridge->getStp(vlan);

  return stp->setHelloTime(value);
}

/**
* @brief   Update stp by ID
*
* Update operation of resource: stp*
*
* @param[in] name ID of name
* @param[in] value stpbody object
*
* Responses:
*
*/
void
update_bridge_stp_list_by_id(const std::string &name, const std::vector<StpJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update max-message-age by ID
*
* Update operation of resource: max-message-age*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] value Maximum age of a BPDU
*
* Responses:
*
*/
void
update_bridge_stp_max_message_age_by_id(const std::string &name, const uint16_t &vlan, const uint32_t &value) {
  auto bridge = get_cube(name);
  auto stp = bridge->getStp(vlan);

  return stp->setMaxMessageAge(value);
}

/**
* @brief   Update priority by ID
*
* Update operation of resource: priority*
*
* @param[in] name ID of name
* @param[in] vlan ID of vlan
* @param[in] value Bridge priority for STP
*
* Responses:
*
*/
void
update_bridge_stp_priority_by_id(const std::string &name, const uint16_t &vlan, const uint16_t &value) {
  auto bridge = get_cube(name);
  auto stp = bridge->getStp(vlan);

  return stp->setPriority(value);
}



/*
 * help related
 */

std::vector<nlohmann::fifo_map<std::string, std::string>> read_bridge_fdb_entry_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&bridge = get_cube(name);
  auto &&fdb = bridge->getFdb();

  auto &&entry = fdb->getEntryList();
  for(auto &i : entry) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["vlan"] = std::to_string(i->getVlan());
    keys["mac"] = i->getMac();

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_bridge_ports_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&bridge = get_cube(name);

  auto &&ports = bridge->getPortsList();
  for(auto &i : ports) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["name"] = i->getName();

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_bridge_ports_stp_list_by_id_get_list(const std::string &name, const std::string &portsName) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&bridge = get_cube(name);
  auto &&ports = bridge->getPorts(portsName);

  auto &&stp = ports->getStpList();
  for(auto &i : stp) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["vlan"] = std::to_string(i->getVlan());

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_bridge_ports_trunk_allowed_list_by_id_get_list(const std::string &name, const std::string &portsName) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&bridge = get_cube(name);
  auto &&ports = bridge->getPorts(portsName);
  auto &&trunk = ports->getTrunk();

  auto &&allowed = trunk->getAllowedList();
  for(auto &i : allowed) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["vlanid"] = std::to_string(i->getVlanid());

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_bridge_stp_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&bridge = get_cube(name);

  auto &&stp = bridge->getStpList();
  for(auto &i : stp) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["vlan"] = std::to_string(i->getVlan());

    r.push_back(keys);
  }
  return r;
}


}

}
}
}

