/**
* bmc API generated from bmc.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */

/*
* BmcBase.h
*
*
*/

#pragma once

#include "../serializer/BmcJsonObject.h"

#include "../BmcStats.h"
#include "../Memcached.h"
#include "../Ports.h"

#include "polycube/services/cube.h"
#include "polycube/services/port.h"



#include "polycube/services/utils.h"
#include "polycube/services/fifo_map.hpp"

#include <spdlog/spdlog.h>

using namespace polycube::service::model;


class BmcBase: public virtual polycube::service::Cube<Ports> {
 public:
  BmcBase(const std::string name);
  
  virtual ~BmcBase();
  virtual void update(const BmcJsonObject &conf);
  virtual BmcJsonObject toJsonObject();

  /// <summary>
  /// Defines if the service should be automatically optimized by Morpheus
  /// </summary>
  virtual bool getDynOpt() = 0;

  /// <summary>
  /// Entry of the ports table
  /// </summary>
  virtual std::shared_ptr<Ports> getPorts(const std::string &name);
  virtual std::vector<std::shared_ptr<Ports>> getPortsList();
  virtual void addPorts(const std::string &name, const PortsJsonObject &conf);
  virtual void addPortsList(const std::vector<PortsJsonObject> &conf);
  virtual void replacePorts(const std::string &name, const PortsJsonObject &conf);
  virtual void delPorts(const std::string &name);
  virtual void delPortsList();

  /// <summary>
  ///
  /// </summary>
  virtual std::shared_ptr<BmcStats> getBmcStats() = 0;
  virtual void addBmcStats(const BmcStatsJsonObject &value) = 0;
  virtual void replaceBmcStats(const BmcStatsJsonObject &conf);
  virtual void delBmcStats() = 0;

  /// <summary>
  /// Entry in the BMC Cache
  /// </summary>
  virtual std::shared_ptr<Memcached> getMemcached(const uint32_t &hashKey) = 0;
  virtual std::vector<std::shared_ptr<Memcached>> getMemcachedList() = 0;
  virtual void addMemcached(const uint32_t &hashKey, const MemcachedJsonObject &conf) = 0;
  virtual void addMemcachedList(const std::vector<MemcachedJsonObject> &conf);
  virtual void replaceMemcached(const uint32_t &hashKey, const MemcachedJsonObject &conf);
  virtual void delMemcached(const uint32_t &hashKey) = 0;
  virtual void delMemcachedList();
};
