/**
* bmc API generated from bmc.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "BmcBase.h"

BmcBase::BmcBase(const std::string name) {
  logger()->set_pattern("[%Y-%m-%d %H:%M:%S.%e] [Bmc] [%n] [%l] %v");
}



BmcBase::~BmcBase() {}

void BmcBase::update(const BmcJsonObject &conf) {
  set_conf(conf.getBase());

  if (conf.portsIsSet()) {
    for (auto &i : conf.getPorts()) {
      auto name = i.getName();
      auto m = getPorts(name);
      m->update(i);
    }
  }
  if (conf.bmcStatsIsSet()) {
    auto m = getBmcStats();
    m->update(conf.getBmcStats());
  }
  if (conf.memcachedIsSet()) {
    for (auto &i : conf.getMemcached()) {
      auto hashKey = i.getHashKey();
      auto m = getMemcached(hashKey);
      m->update(i);
    }
  }
}

BmcJsonObject BmcBase::toJsonObject() {
  BmcJsonObject conf;
  conf.setBase(to_json());

  conf.setName(getName());
  conf.setDynOpt(getDynOpt());
  for (auto &i : getPortsList()) {
    conf.addPorts(i->toJsonObject());
  }
  conf.setBmcStats(getBmcStats()->toJsonObject());
  for(auto &i : getMemcachedList()) {
    conf.addMemcached(i->toJsonObject());
  }

  return conf;
}
void BmcBase::addPortsList(const std::vector<PortsJsonObject> &conf) {
  for (auto &i : conf) {
    std::string name_ = i.getName();
    addPorts(name_, i);
  }
}

void BmcBase::replacePorts(const std::string &name, const PortsJsonObject &conf) {
  delPorts(name);
  std::string name_ = conf.getName();
  addPorts(name_, conf);
}

void BmcBase::delPortsList() {
  auto elements = getPortsList();
  for (auto &i : elements) {
    std::string name_ = i->getName();
    delPorts(name_);
  }
}

void BmcBase::addPorts(const std::string &name, const PortsJsonObject &conf) {
  add_port<PortsJsonObject>(name, conf);
}

void BmcBase::delPorts(const std::string &name) {
  remove_port(name);
}

std::shared_ptr<Ports> BmcBase::getPorts(const std::string &name) {
  return get_port(name);
}

std::vector<std::shared_ptr<Ports>> BmcBase::getPortsList() {
  return get_ports();
}

void BmcBase::replaceBmcStats(const BmcStatsJsonObject &conf) {
  // TODO: This is a basic default implementation, maybe you want to improve it
  delBmcStats();
  addBmcStats(conf);
}
void BmcBase::addMemcachedList(const std::vector<MemcachedJsonObject> &conf) {
  for (auto &i : conf) {
    uint32_t hashKey_ = i.getHashKey();
    addMemcached(hashKey_, i);
  }
}

void BmcBase::replaceMemcached(const uint32_t &hashKey, const MemcachedJsonObject &conf) {
  delMemcached(hashKey);
  uint32_t hashKey_ = conf.getHashKey();
  addMemcached(hashKey_, conf);
}

void BmcBase::delMemcachedList() {
  auto elements = getMemcachedList();
  for (auto &i : elements) {
    uint32_t hashKey_ = i->getHashKey();
    delMemcached(hashKey_);
  }
}


