/**
* bmc API generated from bmc.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


/* Do not edit this file manually */


#include "BmcApiImpl.h"

namespace polycube {
namespace service {
namespace api {

using namespace polycube::service::model;

namespace BmcApiImpl {
namespace {
std::unordered_map<std::string, std::shared_ptr<Bmc>> cubes;
std::mutex cubes_mutex;

std::shared_ptr<Bmc> get_cube(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  auto iter = cubes.find(name);
  if (iter == cubes.end()) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }

  return iter->second;
}

}

void create_bmc_by_id(const std::string &name, const BmcJsonObject &jsonObject) {
  {
    // check if name is valid before creating it
    std::lock_guard<std::mutex> guard(cubes_mutex);
    if (cubes.count(name) != 0) {
      throw std::runtime_error("There is already a cube with name " + name);
    }
  }
  auto ptr = std::make_shared<Bmc>(name, jsonObject);
  std::unordered_map<std::string, std::shared_ptr<Bmc>>::iterator iter;
  bool inserted;

  std::lock_guard<std::mutex> guard(cubes_mutex);
  std::tie(iter, inserted) = cubes.emplace(name, std::move(ptr));

  if (!inserted) {
    throw std::runtime_error("There is already a cube with name " + name);
  }
}

void replace_bmc_by_id(const std::string &name, const BmcJsonObject &bridge){
  throw std::runtime_error("Method not supported!");
}

void delete_bmc_by_id(const std::string &name) {
  std::lock_guard<std::mutex> guard(cubes_mutex);
  if (cubes.count(name) == 0) {
    throw std::runtime_error("Cube " + name + " does not exist");
  }
  cubes.erase(name);
}

std::vector<BmcJsonObject> read_bmc_list_by_id() {
  std::vector<BmcJsonObject> jsonObject_vect;
  for(auto &i : cubes) {
    auto m = get_cube(i.first);
    jsonObject_vect.push_back(m->toJsonObject());
  }
  return jsonObject_vect;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_bmc_list_by_id_get_list() {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  for (auto &x : cubes) {
    nlohmann::fifo_map<std::string, std::string> m;
    m["name"] = x.first;
    r.push_back(std::move(m));
  }
  return r;
}

/**
* @brief   Create getPktCount by ID
*
* Create operation of resource: getPktCount*
*
* @param[in] name ID of name
* @param[in] value getPktCountbody object
*
* Responses:
* BmcStatsGetPktCountOutputJsonObject
*/
BmcStatsGetPktCountOutputJsonObject
create_bmc_bmc_stats_get_pkt_count_by_id(const std::string &name, const BmcStatsGetPktCountInputJsonObject &value) {
  auto bmc = get_cube(name);
  auto bmcStats = bmc->getBmcStats();
  return bmcStats->getPktCount(value);

}

/**
* @brief   Create reset_all by ID
*
* Create operation of resource: reset_all*
*
* @param[in] name ID of name
*
* Responses:
* BmcStatsResetAllOutputJsonObject
*/
BmcStatsResetAllOutputJsonObject
create_bmc_bmc_stats_reset_all_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  auto bmcStats = bmc->getBmcStats();
  return bmcStats->resetAll();

}

/**
* @brief   Create memcached by ID
*
* Create operation of resource: memcached*
*
* @param[in] name ID of name
* @param[in] hashKey ID of hash-key
* @param[in] value memcachedbody object
*
* Responses:
*
*/
void
create_bmc_memcached_by_id(const std::string &name, const uint32_t &hashKey, const MemcachedJsonObject &value) {
  auto bmc = get_cube(name);

  return bmc->addMemcached(hashKey, value);
}

/**
* @brief   Create memcached by ID
*
* Create operation of resource: memcached*
*
* @param[in] name ID of name
* @param[in] value memcachedbody object
*
* Responses:
*
*/
void
create_bmc_memcached_list_by_id(const std::string &name, const std::vector<MemcachedJsonObject> &value) {
  auto bmc = get_cube(name);
  bmc->addMemcachedList(value);
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_bmc_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto bmc = get_cube(name);

  return bmc->addPorts(portsName, value);
}

/**
* @brief   Create ports by ID
*
* Create operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
create_bmc_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  auto bmc = get_cube(name);
  bmc->addPortsList(value);
}

/**
* @brief   Delete memcached by ID
*
* Delete operation of resource: memcached*
*
* @param[in] name ID of name
* @param[in] hashKey ID of hash-key
*
* Responses:
*
*/
void
delete_bmc_memcached_by_id(const std::string &name, const uint32_t &hashKey) {
  auto bmc = get_cube(name);

  return bmc->delMemcached(hashKey);
}

/**
* @brief   Delete memcached by ID
*
* Delete operation of resource: memcached*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_bmc_memcached_list_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  bmc->delMemcachedList();
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
*
*/
void
delete_bmc_ports_by_id(const std::string &name, const std::string &portsName) {
  auto bmc = get_cube(name);

  return bmc->delPorts(portsName);
}

/**
* @brief   Delete ports by ID
*
* Delete operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
*
*/
void
delete_bmc_ports_list_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  bmc->delPortsList();
}

/**
* @brief   Read bmcStats by ID
*
* Read operation of resource: bmcStats*
*
* @param[in] name ID of name
*
* Responses:
* BmcStatsJsonObject
*/
BmcStatsJsonObject
read_bmc_bmc_stats_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  return bmc->getBmcStats()->toJsonObject();

}

/**
* @brief   Read get_recv_count by ID
*
* Read operation of resource: get_recv_count*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_bmc_bmc_stats_get_recv_count_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  auto bmcStats = bmc->getBmcStats();
  return bmcStats->getGetRecvCount();

}

/**
* @brief   Read get_resp_count by ID
*
* Read operation of resource: get_resp_count*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_bmc_bmc_stats_get_resp_count_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  auto bmcStats = bmc->getBmcStats();
  return bmcStats->getGetRespCount();

}

/**
* @brief   Read hit_count by ID
*
* Read operation of resource: hit_count*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_bmc_bmc_stats_hit_count_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  auto bmcStats = bmc->getBmcStats();
  return bmcStats->getHitCount();

}

/**
* @brief   Read hit_misprediction by ID
*
* Read operation of resource: hit_misprediction*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_bmc_bmc_stats_hit_misprediction_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  auto bmcStats = bmc->getBmcStats();
  return bmcStats->getHitMisprediction();

}

/**
* @brief   Read invalidation_count by ID
*
* Read operation of resource: invalidation_count*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_bmc_bmc_stats_invalidation_count_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  auto bmcStats = bmc->getBmcStats();
  return bmcStats->getInvalidationCount();

}

/**
* @brief   Read miss_count by ID
*
* Read operation of resource: miss_count*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_bmc_bmc_stats_miss_count_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  auto bmcStats = bmc->getBmcStats();
  return bmcStats->getMissCount();

}

/**
* @brief   Read set_recv_count by ID
*
* Read operation of resource: set_recv_count*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_bmc_bmc_stats_set_recv_count_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  auto bmcStats = bmc->getBmcStats();
  return bmcStats->getSetRecvCount();

}

/**
* @brief   Read update_count by ID
*
* Read operation of resource: update_count*
*
* @param[in] name ID of name
*
* Responses:
* uint32_t
*/
uint32_t
read_bmc_bmc_stats_update_count_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  auto bmcStats = bmc->getBmcStats();
  return bmcStats->getUpdateCount();

}

/**
* @brief   Read bmc by ID
*
* Read operation of resource: bmc*
*
* @param[in] name ID of name
*
* Responses:
* BmcJsonObject
*/
BmcJsonObject
read_bmc_by_id(const std::string &name) {
  return get_cube(name)->toJsonObject();

}

/**
* @brief   Read dyn-opt by ID
*
* Read operation of resource: dyn-opt*
*
* @param[in] name ID of name
*
* Responses:
* bool
*/
bool
read_bmc_dyn_opt_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  return bmc->getDynOpt();

}

/**
* @brief   Read memcached by ID
*
* Read operation of resource: memcached*
*
* @param[in] name ID of name
* @param[in] hashKey ID of hash-key
*
* Responses:
* MemcachedJsonObject
*/
MemcachedJsonObject
read_bmc_memcached_by_id(const std::string &name, const uint32_t &hashKey) {
  auto bmc = get_cube(name);
  return bmc->getMemcached(hashKey)->toJsonObject();

}

/**
* @brief   Read data by ID
*
* Read operation of resource: data*
*
* @param[in] name ID of name
* @param[in] hashKey ID of hash-key
*
* Responses:
* std::string
*/
std::string
read_bmc_memcached_data_by_id(const std::string &name, const uint32_t &hashKey) {
  auto bmc = get_cube(name);
  auto memcached = bmc->getMemcached(hashKey);
  return memcached->getData();

}

/**
* @brief   Read hash by ID
*
* Read operation of resource: hash*
*
* @param[in] name ID of name
* @param[in] hashKey ID of hash-key
*
* Responses:
* int32_t
*/
int32_t
read_bmc_memcached_hash_by_id(const std::string &name, const uint32_t &hashKey) {
  auto bmc = get_cube(name);
  auto memcached = bmc->getMemcached(hashKey);
  return memcached->getHash();

}

/**
* @brief   Read len by ID
*
* Read operation of resource: len*
*
* @param[in] name ID of name
* @param[in] hashKey ID of hash-key
*
* Responses:
* uint32_t
*/
uint32_t
read_bmc_memcached_len_by_id(const std::string &name, const uint32_t &hashKey) {
  auto bmc = get_cube(name);
  auto memcached = bmc->getMemcached(hashKey);
  return memcached->getLen();

}

/**
* @brief   Read memcached by ID
*
* Read operation of resource: memcached*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<MemcachedJsonObject>
*/
std::vector<MemcachedJsonObject>
read_bmc_memcached_list_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  auto &&memcached = bmc->getMemcachedList();
  std::vector<MemcachedJsonObject> m;
  for(auto &i : memcached)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Read valid by ID
*
* Read operation of resource: valid*
*
* @param[in] name ID of name
* @param[in] hashKey ID of hash-key
*
* Responses:
* std::string
*/
std::string
read_bmc_memcached_valid_by_id(const std::string &name, const uint32_t &hashKey) {
  auto bmc = get_cube(name);
  auto memcached = bmc->getMemcached(hashKey);
  return memcached->getValid();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
*
* Responses:
* PortsJsonObject
*/
PortsJsonObject
read_bmc_ports_by_id(const std::string &name, const std::string &portsName) {
  auto bmc = get_cube(name);
  return bmc->getPorts(portsName)->toJsonObject();

}

/**
* @brief   Read ports by ID
*
* Read operation of resource: ports*
*
* @param[in] name ID of name
*
* Responses:
* std::vector<PortsJsonObject>
*/
std::vector<PortsJsonObject>
read_bmc_ports_list_by_id(const std::string &name) {
  auto bmc = get_cube(name);
  auto &&ports = bmc->getPortsList();
  std::vector<PortsJsonObject> m;
  for(auto &i : ports)
    m.push_back(i->toJsonObject());
  return m;
}

/**
* @brief   Replace memcached by ID
*
* Replace operation of resource: memcached*
*
* @param[in] name ID of name
* @param[in] hashKey ID of hash-key
* @param[in] value memcachedbody object
*
* Responses:
*
*/
void
replace_bmc_memcached_by_id(const std::string &name, const uint32_t &hashKey, const MemcachedJsonObject &value) {
  auto bmc = get_cube(name);

  return bmc->replaceMemcached(hashKey, value);
}

/**
* @brief   Replace memcached by ID
*
* Replace operation of resource: memcached*
*
* @param[in] name ID of name
* @param[in] value memcachedbody object
*
* Responses:
*
*/
void
replace_bmc_memcached_list_by_id(const std::string &name, const std::vector<MemcachedJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_bmc_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto bmc = get_cube(name);

  return bmc->replacePorts(portsName, value);
}

/**
* @brief   Replace ports by ID
*
* Replace operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
replace_bmc_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update bmc by ID
*
* Update operation of resource: bmc*
*
* @param[in] name ID of name
* @param[in] value bmcbody object
*
* Responses:
*
*/
void
update_bmc_by_id(const std::string &name, const BmcJsonObject &value) {
  auto bmc = get_cube(name);

  return bmc->update(value);
}

/**
* @brief   Update bmc by ID
*
* Update operation of resource: bmc*
*
* @param[in] value bmcbody object
*
* Responses:
*
*/
void
update_bmc_list_by_id(const std::vector<BmcJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update memcached by ID
*
* Update operation of resource: memcached*
*
* @param[in] name ID of name
* @param[in] hashKey ID of hash-key
* @param[in] value memcachedbody object
*
* Responses:
*
*/
void
update_bmc_memcached_by_id(const std::string &name, const uint32_t &hashKey, const MemcachedJsonObject &value) {
  auto bmc = get_cube(name);
  auto memcached = bmc->getMemcached(hashKey);

  return memcached->update(value);
}

/**
* @brief   Update data by ID
*
* Update operation of resource: data*
*
* @param[in] name ID of name
* @param[in] hashKey ID of hash-key
* @param[in] value Data inside the BMC cache
*
* Responses:
*
*/
void
update_bmc_memcached_data_by_id(const std::string &name, const uint32_t &hashKey, const std::string &value) {
  auto bmc = get_cube(name);
  auto memcached = bmc->getMemcached(hashKey);

  return memcached->setData(value);
}

/**
* @brief   Update hash by ID
*
* Update operation of resource: hash*
*
* @param[in] name ID of name
* @param[in] hashKey ID of hash-key
* @param[in] value Hash of the cache entry value
*
* Responses:
*
*/
void
update_bmc_memcached_hash_by_id(const std::string &name, const uint32_t &hashKey, const int32_t &value) {
  auto bmc = get_cube(name);
  auto memcached = bmc->getMemcached(hashKey);

  return memcached->setHash(value);
}

/**
* @brief   Update len by ID
*
* Update operation of resource: len*
*
* @param[in] name ID of name
* @param[in] hashKey ID of hash-key
* @param[in] value Lenght on the BMC Cache entry
*
* Responses:
*
*/
void
update_bmc_memcached_len_by_id(const std::string &name, const uint32_t &hashKey, const uint32_t &value) {
  auto bmc = get_cube(name);
  auto memcached = bmc->getMemcached(hashKey);

  return memcached->setLen(value);
}

/**
* @brief   Update memcached by ID
*
* Update operation of resource: memcached*
*
* @param[in] name ID of name
* @param[in] value memcachedbody object
*
* Responses:
*
*/
void
update_bmc_memcached_list_by_id(const std::string &name, const std::vector<MemcachedJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}

/**
* @brief   Update valid by ID
*
* Update operation of resource: valid*
*
* @param[in] name ID of name
* @param[in] hashKey ID of hash-key
* @param[in] value Flag to check if entry is valid or not
*
* Responses:
*
*/
void
update_bmc_memcached_valid_by_id(const std::string &name, const uint32_t &hashKey, const std::string &value) {
  auto bmc = get_cube(name);
  auto memcached = bmc->getMemcached(hashKey);

  return memcached->setValid(value);
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] portsName ID of ports_name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_bmc_ports_by_id(const std::string &name, const std::string &portsName, const PortsJsonObject &value) {
  auto bmc = get_cube(name);
  auto ports = bmc->getPorts(portsName);

  return ports->update(value);
}

/**
* @brief   Update ports by ID
*
* Update operation of resource: ports*
*
* @param[in] name ID of name
* @param[in] value portsbody object
*
* Responses:
*
*/
void
update_bmc_ports_list_by_id(const std::string &name, const std::vector<PortsJsonObject> &value) {
  throw std::runtime_error("Method not supported");
}



/*
 * help related
 */

std::vector<nlohmann::fifo_map<std::string, std::string>> read_bmc_memcached_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&bmc = get_cube(name);

  auto &&memcached = bmc->getMemcachedList();
  for(auto &i : memcached) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["hashKey"] = std::to_string(i->getHashKey());

    r.push_back(keys);
  }
  return r;
}

std::vector<nlohmann::fifo_map<std::string, std::string>> read_bmc_ports_list_by_id_get_list(const std::string &name) {
  std::vector<nlohmann::fifo_map<std::string, std::string>> r;
  auto &&bmc = get_cube(name);

  auto &&ports = bmc->getPortsList();
  for(auto &i : ports) {
    nlohmann::fifo_map<std::string, std::string> keys;

    keys["name"] = i->getName();

    r.push_back(keys);
  }
  return r;
}


}

}
}
}

