/**
* bmc API generated from bmc.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


#pragma once


#include "../base/BmcStatsBase.h"


class Bmc;

using namespace polycube::service::model;

class BmcStats : public BmcStatsBase {
 public:
  BmcStats(Bmc &parent, const BmcStatsJsonObject &conf);
  virtual ~BmcStats();

  /// <summary>
  /// Number of GET command received
  /// </summary>
  uint32_t getGetRecvCount() override;

  /// <summary>
  /// Number of SET command received
  /// </summary>
  uint32_t getSetRecvCount() override;

  /// <summary>
  /// Number of GET command reply analyzed
  /// </summary>
  uint32_t getGetRespCount() override;

  /// <summary>
  /// Number of keys that were expected to hit but did not (either because of a hash colision or a race with an invalidation/update)
  /// </summary>
  uint32_t getHitMisprediction() override;

  /// <summary>
  /// Number of HIT in kernel cache
  /// </summary>
  uint32_t getHitCount() override;

  /// <summary>
  /// Number of MISS in kernel cache
  /// </summary>
  uint32_t getMissCount() override;

  /// <summary>
  /// Number of kernel cache updates
  /// </summary>
  uint32_t getUpdateCount() override;

  /// <summary>
  /// Number of kernel cache entry invalidated
  /// </summary>
  uint32_t getInvalidationCount() override;

  BmcStatsResetAllOutputJsonObject resetAll() override;
  BmcStatsGetPktCountOutputJsonObject getPktCount(BmcStatsGetPktCountInputJsonObject input) override;

  struct bmc_stats {
    unsigned int get_recv_count;			// Number of GET command received
    unsigned int set_recv_count;			// Number of SET command received
    unsigned int get_resp_count;			// Number of GET command reply analyzed
    unsigned int hit_misprediction;			// Number of keys that were expected to hit but did not (either because of a hash colision or a race with an invalidation/update)
    unsigned int hit_count;				// Number of HIT in kernel cache
    unsigned int miss_count;			// Number of MISS in kernel cache
    unsigned int update_count;			// Number of kernel cache updates
    unsigned int invalidation_count;		// Number of kernel cache entry invalidated
  };

  private:
    unsigned int get_recv_count_;			// Number of GET command received
    unsigned int set_recv_count_;			// Number of SET command received
    unsigned int get_resp_count_;			// Number of GET command reply analyzed
    unsigned int hit_misprediction_;			// Number of keys that were expected to hit but did not (either because of a hash colision or a race with an invalidation/update)
    unsigned int hit_count_;				// Number of HIT in kernel cache
    unsigned int miss_count_;			// Number of MISS in kernel cache
    unsigned int update_count_;			// Number of kernel cache updates
    unsigned int invalidation_count_;		// Number of kernel cache entry invalidated
};
