/**
* bmc API generated from bmc.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


// TODO: Modify these methods with your own implementation


#include "BmcStats.h"
#include "Bmc.h"


BmcStats::BmcStats(Bmc &parent, const BmcStatsJsonObject &conf)
    : BmcStatsBase(parent) {

  get_recv_count_ = conf.getGetRecvCount();
  set_recv_count_ = conf.getSetRecvCount();
  get_resp_count_ = conf.getGetRespCount();
  hit_misprediction_ = conf.getHitMisprediction();
  hit_count_ = conf.getHitCount();
  miss_count_ = conf.getMissCount();
  update_count_ = conf.getUpdateCount();
  invalidation_count_ = conf.getInvalidationCount();
}

BmcStats::~BmcStats() {}

uint32_t BmcStats::getGetRecvCount() {
  return get_recv_count_;
}

uint32_t BmcStats::getSetRecvCount() {
  return set_recv_count_;
}

uint32_t BmcStats::getGetRespCount() {
  return get_resp_count_;
}

uint32_t BmcStats::getHitMisprediction() {
  return hit_misprediction_;
}

uint32_t BmcStats::getHitCount() {
  return hit_count_;
}

uint32_t BmcStats::getMissCount() {
  return miss_count_;
}

uint32_t BmcStats::getUpdateCount() {
  return update_count_;
}

uint32_t BmcStats::getInvalidationCount() {
  return invalidation_count_;
}

BmcStatsResetAllOutputJsonObject BmcStats::resetAll() {
  auto statsTable = parent_.get_percpuarray_table<BmcStats::bmc_stats>("map_stats");
  BmcStats::bmc_stats stat = {};

  std::memset(&stat, 0, sizeof(stat));

  statsTable.set(0, stat);

  BmcStatsResetAllOutputJsonObject res;
  res.setResult(true);

  return res;
}

BmcStatsGetPktCountOutputJsonObject BmcStats::getPktCount(BmcStatsGetPktCountInputJsonObject input) {
  auto pktCountTable_rx_filter = parent_.get_percpuarray_table<uint64_t>("pkt_cnt_rx_filter");
  auto pktCountTable_hash_keys = parent_.get_percpuarray_table<uint64_t>("pkt_cnt_hash_keys");
  auto pktCountTable_prepare_packet = parent_.get_percpuarray_table<uint64_t>("pkt_cnt_prepare_packet");
  auto pktCountTable_update_cache = parent_.get_percpuarray_table<uint64_t>("pkt_cnt_update_cache");
  auto pktCountTable_write_reply = parent_.get_percpuarray_table<uint64_t>("pkt_cnt_write_reply");
  uint32_t stat;
  BmcStatsGetPktCountOutputJsonObject output;
  uint32_t time = 0;
  uint32_t time_to_run = 0;

  if (!input.timeIsSet()) {
    time_to_run = 10;
  } else {
    time_to_run = input.getTime();
  }

  uint64_t prev_pkt_cnt_rx_filter = 0;
  std::vector<uint64_t> thoughput_rx_filter;

  uint64_t prev_pkt_cnt_hash_keys = 0;
  std::vector<uint64_t> thoughput_hash_keys;

  uint64_t prev_pkt_cnt_prepare_packet = 0;
  std::vector<uint64_t> thoughput_prepare_packet;

  uint64_t prev_pkt_cnt_update_cache = 0;
  std::vector<uint64_t> thoughput_update_cache;

  uint64_t prev_pkt_cnt_write_reply = 0;
  std::vector<uint64_t> thoughput_write_reply;

  while (time < time_to_run) {
    auto res = pktCountTable_rx_filter.get(0);
    uint64_t pkts_rx_filter = std::accumulate(res.begin(), res.end(), decltype(res)::value_type(0));
    uint64_t delta_rx_filter = pkts_rx_filter - prev_pkt_cnt_rx_filter;
    prev_pkt_cnt_rx_filter = pkts_rx_filter;
    thoughput_rx_filter.emplace_back(delta_rx_filter);
    logger()->info("Processing packet at rate of RX Filter is: {0} pps", delta_rx_filter);

    res = pktCountTable_hash_keys.get(0);
    uint64_t pkts_hash_keys = std::accumulate(res.begin(), res.end(), decltype(res)::value_type(0));
    uint64_t delta_hash_keys = pkts_hash_keys - prev_pkt_cnt_hash_keys;
    prev_pkt_cnt_hash_keys = pkts_hash_keys;
    thoughput_hash_keys.emplace_back(delta_hash_keys);
    logger()->info("Processing packet at rate of Hash Keys is: {0} pps", delta_hash_keys);

    res = pktCountTable_prepare_packet.get(0);
    uint64_t pkts_prepare_packet = std::accumulate(res.begin(), res.end(), decltype(res)::value_type(0));
    uint64_t delta_prepare_packet = pkts_prepare_packet - prev_pkt_cnt_prepare_packet;
    prev_pkt_cnt_prepare_packet = pkts_prepare_packet;
    thoughput_prepare_packet.emplace_back(delta_prepare_packet);
    logger()->info("Processing packet at rate of Prepare Packet is: {0} pps", delta_prepare_packet);

    res = pktCountTable_update_cache.get(0);
    uint64_t pkts_update_cache = std::accumulate(res.begin(), res.end(), decltype(res)::value_type(0));
    uint64_t delta_update_cache = pkts_update_cache - prev_pkt_cnt_update_cache;
    prev_pkt_cnt_update_cache = pkts_update_cache;
    thoughput_update_cache.emplace_back(delta_update_cache);
    logger()->info("Processing packet at rate of Update Cache is: {0} pps", delta_update_cache);

    res = pktCountTable_write_reply.get(0);
    uint64_t pkts_write_reply = std::accumulate(res.begin(), res.end(), decltype(res)::value_type(0));
    uint64_t delta_write_reply = pkts_write_reply - prev_pkt_cnt_write_reply;
    prev_pkt_cnt_write_reply = pkts_write_reply;
    thoughput_write_reply.emplace_back(delta_write_reply);
    logger()->info("Processing packet at rate of Write Replay is: {0} pps", delta_write_reply);

    sleep(1);
    time++;
  }

  if (!thoughput_hash_keys.empty()) {
    uint64_t avg_pkts = std::accumulate(thoughput_hash_keys.begin() + 1, thoughput_hash_keys.end(), decltype(thoughput_hash_keys)::value_type(0)) / (time_to_run - 1);
    output.setAverage(avg_pkts);
  } else {
    output.setAverage(0);
  }

  return output;
}