/**
* bmc API generated from bmc.yang
*
* NOTE: This file is auto generated by polycube-codegen
* https://github.com/polycube-network/polycube-codegen
*/


// TODO: Modify these methods with your own implementation


#include "Bmc.h"
#include "Bmc_config.h"
#include "datapaths/BMC_hash_keys_dp.h"
#include "datapaths/BMC_invalidate_cache_dp.h"
#include "datapaths/BMC_prepare_packet_dp.h"
#include "datapaths/BMC_rx_filter_dp.h"
#include "datapaths/BMC_tx_filter_dp.h"
#include "datapaths/BMC_update_cache_dp.h"
#include "datapaths/BMC_write_reply_dp.h"

using polycube::service::ProgramType;

std::vector<std::string> Bmc::COMPILE_FLAGS = {
    std::string("-I") + std::string(BMC_EBPF_INCLUDE_PATH),
    std::string("-I") + std::string(LINUX_INCLUDE)
};

Bmc::Bmc(const std::string name, const BmcJsonObject &conf)
  : Cube(conf.getBase(), { }, { }),
    BmcBase(name) {
  logger()->info("Creating BMC instance");
  addPortsList(conf.getPorts());
  addMemcachedList(conf.getMemcached());

  std::vector<std::string> custom_cflags(Bmc::COMPILE_FLAGS);
  set_cflags(custom_cflags);

  // Add all programs of BMC to the list of programs, let's start with ingress
  add_program(bmc_rx_filter_dp, Bmc::XDP_PROGRAMS::BMC_PROG_XDP_RX_FILTER, ProgramType::INGRESS);
  logger()->debug("Program bmc_rx_filter created");
  add_program(bmc_hash_keys_dp, Bmc::XDP_PROGRAMS::BMC_PROG_XDP_HASH_KEYS, ProgramType::INGRESS);
  logger()->debug("Program bmc_hash_keys created");
  add_program(bmc_prepare_packet_dp, Bmc::XDP_PROGRAMS::BMC_PROG_XDP_PREPARE_PACKET, ProgramType::INGRESS);
  logger()->debug("Program bmc_prepare_packet created");
  add_program(bmc_write_reply_dp, Bmc::XDP_PROGRAMS::BMC_PROG_XDP_WRITE_REPLY, ProgramType::INGRESS);
  logger()->debug("Program bmc_write_reply created");
  add_program(bmc_invalidate_cache_dp, Bmc::XDP_PROGRAMS::BMC_PROG_XDP_INVALIDATE_CACHE, ProgramType::INGRESS);
  logger()->debug("Program bmc_invalidate_cache created");

  // Now its time to add the egress programs
  add_program(bmc_tx_filter_dp, Bmc::TC_PROGRAMS::BMC_PROG_TC_TX_FILTER, ProgramType::EGRESS);
  logger()->debug("Program bmc_tx_filter created");
  add_program(bmc_update_cache_dp, Bmc::TC_PROGRAMS::BMC_PROG_TC_UPDATE_CACHE, ProgramType::EGRESS);
  logger()->debug("Program bmc_update_cache created");
}


Bmc::~Bmc() {
  logger()->info("Destroying Bmc instance");
}

void Bmc::packet_in(Ports &port,
    polycube::service::PacketInMetadata &md,
    const std::vector<uint8_t> &packet) {
  logger()->debug("Packet received from port {0}", port.name());
}

bool Bmc::getDynOpt() {
  return Cube::get_dyn_opt_enabled();
}

// Basic default implementation, place your extension here (if needed)
std::shared_ptr<Ports> Bmc::getPorts(const std::string &name) {
  // call default implementation in base class
  return BmcBase::getPorts(name);
}

// Basic default implementation, place your extension here (if needed)
std::vector<std::shared_ptr<Ports>> Bmc::getPortsList() {
  // call default implementation in base class
  return BmcBase::getPortsList();
}

// Basic default implementation, place your extension here (if needed)
void Bmc::addPorts(const std::string &name, const PortsJsonObject &conf) {
  BmcBase::addPorts(name, conf);
}

// Basic default implementation, place your extension here (if needed)
void Bmc::addPortsList(const std::vector<PortsJsonObject> &conf) {
  // call default implementation in base class
  BmcBase::addPortsList(conf);
}

// Basic default implementation, place your extension here (if needed)
void Bmc::replacePorts(const std::string &name, const PortsJsonObject &conf) {
  // call default implementation in base class
  BmcBase::replacePorts(name, conf);
}

// Basic default implementation, place your extension here (if needed)
void Bmc::delPorts(const std::string &name) {
  // call default implementation in base class
  BmcBase::delPorts(name);
}

// Basic default implementation, place your extension here (if needed)
void Bmc::delPortsList() {
  // call default implementation in base class
  BmcBase::delPortsList();
}

std::shared_ptr<BmcStats> Bmc::getBmcStats() {
  auto statsTable = get_percpuarray_table<BmcStats::bmc_stats>("map_stats");
  std::shared_ptr<BmcStats> statsBmc = nullptr;
  BmcStats::bmc_stats sum_stat = {};
  
  auto statsVector  = statsTable.get(0);
  for (auto &stat : statsVector) {
    sum_stat.get_recv_count += stat.get_recv_count;
    sum_stat.set_recv_count += stat.set_recv_count;
    sum_stat.get_resp_count += stat.get_resp_count;
    sum_stat.hit_count += stat.hit_count;
    sum_stat.hit_misprediction += stat.hit_misprediction;
    sum_stat.invalidation_count += stat.invalidation_count;
    sum_stat.miss_count += stat.miss_count;
    sum_stat.update_count += stat.update_count;
  }

  BmcStatsJsonObject conf;
  conf.setGetRecvCount(sum_stat.get_recv_count);
  conf.setSetRecvCount(sum_stat.set_recv_count);
  conf.setGetRespCount(sum_stat.get_resp_count);
  conf.setHitCount(sum_stat.hit_count);
  conf.setHitMisprediction(sum_stat.hit_misprediction);
  conf.setInvalidationCount(sum_stat.invalidation_count);
  conf.setMissCount(sum_stat.miss_count);
  conf.setUpdateCount(sum_stat.update_count);

  statsBmc = std::shared_ptr<BmcStats>(new BmcStats(*this, conf));

  return statsBmc;
}

void Bmc::addBmcStats(const BmcStatsJsonObject &value) {
  throw std::runtime_error("Bmc::addBmcStats: Method not supported");
}

// Basic default implementation, place your extension here (if needed)
void Bmc::replaceBmcStats(const BmcStatsJsonObject &conf) {
  // call default implementation in base class
  BmcBase::replaceBmcStats(conf);
}

void Bmc::delBmcStats() {
  throw std::runtime_error("Bmc::delBmcStats: method not implemented");
}

std::shared_ptr<Memcached> Bmc::getMemcached(const uint32_t &hashKey) {
  auto cacheTable = get_array_table<Bmc::bmc_cache_entry>("map_kcache");

  auto val = cacheTable.get(hashKey);

  std::shared_ptr<Memcached> cacheEntry = nullptr;

  MemcachedJsonObject conf;
  conf.setLen(val.len);
  conf.setValid(std::string(1, val.valid));
  std::stringstream ss;
  ss << std::hex << std::setfill('0');
  for (int i = 0; i < sizeof(val.data) / sizeof(val.data[0]); ++i)
  {
    ss << std::setw(2) << static_cast<unsigned>(val.data[i]);
  }

  conf.setData(ss.str());
  conf.setHash(val.hash);

  cacheEntry = std::shared_ptr<Memcached>(new Memcached(*this, conf));

  return cacheEntry;
}

std::vector<std::shared_ptr<Memcached>> Bmc::getMemcachedList() {
  auto cacheTable = get_array_table<Bmc::bmc_cache_entry>("map_kcache");

  auto entries = cacheTable.get_all();

  std::vector<std::shared_ptr<Memcached>> cacheEntryList(entries.size());

  for (auto &val : entries) {
    MemcachedJsonObject conf;
    conf.setHashKey(val.first);

    conf.setLen(val.second.len);
    conf.setValid(std::string(1, val.second.valid));

    std::stringstream ss;
    ss << std::hex << std::setfill('0');
    for (int i = 0; i < sizeof(val.second.data) / sizeof(val.second.data[0]); ++i)
    {
      ss << std::setw(2) << static_cast<unsigned>(val.second.data[i]);
    }

    conf.setData(ss.str());
    conf.setHash(val.second.hash);

    cacheEntryList[val.first] = std::shared_ptr<Memcached>(new Memcached(*this, conf));
  }

  return cacheEntryList;
}

void Bmc::addMemcached(const uint32_t &hashKey, const MemcachedJsonObject &conf) {
  throw std::runtime_error("Bmc::addMemcached: Method not implemented");
}

// Basic default implementation, place your extension here (if needed)
void Bmc::addMemcachedList(const std::vector<MemcachedJsonObject> &conf) {
  // call default implementation in base class
  BmcBase::addMemcachedList(conf);
}

// Basic default implementation, place your extension here (if needed)
void Bmc::replaceMemcached(const uint32_t &hashKey, const MemcachedJsonObject &conf) {
  // call default implementation in base class
  BmcBase::replaceMemcached(hashKey, conf);
}

void Bmc::delMemcached(const uint32_t &hashKey) {
  throw std::runtime_error("Bmc::delMemcached: Method not implemented");
}

// Basic default implementation, place your extension here (if needed)
void Bmc::delMemcachedList() {
  // call default implementation in base class
  BmcBase::delMemcachedList();
}


