/**
 * Copyright (C) 2015 Hewlett Packard Enterprise Development LP
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * @file config.hpp
 * libviface configuration header file.
 * Configuration and build time defined parameters for libviface
 */

#ifndef _VIFACE_CONFIG_HPP
#define _VIFACE_CONFIG_HPP

namespace viface {
/**
 * @defgroup libviface_private_config Library Configuration
 * Library configuration parameters.
 * @{
 */

/**
 * @def VIFACE_VERSION
 * libviface full version string
 */
#define VIFACE_VERSION "1.1.0"

/** @} */ // End of libviface_private_config
};

#endif // _VIFACE_CONFIG_HPP
