/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1beta

import (
	v1beta "github.com/polycube-network/polycube/src/components/k8s/pcn_k8s/pkg/apis/polycube.network/v1beta"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// PolycubeNetworkPolicyLister helps list PolycubeNetworkPolicies.
type PolycubeNetworkPolicyLister interface {
	// List lists all PolycubeNetworkPolicies in the indexer.
	List(selector labels.Selector) (ret []*v1beta.PolycubeNetworkPolicy, err error)
	// PolycubeNetworkPolicies returns an object that can list and get PolycubeNetworkPolicies.
	PolycubeNetworkPolicies(namespace string) PolycubeNetworkPolicyNamespaceLister
	PolycubeNetworkPolicyListerExpansion
}

// polycubeNetworkPolicyLister implements the PolycubeNetworkPolicyLister interface.
type polycubeNetworkPolicyLister struct {
	indexer cache.Indexer
}

// NewPolycubeNetworkPolicyLister returns a new PolycubeNetworkPolicyLister.
func NewPolycubeNetworkPolicyLister(indexer cache.Indexer) PolycubeNetworkPolicyLister {
	return &polycubeNetworkPolicyLister{indexer: indexer}
}

// List lists all PolycubeNetworkPolicies in the indexer.
func (s *polycubeNetworkPolicyLister) List(selector labels.Selector) (ret []*v1beta.PolycubeNetworkPolicy, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta.PolycubeNetworkPolicy))
	})
	return ret, err
}

// PolycubeNetworkPolicies returns an object that can list and get PolycubeNetworkPolicies.
func (s *polycubeNetworkPolicyLister) PolycubeNetworkPolicies(namespace string) PolycubeNetworkPolicyNamespaceLister {
	return polycubeNetworkPolicyNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// PolycubeNetworkPolicyNamespaceLister helps list and get PolycubeNetworkPolicies.
type PolycubeNetworkPolicyNamespaceLister interface {
	// List lists all PolycubeNetworkPolicies in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1beta.PolycubeNetworkPolicy, err error)
	// Get retrieves the PolycubeNetworkPolicy from the indexer for a given namespace and name.
	Get(name string) (*v1beta.PolycubeNetworkPolicy, error)
	PolycubeNetworkPolicyNamespaceListerExpansion
}

// polycubeNetworkPolicyNamespaceLister implements the PolycubeNetworkPolicyNamespaceLister
// interface.
type polycubeNetworkPolicyNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all PolycubeNetworkPolicies in the indexer for a given namespace.
func (s polycubeNetworkPolicyNamespaceLister) List(selector labels.Selector) (ret []*v1beta.PolycubeNetworkPolicy, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1beta.PolycubeNetworkPolicy))
	})
	return ret, err
}

// Get retrieves the PolycubeNetworkPolicy from the indexer for a given namespace and name.
func (s polycubeNetworkPolicyNamespaceLister) Get(name string) (*v1beta.PolycubeNetworkPolicy, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1beta.Resource("polycubenetworkpolicy"), name)
	}
	return obj.(*v1beta.PolycubeNetworkPolicy), nil
}
