/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta

import (
	"time"

	v1beta "github.com/polycube-network/polycube/src/components/k8s/pcn_k8s/pkg/apis/polycube.network/v1beta"
	scheme "github.com/polycube-network/polycube/src/components/k8s/pcn_k8s/pkg/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// PolycubeNetworkPoliciesGetter has a method to return a PolycubeNetworkPolicyInterface.
// A group's client should implement this interface.
type PolycubeNetworkPoliciesGetter interface {
	PolycubeNetworkPolicies(namespace string) PolycubeNetworkPolicyInterface
}

// PolycubeNetworkPolicyInterface has methods to work with PolycubeNetworkPolicy resources.
type PolycubeNetworkPolicyInterface interface {
	Create(*v1beta.PolycubeNetworkPolicy) (*v1beta.PolycubeNetworkPolicy, error)
	Update(*v1beta.PolycubeNetworkPolicy) (*v1beta.PolycubeNetworkPolicy, error)
	Delete(name string, options *v1.DeleteOptions) error
	DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error
	Get(name string, options v1.GetOptions) (*v1beta.PolycubeNetworkPolicy, error)
	List(opts v1.ListOptions) (*v1beta.PolycubeNetworkPolicyList, error)
	Watch(opts v1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta.PolycubeNetworkPolicy, err error)
	PolycubeNetworkPolicyExpansion
}

// polycubeNetworkPolicies implements PolycubeNetworkPolicyInterface
type polycubeNetworkPolicies struct {
	client rest.Interface
	ns     string
}

// newPolycubeNetworkPolicies returns a PolycubeNetworkPolicies
func newPolycubeNetworkPolicies(c *PolycubeV1betaClient, namespace string) *polycubeNetworkPolicies {
	return &polycubeNetworkPolicies{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the polycubeNetworkPolicy, and returns the corresponding polycubeNetworkPolicy object, and an error if there is any.
func (c *polycubeNetworkPolicies) Get(name string, options v1.GetOptions) (result *v1beta.PolycubeNetworkPolicy, err error) {
	result = &v1beta.PolycubeNetworkPolicy{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("polycubenetworkpolicies").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of PolycubeNetworkPolicies that match those selectors.
func (c *polycubeNetworkPolicies) List(opts v1.ListOptions) (result *v1beta.PolycubeNetworkPolicyList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1beta.PolycubeNetworkPolicyList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("polycubenetworkpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested polycubeNetworkPolicies.
func (c *polycubeNetworkPolicies) Watch(opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("polycubenetworkpolicies").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a polycubeNetworkPolicy and creates it.  Returns the server's representation of the polycubeNetworkPolicy, and an error, if there is any.
func (c *polycubeNetworkPolicies) Create(polycubeNetworkPolicy *v1beta.PolycubeNetworkPolicy) (result *v1beta.PolycubeNetworkPolicy, err error) {
	result = &v1beta.PolycubeNetworkPolicy{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("polycubenetworkpolicies").
		Body(polycubeNetworkPolicy).
		Do().
		Into(result)
	return
}

// Update takes the representation of a polycubeNetworkPolicy and updates it. Returns the server's representation of the polycubeNetworkPolicy, and an error, if there is any.
func (c *polycubeNetworkPolicies) Update(polycubeNetworkPolicy *v1beta.PolycubeNetworkPolicy) (result *v1beta.PolycubeNetworkPolicy, err error) {
	result = &v1beta.PolycubeNetworkPolicy{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("polycubenetworkpolicies").
		Name(polycubeNetworkPolicy.Name).
		Body(polycubeNetworkPolicy).
		Do().
		Into(result)
	return
}

// Delete takes name of the polycubeNetworkPolicy and deletes it. Returns an error if one occurs.
func (c *polycubeNetworkPolicies) Delete(name string, options *v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("polycubenetworkpolicies").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *polycubeNetworkPolicies) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("polycubenetworkpolicies").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched polycubeNetworkPolicy.
func (c *polycubeNetworkPolicies) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta.PolycubeNetworkPolicy, err error) {
	result = &v1beta.PolycubeNetworkPolicy{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("polycubenetworkpolicies").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
