/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package v1beta

import (
	v1beta "github.com/polycube-network/polycube/src/components/k8s/pcn_k8s/pkg/apis/polycube.network/v1beta"
	"github.com/polycube-network/polycube/src/components/k8s/pcn_k8s/pkg/client/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type PolycubeV1betaInterface interface {
	RESTClient() rest.Interface
	PolycubeNetworkPoliciesGetter
}

// PolycubeV1betaClient is used to interact with features provided by the polycube.network group.
type PolycubeV1betaClient struct {
	restClient rest.Interface
}

func (c *PolycubeV1betaClient) PolycubeNetworkPolicies(namespace string) PolycubeNetworkPolicyInterface {
	return newPolycubeNetworkPolicies(c, namespace)
}

// NewForConfig creates a new PolycubeV1betaClient for the given config.
func NewForConfig(c *rest.Config) (*PolycubeV1betaClient, error) {
	config := *c
	if err := setConfigDefaults(&config); err != nil {
		return nil, err
	}
	client, err := rest.RESTClientFor(&config)
	if err != nil {
		return nil, err
	}
	return &PolycubeV1betaClient{client}, nil
}

// NewForConfigOrDie creates a new PolycubeV1betaClient for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *PolycubeV1betaClient {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new PolycubeV1betaClient for the given RESTClient.
func New(c rest.Interface) *PolycubeV1betaClient {
	return &PolycubeV1betaClient{c}
}

func setConfigDefaults(config *rest.Config) error {
	gv := v1beta.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = scheme.Codecs.WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}

	return nil
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *PolycubeV1betaClient) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
