/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	v1beta "github.com/polycube-network/polycube/src/components/k8s/pcn_k8s/pkg/apis/polycube.network/v1beta"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakePolycubeNetworkPolicies implements PolycubeNetworkPolicyInterface
type FakePolycubeNetworkPolicies struct {
	Fake *FakePolycubeV1beta
	ns   string
}

var polycubenetworkpoliciesResource = schema.GroupVersionResource{Group: "polycube.network", Version: "v1beta", Resource: "polycubenetworkpolicies"}

var polycubenetworkpoliciesKind = schema.GroupVersionKind{Group: "polycube.network", Version: "v1beta", Kind: "PolycubeNetworkPolicy"}

// Get takes name of the polycubeNetworkPolicy, and returns the corresponding polycubeNetworkPolicy object, and an error if there is any.
func (c *FakePolycubeNetworkPolicies) Get(name string, options v1.GetOptions) (result *v1beta.PolycubeNetworkPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(polycubenetworkpoliciesResource, c.ns, name), &v1beta.PolycubeNetworkPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta.PolycubeNetworkPolicy), err
}

// List takes label and field selectors, and returns the list of PolycubeNetworkPolicies that match those selectors.
func (c *FakePolycubeNetworkPolicies) List(opts v1.ListOptions) (result *v1beta.PolycubeNetworkPolicyList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(polycubenetworkpoliciesResource, polycubenetworkpoliciesKind, c.ns, opts), &v1beta.PolycubeNetworkPolicyList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &v1beta.PolycubeNetworkPolicyList{ListMeta: obj.(*v1beta.PolycubeNetworkPolicyList).ListMeta}
	for _, item := range obj.(*v1beta.PolycubeNetworkPolicyList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested polycubeNetworkPolicies.
func (c *FakePolycubeNetworkPolicies) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(polycubenetworkpoliciesResource, c.ns, opts))

}

// Create takes the representation of a polycubeNetworkPolicy and creates it.  Returns the server's representation of the polycubeNetworkPolicy, and an error, if there is any.
func (c *FakePolycubeNetworkPolicies) Create(polycubeNetworkPolicy *v1beta.PolycubeNetworkPolicy) (result *v1beta.PolycubeNetworkPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(polycubenetworkpoliciesResource, c.ns, polycubeNetworkPolicy), &v1beta.PolycubeNetworkPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta.PolycubeNetworkPolicy), err
}

// Update takes the representation of a polycubeNetworkPolicy and updates it. Returns the server's representation of the polycubeNetworkPolicy, and an error, if there is any.
func (c *FakePolycubeNetworkPolicies) Update(polycubeNetworkPolicy *v1beta.PolycubeNetworkPolicy) (result *v1beta.PolycubeNetworkPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(polycubenetworkpoliciesResource, c.ns, polycubeNetworkPolicy), &v1beta.PolycubeNetworkPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta.PolycubeNetworkPolicy), err
}

// Delete takes name of the polycubeNetworkPolicy and deletes it. Returns an error if one occurs.
func (c *FakePolycubeNetworkPolicies) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(polycubenetworkpoliciesResource, c.ns, name), &v1beta.PolycubeNetworkPolicy{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakePolycubeNetworkPolicies) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(polycubenetworkpoliciesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &v1beta.PolycubeNetworkPolicyList{})
	return err
}

// Patch applies the patch and returns the patched polycubeNetworkPolicy.
func (c *FakePolycubeNetworkPolicies) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1beta.PolycubeNetworkPolicy, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(polycubenetworkpoliciesResource, c.ns, name, pt, data, subresources...), &v1beta.PolycubeNetworkPolicy{})

	if obj == nil {
		return nil, err
	}
	return obj.(*v1beta.PolycubeNetworkPolicy), err
}
