       SUBROUTINE VARIN4
C***
C***  THIS SUBROUTINE WAS WRITTEN BY W.D. GRUNDY  JANUARY 1981
C***
C***  THIS SUBROUTINE INPUTS THE VARIOGRAM PARAMETERS
C***  AND COMPUTES ANISOTROPY CORRECTION FACTORS FOR PROGRAMS
C***  SS2DXVAL, SS2DBLOK, SS2DGRID, AND SS2DDRES.
C***  SEE JOURNEL AND HUIJBREGTS (1978,PP. 175-183)
C***
C***                   HOW TO ENTER ANISOTROPY
C***
C***  FOR GEOMETRIC ANISOTROPY:
C***
C***  1) WITH PENCIL AND GRAPH PAPER, CONSTRUCT ELLIPTICAL VECTOR
C***     DIAGRAM OF VARIOGRAM RANGES IN DIFFERENT DIRECTIONS.  (SEE
C***     JOURNEL AND HUIJBREGTS, 1978, P. 180)
C***  2) DETERMINE PARAMETERS OF VARIOGRAM IN DIRECTION PARALLEL
C***     TO THE MAJOR AXIS OF THE ELLIPSE (NUGGET, C-VALUE, A-VALUE)
C***  3) MEASURE BEARING IN DEGREES OF THE MAJOR AXIS OF THE ELLIPSE
C***     (EAST IS TAKEN AS 0 DEGREES; A COUNTER-CLOCKWISE DIRECTION
C***     IS POSITIVE; A CLOCKWISE DIRECTION IS NEGATIVE.)
C***  4) CALCULATE THE RATIO OF THE LENGTH OF THE MAJOR AXIS TO THE
C***     LENGTH OF THE MINOR AXIS.  THIS IS THE ANISOTROPY RATIO
C***     AND SHOULD BE GREATER THAN ONE.
C***  5) WHEN REQUESTED BY PROGRAMS SS2DXVAL, SS2DBLOK, SS2DGRID, OR
C***     SS2DDRES, ENTER THE VARIOGRAM PARAMETERS FROM STEP 2 ABOVE.
C***     INDICATE TO THE PROGRAM THAT THE ANISOTROPY IS GEOMETRIC,
C***     AND ENTER THE BEARING OF THE MAJOR AXIS OF THE ELLIPSE OB-
C***     TAINED IN STEP 3 ABOVE.  NEXT ENTER THE ANISOTROPY RATIO
C***     OBTAINED IN STEP 4 ABOVE.
C***
C***  FOR ZONAL ANISOTROPY:
C***
C***  1) DETERMINE THE DIRECTION OF ZONAL VARIATION (I.E., THE
C***     DIRECTION IN WHICH THE VARIOGRAM EXHIBITS THE HIGHEST SILL.)
C***     AGAIN, EAST IS TAKEN AS ZERO DEGREES AND ANGLES IN A COUNTER-
C***     CLOCKWISE DIRECTION ARE POSITIVE.
C***  2) DETERMINE THE PARAMETERS OF THE ISOTROPIC COMPONENT OF
C***     VARIATION (NUGGET, A-VALUE, AND C-VALUE).
C***  3) SUBTRACT THE C-VALUE OF THE ISOTROPIC COMPONENT FROM THE
C***     SILL ESTIMATED ALONG THE DIRECTION OF HIGHEST VARIATION.
C***     THIS YIELDS THE C-VALUE OF THE ZONAL COMPONENT.
C***  4) DETERMINE THE A-VALUE OF THE ZONAL COMPONENT.
C***  5) WHEN ASKED TO GIVE THE NUMBER OF "OTHER" VARIOGRAMS IN THE
C***     MODEL, RESPOND WITH A VALUE OF TWO.
C***  6) ENTER THE PARAMETERS OF THE ISOTROPIC COMPONENT.  NEXT
C***     ENTER THE PARAMETERS OF THE ZONAL COMPONENT.
C***  7) INDICATE THAT THIS VARIOGRAM HAS ZONAL ANISOTROPY, AND ENTER
C***     THE DIRECTION DETERMINED IN STEP 1 ABOVE.  THE ANISOTROPY
C***     RATIO IS AUTOMATICALLY SET TO ZERO.
C***
C**********************************************************************
C***
C***  NOTE: THIS PROGRAM REQUESTS A C-VALUE FOR A LINEAR VARIOGRAM,
C***  ALTHOUGH A LINEAR VARIOGRAM CANNOT HAVE A C-VALUE AS IT HAS
C***  NO SILL.  THE C-VALUE IN THIS CASE IS A PSEUDO-PARAMETER WHICH
C***  IS INTRODUCED TO ALLOW USE OF AN EFFICIENT SUBPROGRAM FOR
C***  SOLVING FOR KRIGING WEIGHTS.  (SEE FOOTNOTE ON PAGE 306 OF
C***  JOURNEL AND HUIJBREGTS).  WHEN USING A LINEAR VARIOGRAM, THE
C***  SEARCH RADIUS MUST BE DEFINED SO THAT NO TWO POINTS INVOLVED
C***  IN COVARIANCE CALCULATIONS ARE FARTHER APART THAN THE DISTANCE
C***  DEFINED FROM THE ORIGIN OF THE VARIOGRAM TO THE POINT WHERE
C***  THE LINEAR SEGMENT INTERSECTS THE PSEUDO-SILL.
C***
C***  NOTE: THIS SUBROUTINE MUST USE THE FORTRAN 77 DO LOOP SEMANTICS
C***
$INCLUDE: 'MYST.INC'
      CHARACTER*8 IHOLID
C      CHARACTER*4 IVIB
      integer*4 IVIB
      INTEGER*2 EX,EY
      COMMON /COV4/ P(1830),ID(60),W(60),IHOL(51),R(60)
C***  INITIALIZE VARIOGRAM PARAMETERS
      DO 10 I=1,5
      C(I)=0.
      ANGLE(I)=0.
      AFH(I)=1.
      AVALU(I)=0.
      ITYPE(I)=0
      SLOPE(I)=0.
   10 CONTINUE
      C0=0.
      WRITE(*,20)
   20 FORMAT(/,' ENTER PARAMETERS OF THE VARIOGRAM[S] ',/)
   30 JER=1
      WRITE(*,40)
   40 FORMAT(' ENTER THE NUGGET VALUE : ',/,' ?'\)
      READ(*,50,ERR=420) C0
   50 FORMAT(BN,F10.0)
      IF(C0.GE.0) GO TO 70
      write(*,*)char(bel)
      WRITE(*,60)
   60 FORMAT(' NUGGET VALUE MUST NOT BE NEGATIVE')
      GO TO 30
   70 IER=1
      WRITE(*,80)
   80 FORMAT(' HOW MANY OTHER VARIOGRAMS ARE IN THE MODEL ',
     1' (MAX=5) :',/,' ? '\)
      READ(*,90,ERR=440) NEST
   90 FORMAT(BN,I2)
      IF(NEST.GE.0.AND.NEST.LE.5) GO TO 110
      write(*,*)char(bel)
      WRITE(*,100)
  100 FORMAT(' ANSWER MUST BE 0,1,2,3,4,OR 5')
      GO TO 70
  110 IF(C0.GT.0..OR.NEST.GT.0) GO TO 130
      write(*,*)char(bel)
      WRITE(*,120)
  120 FORMAT(' THE NUGGET VALUE AND THE NUMBER OF OTHER',
     1' VARIOGRAMS CANNOT BOTH',/,' BE EQUAL TO ZERO.  REDO OR BREAK.')
      GO TO 30
  130 IF(NEST.EQ.0) GO TO 390
      I=1
  150 IER=2
      WRITE(*,160) I
  160 FORMAT(' IS VARIOGRAM NO. ',I1,' (1) SPHERICAL, (2) EXPONENTIAL,
     1',/,' (3) LINEAR, (4) GAUSSIAN, OR (5) CUBIC?',/,
     2' ANSWER 1, 2, 3, 4, OR 5 :',/,' ?'\)
      READ(*,90,ERR=440) ITYPE(I)
      IF(ITYPE(I).GE.1.AND.ITYPE(I).LE.5) GO TO 170
      write(*,*)char(bel)
      GO TO 150
  170 JER=2
      WRITE(*,180) I
  180 FORMAT(' ENTER SILL OF VARIOGRAM NO ',I1,':',/,' ?'\)
      READ(*,50,ERR=420) C(I)
      C(I)=C(I)-C0
      IF(C(I).GT.0.) GO TO 200
      write(*,*)char(bel)
      WRITE(*,190)
  190 FORMAT(' SILL MUST BE GREATER THAN NUGGET')
      GO TO 170
  200 JER=3
      IF (ITYPE(I).NE.3) THEN
        WRITE (*,210) I
  210   FORMAT(' ENTER RANGE OF INFLUENCE OF VARIOGRAM NO ',I1,':',
     + ' ?'\)
        READ(*,50,ERR=420) AVALU(I)
      ELSE
        AVALU(I) = 1
      ENDIF
      IF(AVALU(I).GT.0.) GO TO 230
      write(*,*)char(bel)
      WRITE(*,220)
  220 FORMAT(' RANGE OF INFLUENCE MUST BE GREATER THAN ZERO')
      GO TO 200
  230 IF(ITYPE(I).NE.3) GO TO 280
C     IF(AVALU(I).LT.2.) GO TO 250
C     write(*,*)char(bel)
C     WRITE(*,240)
C 240 FORMAT(' FOR LINEAR VARIOGRAM RANGE MUST BE GREATER THAN',
C    1' ZERO AND LESS THAN TWO')
C     GO TO 200
  250 JER=4
      WRITE(*,260) I
  260 FORMAT(' ENTER SLOPE OF LINEAR VARIOGRAM NO. ',I1,':',/,' ?'\)
      READ(*,50,ERR=420) SLOPE(I)
      IF(SLOPE(I).GT.0.) GO TO 280
      write(*,*)char(bel)
      WRITE(*,270)
  270 FORMAT(' SLOPE OF LINEAR VARIOGRAM MUST BE GREATER THAN ZERO')
      GO TO 250
  280 IER=3
      WRITE(*,290) I
  290 FORMAT(' IS VARIOGRAM NO ',I1,' (1) ISOTROPIC OR (2) ANISOTROPIC
     1 ?',/,' ANSWER 1 OR 2 :',/,' ?'\)
      READ(*,90,ERR=440) IANS
      IF(IANS.GE.1.AND.IANS.LE.2) GO TO 300
      write(*,*)char(bel)
      GO TO 280
  300 IF(IANS.EQ.1) GO TO 380
      AFH(I)=0.
  310 IER=4
      WRITE(*,320) I
  320 FORMAT(' IS ANISOTROPY OF VARIOGRAM NO ',I1,' (1) GEOMETRIC OR (
     12) ZONAL ?',/,' ANSWER 1 OR 2 :',/,' ?'\)
      READ(*,90,ERR=440) IANS
      IF(IANS.GE.1.AND.IANS.LE.2) GO TO 330
      write(*,*)char(bel)
      GO TO 310
  330 JER=5
      WRITE(*,340) I
  340 FORMAT(' ENTER ANISOTROPY ANGLE OF VARIOGRAM NO ',I1,
     1' (DEC. DEG, NORTH=0) :',/,' ?'\)
      READ(*,50,ERR=420) ANGLE(I)
C
C     CONVERT ANGLE FROM NORTH=0,CLOCKWISE TO EAST=0,COUNTERCLOCKWISE
C
      ANGLE(I) = 450 - ANGLE(I)
      IF(IANS.EQ.2) GO TO 380
  350 JER=6
      WRITE(*,360) I
  360 FORMAT(' ENTER ANISOTROPY FACTOR OF VARIOGRAM NO ',I1,':',/,
     +' ?'\)
      READ(*,50,ERR=420) AFH(I)
      IF(AFH(I).GE.0.) GO TO 380
      write(*,*)char(bel)
      WRITE(*,370)
  370 FORMAT(' ANISOTROPY FACTOR MUST NOT BE NEGATIVE')
      GO TO 350
  380 I=I+1
      IF(I-NEST) 150,150,390
C***  COMPUTE SILL VALUE
  390 SILL=C0
      DO 400 I=1,NEST
      SILL=SILL+C(I)
  400 CONTINUE
C***  COMPUTE ANISOTROPY CORRECTION FACTORS
      DO 410 I=1,NEST
C***  TEMPORARILY CHANGE SIGN OF ANGLE OF ANISOTROPY
      ANGLE(I)=-ANGLE(I)
      SINANG=SIN(ANGLE(I)*1.7453292D-02)
      COSANG=COS(ANGLE(I)*1.7453292D-02)
      AISI(I)=COSANG**2+AFH(I)*SINANG**2
      BISI(I)=SINANG**2+AFH(I)*COSANG**2
      CISI(I)=(1.-AFH(I))*SINANG*COSANG
      ANGLE(I)=-ANGLE(I)
  410 CONTINUE
      RETURN
  420 write(*,*)char(bel)
      WRITE(*,430)
  430 FORMAT(' REAL VALUE WAS EXPECTED; REENTER VALUE')
      GO TO (30,170,200,250,330,350), JER
  440 write(*,*)char(bel)
      WRITE(*,450)
  450 FORMAT(' INTEGER VALUE WAS EXPECTED; REENTER VALUE')
      GO TO (70,150,280,310), IER
      END
