C******************************************************************************
C
C             S U B R O U T I N E    T A B A R A
C
C  FUNCTION - DETERMINE UNIQUE SET OF SUBJECTS AND PRINT
C             OUT A SUMMARY TABLE OF SUBJECTS, AREAS, AND
C             FREQUENCIES (ALSO IS USED FOR LENGTH INFO
C
C  INPUT PARAMETERS -
C
C       LINES  = UPDATED CURSOR POSITION
C       JTYPE  = TABULATION TYPE =
C                -1 = AREAS
C                -2 = LENGTHS
C                -3 = FREQUENCIES
C                -4 = PERIMETER
C******************************************************************************
C
      SUBROUTINE TABARA(LINES,JTYPE)
C       COMMON /IDEVIC/ LDEVL(128)
       COMMON /PNTFET/ NPOINT
       COMMON /FLS/    IUNIT,IFILE(5)
       COMMON /WHMAP/  ISTRCT(300),NSTRCT
       COMMON /UNIT/   CHANEL,ATRBTE,POLYGON,ADRESS
       COMMON /ATTFET/ KAT(86),LBAT
       COMMON /IO/     NPRNT,IOIN
       COMMON /WORK/   IBUFF(128),MAP(25),ICOM(10),JCOM(10)
$Include:'strng.inc'
       COMMON /TYPE/   IDATYP(40),NACTS
       dimension numb(2,5000) , polsiz(5000), mapname(25)
       DIMENSION   ITRNS(2),WIND(4),IACT(20),IATT(3,20),isubj(16)
       character linp*20
       INTEGER     IATBUF(128),CHANEL,ATRBTE,POLYGON,ADRESS,linepr(25)
       LOGICAL     INSERT,IOK,HARD,MCOMP1,MCOMP,SORT,FOUND
       EQUIVALENCE (IBUFF(9),PERIM),(linp,linepr(1))
       EQUIVALENCE (IBUFF(7),AMOUNT)
       EQUIVALENCE (ITRNS(1),XTT)
       data numb/10000*0/polsiz/5000*0.0/
C
C
C  ANY DATA TO WORK WITH ?
C
C      IF(NSTRCT.LE.0) GO TO 9898
C
C  SET LINE COUNTER
C
      FT2MT = .304800609
      MAXSUB = 2500
      IUNITS= 0
      NPAGE=1
      SORT = .TRUE.
      INSERT=.TRUE.
      HARD=.FALSE.
      IP=0
      LINES=1
      ICHAN=10
      ICHANT=98
      NSUBS=0
      CHANEL = 31
      LCOUNT=24
      NPAGE=1
C
C
C CHECK FOR INDETERMINATE CALL TO TABARA
C
      IF(JTYPE.GE.0.OR.JTYPE.LE.-5) GO TO 9999
C
C  SET SUMMARY TYPE
C
      ITYPE=IABS(JTYPE)
C
C  GET ACTIVE DATA SET NUMBER
C
      CALL DAGET(ICARD,icardp,IACT,20,MACTS)
C
C  ANY ACTIVE DATA SET SPECIFIED ?
C
      IF(MACTS.NE.0) GO TO 10
C
C  NO.  PROMPT THE USER
C
      WRITE(NPRNT,1000)
 1000 FORMAT(' ENTER ACTIVE MAP I.D.(S)'\)
      CALL READIN(ICARD,lenicd,icardp,istop)
      CALL DAGET(ICARD,icardp,IACT,20,MACTS)
      GO TO 9
C
C  GOT AN ACTIVE DATA SET.  NOW DETERMINE THE
C  APPROPRIATE PARAMETERS FOR THE TABULATION ROUTINE.
C  FIRST GET THE PROPER FIT AND DATA CHANNEL
C
  10  CONTINUE
       KK=icardp
       CALL CLEAR(MAP,25)
       CALL DECIP(ICARD,ICOM,KK)
       IF (ICOM(1) .EQ. 0) GO TO 9
       IF(.NOT. MCOMP(ICOM,'HARD',4,IER)) GO TO 19
       icardp=KK
       LCOUNT=60
       nprnt=70
       HARD =.TRUE.
       linp='Hard.cpy'
       CALL OPENF(70,linepr,0,0,0,IER)
       IF(IER.NE.0) GO TO 916
       GO TO 9
C
C  NAMED OUTPUT FILE
C
  19   CONTINUE
       if(icom(1).eq.78.and.icom(2).eq.0)go to 9
       CALL PACKC(ICOM,MAP,10)
       call openf(70,map,0,0,0,ier)
c       I=12
c       WRITE(70,1234) I
c 1234  FORMAT(A2)
       LCOUNT = 60
       nprnt=70
       HARD = .TRUE.
       icardp=kk
C
  9    CONTINUE
       IF(MACTS.LE.0) GO TO 908
C
       CALL DECIP (ICARD,ICOM,icardp)
       IF ( MCOMP(ICOM,'N',1,IER)) SORT = .FALSE.
C
C  SEE IF CELL DATA ON ID 1
C
      IDD = IACT(1)
      IFTYP=IDATYP( (IDD/7)+1 )
      IF ((ITYPE.EQ.1 .OR. ITYPE.EQ.3) .AND. IFTYP.EQ.7) GO TO 200
      IF (IFTYP .EQ. 6  .OR.  IFTYP .EQ. 8  .OR.  IFTYP .EQ. 9)GO TO 900
C
C  DELETE, CREATE, AND OPEN TEMPSUB FILE
C
      map(1)=2hZ
      call openf(ichant,map,3,256,2,ier)
C
C LOOP THROUGH ALL ACTIVE MAPS AND CREATED SORTED LIST OF SUBJECTS
C
      NNSUB=0
      IREC = 0
      CALL CLEAR(IATT,60)
      DO 350 II=1,MACTS
C
        IDD1=(IACT(II)/7)+1
        IDD=IACT(II)
C
C  CHECK FOR ILLEGAL ACTIONS ON THIS PASS
C
        IFTYP=IDATYP(IDD1)
        IF ((ITYPE.EQ.1 .OR. ITYPE.EQ.3) .AND. IFTYP.EQ.7) GO TO 200
        IF ((ITYPE.EQ.2 .OR. ITYPE.EQ.4) .AND. IFTYP.EQ.7) GO TO 902
        IF(IFTYP .EQ. 6  .OR.  IFTYP .EQ. 8  .OR. IFTYP .EQ. 9)GO TO 900
C
        IF(ITYPE.EQ.2.AND.IFTYP.EQ.6) GO TO 912
        IF(ITYPE.EQ.1.AND.IFTYP.EQ.1) GO TO 907
        IF(ITYPE.EQ.1.AND.IFTYP.EQ.2) GO TO 906
        IF(ITYPE.EQ.2.AND.IFTYP.EQ.1) GO TO 905
        IF(ITYPE.EQ.2.AND.IFTYP.EQ.3) GO TO 904
C
C GET MAP NAME AND OPEN
C
        CALL GTNAM(IDD,0,2h  ,MAP,IER)
C
        call adddir(map,mapname)
C
        CALL OPENF(ICHAN,MAPname,1,256,2,IER)
        IF(IER.NE.0) GO TO 909
C
C  READ HEADER BLOCK AND GET NUMBER OF SUBJECTS
C
        CALL RDBLK(ICHAN,1,IBUFF,1,IER)
        NSUBS=IBUFF(67)
        ITEMS=IBUFF(63)
        IF (IBUFF(76) .NE. 1) GO TO 300
        IF (KAT((IDD/7)*2+1) .EQ. 0) GO TO 300
C
C  OPEN MA FILE
C
        CALL GTNAM(IDD,4,2h  ,MAP,IER)
C
        call adddir(map,mapname)
C
        CALL OPENF(CHANEL,MAPname,1,256,2,IER)
        IF (IER .NE. 0) GO TO 909
C
C  GET TYPE , WORDS, LOCATE
C  IF TYPE CHAR TYPE STORED AS NEG OF WORDS, BSEARCH SETS TYPE TO 4
C
        IATT(1,II) = KAT((IDD/7)*2+1)
        IATT(2,II) = IABS(IATT(1,II))
        IF (IATT(1,II) .LT. 0) IATT(1,II) = 3
        IATT(3,II) = KAT((IDD/7)*2+2)
        IF (IATT(1,II) .LT. 4) GO TO 260
C
C  BSEARCHED FILE
C
        CALL INITIAL
        CALL RETRVL(FOUND,IATBUF)
        IF (.NOT. FOUND) CLOSE(CHANEL,iostat=IER)
        IF (.NOT. FOUND) GO TO 300
        IATT(1,II) = IATBUF(84)
        IATT(2,II) = IATBUF(85)
        IATT(3,II) = IATBUF(86)
C
 260    CONTINUE
        DO 280 JJ=1,ITEMS
          CALL GETAT(CHANEL,IATT(1,II),IATT(2,II),IATT(3,II),
     +               IATBUF,JJ,IBUFF,RNUM,IER)
           IF (IER .NE. 0) GO TO 950
C
C  CALL SUBJECT SEARCH/SORT ROUTINE
C
          do 53 iii=1,16
   53     isubj(iii)=ibuff(iii)
          irec=irec+1
          IF (SORT) CALL FNDSUB(ICHANT,isubj,NNSUB,INSERT,IREC,IER)
          IF (.NOT. SORT)
     +      CALL NSSUB(ICHANT,isubj,NNSUB,INSERT,IREC,IER)
          IF(IER.NE.0) GO TO 917
          IF (NNSUB .GT. MAXSUB) GO TO 924
 280    CONTINUE
        CLOSE(CHANEL,iostat=IER)
        CLOSE(ICHAN,iostat=IER)
        GO TO 350
C
C  LOOP THROUGH EACH SUBJECT
C
 300    CONTINUE
        DO 340 JJ=1,NSUBS
C
          CALL RDBLK(ICHAN,JJ+2,IBUFF,1,IER)
C
C  CALL SUBJECT SEARCH/SORT ROUTINE
C
          do 51 iii=1,15
   51     isubj(iii)=ibuff(iii)
          call fixchr(isubj,30)
          isubj(16)=ibuff(16)
          irec=irec+1
          IF (SORT) CALL FNDSUB(ICHANT,isubj,NNSUB,INSERT,IREC,IER)
          IF (.NOT. SORT)
     +       CALL NSSUB(ICHANT,isubj,NNSUB,INSERT,IREC,IER)
          IF(IER.NE.0) GO TO 917
          IF (NNSUB .GT. MAXSUB) GO TO 924
  340   CONTINUE
C
C  CLOSE CHANNEL AND DO NEXT MAP
C
         CLOSE(ICHAN,iostat=IER)
C
 350  CONTINUE
C
C  NEXT MAJOR LOOP.  BUILD ACTUAL TABLE
C
      INSERT=.FALSE.
      IREC = 0
      DO 400 II=1,MACTS
C
C  GET MAP NAME FOR THIS ID
C
       IDD = IACT(II)
       CALL GTNAM(IDD,0,2h  ,MAP,IER)
C
C  OPEN CHANNEL TO THIS MAP
C
C
      call adddir(map,mapname)
C
      CALL OPENF(ICHAN,MAPname,1,256,2,IER)
      IF(IER.NE.0) GO TO 909
C
C  OPEN ATTRIBUTE FILE IF REQUIRED
C
      IF (IATT(1,II) .NE. 0) then
        CALL GTNAM(IDD,4,2h  ,MAP,IER)
C
        call adddir(map,mapname)
C
        CALL OPENF(CHANEL,MAPname,1,256,2,IER)
        IF (IER .NE. 0) GO TO 909
      endif


C
C  NOW GET POINTER SET
C
      CALL APGET(IDD,ISTART,ISTOP,NTOTAL)
C
C  LOOP THROUGH ALL ACTIVE FEATURES FOR THIS I.D.
C
        DO 390 JJ=ISTART,ISTOP
          CALL GETFAST(JJ,WIND,INDEX,ISUBP,IEX1,IEX2,IER)
C
C  FOR NORMAL OR FROM ATTRIBUTE
C
          IF (IATT(1,II) .NE. 0) GO TO 370
C
C  NORMAL
          CALL RDBLK(ICHAN,ISUBP,IBUFF,1,IER)
          IF (IER .NE. 0) GO TO 940
          GO TO 380
C
C  ATTRIBUTE
C
 370      CONTINUE
          CALL RDBLK(ICHAN,INDEX,IATBUF,1,IER)
          IF (IER .NE. 0) GO TO 940
          NREC = IATBUF(5)
          CALL GETAT(CHANEL,IATT(1,II),IATT(2,II),IATT(3,II),
     +               IATBUF,NREC,IBUFF,RNUM,IER)
          IF (IER .NE. 0) GO TO 950
C
C  FIND SUBJECT IN SORTED FILE
C
 380      irec=irec+1
           do 54 iii=1,15
   54      isubj(iii)=ibuff(iii)
           if(sort)then
            CALL FNDSUB(ICHANT,isubj,NNSUB,INSERT,IREC,IER)
            else
            CALL NSSUB(ICHANT,isubj,NNSUB,INSERT,IREC,IER)
            IF (IER .NE. 0) GO TO 917
          endif
C
C  READ HEADER BLOCK AND EXTRACT AREA/LENGTH INFO
C
 381      CALL RDBLK(ICHAN,INDEX,IBUFF,1,IER)
          IF (IER .NE. 0) GO TO 940
C
C  NOW TABULATE...INPUT ALWAYS IS AREA IN ACRES & LENGTH AND PERIMITER IN MILES
C
          NUMB(1,IREC)=IREC
          NUMB(2,IREC)=NUMB(2,IREC)+1
          IF(ITYPE.EQ.4) AMOUNT=PERIM
C
C  IF IUNITS=1,
C**  CONVERT ACRES TO HECTARES, LENGTH AND PERIMETER FROM MILES TO KILOMETERS
C
          IF(ITYPE.EQ.1 .AND. IUNITS.EQ.1) AMOUNT = AMOUNT * .4046856422
          IF(ITYPE.EQ.2 .AND. IUNITS.EQ.1) AMOUNT = AMOUNT * 1.60935
          IF(ITYPE.EQ.3 .AND. IUNITS.EQ.1) AMOUNT = AMOUNT * 1.60935
          POLSIZ(IREC)=POLSIZ(IREC)+AMOUNT
 390    CONTINUE
       CLOSE(ICHAN,iostat=IER)
       IF (IATT(1,II) .NE. 0) CLOSE(CHANEL,iostat=IER)
C
 400  CONTINUE
C
C  WE NOW HAVE THE TABULATION INFO STORED IN NUMB. WE
C  NOW PRINT IT OUT, STARTING WITH A HEADER
C
        LENT=NSUBS*2
C
C  WRITE OUT THE NAMES & ACTIVE ID'S
C
       if(nprnt.ne.6)then
       CALL PRHEAD('Meas. & Freq Report',lines,npage)
       endif
       WRITE(nprnt,2050)
 2050  FORMAT(/)
       DO 600 II = 1,MACTS
         IDD=IACT(II)
         CALL GTMAP(ICOM,IDD)
         if(icom(1).lt.0)icom(1)=iabs(icom(1))
         ID=IDD/7+1
         LINES = LINES + 1
      IF(ITYPE.EQ.1) WRITE(nprnt,1001) (ICOM(I),I=1,5),ID
 1001 FORMAT(22H AREA SUMMARY FOR MAP ,5A2,2X,
     1 16HACTIVE MAP NO.  ,I4)
      IF(ITYPE.EQ.2) WRITE(nprnt,1017) (ICOM(I),I=1,5),ID
 1017 FORMAT(24H LENGTH SUMMARY FOR MAP  ,5A2,2X,
     1 16HACTIVE MAP NO.  ,I4)
      IF(ITYPE.EQ.3) WRITE(nprnt,1018) (ICOM(I),I=1,5),ID
 1018 FORMAT(27H FREQUENCY SUMMARY FOR MAP  ,5A2,2X,
     1 16HACTIVE MAP NO.  ,I4)
      IF(ITYPE.EQ.4) WRITE(nprnt,1019) (ICOM(I),I=1,5),ID
 1019 FORMAT(27H PERIMETER SUMMARY FOR MAP  ,5A2,2X,
     1 16HACTIVE MAP NO.   ,I4)
  600  CONTINUE
C
      IF(ITYPE.EQ.1) WRITE(nprnt,1002)
 1002 FORMAT(//,13X,7HSUBJECT,18X,4HAREA,6X,9HFREQUENCY,4X,7HPERCENT)
      IF(ITYPE.EQ.2) WRITE(nprnt,1015)
 1015 FORMAT(//,13X,7HSUBJECT,17X,6HLENGTH,6X,9HFREQUENCY,4X,7HPERCENT)
      IF(ITYPE.EQ.3) WRITE(NPRNT,1016)
 1016 FORMAT(//,13X,7HSUBJECT,15X,9HFREQUENCY,6X,7HPERCENT)
      IF(ITYPE.EQ.4)WRITE(NPRNT,1020)
 1020 FORMAT(//,13X,7HSUBJECT,13X,9HPERIMETER,6X,9HFREQUENCY,
     + 4X,7HPERCENT)
      WRITE(NPRNT,1003)
 1003 FORMAT(1X,
     167H---------------------------------------------------------------
     2----)
      LINES=LINES+3
C
C  GET TO TOTAL TO DO PERCENTS
C
      NSUBS=NNSUB
      KOUNT=0
      TOTALL=0.0
      DO 25 I=1,NSUBS
      KOUNT=KOUNT+NUMB(2,I)
      TOTALL=POLSIZ(I)+TOTALL
  25  CONTINUE
      IF(ITYPE.EQ.3) TOTALL=1.0
C
C  NOW PRINT OUT THE ACTUAL TABLE
C
 26   CONTINUE
      TOTAR=0.0
      TOTPER=0.0
      NFREQ=0
      PTOT=0.0
      IF(NSUBS.EQ.0) GO TO 910
      DO 30 I=1,NSUBS
      IF(NUMB(2,I).EQ.0) GO TO 30
C
C  GET SUBJECT
C
      CALL GETFSUB(ICHANT,NUMB(1,I),isubj,1,IER)
      IF (IER .NE. 0) GO TO 922
C
      PER=FLOAT(NUMB(2,I))/FLOAT(KOUNT)
      PER=PER*100.0
      PTOT=PTOT+PER
      ALPER=POLSIZ(I)/TOTALL
      ALPER=ALPER*100.0
      TOTPER=TOTPER+ALPER
      IF(ITYPE.LT.3.OR.ITYPE.EQ.4)WRITE(NPRNT,1044) (isubj(IK),IK=1,15),
     1 POLSIZ(I),NUMB(2,I),ALPER
 1044 FORMAT(1X,15A2,F11.2,7X,I5,7X,F6.2)
      IF(ITYPE.EQ.3) WRITE(NPRNT,1004) (isubj(IK),IK=1,15),
     1 NUMB(2,I),PER
 1004 FORMAT(2X,15A2,2X,I10,8X,F5.1)
      NFREQ=NFREQ+NUMB(2,I)
      TOTAR=TOTAR+POLSIZ(I)
      IF(.NOT.HARD) CALL CONTIN(LINES,ISTOP)
      IF(ISTOP.EQ.1) GO TO 9999
      IF(LINES.LE.LCOUNT) GO TO 30
      LINES=1
      NPAGE=NPAGE+1
      CALL PRHEAD('Meas. & Freq. Report',lines,npage)
      WRITE(NPRNT,1084)
 1084 FORMAT(/)
      CALL CONTIN(LINES,IER)
  30  CONTINUE
C
C  NOW PRINT SUMMARY
C
      WRITE(NPRNT,1003)
      IF(ITYPE.EQ.1.AND.IUNITS.EQ.0) WRITE(NPRNT,1088) TOTAR,NFREQ,
     + TOTPER
 1088 FORMAT(3X,'TOTAL (IN ACRES)    ',6X,F13.2,7X,I5,7X,F6.2)
      IF(ITYPE.EQ.1.AND.IUNITS.EQ.1) WRITE(NPRNT,1058) TOTAR,NFREQ,
     + TOTPER
 1058 FORMAT(3X,'TOTAL (IN HECTARES) ',9X,F13.2,4X,I5,7X,F6.2)
      IF((ITYPE.EQ.2.OR.ITYPE.EQ.4).AND.IUNITS.EQ.0)
     +  WRITE(NPRNT,1089) TOTAR,NFREQ,TOTPER
 1089 FORMAT(3X,'TOTAL (IN MILES)      ',4X,F13.2,7X,I5,7X,F6.2)
      IF((ITYPE.EQ.2.OR.ITYPE.EQ.4).AND.IUNITS.EQ.1)
     +  WRITE(NPRNT,1059) TOTAR,NFREQ,TOTPER
 1059 FORMAT(3X,'TOTAL (IN KILOMETERS) ',7X,F13.2,4X,I5,4X,F6.2)
 1005 FORMAT(3X,5HTOTAL,26X,I10,8X,F6.2 )
      IF(ITYPE.EQ.3) WRITE(NPRNT,1005) NFREQ,PTOT
      LINES=LINES+3
      GO TO 9999
C
C  DISCRETE CELL AREAS
C
 200  CONTINUE
C      CALL TABCEL(NPRNT,IDD,LINES,IER)
      GO TO 9999
C
C  ERROR RETURNS
C
 900  WRITE(*,1006) IFTYP
 1006 FORMAT(' *TABARA*  CAN ONLY USE DISCRETE CELL MAPS NOT TYPE',I5)
      GO TO 9999
C
 902  WRITE(*,3009) IFTYP
 3009 FORMAT(' *TABARA*  MAY ONLY DO AREA AND FREQUENCY WITH CELL TYPE '
     + ,I4)
      GO TO 9999
C
 910  WRITE(*,3010)
 3010 FORMAT(' THIS MAP DOES NOT HAVE ANY SUBJECTS')
      GO TO 9999
C
 909   WRITE(*,90909) (MAPname(I),I=1,25),IER
90909  FORMAT(' *TABARA*  ERROR OPENING MAP ',25A1,'  ERROR',I5)
       GO TO 9999
C
 908  WRITE(*,3008)
 3008 FORMAT(' NO ACTIVE MAPS SPECIFIED')
      GO TO 9999
C
 907  WRITE(*,3007)
3007  FORMAT(' CANNOT DO AREAS ON POINT DATA')
      GO TO 9999
C
906   WRITE(*,3006)
3006  FORMAT(' CANNOT DO AREA ON LINE DATA')
      GO TO 9999
C
905   WRITE(*,3005)
3005  FORMAT(' CANNOT DO LENGTH ON POINT DATA')
      GO TO 9999
C
904   WRITE(*,3004)
3004  FORMAT(' CANNOT DO LENGTH ON AREA DATA')
      GO TO 9999
C
 912  WRITE(*,3012)
 3012 FORMAT(' CANNOT DO LENGTH ON RASTER DATA ')
      GO TO 9999
C
 914  write(*,*)' Error on accessing input map -'
      GO TO 9999
C
 915  WRITE(*,3015)
 3015 FORMAT(' *TABARA* COULD NOT CREATE LINE.PTR ON DISK')
      GO TO 9999
C
 916  go to 914
C
 917  WRITE(*,3017) IER
 3017 FORMAT(' *TABARA* ERROR FROM FNDSUB  ERROR',I5)
      GO TO 9999
C
918   WRITE(*,3018) (MAP(I),I=1,15),IER
 3018 FORMAT(' ERROR OPENING PRINTER FILE ',15A2,'  ERROR',I5)
      GO TO 9999
C
  922 write(*,*)' Error reading subjects from input file'
      go to 9999
C
 924  WRITE(*,3024) MAXSUB
3024  FORMAT(' *TABARA*  NUMBER OF SUBJECTS GT MAXIMUM OF',I5)
      GO TO 9999
C
 940  WRITE(*,3040) IER
 3040 FORMAT(' *TABARA*  ERROR FROM RDBLK  ERROR',I5)
      GO TO 9999
C
 950  WRITE(*,3050) IER
 3050 FORMAT(' *TABARA*  ERROR FROM GETAT  ERROR',I5)
      GO TO 9999
C
C9898  write(*,*)'No ACTIVE Data Sets - Use Select '
C  JUMP OUT
C
 9999 CONTINUE
      IF(HARD) CLOSE(70,iostat=IER)
      NPRNT=6
      RETURN
      END
