      SUBROUTINE SS2DPREP(ichstp,ichupr,ier)
C***  WRITTEN BY W.D. GRUNDY  APRIL  1984
C***
C***  PRE-PROCESSING PROGRAM WHICH MUST BE RUN PRIOR TO RUNNING
C***  PROGRAMS SS2DGAMH, SS2DGRID, AND SS2DDRES.  THE STATPAC FILE
C***  CREATED BY THIS PROGRAM IS USED AS AN INPUT FILE TO THESE
C***  PROGRAMS.
C***
C***  THIS PROGRAM SORTS THE SOURCE STATPAC DATA FILE IN ASCENDING
C***  ORDER OF THE HOLE COORDINATES AND CHECKS FOR DUPLICATED DATA
C***  LOCATIONS.  AN OUTPUT FILE IS NOT PRODUCED IF ANY DUPLICATES
C***  ARE FOUND.  A REPORT OF THE PRIMARY ROWIDS OF DUPLICATED
C***  POINTS AND ROW NUMBERS IS PRINTED ON THE SCREEN.  THE DUPLICATES
C***  MUST BE RECONCILED AND REMOVED FROM THE INPUT FILE BEFORE THIS
C***  PROGRAM WILL PRODUCE THE NEEDED OUTPUT FILE FOR PROGRAM SS2DGAMH.
C***
C***  IF THE INPUT FILE HAS MISSING DATA WHICH ARE NOT QUALIFIED,
C***  AND IF THESE MISSING DATA HAVE A UNIQUE NUMERIC VALUE (SUCH
C***  AS -999), THIS PROGRAM REQUESTS THE UNIQUE VALUE, AND ATTACHES
C***  THE STATPAC QUALIFIER 'B' TO THAT MISSING DATA ITEM.  THIS
C***  QUALIFIER IS NECESSARY TO PREVENT PROGRAM SS2DGAMH AND THE
C***  KRIGING PROGRAMS FROM USING INVALID DATA POINTS.
C***
C***  LINKS REQUIRED: B2SORT,CHEKER,CKSAFE,CONCAT,GETDATE,FSORT,IOS,MDYHMS,
C***  SOUND,TICKER
C***
C***  FILE NAME REQUIREMENTS:
C***       THE STATPAC INPUT FILE MUST HAVE THE EXTENSION .STP
C***       THE STATPAC OUTPUT FILE WILL AUTOMATICALLY BE GIVEN
C***       THE EXTENSION .UPR (Unformatted PRep).
C
C
      INTEGER*4 LOC(2)
      INTEGER*4 ITIME1,ITIME2
      INTEGER*2 UNIT10(8),UNIT14(8),N,M
C      CHARACTER*32 UNIT10,UNIT14
      CHARACTER*4 EXT0,EXT1
      CHARACTER*8 IDS,IVID(99),NAME(2),TEMP,IDUM8
      INTEGER*2 IZERO
      CHARACTER*1 IA(99),IANS
      LOGICAL FLAG
      LOGICAL IFLAGQ
      DIMENSION XE(1000),YN(1000),X(99),IPOINT(1000)
      EQUIVALENCE (TEMP,NAME(1))
      DATA EXT0/'.STP'/,EXT1/'.UPR'/
      DATA IOK,IBAD/0,-1/
      DATA EPS/1E-10/
      DATA MAXH/2000/
C**********************************************************************
C***  KI IS INPUT UNIT; KO IS OUTPUT UNIT; KS IS SCRATCH UNIT
      KI=ichstp
      rewind(KI)
      ko=18
      ichupr=ko
      KS=13
C***  INITIALIZE COUNT OF DUPLICATES
      IDUP=0
C*********************************************************************
C***
C***  GET NAMES OF INPUT/OUTPUT FILES
C***
      UNIT14(1) = 2HTE
      UNIT14(2) = 2HMP
      UNIT14(3) = 2HKR
      UNIT14(4) = 2HIG
      UNIT14(5) = 2H.U
      UNIT14(6) = 2HPR
c      CALL openf(KI,UNIT10,1,0,1,IER)
       CALL openf(KO,UNIT14,3,0,1,IER)
C      OPEN(KI,FILE='TEMPKRIG.STP',STATUS='OLD',FORM='UNFORMATTED')
C      OPEN(KO,FILE='TEMPKRIG.UPR',STATUS='NEW',FORM='UNFORMATTED')
C***  READ STATPAC HEADER RECORD
C      READ(KI) IDS,N,M
       READ(KI) IDS,N,M,IDUM8,IDUM8,IDUM8
C       WRITE(*,*) 'SS2DPREP: STP HEADER READ N = ',N
       IF(N.GT.MAXH) THEN
           write(*,*)char(bel)
           WRITE (*,31) N,MAXH
   31      FORMAT (' WARNING*** THERE ARE ',I5,' ROWS IN THE STATPAC',
     1   'INPUT FILE.',/,' THE LIMIT FOR KRIGING IS',I5,' DATA POINTS.')
      ENDIF
      IF(M.GT.99) THEN
         write(*,*)char(bel)
         WRITE(*,33) M
   33    FORMAT (' THERE ARE ',I3,' COLS IN THE STATPAC INPUT ',
     1   ' FILE.',/,' THE LIMIT FOR KRIGING IS 99 COLUMNS.')
      ier=1
      return
      ENDIF
      REWIND (KI)
C      READ(KI) IDS,N,M,(IVID(I),I=1,3)
      READ(KI) IDS,N,M,IVID(1),IVID(2),IVID(3)
C***  COMPUTE RECORD LENGTH FOR DIRECT ACCESS SCRATCH FILE
CSKG      LENREC=24+5*M
      LENREC = 256
C***  OPEN DIRECT ACCESS SCRATCH FILE
      OPEN(KS,ACCESS='DIRECT',STATUS='SCRATCH',
     1FORM='UNFORMATTED',RECL=LENREC)
C*********************************************************************
C***
C***  GET COLUMN NUMBERS OF NORTH- AND EAST-COORDINATES
C***
      INORTH = 2
      IEAST  = 1
      XFLAG  = 0
C**********************************************************************
C***
C***  READ STATPAC INPUT FILE AND STORE NORTH- AND EAST-COORDINATES
C***
  150 continue
C       WRITE(*,160)N
  160 FORMAT('         NOW READING ',I5,' RECORDS INTO SORT')
      DO 190 I=1,N
C      WRITE(*,*) KI,IROW,NAME,LOC,X(1),X(2),X(3),IA,M,IER
      CALL JKGTLS(KI,IROW,NAME,LOC,X,IA,M,IER)
C      IF(IER.NE.0) STOP 'UNEXPECTED END OF FILE'
      IF(IER.NE.0) THEN
        CLOSE(KO)
        ier=1
         return
        ENDIF
      IF(IFLAGQ) THEN
      DO 170 J=1,M
      IF(X(J).EQ.XFLAG.AND.IA(J).EQ.' ') IA(J)='B'
  170 CONTINUE
      ENDIF
      XE(I)=X(IEAST)
      YN(I)=X(INORTH)
      IPOINT(I)=I
C***  WRITE DIRECT ACCESS SCRATCH FILE
      WRITE(KS,REC=I) NAME,LOC,(X(J),IA(J),J=1,M)
C      IF(I/10*10.EQ.I) WRITE(*,180) I
  180 FORMAT('+',I5)
  190 CONTINUE
C      WRITE(*,*) 'STARTING SORTS'
C*********************************************************************
C***
C***  SORT ARRAY OF POINTERS WITH NORTH AS MAJOR AND EAST AS MINOR KEY
C***
      CALL FSORT(YN,IPOINT,N)
      CALL B2SORT(YN,XE,IPOINT,N)
C**********************************************************************
C***
C***  NOW LOOP TO SEARCH FOR MATCHED COORDINATES
C***
C      WRITE(*,200)
  200 FORMAT('         NOW SEARCHING FOR DUPLICATES')
      DO 230 J=2,N
      K=J-1
      IF ((ABS( YN(IPOINT(J)) - YN(IPOINT(K) )) .LE.EPS) .AND.
     1    (ABS( XE(IPOINT(J)) - XE(IPOINT(K) )) .LE.EPS)) THEN
         WRITE(*,220) IPOINT(K),IPOINT(J)
  220    FORMAT(' Point ',I5,' in same location as point ',I5)
         IDUP=IDUP+1
      ENDIF
  230 CONTINUE
C**********************************************************************
C***
C***  IF NO DUPLICATES WERE FOUND WRITE A STATPAC OUTPUT FILE
C***
      IF(IDUP.EQ.0) THEN
C      WRITE(*,240)
  240 FORMAT('         NO DUPLICATED LOCATIONS WERE FOUND')
C***  IT IS OKAY TO WRITE THE STATPAC OUTPUT FILE
C      WRITE(*,250)
  250 FORMAT('         NOW WRITING SORTED STATPAC FILE')
      CALL GETDATE(IDS)
      WRITE(KO) IDS,N,M,IVID(1),IVID(2),IDUM8
      DO 260 I=1,N
      READ(KS,REC=IPOINT(I)) NAME,LOC,(X(J),IA(J),J=1,M)
      CALL JKPTLS(KO,I,NAME,LOC,X,IA,M)
C      IF (I/10*10.EQ.I) WRITE (*,180)I
  260 CONTINUE
C      WRITE (*,180) I-1
      ELSE
      WRITE(*,280) IDUP
  280 FORMAT (1X,I4,' DUPLICATE DATA POINTS WERE FOUND.',/,
     1 ' KRIGING CANNOT BE DONE WITH DUPLICATE DATA POINTS.')
      CLOSE(KO,STATUS='DELETE')
        ier=1
        return
      ENDIF
C**********************************************************************
C***
C***  WRITE MESSAGES TO SCREEN AND FINISH
C***
      CLOSE(KS,STATUS='DELETE')
999    ier=0
       return
C     STOP
      END
