      SUBROUTINE SS2DGRID(ichupr,ichugr,ier)
C***
C***  PROGRAM ESTIMATES POINT-VALUES ALONG A GRID USING KRIGING
C***
C***  REFERENCES:
C***  Skrivan, J.A., and Karlinger, M.R., 1980, Semi-variogram estima-
C***      tion and universal kriging program, computer contribution,
C***      U.S. Geological Survey, Water Resources Division, Tacoma,
C***      Washington, 98 p.
C***
C***  Knudsen, H.P., and Kim, Y.C., 1977, A short course on geostatist-
C***      ical ore reserve estimation: College of mines, University of
C***      Arizona, Tucson, Arizona, 202 pages and appendices.
C***
C***  Journel, A.G., and Huijbregts, Ch. J., 1978, Mining geo-
C***      statistics: Academic Press, New York, 600 p.
C***
C***  THIS IS A TWO-DIMENSIONAL POINT-KRIGING PROGRAM USED TO KRIG A
C***  GRID OF POINTS.  IT WAS SYNTHESIZED BY W.D. GRUNDY FROM PROGRAM
C***  UKRIG OF KNUDSEN AND KIM AND THE KRIGING PACKAGE OF SKRIVAN AND
C***  KARLINGER.  ALGORITHMS PUBLISHED BY JOURNEL AND HUIJBREGTS WERE
C***  ALSO USED.
C***  THIS PROGRAM HAS A CHOICE OF UNIVERSAL OR ORDINARY KRIGING AND
C***  ALLOWS THE USER TO SPECIFY THE NEIGHBORHOOD SIZE.  FIVE
C***  VARIOGRAM MODELS, THE SPHERICAL, EXPONENTIAL, LINEAR,
C***  GAUSSIAN, AND CUBIC ARE INCLUDED.  AS MANY AS FIVE NESTED
C***  VARIOGRAMS MAY BE USED.  ANISOTROPIES, IF PRESENT,
C***  MAY BE EITHER GEOMETRIC OR ZONAL TYPE.
C***
C**********************************************************************
C***
C***                       INPUT AND OUTPUT FILES
C***
C***  PROGRAM REQUIRES AN INPUT STATPAC DATA FILE.  THE INPUT FILE
C***  MUST CONTAIN CARTESIAN X- AND Y-COORDINATES (EASTINGS AND NORTH-
C***  INGS) AND AN OBSERVED VALUE OF A REGIONALIZED VARIABLE.  THE
C***  STATPAC INPUT FILE MUST BE PREPROCESSED BY PROGRAM SS2DPREP.
C***
C***  PROGRAM CREATES A STATPAC OUTPUT FILE CONTAINING THE FOLLOWING
C***  VARIABLES FOR EACH GRID POINT: 1)X-COORDINATE, 2)Y-COORDINATE,
C***  3)KRIGED VALUE, AND 4)KRIGING VARIANCE.
C***
C***  PROGRAM ALSO CREATES A CHARACTER OUTPUT FILE CONTAINING THE
C***  SAME INFORMATION AS THE STATPAC OUTPUT FILE, BUT ALSO CONTAINING
C***  A HEADER SHOWING THE PARAMETERS USED IN THE GRIDDING.
C***
C**********************************************************************
C***
C***  LINKS REQUIRED: CHEKER,CKSAFE,KCLEAR,CONCAT,COVAR4,GETDATE,DELAY,
C***  DOLITL,DRFTRM,DSORT,GETFLE,KHEADER,INGRD,IOS,KRIG4P,MAXCOR,MDYHMS,
C***  MNVAR,NEIGH,OUTGEO,PRECHK,PSET4,SRCHPB,SOUND,TICKER,TERM,VALDOP,
C***  VARIN4
C***
C***  FILE NAME REQUIREMENTS
C***       THE STATPAC INPUT FILE MUST HAVE THE EXTENSION .UPR
C***       THE CHARACTER OUTPUT FILE IS AUTOMATICALLY GIVEN THE
C***       EXTENSION .FGR
C***       THE STATPAC OUTPUT FILE IS AUTOMATICALLY GIVEN THE
C***       EXTENSION .UGR
C***
C**********************************************************************
C***
C***  MAJOR VARIABLES AND DIMENSION REQUIREMENTS
C***
C***    NEST         NUMBER OF VARIOGRAMS IN MODEL (MAX=5)
C***    C0           NUGGET EFFECT
C***    C(NEST)      C-VALUES OF VARIOGRAMS
C***    AVALU(NEST)  A-VALUES OF VARIOGRAMS
C***                 IF VARIOGRAM IS OF FORM GAM(H)=C0+SLOPE*H**A
C***                 AVALU REPRESENTS THE POWER A.
C***                 FOR CUBIC AND SPHERICAL VARIOGRAMS, AVALU
C***                 REPRESENTS THE VARIOGRAM RANGE.
C***                 FOR EXPLANATION OF THIS PARAMETER FOR GAUSSIAN
C***                 AND EXPONENTIAL VARIOGRAMS, SEE JOURNEL AND
C***                 HUIJBREGTS, 1978, PAGE 164.
C***    ANGLE(NEST)  ANGLES OF ROTATION OF ANISOTROPIC VARIOGRAMS ABOUT
C***                 EAST-WEST AXIS.  EAST IS TAKEN AS ZERO DEGREES.
C***                 ANGLES ARE ENTERED IN DECIMAL DEGREES.
C***                 NEGATIVE ANGLE INDICATES CLOCKWISE ROTATION.
C***                 POSITIVE ANGLE INDICATES COUNTER-CLOCKWISE ROTATION
C***                 IF ANISOTROPY IS GEOMETRIC, ANGLE IS THE BEARING
C***                 OF THE MAJOR AXIS OF THE ELLIPSE.
C***                 IF ANISOTROPY IS ZONAL, ANGLE IS THE BEARING
C***                 OF THE DIRECTION OF VARIATION.
C***    AFH(NEST)    ANISOTROPY RATIOS OF VARIOGRAMS
C***                 AFH=0     INDICATES ZONAL ANISOTROPY
C***                 AFH>1     INDICATES GEOMETRIC ANISOTROPY
C***                 AFH=1     INDICATES ISOTROPIC VARIOGRAM
C***    SILL         C0 PLUS SUM OF C'S
C***    ITYPE(NEST) VARIOGRAM TYPE
C***                =1 INDICATES SPHERICAL VARIOGRAM
C***                =2 INDICATES EXPONENTIAL VARIOGRAM
C***                =3 INDICATES LINEAR VARIOGRAM
C***                =4 INDICATES GAUSSIAN VARIOGRAM
C***                =5 INDICATES CUBIC VARIOGRAM
C***    AISI(NEST)     ANISOTROPY CORRECTION FACTOR
C***    BISI(NEST)     ANISOTROPY CORRECTION FACTOR
C***    CISI(NEST)     ANISOTROPY CORRECTION FACTOR
C***    SLOPE(NEST) SLOPES OF LINEAR VARIOGRAMS
C***                ZERO SLOPE INDICATES VARIO-
C***                GRAM IS NOT A LINEAR TYPE.
C***
C***  /DRIFT/
C***    NT           NUMBER OF DRIFT TERMS (MAX=10)
C***    EX(NT)       X-EXPONENTS OF DRIFT TERMS
C***    EY(NT)       Y-EXPONENTS OF DRIFT TERMS
C***    COEF(NT)     COEFFICIENTS OF DRIFT TERMS (THIS ARRAY IS NOT USED
C***
C***    MAXH         MAXIMUM NUMBER OF DRILL HOLES WHICH ARE ALLOWED TO BE
C***                 READ IN FROM THE STATPAC FILE.  IN THIS PROGRAM MAXH IS
C***                 SET TO 500.
C***    IHOLID(MAXH) ALPHAMERIC DRILL HOLE IDENTIFIERS
C***    XE(MAXH)     ARRAY OF X-COORDINATES (EASTINGS) OF DRILL HOLES
C***    YN(MAXH)     ARRAY OF Y-COORDINATES (NORTHINGS) OF DRILL HOLES
C***    GD(MAXH)     ARRAY OF SAMPLE MEASUREMENTS OF DRILL HOLES
C***    ERMEAS(MAXH) ARRAY OF MEASUREMENT VARIANCES OF GD
C***
C***  /COV4/
C***    MAXK         MAXIMUM NUMBER OF HOLES IN NEIGHBORHOOD WHICH CAN
C***                 BE USED IN KRIGING A POINT.  IN THIS PROGRAM MAXK
C***                 IS SET TO 50.
C***    P(KDIM)      COVARIANCE AND DRIFT TERM MATRIX
C***                 KDIM=(MAXK+NT)*(MAXK+NT+1)/2
C***    ID(MAXK+NT)  AN ARRAY OF POINTERS FOR MANIPULATING MATRIX P
C***    W(MAXK+NT)   ARRAY OF KRIGING WEIGHTS AND LAGRANGIAN MULTIPLIERS
C***    IHOL(MAXK+1) ARRAY OF POINTERS TO HOLES TO BE USED IN KRIGING
C***                 A PARTICULAR LOCATION
C***    R(MAXK+NT)   COLUMN VECTOR OF KRIGING SYSTEM
C***
C***    IPT          STATPAC INPUT FILE
C***    IOUT         STATPAC OUTPUT FILE
C***    IPR          CHARACTER OUTPUT FILE
C***    NHOL         ACTUAL NUMBER OF DRILL HOLES OBTAINED FROM STATPAC
C***    IVIB(2,99)   ARRAY OF IDENTIFIERS OF STATPAC FILE VARIABLES
C***
C***    DIST(MAXK+1) ARRAY OF DISTANCES OF DRILL HOLES FROM POINT BEING
C***                 KRIGED.
C***    B(2)         TEMPORARY STORAGE FOR COORDINATES OF POINT BEING
C***                 KRIGED
C***    NK           USER-SPECIFIED ACTUAL MAXIMUM NUMBER OF HOLES TO BE
C***                 USED IN KRIGING A POINT
C***    RMAX         SEARCH RADIUS (NEIGHBORHOOD) ABOUT POINT BEING KRIGED
C***
C***    NER          NUMBER OF NORTH-SOUTH GRID POINTS
C***    WIDY         DISTANCE BETWEEN POINTS IN NORTH-SOUTH DIRECTION
C***    NEC          NUMBER OF EAST-WEST GRID POINTS
C***    WIDX         DISTANCE BETWEEN POINTS IN EAST-WEST DIRECTION
C***    YMN          NORTHING OF SOUTHWEST CORNER OF GRID OF POINTS
C***    XMN          EASTING OF SOUTHWEST CORNER OF GRID OF POINTS
C***
C**********************************************************************
C***
C***  PROGRAM REVISED BY GEORGE W HEINE, BUREAU OF LAND MANAGEMENT,
C***  DENVER, 1985, TO FUNCTION AS A SUBPROGRAM SWAPPED IN FROM THE
C***  MOSS SYSTEM.  PRINCIPAL CHANGES INCLUDE:
C***
C***    GRID SIZE PARAMETERS ARE READ FROM A DISK FILE NAMED
C***       'TEMP.KRIG.PRM', RATHER THAN ENTERED FROM KEYBOARD
C***    THE INPUT STATPAC FILE IS ALWAYS A FILE NAMED 'TEMPKRIG.UPR'
C***    ORDER OF PROCESSING GRID CELLS IS ROW-BY-ROW, FROM HIGHEST
C***       NUMBERED ROW TO LOWEST.  ALSO THE KRIGED VALUE IS COMPUTED
C***       FOR CENTER POINT OF CELL RATHER THAN FOR ITS SW CORNER.
C***       THIS CHANGE IS REFLECTED IN THE COMPUTATION OF B(1) AND
C***       B(2) AFTER STATEMENT 30.
C***    CELLS WHICH CANNOT BE KRIGED ARE ASSIGNED A DEFAULT KRIGED
C***       VALUE AND KRIGING VARIANCE.
C***    MAXH HAS BEEN INCREASED TO 15000. AND MAXK REDUCED TO 50.
C***       ARRAYS XE,YN,GD,ID,W,IHOL, AND R HAVE BEED SCALED
C***       ACCORDINGLY.  ARRAYS IHOLID AND ERMEAS WERE ELIMINATED.
C***
C
C
$INCLUDE: 'MYST.INC'
      CHARACTER*8 IHOLID
C      CHARACTER*4 IVIB
      INTEGER*4 IVIB
      INTEGER*2 EX,EY
      COMMON /COV4/ P(1830),ID(60),W(60),IHOL(51),R(60)
      INTEGER*4 ITIME1,ITIME2
      CHARACTER*32 UNIT10,UNIT14,UNIT21
      CHARACTER*4 IDST,IDSV(2,4),EXT1,EXT2
      CHARACTER IANS
      DIMENSION B(2),IDST(2),DUMMY(4)
      DATA IDSV/'X-CO','ORD.','Y-CO','ORD.','KRIG',' VAL','KRIG',
     1 ' VAR'/
      DATA EXT1/'.FGR'/, EXT2/'.UGR'/
      DATA IOK,IBAD/0,-1/
C**********************************************************************
      IPT=ichupr
      IPR=21
      IOUT=19
      ichugr=iout
      ISCRCH=15
      IPARAM=33
      MAXH=500
      MAXK=50
      NEGERR=0
      ISOLVE=0
      IANS = 'N'
C      CALL GETDATE(IDST)
C**********************************************************************
C****
C***  GET NAMES OF INPUT/OUTPUT FILES FROM KEYBOARD
C***
      CALL VALDOP(IPARAM,ISCRCH,UNIT10,UNIT14,UNIT21,EXT1,EXT2)
C**********************************************************************
C***
C***  CHECK IF UNIVERSAL KRIGING IS WANTED AND GET POSSIBLE DRIFT TERMS
C***  FROM THE KEY BOARD
C***
    5 CALL DRFTRM(0)
C***
C**********************************************************************
C***
C***  GET NEIGHBORHOOD LIMITS (SEARCH RADIUS AND MAXIMUM NUMBER OF
C***  SAMPLE POINTS TO BE USED) FROM THE KEYBOARD
C***
      CALL NEIGH(IPARAM,RMAX,NK,NT,MAXK)
C**********************************************************************
C***
C***  GET VARIOGRAM PARAMETERS
C***
      CALL VARIN4
C***
C**********************************************************************
C***
C***  GET DESCRIPTORS OF GRID TO BE KRIGED FROM THE PARAMETER FILE
      IF(IANS.EQ.'N') CALL INGRD(IPARAM,NER,WIDY,NEC,WIDX,YMN,XMN)
C***
C**********************************************************************
C***
C***  GET DESCRIPTION OF STATPAC INPUT FILE FROM THE KEYBOARD AND
C***  READ THE FILE FROM DISK
      CALL GETFLE(IGD,ier)
      if(ier.ne.0)return
       
C***
C**********************************************************************
C***
C***  CHECK FOR PREPROCESSED STATPAC INPUT DATA FILE AND STOP EXECUTION
C***  IF INPUT FILE WAS NOT SORTED IN ASCENDING ORDER OF Y-COORDINATES.
C***
      CALL PRECHK(YN,XE,NHOL)
C**********************************************************************
C***
C***  WRITE OUT HEADER FOR VARIOGRAM(S) AND ANY DRIFT TERMS.
C***
      CALL KHEADER(6,RMAX,NK)
      CALL KHEADER(IPR,RMAX,NK)
C**********************************************************************
C***
C***  WRITE OUT USER'S SPECIFICATIONS OF THE GRID AND HEADER FOR THE
C***  KRIGING ESTIMATES.
C***  
      yrng=ner*widy
      xrng=nec*widx
      WRITE(*,10) NER,WIDY,NEC,WIDX,YMN,XMN,yrng,xrng,RMAX,NK
      WRITE(IPR,10) NER,WIDY,NEC,WIDX,YMN,XMN,yrng,xrng,RMAX,NK
   10 FORMAT(//,1X,'NUMBER OF CELLS IN N/S DIRECTION     = ',I9,/,
     11X,'CELL SIZE (IN METERS) IN N/S DIRECTION = ',F12.2,/,
     21X,'NUMBER OF CELLS IN  E/W  DIRECTION     = ',I9,/,
     31X,'CELL SIZE (IN METERS) IN E/W DIRECTION = ',F12.2,/,
     41X,'NORTHING OF SOUTHWEST CORNER OF GRID   = ',F12.2,/,
     51X,'EASTING  OF SOUTHWEST CORNER OF GRID   = ',F12.2,/,
     61x,'NORTHING RANGE                         = ',f12.2,/,
     71x,'EASTING RANGE                          = ',f12.2,/, 
     81X,'SEARCH RADIUS                          = ',f12.2,/,
     91X,'MAXIMUM NUMBER OF HOLES USED           = ',i9)
      WRITE (*,15)
   15 FORMAT (/,' DO YOU WISH TO RE-ENTER KRIGING PARAMETERS? [N]  ')
      READ (*,17) IANS
   17 FORMAT (A1)
      IF ((IANS.EQ.'Y').OR.(IANS.EQ.'y')) GO TO 5
      WRITE(IPR,20)
   20 FORMAT(//,16X,'***OUTPUT OF KRIGED RESULTS***',//,
     13X,'COLUMN  ROW     X-COORD.    Y-COORD.     ',
     2'VALUE      KRG VAR.',/)
C**********************************************************************
C***
C***  START THE KRIGING PROCESS
C***
      WRITE(*,30)
   30 FORMAT(/,'          NOW KRIGING GRID POINTS')
      R2=RMAX*RMAX
      KOUNT=0
      YM=YMN-WIDY
      XM=XMN-WIDX
      DO 100 K=NER,1,-1
      B(2)=YM+FLOAT(K)*WIDY
      DO 100 J=1,NEC
      B(1)=XM+FLOAT(J)*WIDX
C***  FIND NEAREST NS HOLES FROM POINT J,K
      ISTART=KSTART+1
      CALL SRCHPB(B(1),B(2),NS,NK,R2,RMAX,ISTART,KSTART)
C***  BE SURE THERE IS AT LEAST ONE DEGREE OF FREEDOM
C***  IF THIS POINT CANNOT BE KRIGED, ASSIGN A DEFAULT VALUE
C***  OF ZERO TO BOTH THE KRIGING VALUE AND THE KRIGING VARIANCE
      IF(NS.GT.NT) GO TO 35
        GR = 0
        VARKG = 0
        GO TO 75
   35 CONTINUE
C***  KRIG THE POINT IF THERE ARE ENOUGH DRILL HOLES
C***  WITHIN THE SEARCH RADIUS.
C***  GET KRIGING WEIGHTS WHICH WILL BE STORED IN ARRAY W
      CALL KRIG4P(B,NS,IFERR)
      IF(IFERR.EQ.0) GO TO 70
      ISOLVE=ISOLVE+1
      WRITE(IPR,40) J,K
   40 FORMAT(' ERROR IN MATRIX SOLUTION POINT ',2I5)
      DO 60 M=1,NS
      LL=IHOL(M)
C     WRITE(IPR,50) IHOLID(LL),YN(LL),XE(LL)
C  50 FORMAT(1X,A8,1X,F10.2,1X,F10.2)
   60 CONTINUE
      GO TO 100
C***  COMPUTE THE KRIGED VALUE AND THE KRIGING VARIANCE
C***  KRIGED VALUE WILL BE STORED IN GR
   70 CALL MNVAR(NS,SILL,GR,VARKG)
      IF(VARKG.LT.0) NEGERR=NEGERR+1
   75 WRITE(IPR,80) J,K,B(1),B(2),GR,VARKG
   80 FORMAT(4X,2I5,3X,2F12.3,F8.2,F15.4)
      WRITE(ISCRCH)B(1),B(2),GR,VARKG
      KOUNT=KOUNT+1
      WRITE(*,90) KOUNT
   90 FORMAT('+',I4)
  100 CONTINUE
C**********************************************************************
C***
C***  KRIGING ESTIMATES HAVE BEEN COMPLETED.  IF POINTS HAVE BEEN
C***  ESTIMATED WRITE STATPAC OUTPUT FILE AND FINISH.
C***
      IF(KOUNT.EQ.0) THEN
        WRITE(*,*) ' NO POINTS COULD BE KRIGED'
        ier=1
        return
        ENDIF
C
C***  WRITE STATPAC OUTPUT FILE
      CALL OUTGEO(ISCRCH,IDST,IDSV,IGD,KOUNT,4,DUMMY,UNIT10,UNIT14,
     1            UNIT21)
C***  INFORM USER OF ANY PROBLEMS ENCOUNTERED IN KRIGING THE GRID.
      IF(ISOLVE.NE.0) WRITE(*,110) ISOLVE
  110 FORMAT(' ',I3,' POINTS COULD NOT BE GRIDDED BECAUSE OF ERRORS',
     1' IN THE MATRIX SOLUTION',/,' EXAMINE THE CHARACTER OUTPUT FILE',
     2' AND LOOK FOR DUPLICATED SAMPLE LOCATIONS.')
      IF(NEGERR.NE.0) WRITE(*,120) NEGERR
  120 FORMAT(' ',I3,' GRID POINTS HAVE NEGATIVE KRIGING VARIANCES.  ',
     1'THIS CAN',/,' RESULT FROM HAVING MORE THAN 6 SIGNIFICANT DIG',
     2'ITS IN THE NORTH OR',/,' EAST COORDINATES WHEN USING UNIVERSAL',
     3' KRIGING.')
      return
      END
