C******************************************************************************
C
C              P R O G R A M       P R O X I M I T Y
C FUNCTION:
C             THIS ROUTINE IS THE LOGICAL DRIVER FOR PROXIMITY ANALYSIS
C PARAMETERS:
C            ALL INPUT PARAMETERS ARE USED AS WORK SPACE
C******************************************************************************
C
C
C  PROGRAM IDENTIFIERS (CONSTANTS, VARIABLES, COMONS, FUNCTIONS)
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
      COMMON /FLS/    IUNIT,IFILE(5)
      COMMON /IO/     NPRNT,IOIN
      COMMON /WHMAP/  ISTRCT(300),NSTRCT
      COMMON /WORK/   IBUFF(128),MAP(25),ICOM(10),JCOM(10)
      COMMON /TYPE/   IDATYP(40),NACTS
      COMMON /TABLE/  ITABLE(40)
$Include:'pqpnts.inc'
      COMMON /OFFST/  SXMIN,SYMIN
      COMMON /ISLL/   IDS(353),JDS(353),IH,JH
      COMMON /ITEMMS/ ORIFSN,OBJFSN
$Include:'mfast.inc'
$Include:'dbchan.inc'
$Include:'dnames.inc'
      COMMON /OSAVE/  ISUB(15),NPOLYS,OBJTYP,IDISP,NOSAVE,ICHTSUB
C
      REAL MBRORI(4),MBROBJ(4), MBRHOLD(4)
      integer orimbr(8),objmbr(8),holdmbr(8),mapname(25)
C
C     SET WINDOW VALUES
      REAL WDXMIN,WDXMAX,WDYMIN,WDYMAX
C
C  INTEGER VARIABLE, USED TO HOLD "NOT USED PARAMETERS"
      INTEGER IHOLD,kcom(10),name1(25),name2(25),mapout(25)
C
C  ACTIVE MAP INDICIES INTO STRUCTURE TABLE (ISTRCT)
      INTEGER ORIPTR, OBJPTR
C
C  MAP TYPES FOR ORIGIN, OBJECT AND INDIVIDUAL FEATURES
      INTEGER ORITYP, OBJTYP
C
C  NUMBER OF FEATURES IN ORIGIN AND OBJECT MAPS
      INTEGER NFEORI, NFEOBJ
C
C  NUMBER OF VERTICIES (COORDINATE PAIRS) IN FEATURE
      INTEGER NVTORI, NVTOBJ
C
C  INDICES INTO ORIGIN AND OBJECT MAPS (FROM 'POINT.DT')
      INTEGER ORINDX, OBJNDX
C
C  FEATURE DATA POINTERS IN STRUCTURE TABLE (ISTRCT).
      INTEGER ORIBEG, ORIEND
      INTEGER OBJBEG, OBJEND
C
C  ORIGIN AND OBJECT MAP FEATURE SEQUENCE NUMBER.
      INTEGER ORIFSN,OBJFSN
C
C  ORIGIN AND OBJECT MAP SUBJECT RECORD NUMBERS.
      INTEGER SUBREC1, SUBREC2
C
C  ORIGIN AND OBJECT ATTRIBUTE RECORD POINTERS
      INTEGER ATRPTR1,ATRPTR2
C
C  NPOLYS IS A COUNT OF NUMBER OF FEATURES THAT MEET THE CRITERIA.
      INTEGER NPOLYS
      INTEGER IHEAD(256), JBUFF(128)
C
C  FLAGS FOR CHOSING IN OR OUT OF PROXIMITY
      LOGICAL OUTPROX, INPROX
C
      INTEGER LABEL(10)
C
C  MAP DESCRIPTION
      INTEGER DESCMAP(30)
C
C CALLED FUNCTIONS:
      LOGICAL DETPROX
C
C MAP TYPE PARAMETERS
      INTEGER POINT, LINE, POLYGON, COMPARTYP
      DIMENSION XCIRC(80),YCIRC(80)
C
C      DATA  SXMIN/0.0/SYMIN/0.0/
C
      REAL    RARRAY(4)
      EQUIVALENCE(RARRAY(1),IHEAD(68)),(mbrori(1),orimbr(1))
      equivalence (mbrobj(1),objmbr(1))
C
C MINIMUM BOUNDING RECTANGLE INDICES:
      PARAMETER (MXMIN = 1)
      PARAMETER (MXMAX = 2)
      PARAMETER (MYMIN = 3)
      PARAMETER (MYMAX = 4)
C
C MAP TYPES:
      PARAMETER (POINT   = 1)
      PARAMETER (LINE    = 2)
      PARAMETER (POLYGON = 3)
      PARAMETER (MYSTERY = 4)
C
C PROXIMITY TYPES:
      PARAMETER (POINT2POINT = 1)
      PARAMETER (POINT2LINE  = 2)
      PARAMETER (POINT2POLY  = 3)
      PARAMETER (LINE2POINT  = 4)
      PARAMETER (LINE2LINE   = 5)
      PARAMETER (LINE2POLY   = 6)
      PARAMETER (POLY2POINT  = 7)
      PARAMETER (POLY2LINE   = 8)
      PARAMETER (POLY2POLY   = 9)
C

C
C  READ IN COMMON BLOCKS
C
      CALL initl(ier)
      if(ier.ne.0)stop
C
      map(1)=2hLM
      map(2)=2h
      jchan=81
      call openf(jchan,map,1,0,1,ier)
      if(ier.ne.0)then
       write(nprnt,2)
  2    format(/,1x,'You must do the <PLOT> command first')
       stop
      endif
C
      map(1)=2Hz 
      call openf(70,map,3,0,1,ier)
C
C  OUTPUT MAP
       ICHOUT=20
C
C  ORIGIN INPUT MAP
       ICHORI=10
C
C  OBJECT INPUT MAP
       ICHOBJ=11
C
C  TEMP FILE, USED IN SAVWRK
       ICHTEMP = 51
C
C  TEMPSUB FILE, USED IN SAVWRK
       ICHTSUB = 52
C
C  POLYGON.DT WORK FILE
       ICHPL=icwork
C
C   OPEN CHANNEL FOR POINTER FILE
C
      incore=0
      iwrtn=0
      CALL OPENF(icdcfa,idesfa,1,512,2,IER)
      IF(IER.NE.0) GO TO 900
C
C  OPEN TEMP FILE
C
       map(1)=2hT
       CALL OPENF(ICHTEMP,map,3,0,1,IER)
       map(1)=2hY
       CALL OPENF(ICHTSUB,map,3,256,2,IER)
C
C  SET GRAPHICS WINDOW
       CALL SETWND
C
C  CHECK FOR ZERO WINDOW
       CALL WHWND(WDXMIN,WDYMIN,WDXMAX,WDYMAX)
C
       IF  ( (WDXMAX-WDXMIN .EQ. 0.0 ) .OR.
     +      (WDYMAX-WDYMIN .EQ. 0.0 ) ) GO TO 804
C
C  INITIATE COUNTERS
      IH = 1
      IHH = 0
      JH = 0
      JHH = 0
      CALL CLEAR (IDS,353)
      CALL CLEAR (JDS,353)
      NPOLYS=0
C
C  CALL USER INPUT ROUTINE
C
      CALL PXPARM(ITABLE,LINES,NUMMAPS,LABEL,DISMAX,OUTPROX,
     +            DESCMAP,IER)
      IF(IER.NE.0) GO TO 9000
C
C  CREATE AND OPEN OUTPUT MAP FILE.
      CALL PACKC(LABEL,kcom,10)
      write(ICHTEMP)KCOM
C
C
C  IF TYPE EQ 1,, GET SEARCH POINT FROM USER AND DRAW
C  THE SEARCH CIRCLE
C
      ORIPTR=ITABLE(1)
      CALL GTMAP(icom,ORIPTR)
      call adddir(icom,mapname)
      CALL OPENF(ICHORI,mapname,1,256,2,IER)
      IF(IER.NE.0) GO TO 907
c     write(ICHTEMP)ICOM
c This statement revised on 6/6/89 - wrong length of ICOM will bomb SAVWRK 
      write(ichtemp)mapname
C
C  GET  TYPE FOR ORIGIN MAP
      ORITYP=IDATYP(ORIPTR/7+1)
      IF ( .NOT.  ( ( ORITYP .EQ. POINT) .OR.
     +              ( ORITYP .EQ. LINE ) .OR.
     +              ( ORITYP .EQ. POLYGON) ) ) GO TO 801
C
C**************************************************
C IF TWO MAP, JUMP TO PROPER SECTION OF CODE      *
C**************************************************
      IF(NUMMAPS.EQ.2) GO TO 100
C
C  THERE IS NO SECOND MAP, BUT SAVWRK EXPECTS A RECORD HERE
C     SO I'M WRITING IT....
C
c     write(ICHTEMP)JCOM
c This statement revised 6/6/89 - wrong length of JCOM will bomb SAVWRK routine
      write(ichtemp)mapname
C
C  READ MAP HEADER, STORE NEW DESCRIPTION, AND WRITE TO TEMP FILE
C
      CALL RDBLK(ICHORI,1,IHEAD,1,IER)
      IF (IER .NE. 0) GO TO 911
      ICONV=IHEAD(77)
C
C  SAVE MBR'S FROM OBJECT MAP TO LOAD IN HEADER OF NEW MAP LATER
C     (RARRAY IS EQUIVALENCED TO MBR INFO IN IHEAD)
      MBRHOLD(MXMIN) = RARRAY(1)
      MBRHOLD(MXMAX) = RARRAY(2)
      MBRHOLD(MYMIN) = RARRAY(3)
      MBRHOLD(MYMAX) = RARRAY(4)
C
      write(ICHTEMP)IHEAD
C
C  WRITE OUT ORIGIN MAP TYPE TO TEMP FILE
      write(ICHTEMP)ORITYP
C
C
      WRITE(NPRNT,1002)
 1002 FORMAT(25H POINT TO SEARCH LOCATION  )
      LINES=LINES+1
C
      rewind (jchan)
      call drfast(jchan,ier)
      CALL VCURSR(IHOLD,XT,YT)
C
      ATOL=AMAX1( WDXMAX-WDXMIN, WDYMAX-WDYMIN)
      ATOL=ATOL/75.
      CALL BXCALC(XB,YB,5,ATOL)
      CALL SYMDRW(XB,YB,5,XT,YT)
C
      CALL CIRCOMP(XCIRC,YCIRC,80,DISMAX)
      CALL SYMDRW(XCIRC,YCIRC,80,XT,YT)
       CALL anmode
       write(*,*)char(27),char(12)
C
C  DETERMINE WINDOW FOR POINT
C
      XMINORI=(XT-DISMAX)
      XMAXORI=(XT+DISMAX)
      YMINORI=(YT-DISMAX)
      YMAXORI=(YT+DISMAX)
C
C INITIALIZE VARIABLES USED IN DETPROX FOR THE OBJECT MAP
C    (OR IN THIS CASE FOR THE INDICATED POINT)
      NVTOBJ = 1
      OBJTYP = 1
C
C FIRST GET POINTER SET
      CALL APGET(ORIPTR,ORIBEG, ORIEND,IHOLD)
C
C PLACR POINT INFORMATION IN P,Q ARRAYS
      call spoints('P ',p,xt,1,2)
      call spoints('Q ',q,yt,1,2)
c      P(1) = XT
c      Q(1) = YT
C
C
C  ENTER MAIN LOOP
C
      DO 70 IORI=ORIBEG,ORIEND
C
          CALL GETFAST(IORI,orimbr,ORINDX,SUBREC1,ATRPTR1,IHOLD,IER)
          IF(IER.NE.0) GO TO 70
C
C  DO MBR'S OVERLAP
C
          INPROX = .FALSE.
          IF ( ( .NOT.OUTPROX ) .AND.
     +         (INVWND(MBRORI(1),MBRORI(2),MBRORI(3),MBRORI(4),
     +            XMINORI,XMAXORI,YMINORI,YMAXORI) .EQ. 0 ) ) GO TO 50
C
C
          CALL RDBLK(ICHORI,ORINDX,IBUFF,1,IER)
          OBJFSN = IBUFF(5)
C
          IF (ORITYP .NE. POLYGON) GO TO 20
              IHH = 0
              CALL CLEAR(IDS,353)
              CALL igetis(IBUFF,IDS,IHH,ICHORI,ORINDX)
 20       CONTINUE
C
          CALL CORDXY(IBUFF,NVTORI,ORINDX,MBRORI(1),MBRORI(3),ICHORI)
C
C   INCREMENT NUMBER OF OBJECTS COUNTER
          IF (ORITYP .NE. POLYGON) GO TO 30
             IH = 1
             IF ( IHH .LE. 0 ) GO TO 30
                CALL SETPTR (IHH,IDS,IH)
                IH = IH + 1
                IDS(IH) = NVTORI
                IDS(1) = 0
30        CONTINUE
C
C SET UP COMPARE INDICATOR FOR DETPROX
          IF ( ORITYP .EQ. POINT ) COMPARTYP = POINT2POINT
          IF ( ORITYP .EQ. LINE ) COMPARTYP = LINE2POINT
          IF ( ORITYP .EQ. POLYGON) COMPARTYP = POLY2POINT
C
C  DETERMINE IF ENTITIES ARE WITHING DESIRED PROXIMITY
          INPROX = DETPROX ( COMPARTYP, DISMAX,
     +                       NVTORI, NVTOBJ, ORITYP, OBJTYP,
     +                       IH, IDS, JH, JDS)
C
C  DECIDE IF ENTITY IS TO BE WRITTEN OUT TO NEW FILE
C
 50      IF ( INPROX .AND. OUTPROX ) GO TO 70
         IF ( (.NOT.INPROX) .AND.  (.NOT.OUTPROX) ) GO TO 70
C
C  SAVE.
C
  55      CALL GETSUB(ICHORI,SUBREC1,JBUFF,ISUB,IHOLD)
C
C  INCREMENT COUNTER FOR SAVED ENTITIES
          NPOLYS = NPOLYS + 1

C
C  WRITE ENTITY OUT TO TEMPSUB FILE
C
          IF ( IHH .EQ. 0 ) GO TO  60
             DO 40 LOOP = 1,IH-1
                IDS(LOOP) = IDS(LOOP) + 1
  40         CONTINUE
  60      CONTINUE
C
          CALL WRTENTY(NVTORI,IDS,IH-1,ISUB,1,ICHTSUB,ICHTEMP,npolys)
C
  70  CONTINUE
C
C  DONE
C
      GO TO 200
C
C
 100  CONTINUE
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C LOGIC FOR PROCESSING TWO MAPS
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
C   OPEN CHANNEL FOR MAP 2
C
      OBJPTR=ITABLE(2)
      CALL GTMAP(JCOM,OBJPTR)
c      write(ICHTEMP)JCOM
C
C   READ OBJECT MAP HEADER AND WRITE TO TEMP FILE
      call adddir(jcom,mapname)
      CALL OPENF(ICHOBJ,mapname,1,256,2,IER)
      IF(IER.NE.0) GO TO 908
c  This statement revised on 6/7/89 - wrong length of JCOM will bomb SAVWRK
      write(ichtemp)mapname
C
C
C     READ HEADER FROM MAP 2
C     ESTIMATE NUMBER OF CATEGORIES AND SUBJECTS
C
      CALL RDBLK (ICHOBJ,1,IHEAD,1,IER)
      IF (IER.NE.0) GO TO 911
C
C  SAVE MBR'S FROM OBJECT MAP TO LOAD IN HEADER OF NEW MAP LATER
C     (RARRAY IS EQUIVALENCED TO MBR INFO IN IHEAD)
      MBRHOLD(MXMIN) = RARRAY(1)
      MBRHOLD(MXMAX) = RARRAY(2)
      MBRHOLD(MYMIN) = RARRAY(3)
      MBRHOLD(MYMAX) = RARRAY(4)
C
C
      write(ICHTEMP)(IHEAD(ll),ll=1,130)
C
C    GET DATA TYPE FOR OUT MAP AND WRITE TO TEMP FILE
      OBJTYP=IDATYP(OBJPTR/7+1)
C
C    CHECK IF VALID MAP TYPE
      IF (.NOT.  (( OBJTYP .EQ. POINT) .OR.
     +            ( OBJTYP .EQ. LINE ) .OR.
     +            ( OBJTYP .EQ. POLYGON) ) ) GO TO 802
      write(ICHTEMP)OBJTYP
C
C    DETERMINE THE ENTITY TYPES TO BE COMPARED FOR  PROXIMITY
         IF ( ORITYP .NE. POINT ) GO TO 2100
            IF ( OBJTYP .EQ. POINT ) COMPARTYP = POINT2POINT
            IF ( OBJTYP .EQ. LINE )  COMPARTYP = POINT2LINE
            IF ( OBJTYP .EQ. POLYGON ) COMPARTYP = POINT2POLY
            GO TO 2400
C
 2100    IF ( ORITYP .NE. LINE ) GO TO 2200
            IF ( OBJTYP .EQ. POINT ) COMPARTYP = LINE2POINT
            IF ( OBJTYP .EQ. LINE  ) COMPARTYP = LINE2LINE
            IF ( OBJTYP .EQ. POLYGON ) COMPARTYP = LINE2POLY
            GO TO 2400
C
C
 2200    IF ( ORITYP .NE. POLYGON ) GO TO 2300
            IF ( OBJTYP .EQ. POINT ) COMPARTYP = POLY2POINT
            IF ( OBJTYP .EQ. LINE  ) COMPARTYP = POLY2LINE
            IF ( OBJTYP .EQ. POLYGON ) COMPARTYP = POLY2POLY
            GO TO 2400
C
C  INCORRECT MAP TYPE
 2300    GO TO 801
C
C
C  GET BEGINNING AND ENDING POINTER AND NUMBER OF POINTERS.
C  NOTE: THE NUMBER OF POINTERS ARE NOT USED.
C
 2400   CALL APGET(ORIPTR, ORIBEG, ORIEND, NFEORI)
	CALL APGET(OBJPTR, OBJBEG, OBJEND, NFEOBJ)
C
C	INITIALIZE OUTPUT MAP FEATURE COUNTER
C
C	SCAN ALL OF THE FEATURES IN THE OBJECT MAP.
	DO 4000 IOBJ = OBJBEG, OBJEND
C
C               GET POINTER TO ITEM
                CALL GETFAST(IOBJ,objmbr,OBJNDX,SUBREC2,
     +                       ATRPTR2,IHOLD,IER)
		IF (IER .NE. 0) GOTO 4000
C
C		READ IN IBUFF FOR FEATURE.
		CALL RDBLK(ICHOBJ,OBJNDX,IBUFF,1,IER)
                IF (IER.NE.0) GO TO 911
		OBJFSN = IBUFF(5)
C
C          CHECK IF FEATURE TYPE MATCHES MAP TYPE
                IF ( IBUFF(6) .EQ. OBJTYP ) GO TO 3100
                    WRITE ( NPRNT, 3050 ) IBUFF(6), OBJTYP
 3050               FORMAT (' *PROXIM* FEATURE TYPE DOES NOT MATCH',
     +                      ' OBJECT MAP TYPE',I3,' ',I3)
                    GO TO 4000
 3100           CONTINUE
C
C
C		IS FEATURE IN CURRENT WINDOW?
		IF (INVWND(MBROBJ(MXMIN),
     1		  MBROBJ(MXMAX),MBROBJ(MYMIN),MBROBJ(MYMAX),
     2            WDXMIN, WDXMAX, WDYMIN, WDYMAX) .EQ. 0 ) GO TO 4000
C
C		IF FEATURE IS POLYGON, GET ISLAND INFO:
C		# OF ISLANDS (JHH), ISLAND POINTER TABLE (JDS)
		IF (OBJTYP .NE. POLYGON) GO TO 3200
		    JHH = 0
		    CALL CLEAR(JDS, 353)
                    CALL igetis(IBUFF, JDS, JHH, ICHOBJ, OBJNDX)
 3200            CONTINUE
C
C              GET COORDINATES, SCALE 'EM, AND FEED INTO DISK ARRAYS
		CALL CORDPQ(IBUFF, NVTOBJ, OBJNDX, MBROBJ(MXMIN),
     1		            MBROBJ(MYMIN), ICHOBJ)
C
C
C		SET SEARCH RECTANGLE FOR THIS FEATURE.
		XMINOBJ = MBROBJ(MXMIN) - DISMAX
		XMAXOBJ = MBROBJ(MXMAX) + DISMAX
		YMINOBJ = MBROBJ(MYMIN) - DISMAX
		YMAXOBJ = MBROBJ(MYMAX) + DISMAX
C
C		GET OBJECT MAP SUBJECT INFO.
		CALL GETSUB(ICHOBJ, SUBREC2, JBUFF, ISUB, IHOLD)
C
C		SCAN FEATURES OF ORIGIN MAP UNTIL PROXIMITY CRITERIA
C		IS SATISFIED.
		DO 3800 IORI = ORIBEG, ORIEND
C
C                  GET INDEX FOR FEATURE FOR ORIGIN MAP
                   CALL GETFAST(IORI,orimbr,ORINDX,SUBREC1,
     +                          ATRPTR1,IHOLD,IER)
                   IF (IER .NE. 0) GO TO 3800
C
C                  LOAD IBUFF FOR FEATURE.
                   CALL RDBLK(ICHORI,ORINDX,IBUFF,1,IER)
                      IF (IER.NE.0) GO TO 911
                      ORIFSN = IBUFF(5)
C
C                     DOUBLE CHECK MAP TYPE IS LEGIT.
                      IF ( IBUFF(6) .EQ. ORITYP ) GO TO 3300
                         WRITE(NPRNT,3350) IBUFF(6),ORITYP
 3350  FORMAT (' *PROXIM*  FEATURE TYPE DOES NOT'
     + ,' MATCH ORIGIN MAP TYPE', I3,' ',I3)
                         GO TO 3800
 3300                 CONTINUE
C
C                     SET SEARCH RECTANGLE
		      XMINORI = MBRORI(MXMIN)
		      XMAXORI = MBRORI(MXMAX)
		      YMINORI = MBRORI(MYMIN)
	              YMAXORI = MBRORI(MYMAX)
C
C	             DO OBJECT AND ORIGIN SEARCH WINDOWS OVERLAP?
		     INPROX = .FALSE.
		     IF (INVWND(
     1			XMINORI, XMAXORI, YMINORI, YMAXORI,
     2			XMINOBJ, XMAXOBJ, YMINOBJ, YMAXOBJ)
     3			.EQ. 0) GOTO 3700
C
C                     IF ORIGIN FEATURE IS POLYGON, GET ISLAND INFO
		      IF (ORITYP .NE. POLYGON)  GO TO 3400
                         IHH = 0
                         IDS(1) = 0
                         CALL igetis(IBUFF,IDS,IHH,ICHORI,ORINDX)
 3400                  CONTINUE
C
C                     GET COORDINATES, SCALE 'EM AND FEED INTO ARRAYS.
		      CALL CORDXY(IBUFF, NVTORI, ORINDX,
     1		                  MBRORI(MXMIN), MBRORI(MYMIN), ICHORI)
C
C
C  DETERMINE IF ENTITIES ARE WITHING DESIRED PROXIMITY
                   INPROX = DETPROX( COMPARTYP, DISMAX,
     +                               NVTORI, NVTOBJ, ORITYP, OBJTYP,
     +                               IHH,IDS,JHH,JDS)
C
 3700              IF (INPROX .AND. (.NOT. OUTPROX)) GOTO 3900
                   IF (INPROX .AND. OUTPROX) GOTO 4000
C
 3800		CONTINUE
		IF (.NOT. OUTPROX) GOTO 4000
C
C		SAVE FEATURE IN OUTPUT MAP.
 3900		CONTINUE
C
C
C               INCREMENT COUNT OF SAVED ITEMS
                NPOLYS = NPOLYS + 1
C
                CALL WRTENTY(NVTOBJ,JDS,JHH,ISUB,2,ICHTSUB,ICHTEMP,
     +           npolys)
C
 4000	CONTINUE
C
C
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
 200  CONTINUE
C
C  ALL DONE
C
       WRITE(NPRNT,1004) NPOLYS
 1004  FORMAT('  NUMBER OF ITEMS = ',I5)
       LINES = LINES + 3
       IF (NPOLYS.EQ.0) GO TO 803
C
C     UPDATE HEADER WITH TRUE SUBJECT COUNT AND WRITE OUT
      CALL OPENF(ICHOUT,KCOM,0,256,2,IER)
C
      CALL SAVWRK(ichtsub,npolys,ichtemp,ichout)
C
C   OPEN NEW FILE, AND UPDATE HEADER WITH MAP DESCRIPTION AND MBR INFO

      CALL RDBLK(ICHOUT,1,IHEAD(1),1,IER)
C
      IHEAD(77)=ICONV
C
      DO 250 I=1,30
        IHEAD(I+19)=DESCMAP(I)
 250  CONTINUE
C
      RARRAY(1) = MBRHOLD(MXMIN)
      RARRAY(2) = MBRHOLD(MXMAX)
      RARRAY(3) = MBRHOLD(MYMIN)
      RARRAY(4) = MBRHOLD(MYMAX)
C
      CALL WRBLK(ICHOUT,1,IHEAD,1,IER)
      CALL WRBLK(ICHOUT,2,IHEAD(129),1,IER)
C
C     UPDATE DIRECTORY;  IHOLD,IHOLD,IHOLD CAUSED SPORADIC POLYGON.D<T,H>
C                        PROBLEMS.  GWF, MAY 86
C
      CALL TUPDIR(IHOLD,ORIPTR,OBJPTR,LABEL,IHEAD,iwork,icwork,IER)
C
      CLOSE(ICHOUT,iostat=IER)
      close(icwork)
      GO TO 9000
C
C  ERROR RETURNS
C
 801  WRITE (NPRNT,9801) ORITYP
9801  FORMAT (41H *PROXIM*  ORIGIN MAP IS INVALID MAP TYPE,I3)
      GO TO 9000
 802  WRITE (NPRNT,9802) OBJTYP
9802  FORMAT (41H *PROXIM*  OBJECT MAP IS INVALID MAP TYPE,I3)
      GO TO 9000
 803  WRITE(NPRNT,3083)
 3083 FORMAT(46H THERE ARE NO ITEMS WITHIN THE SPECIFIED RANGE)
      LINES=LINES+2
      GO TO 9000
 804  write(nprnt,*)' Display window not set. Set window to active map'
      GO TO 9000
 900  write(*,*)' Could not open <DESCRIBE.FA>'
      GO TO 9000
 901  write(*,*)' Could not open <"PROJECT.DT">.'
      GO TO 9000
 902  write(*,*)
      GO TO 9001
 903  write(*,*)' Could not open Dist arrays'
      GO TO 9000
 907  write(*,*)' Error on processing input map'
      GO TO 9000
 908  go to 907
 911  WRITE(NPRNT,4011)
 4011 FORMAT(27HERROR ON READING MAP HEADER)
      LINES = LINES + 2
      GO TO 9000
 912  WRITE(NPRNT,4012)
 4012 FORMAT(32H ERROR ON READING POLYGON HEADER)
      LINES = LINES + 2
      GO TO 9001
 913  WRITE(NPRNT,4013)
 4013 FORMAT(36H EMPTY SUBJECT TABLE FOR COMPARISONS)
      LINES = LINES + 2
      GO TO 9000
 9000 CONTINUE
C
C      CALL OPEN(IUNIT,IFILE,2,IER)
C      CALL CPLAC(LINES)
C      CALL POSTF
 9001 CONTINUE
      CALL OUTCM
C      CALL BACK
      END
