C*********************************************************************
C
C     NAME:  SUBROUTINE PROVW
C
C     FUNCTION:  DISPLAYS THE PARAMETERS REQUIRED FOR DEFINITION OF 
C                A MAP PROJECTION.
C
C     PARAMETERS:  NAME     USE     TYPE     DIMENSION     RANGE
C                  ------------------------------------------------
C                  IOUT     I       I*2                    +INTEGER
C                           CHANNEL TO OUTPUT TO THE SCREEN
C                  ------------------------------------------------
C                  IPROJ    I       I*2                     0 - 20
C                           INDICATES SELECTED MAP PROJECTION
C                  ------------------------------------------------
C                  IZONE    I       I*2                    +INTEGER
C                           INDICATES UTM ZONE
C                  ------------------------------------------------
C                  IUNIT    I       I*2                    0-4 INTEGER
C                           INDICATES UNITS OF PROJECTION
C                            0 - RADIANS  1 - FEET  2 - METERS
C                            3 - SECONDS OF ARC  4 - DEGREES OF ARC
C                  ------------------------------------------------
C                  ELTYP    I       I*2          0,19       +INTE
C                           ELIPSOID TYPE
C                  ------------------------------------------------
C                  PRAMTR   DP      R*8          16        DBL PREC
C                           PARAMETERS DEFINING MAP PROJECTION
C                  ------------------------------------------------
C
C     FILES:  NONE
C
C     CALLING ROUTINE:
C
C     ROUTINES REQUIRED:  NONE
C
C     LANGUAGE DEPENDENCE:  FORTRAN
C
C************************************************************************
C
      SUBROUTINE PROVW(IOUT,IPROJ,IZONE,IUNIT,ELTYP,PRAMTR)
      INTEGER ELTYP
      DOUBLE PRECISION PRAMTR(15),CUM(5)
      DATA CUM/8HRADIANS ,8HFEET    ,8HMETERS  ,8HSECONDS ,8HDEGREES /
C
C**     BRANCH TO PROPER PROJECTION
C
      GO TO (9000,10000,10010,10020,10030,10040,10050,
     +       10060,10070,10090,10100,10110,10120,
     +       10130,10140,10150,10160,
     +       10170,10180,10190,10210) IPROJ + 1
      GO TO 85000
C
C
C       GEOGRAPHIC
9000  continue
c       WRITE(IOUT,91000)
c      WRITE(IOUT,99000)
99000 FORMAT('  # 0 PROJECTION IS GEOGRAPHIC(LON/LAT)')
C       WRITE(IOUT,91001) ELTYP,PRAMTR(1)
C       WRITE(IOUT,91002)PRAMTR(2)
      GO TO 90000
C
C       UNIVERSAL TRANSVERSE MERCATOR (UTM)
10000 CONTINUE                    
        WRITE(IOUT,91000)
        WRITE(IOUT,90001)
        WRITE(IOUT,92000) CUM(IUNIT+1)
        WRITE(IOUT,91001) ELTYP,PRAMTR(14)
        WRITE(IOUT,91002)PRAMTR(15)
        WRITE(IOUT,91011)IZONE
        WRITE(IOUT,90100)PRAMTR(1)
        WRITE(IOUT,90200)PRAMTR(2)
        GO TO 90000
C
C       STATE PLANE
10010 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90002)
        WRITE(IOUT,92000) CUM(IUNIT+1)
        WRITE(IOUT,91001) ELTYP,PRAMTR(1)
        WRITE(IOUT,91002)PRAMTR(2)
        WRITE(IOUT,91011)IZONE
        GO TO 90000
C
C       ALBERTS CONICAL EQUAL AREA
10020 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90003)
        WRITE(IOUT,92000) CUM(IUNIT+1)
20      WRITE(IOUT,91001) ELTYP,PRAMTR(1)
        WRITE(IOUT,91002)PRAMTR(2)
        WRITE(IOUT,91003)PRAMTR(3)
        WRITE(IOUT,91004)PRAMTR(4)
        WRITE(IOUT,91005)PRAMTR(5)
        WRITE(IOUT,91006)PRAMTR(6)
        WRITE(IOUT,91007)PRAMTR(7)
        WRITE(IOUT,91008)PRAMTR(8)
        GO TO 90000
C
C       LAMBERT CONFORMAL CONIC
10030 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90004)
        WRITE(IOUT,92000) CUM(IUNIT+1)
        GO TO 20
C
C       MERCATOR
10040 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90005)
        WRITE(IOUT,92000) CUM(IUNIT+1)
        WRITE(IOUT,91001) ELTYP,PRAMTR(1)
        WRITE(IOUT,91002)PRAMTR(2)
        WRITE(IOUT,91055)PRAMTR(5)
        WRITE(IOUT,91065) PRAMTR(6)
        WRITE(IOUT,91007)PRAMTR(7)
        WRITE(IOUT,91008)PRAMTR(8)
        GO TO 90000
C
C       POLAR STEREOGRAPHIC
10050 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90006)
        WRITE(IOUT,92000) CUM(IUNIT+1)
        WRITE(IOUT,91001) ELTYP,PRAMTR(1)
        WRITE(IOUT,91002)PRAMTR(2)
        WRITE(IOUT,91005)PRAMTR(5)
        WRITE(IOUT,91065)PRAMTR(6)
        WRITE(IOUT,91007)PRAMTR(7)
        WRITE(IOUT,91008)PRAMTR(8)
        GO TO 90000
C
C       POLYCONIC
10060 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90007)
        WRITE(IOUT,92000) CUM(IUNIT+1)
        WRITE(IOUT,91001) ELTYP,PRAMTR(1)
        WRITE(IOUT,91002)PRAMTR(2)
        WRITE(IOUT,91005)PRAMTR(5)
        WRITE(IOUT,91006)PRAMTR(6)
        WRITE(IOUT,91007)PRAMTR(7)
        WRITE(IOUT,91008)PRAMTR(8)
        GO TO 90000
C
C       EQUIDISTANT CONIC TYPES A & B
10070 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90008)
        WRITE(IOUT,92000) CUM(IUNIT+1)
          IF(PRAMTR(9).EQ.0.) WRITE(IOUT,10075)
          IF(PRAMTR(9).NE.0.) WRITE(IOUT,10080)
        WRITE(IOUT,91001) ELTYP,PRAMTR(1)
        WRITE(IOUT,91002)PRAMTR(2)
        WRITE(IOUT,91003)PRAMTR(3)
        IF (PRAMTR(9) .NE. 0.) WRITE(IOUT,91004)PRAMTR(4)
        WRITE(IOUT,91005)PRAMTR(5)
        WRITE(IOUT,91006)PRAMTR(6)
        WRITE(IOUT,91007)PRAMTR(7)
        WRITE(IOUT,91008)PRAMTR(8)
        GO TO 90000
C
C       TRANSVERSE MERCATOR
10090 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90009)
        WRITE(IOUT,92000) CUM(IUNIT+1)
        WRITE(IOUT,91001) ELTYP,PRAMTR(1)
        WRITE(IOUT,91002)PRAMTR(2)
        WRITE(IOUT,91035)PRAMTR(3)
        WRITE(IOUT,91005)PRAMTR(5)
        WRITE(IOUT,91006)PRAMTR(6)
        WRITE(IOUT,91007)PRAMTR(7)
        WRITE(IOUT,91008)PRAMTR(8)
        GO TO 90000
C
C       STEREOGRAPHIC
10100 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90010)
        WRITE(IOUT,92000) CUM(IUNIT+1)
100     WRITE(IOUT,91010)PRAMTR(1)
        WRITE(IOUT,91056)PRAMTR(5)
        WRITE(IOUT,91066)PRAMTR(6)
        WRITE(IOUT,91007)PRAMTR(7)
        WRITE(IOUT,91008)PRAMTR(8)
        GO TO 90000
C
C       LAMBERT AZIMUTHAL EQUAL AREA
10110 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90011)
        WRITE(IOUT,92000) CUM(IUNIT+1)
        GO TO 100
C
C       AZIMUTHAL EQUIDISTANT
10120 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90012)
        WRITE(IOUT,92000) CUM(IUNIT+1)
        GO TO 100
C
C       GNOMONIC
10130 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90013)
        WRITE(IOUT,92000)
        GO TO 100
C
C       ORTHOGRAPHIC
10140 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90014)
        WRITE(IOUT,92000) CUM(IUNIT+1)
        GO TO 100
C
C       GENERAL VERTICAL NEAR SIDE PERSPECTIVE
10150 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90015)
        WRITE(IOUT,92000) CUM(IUNIT+1)
        WRITE(IOUT,91010)PRAMTR(1)
        WRITE(IOUT,91036)PRAMTR(3)
        WRITE(IOUT,91056)PRAMTR(5)
        WRITE(IOUT,91066)PRAMTR(6)
        WRITE(IOUT,91007)PRAMTR(7)
        WRITE(IOUT,91008)PRAMTR(8)
        GO TO 90000
C
C       SINUSOIDAL
10160 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90016)
        WRITE(IOUT,92000) CUM(IUNIT+1)
160     WRITE(IOUT,91010)PRAMTR(1)
        WRITE(IOUT,91005)PRAMTR(5)
        WRITE(IOUT,91007)PRAMTR(7)
        WRITE(IOUT,91008)PRAMTR(8)
        GO TO 90000
C
C       EQUIRETANGULAR (PLATE COVER)
10170 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90017)
        WRITE(IOUT,92000) CUM(IUNIT+1)
        GO TO 160
C
C       MILLER CYLINDRICAL
10180 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90018)
        WRITE(IOUT,92000) CUM(IUNIT+1)
        GO TO 160
C
C       VAN DER GRINTEN I
10190 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90019)
        WRITE(IOUT,92000) CUM(IUNIT+1)
        GO TO 160
C
C       OBLIQUE MERCATOR (DEFINITION FORMAT A & B)
10210 CONTINUE
        WRITE(IOUT,91000)
        WRITE(IOUT,90020)
        WRITE(IOUT,92000) CUM(IUNIT+1)
          IF(PRAMTR(13).EQ.0.) WRITE(IOUT,90021)
          IF(PRAMTR(13).NE.0.) WRITE(IOUT,90022)
        WRITE(IOUT,91001) ELTYP,PRAMTR(1)
        WRITE(IOUT,91002)PRAMTR(2)
        WRITE(IOUT,91037)PRAMTR(3)
        IF (PRAMTR(13) .NE. 0.) WRITE(IOUT,91060)PRAMTR(4)
        IF (PRAMTR(13) .NE. 0.) WRITE(IOUT,91070)PRAMTR(5)
        WRITE(IOUT,91006)PRAMTR(6)
        WRITE(IOUT,91007)PRAMTR(7)
        WRITE(IOUT,91008)PRAMTR(8)
        IF (PRAMTR(13) .EQ. 0) WRITE(IOUT,91020)PRAMTR(9)
        IF (PRAMTR(13) .EQ. 0) WRITE(IOUT,91030)PRAMTR(10)
        IF (PRAMTR(13) .EQ. 0) WRITE(IOUT,91040)PRAMTR(11)
        IF (PRAMTR(13) .EQ. 0) WRITE(IOUT,91050)PRAMTR(12)
        GO TO 90000
C
C**     FORMATS
C
91000 FORMAT(/,9X,'MAP PROJECTION',/)
92000 FORMAT('      COORDINATE UNITS ARE: ',A8,/,
     +       ' VALUES OF ENTERED PARAMETERS',/,
     +       ' ----------------------------')
90001 FORMAT('  # 1 UNIVERSAL TRANSVERSE MERCATOR')
90002 FORMAT('  # 2 STATE PLANE')
90003 FORMAT('  # 3 ALBERTS CONICAL EQUAL AREA')
90004 FORMAT('  # 4 LAMBERT CONFORMAL CONIC')
90005 FORMAT('  # 5 MERCATOR')
90006 FORMAT('  # 6 POLAR STEREOGRAPHIC')
90007 FORMAT('  # 7 POLYCONIC')
90008 FORMAT('  # 8 EQUIDISTANT CONIC TYPE A & B')
90009 FORMAT('  # 9 TRANSVERSE MERCATOR')
90010 FORMAT('  # 10 STEREOGRAPHIC')
90011 FORMAT('  # 11 LAMBERT AZIMUTHAL')
90012 FORMAT('  # 12 AZIMUTHAL EQUIDISTANT')
90013 FORMAT('  # 13 GNOMONIC')
90014 FORMAT('  # 14 ORTHOGRAPHIC')
90015 FORMAT('  # 15 GENERAL VERTICAL NEAR SIDE PERSPECTIVE')
90016 FORMAT('  # 16 SINUSOIDAL')
90017 FORMAT('  # 17 EQUIRECTANGULAR (PLATE CARREE)')
90018 FORMAT('  # 18 MILLER CYLINDRICAL')
90019 FORMAT('  # 19 VAN DER GRINTEN I')
90020 FORMAT('  # 20 OBLIQUE MERCATOR')
90100 FORMAT( ' LONGITUDE',T45,F15.4)
90200 FORMAT( ' LATITUDE',T45,F15.4)
91011 FORMAT( ' ZONE',T45,I15)
91001 FORMAT( ' ELIPSOID SELECTED IS TYPE',T45,I15,/,
     +        ' SEMI-MAJOR AXIS OF ELLIPSOID',T45,F15.4)
91002 FORMAT( ' ECCENTRICITY SQUARED OF ELLIPSOID',T45,F15.4)
91003 FORMAT( ' LATITUDE OF 1ST STANDARD PARALLEL',T45,F15.4)
91035 FORMAT( ' SCALE FACTOR AT CENTRAL MERIDIAN',T45,F15.4)
91036 FORMAT( ' HEIGHT OF PERSPECTIVE POINT ABOVE SPHERE',T45,F15.4)
91037 FORMAT( ' SCALE FACTOR AT THE CENTER PROJECTION',T45,F15.4)
91004 FORMAT( ' LATITUDE OF 2ND STANDARD PARALLEL',T45,F15.4)
91005 FORMAT( ' LONGITUDE OF CENTRAL MERIDIAN',T45,F15.4)
91055 FORMAT( ' LONGITUDE DIRECTED STRAIGHT DOWN BELOW POLE',/,
     +        '  OF MAP',T45,F15.4)
91056 FORMAT( ' LONGITUDE OF CENTER PROJECTION',T45,F15.4)
91006 FORMAT( ' LATITUDE ORIGIN OF PROJECTION',T45,F15.4)
91065 FORMAT( ' LATITUDE OF TRUE SCALE',T45,F15.4)
91066 FORMAT( ' LATITUDE OF CENTER OF PROJECTIN',T45,F15.4)
91007 FORMAT( ' FALSE EASTING',T45,F15.4)
91008 FORMAT( ' FALSE NORTHING',T45,F15.4)
91009 FORMAT( ' ZERO')
91095 FORMAT( ' ANY NON-ZERO NUMBER')
91010 FORMAT( ' RADIUS OF THE SPHERE OF REFERENCE, IF LEFT',/,
     +        '  BLANK, THE VALUE 6370997.0 METERS IS',/,               
     +        '  ASSUMED',T45,F15.4)
91020 FORMAT( ' LONGITUDE OF 1ST POINT DEFINING CENTRAL',/,
     +        '  GEODETIC LINE OF PROJECTION',T45,F15.4)
91030 FORMAT( ' LATITUDE OF 1ST POINT DEFINING CENTRAL',/,
     +        '  GEODETIC LINE OF PROJECTION',T45,F15.4)
91040 FORMAT( ' LONGITUDE OF 2ND POINT DEFINING CENTRAL',/,
     +        '  GEODETIC LINE OF PROJECTION',T45,F15.4)
91050 FORMAT( ' LATITUDE OF 2ND POINT DEFINING CENTRAL',/,
     +        '  GEODETIC LINE OF PROJECTION',T45,F15.4)
91060 FORMAT( ' ANGLE OF AZIMUTH EAST OF NORTH FOR CENTRAL',/,
     +        '  LINE OF PROJECTION',T45,F15.4)
91070 FORMAT( ' LONGITUDE OF POINT ALONG CENTRAL LINE OF',/,
     +        '  PROJECTION AT WHICH ANGLE OF AZIMUTH IS',/,
     +        '  MEASURED',T45,F15.4)
10075 FORMAT(6X,' TYPE A',T45,F15.4)
10080 FORMAT(6X,' TYPE B',T45,F15.4)
90021 FORMAT(6X,' DEFINITION FORMAT A',T45,F15.4)
90022 FORMAT(6X,' DEFINITION FORMAT B',T45,F15.4)
C
C**     ERROR RETRUNS
C
85000  WRITE(IOUT,98500) PROJ
98500  FORMAT(' *PROVW  PROJECTION',I6,' NOT DEFINED  ERROR')
C
C**     JUMP OUT
C
90000 RETURN
      END
