C********************************************************************
C
C     NAME:  SUBROUTINE PROIN
C
C     FUNCTION:  ACCEPTS THE PARAMETERS REQUIRED FOR DEFINITION OF
C                A MAP PROJECTION.
C
C     PARAMETERS:  NAME     USE     TYPE     DIMENSION     RANGE
C                  ------------------------------------------------
C                  IIN      I       I*2                    +INTEGER
C                           CHANNEL TO INPUT FROM SCREEN
C                  ------------------------------------------------
C                  IOUT     I       I*2                    +INTEGER
C                           CHANNEL TO OUTPUT TO SCREEN
C                  ------------------------------------------------
C                  IA       I       I*2                     1,2
C                           1--CHANGING EXISTING PARAMETERS
C                           2--ENTERING NEW PARAMETERS
C                  ------------------------------------------------
C                  IPROJ    I       I*2                     0 - 20
C                           INDICATES SELECTED MAP PROJECTION
C                  ------------------------------------------------
C                  IZONE    I       I*2                     INTEGER
C                           INDICATES UTM OR STATE PLANE ZONE
C                  ------------------------------------------------
C                  IUNIT    I       I*2                     0-4 INTEGER
C                           INDICATES UNITS OF PROJECTION
C                            0 - RADIANS  1 - FEET  2 - METERS
C                            3 - SECONDS OF ARC  4 - DEGREES OF ARC
C                  ------------------------------------------------
C                  ELTYP    IP      I*2          0,19      ELIPSE TYPE
C                  ------------------------------------------------
C                           INDICATES ELIPSOID
C                  PRAMTR   DP      R*8          15        DBL PREC
C                           PARAMETERS DEFINING MAP PROJECTION
C                  ------------------------------------------------
C
C     FILES:  NONE
C
C     CALLING ROUTINE:
C
C     ROUTINES REQUIRED:  DMSIN--ACCEPTS USER INPUT OFDEGREES,MINUTES,& SECONDS
C                         UDIN---ACCEPTS DOUBLE PRECISION FROM USER
C                         UIIN---ACCEPTS INTEGER VALUE FROM USER
C                         SELELP-ACCEPTS ELIPSOID TYPE 0-19
C                         ELIPSE-COMPUTES ELIPSOID PARAMETERS
C
C     LANGUAGE DEPENDENCE:  FORTRAN
C
C************************************************************************
C
      SUBROUTINE PROIN(IIN,IOUT,IA,IPROJ,IZONE,IUNIT,ELTYP,PRAMTR)
      INTEGER ELTYP
      DOUBLE PRECISION PRAMTR(15)
      REAL DMS(3)
C
      IDUM = 0
      IB = ABS(IA)
C      IF (IA .GT. 0) GO TO 120
c      if(iproj.eq.0)then
c        write(*,*)' LAT/LONG is not valid in this version.'
c        write(*,*)' Select another projection.'
c      endif
C
C   SELECT MAP PROJECTION
C
100   WRITE(IOUT,80001)
80001 FORMAT(/,26X,'MAP PROJECTION MENU',//,
C     +  '  0 GEOGRAPHIC(LAT/LON)',/,
     +  '  1 UNIVERSAL TRANSVERSE MERCATOR  11 LAMBERT AZIMUTHAL',
     +  ' EQUAL AREA',/,
     +  '  2 STATE PLANE                    12 AZIMUTHAL EQUIDISTANT'/,
     +  '  3 ALBERS CONICAL EQUAL AREA      13 GNOMONIC',/,
     +  '  4 LAMBERT CONFORMAL CONIC        14 ORTHOGRAPHIC',/,
     +  '  5 MERCATOR                       15 VERTICAL NEAR SIDE',
     +  ' PERSPECTIVE',/,
     +  '  6 POLAR STEREOGRAPHIC            16 SINUSOIDAL',/,
     +  '  7 POLYCONIC                      17 EQUIRECTANGULAR',
     +  ' (PLATE CARREE)',/,
     +  '  8 EQUIDISTANT CONIC A & B        18 MILLER CYLINDRICAL',/,
     +  '  9 TRANSVERSE MERCATOR            19 VAN DER GRINTEN I',/,
     +' 10 STEREOGRAPHIC                  20 OBLIQUE MERCATOR (HOTINE)')
120    WRITE(IOUT,90120)
90120  FORMAT(/,' PROJECTION(1-20) '\)
C
       CALL UIIN(IIN,IOUT,I,IC)
       IF (IC .LT. 1  .AND.  IB .EQ. 1) GO TO 90000
       IF (IC .LT. 1  .AND.  IB .EQ. 2) GO TO 100
       IF (I .Le. 0  .OR. I .GT. 20) GO TO 100
       IPROJ = I
C
C**     CHANGING OR ENTERING  1- CHANGING  2- ENTERING
C
      IZONE = 32767
      IUNIT = 2
      DO 1 I=1,15
           PRAMTR(I)=0.0D0
1     CONTINUE
C
       IF (IB .EQ. 1) WRITE(IOUT,90200)
90200  FORMAT(/,' PLEASE RE-ENTER ALL VALUES',/)
C
C......GET ELIPSOID TYPE, THEN GET SEMI-MAJOR AXIS AND E**2
C......DON'T IF THIS IS A STEREOGRAPHIC.  IF UTM, PUT PARAMETERS
C......IN LOCATIONS 14 AND 15
        IF (IPROJ .EQ. 0) ELTYP = 0
        IF (IPROJ.GE.1 .AND. IPROJ.LE.9 .OR. IPROJ .EQ. 20)
     .        CALL SELELP (IIN,IOUT,IA,ELTYP,IER)
        IF (IPROJ.EQ.1) CALL ELIPSE (ELTYP,PRAMTR(15),PRAMTR(14),IER)
        IF (IPROJ.GE.2 .AND. IPROJ.LE.9 .OR. IPROJ .EQ. 20)
     .      CALL ELIPSE (ELTYP,PRAMTR(2),PRAMTR(1),IER)
C
      GO TO (9000,10000,10010,10020,10030,10040,10050,
     +       10060,10070,10090,10100,10110,10120,
     +       10130,10140,10150,10160,
     +       10170,10180,10190,10210)  IPROJ + 1
C
      GO TO 100
C
C       GEOGRAPHIC
9000  IZONE = 0
      IUNIT = 4
      GO TO 90000
C
C       UNIVERSAL TRANSVERSE MERCATOR (UTM)
10000 CONTINUE
        WRITE(IOUT,90010)
        CALL DMSIN(IIN, IOUT, DMS(1), PRAMTR(1), IC, IDUM)
        IZONE=IDINT( (186D0+PRAMTR(1))  / 6D0 )
        WRITE(IOUT,90020) IZONE
        CALL DMSIN(IIN, IOUT, DMS(1), PRAMTR(2), IC, IDUM)
        GO TO 90000
C
C       STATE PLANE
10010 CONTINUE
140    WRITE(IOUT,90140)
90140  FORMAT(/,' UNITS MENU',
     +        /,'  1 FEET',
     +        /,'  2 METERS'\)
       CALL UIIN(IIN,IOUT,IUNIT,IC)
       IF (IUNIT .LT. 1  .OR.  IUNIT .GT. 2) GO TO 140
        WRITE(IOUT,90012)
        CALL UIIN(IIN,IOUT,IZONE,IC)
        IF(IZONE.LT.3101.OR.IZONE.GT.6426) GO TO 10010
        I = IZONE - (IZONE/100*100)
        IF (I .EQ. 1  .OR.  I .EQ. 26  .OR.  I .EQ. 51  .OR.  I .EQ. 76)
     +           GO TO 90000
        GO TO 10010
C
C       ALBERTS CONICAL EQUAL AREA
10020 CONTINUE
        WRITE(IOUT,91003)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(3),IC,IDUM)
        WRITE(IOUT,91004)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(4),IC,IDUM)
        WRITE(IOUT,91005)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(5),IC,IDUM)
        WRITE(IOUT,91006)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(6),IC,IDUM)
        WRITE(IOUT,91007)
        CALL UDIN(IIN, IOUT,PRAMTR(7), IC)
        WRITE(IOUT,91008)
        CALL UDIN(IIN, IOUT,PRAMTR(8), IC)
        GO TO 90000
C
C       LAMBERT CONFORMAL CONIC
10030 CONTINUE
        GO TO 10020
C
C       MERCATOR
10040 CONTINUE
        WRITE(IOUT,91005)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(5),IC,IDUM)
        WRITE(IOUT,91065)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(6),IC,IDUM)
        WRITE(IOUT,91007)
        CALL UDIN(IIN,IOUT,PRAMTR(7),IC)
        WRITE(IOUT,91008)
        CALL UDIN(IIN,IOUT,PRAMTR(8),IC)
        GO TO 90000
C
C       POLAR STEREOGRAPHIC
10050 CONTINUE
        WRITE(IOUT,91055)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(5),IC,IDUM)
        WRITE(IOUT,91065)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(6),IC,IDUM)
        WRITE(IOUT,91007)
        CALL UDIN(IIN,IOUT,PRAMTR(7),IC)
        WRITE(IOUT,91008)
        CALL UDIN(IIN,IOUT,PRAMTR(8),IC)
        GO TO 90000
C
C       POLYCONIC
10060 CONTINUE
        WRITE(IOUT,91005)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(5),IC,IDUM)
        WRITE(IOUT,91006)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(6),IC,IDUM)
        WRITE(IOUT,91007)
        CALL UDIN(IIN,IOUT,PRAMTR(7),IC)
        WRITE(IOUT,91008)
        CALL UDIN(IIN,IOUT,PRAMTR(8),IC)
        GO TO 90000
C
C       EQUIDISTANCE CONIC TYPES A & B
10070 CONTINUE
            WRITE(IOUT,07)
07          FORMAT(' 1 EQUIDISTANCE CONIC TYPE A',/,
     +             ' 2 EQUIDISTANCE CONIC TYPE B'\)
            CALL UIIN(IIN,IOUT,ICHCE,IC)
            IF( ICHCE.EQ.1) GO TO 10075
            IF( ICHCE.EQ.2) GO TO 10080
            GO TO 10070
C
10075 CONTINUE
        WRITE(IOUT,91003)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(3),IC,IDUM)
        WRITE(IOUT,91005)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(5),IC,IDUM)
        WRITE(IOUT,91006)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(6),IC,IDUM)
        WRITE(IOUT,91007)
        CALL UDIN(IIN,IOUT,PRAMTR(7),IC)
        WRITE(IOUT,91008)
        CALL UDIN(IIN,IOUT,PRAMTR(8),IC)
        PRAMTR(9)=0.
        GO TO 90000
C
10080 CONTINUE
        WRITE(IOUT,91003)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(3),IC,IDUM)
        WRITE(IOUT,91004)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(4),IC,IDUM)
        WRITE(IOUT,91005)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(5),IC,IDUM)
        WRITE(IOUT,91006)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(6),IC,IDUM)
        WRITE(IOUT,91007)
        CALL UDIN(IIN,IOUT,PRAMTR(7),IC)
        WRITE(IOUT,91008)
        CALL UDIN(IIN,IOUT,PRAMTR(8),IC)
C       THIS IS A 'ENTER:ANY NON-ZERO #' ROUTINE
        PRAMTR(9)=-1.
        GO TO 90000
C
C       TRANSVERSE MERCATOR
10090 CONTINUE
        WRITE(IOUT,91035)
        CALL UDIN(IIN,IOUT,PRAMTR(3),IC)
        WRITE(IOUT,91005)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(5),IC,IDUM)
        WRITE(IOUT,91006)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(6),IC,IDUM)
        WRITE(IOUT,91007)
        CALL UDIN(IIN,IOUT,PRAMTR(7),IC)
        WRITE(IOUT,91008)
        CALL UDIN(IIN,IOUT,PRAMTR(8),IC)
        GO TO 90000
C
C       STEREOGRAPHIC
10100 CONTINUE
        WRITE(IOUT,91010)
        CALL UDIN(IIN,IOUT,PRAMTR(1),IC)
        WRITE(IOUT,91056)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(5),IC,IDUM)
        WRITE(IOUT,91066)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(6),IC,IDUM)
        WRITE(IOUT,91007)
        CALL UDIN(IIN,IOUT,PRAMTR(7),IC)
        WRITE(IOUT,91008)
        CALL UDIN(IIN,IOUT,PRAMTR(8),IC)
        IF (PRAMTR(1) .EQ. 0.) PRAMTR(1) = 6370997.
        GO TO 90000
C
C       LAMBERT AZIMUTHAL EQUAL AREA
10110 CONTINUE
        GO TO 10100
C
C       AZIMUTHAL EQUIDISTANT
10120 CONTINUE
        GO TO 10100
C
C       GNOMONIC
10130 CONTINUE
        GO TO 10100
C
C       ORTHOGRAPHIC
10140 CONTINUE
        GO TO 10100
C
C       GENERAL VERTICAL NEAR SIDE PERSPECTIVE
10150 CONTINUE
        WRITE(IOUT,91010)
        CALL UDIN(IIN,IOUT,PRAMTR(1),IC)
        WRITE(IOUT,91036)
        CALL UDIN(IIN,IOUT,PRAMTR(3),IC)
        WRITE(IOUT,91056)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(5),IC,IDUM)
        WRITE(IOUT,91066)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(6),IC,IDUM)
        WRITE(IOUT,91007)
        CALL UDIN(IIN,IOUT,PRAMTR(7),IC)
        WRITE(IOUT,91008)
        CALL UDIN(IIN,IOUT,PRAMTR(8),IC)
       IF (PRAMTR(1) .EQ. 0.0) PRAMTR(1) = 6370997.
        GO TO 90000
C
C       SINUSOIDAL
10160 CONTINUE
        WRITE(IOUT,91010)
        CALL UDIN(IIN,IOUT,PRAMTR(1),IC)
        WRITE(IOUT,91005)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(5),IC,IDUM)
        WRITE(IOUT,91007)
        CALL UDIN(IIN,IOUT,PRAMTR(7),IC)
        WRITE(IOUT,91008)
        CALL UDIN(IIN,IOUT,PRAMTR(8),IC)
        IF (PRAMTR(1) .EQ. 0.0) PRAMTR(1) = 6370997.
        GO TO 90000
C
C       EQUIRETANGULAR (PLATE COVER)
10170 CONTINUE
        GO TO 10160
C
C       MILLER CYLINDRICAL
10180 CONTINUE
        GO TO 10160
C
C       VAN DER GRINTEN I
10190 CONTINUE
        GO TO 10160
C
C       OBLIQUE MERCATOR (DEFINITION FORMAT A & B)
10210 CONTINUE
        WRITE(IOUT,08)
08      FORMAT( ' 1 OBLIQUE MERCATOR (FORMAT A)',/,
     +          ' 2 OBLIQUE MERCATOR (FORMAT B)',\)
        CALL UIIN (IIN,IOUT,ICHCE,IC)
        IF( ICHCE.EQ.1) GO TO 10215
        IF( ICHCE.EQ.2) GO TO 10220
        GO TO 10210
C
10215 CONTINUE
        CALL UDIN(IIN,IOUT,PRAMTR(3),IC)
        WRITE(IOUT,91006)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(6),IC,IDUM)
        WRITE(IOUT,91007)
        CALL UDIN(IIN,IOUT,PRAMTR(7),IC)
        WRITE(IOUT,91008)
        CALL UDIN(IIN,IOUT,PRAMTR(8),IC)
        WRITE(IOUT,91020)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(9),IC,IDUM)
        WRITE(IOUT,91030)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(10),IC,IDUM)
        WRITE(IOUT,91040)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(11),IC,IDUM)
        WRITE(IOUT,91050)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(12),IC,IDUM)
C       THIS IS A 'ENTER:ZERO' ROUTINE
        PRAMTR(13)=0.
        GO TO 90000
C
10220 CONTINUE
        CALL UDIN(IIN,IOUT,PRAMTR(3),IC)
        WRITE(IOUT,91060)
        CALL UDIN(IIN,IOUT,PRAMTR(4),IC)
        WRITE(IOUT,91070)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(5),IC,IDUM)
        WRITE(IOUT,91006)
        CALL DMSIN (IIN,IOUT,DMS(1),PRAMTR(6),IC,IDUM)
        WRITE(IOUT,91007)
        CALL UDIN(IIN,IOUT,PRAMTR(7),IC)
        WRITE(IOUT,91008)
        CALL UDIN(IIN,IOUT,PRAMTR(8),IC)
C       THIS IS A 'ENTER:ANY NON-ZERO #' ROUTINE
        PRAMTR(13)=-1.
        GO TO 90000
C
C
C**     FORMATS
C
90010 FORMAT( ' LONGITUDE OF ANY POINT WITHIN THE UTM ZONE '\)
90020 FORMAT( ' LATITUDE OF ANY POINT WITHIN UTM ZONE',I5,' '\)
90012 FORMAT( ' STATE PLANE ZONE(3101-6426) '\)
91003 FORMAT( ' LATITUDE OF 1ST STANDARD PARALLEL '\)
91035 FORMAT( ' SCALE FACTOR AT CENTRAL MERIDIAN '\)
91036 FORMAT( ' HEIGHT OF PERSPECTIVE POINT ABOVE SPHERE '\)
91037 FORMAT( ' SCALE FACTOR AT CENTER OF THE PROJECTION '\)
91004 FORMAT( ' LATITUDE OF 2ND STANDARD PARALLEL '\)
91005 FORMAT( ' LONGITUDE OF CENTRAL MERIDIAN '\)
91055 FORMAT( ' LONGITUDE DIRECTED STRAIGHT DOWN BELOW POLE '\)
91056 FORMAT( ' LONGITUDE OF CENTER PROJECTION '\)
91006 FORMAT( ' LATITUDE ORIGIN OF PROJECTION '\)
91065 FORMAT( ' LATITUDE OF TRUE SCALE '\)
91066 FORMAT( ' LATITUDE OF CENTER OF PROJECTION '\)
91007 FORMAT( ' ENTER FALSE EASTING IN SAME UNITS OF MEASURE',/,
     .        ' AS THE SEMI-MAJOR AXIS OF ELLIPSOID'\)
91008 FORMAT( ' ENTER FALSE NORTHING IN SAME UNITS OF MEASURE',/,
     .        ' AS THE SEMI-MAJOR AXIS OF ELLIPSOID'\)
91010 FORMAT( ' RADIUS OF THE SPHERE OF REFERENCE ?  IF LEFT',/,
     +        ' BLANK, 6370997.0 METERS IS ASSUMED.'\)
91020 FORMAT( ' LONGITUDE OF 1ST POINT DEFINING CENTRAL',/,
     +        ' GEODETIC LINE OF PROJECTION '\)
91030 FORMAT( ' LATITUDE OF 1ST POINT DEFINING CENTRAL',/,
     +        ' GEODETIC LINE OF PROJECTION '\)
91040 FORMAT( ' LONGITUDE OF 2ND POINT DEFINING CENTRAL',/,
     +        ' GEODETIC LINE OF PROJECTION '\)
91050 FORMAT( ' LATITUDE OF 2ND POINT DEFINING CENTRAL',/,
     +        ' GEODETIC LINE OF PROJECTION '\)
91060 FORMAT( ' ANGLE OF AZIMUTH EAST OF NORTH FOR CENTRAL',/,
     +        ' LINE OF PROJECTION '\)
91070 FORMAT( ' LONGITUDE OF POINT ALONG CENTRAL LINE OF',/,
     +        ' PROJECTION WHERE ANGLE OF AZIMUTH IS MEASURED '\)
C
C**     JUMP OUT
C
90000 RETURN
      END
