C************************************************************************
C
C  NAME:  ROUTINE MCONTPR
C
C  FUNCTION:  PROCESSOR FOR CONTOUR COMMAND WHICH GENERATES A LINE-DRAWING
C             OF A CONTINUOUS MAP BY TRACING LINES TO CONNECT THOSE CELLS
C             OF EQUAL ELEVATIONS WHICH LIE ON CONTOUR INTERVALS.
C******************************************************************************
C
      subroutine     mcontpr(idd,iddt,iddr,ier)
c
      COMMON /IO/     NPRNT,IOIN
      COMMON /STRNG/  ICARD(80),ICARDP,LENICD
      COMMON /TYPE/   IDATYP(40),NACTS
      COMMON /FLS/    IUNIT,IFILE(5)
      COMMON /WORK/   IBUFF(128),MAP(25),ICOM(10),JCOM(10)
      COMMON /CLINES/ ICLINE, IBATCH
      COMMON /DSBUF/  MLEN,IDATA(8192)
      common/intrvl/ ci(20),smin(20),smax(20)
      COMMON /MLOCAL/  NRWCOL(4),NROWS,NCOLS,NBYTES,LEN,ICHAN,INTRVL,
     +                WNDW(4)
      INTEGER*4 NREC
      INTEGER*2 pass1,pass2,MAPX(25),mapname(25)
      LOGICAL OK, LTIME
      EQUIVALENCE ( IBUFF(88),VMIN ),( IBUFF(90),VMAX )
      IBLNK = 8224
      MLEN  = 8192
      ICHAN = 15
C
      CALL SETWND
      CALL WHWND(WNDW(1),WNDW(2),WNDW(3),WNDW(4))
      IF (WNDW(3)-WNDW(1).EQ.0. .OR. WNDW(4)-WNDW(2).EQ.0.) GO TO 80100
C
C.......ACTIVE ID PLACED IN ICARD(80), LINE COUNTER IN ICARD(79)
C
C.......GET MAP NAME FROM STRUCTURE TABLE AND OPEN IT
        call gtnam(IDD,5,IBLNK,MAP,IER)
        call adddir(map,mapname)
        call openf(ICHAN,MAPname,1,256,2,IER)
        IF(IER.NE.0) GO TO 80400
C
C.......READ MAP HEADER AND CLOSE
        NREC = 2
        IRECL = 256
        call rdblk(ICHAN,NREC,IBUFF,1,IER)
        IF(IER .NE. 0) GO TO 80160
c        LEN = GTBYT(IBUFF(57),1)
        pass2 = 0
        ione = 1
        pass1 = ibuff(57)
        CALL   GTB( PASS2, PASS1, IONE )
        len = pass2
C
        NREC = 1
        call rdblk(ICHAN,NREC,IBUFF,1,IER)
        IF(IER .NE. 0) GO TO 80160
        CLOSE(ICHAN,IOSTAT=IIER)
C
C.......BIT OR WORD
        IB = 2
        IF (LEN .GE. 16) IB = 1
        IF (IB .EQ. 1)  LEN = LEN/16
        IF (IB .EQ. 2) LEN = 0
        IDDT  = IBUFF(62)
        NROWS = IBUFF(60)
        NCOLS = IBUFF(61)
C
C.......GET CORRECT SUFFFIX ON MAPname AND OPEN IT
        call gtnam(IDD,IDDT,IBLNK,MAP,IER)
        IF (IER .NE. 0) GO TO 80400
        NBYTES = NCOLS * 2 * LEN
        IF(NBYTES .EQ. 0) NBYTES = 1
        call adddir(map,mapname)
        CALL DSOPN(ICHAN,MAPname,1,1,1,LEN,128,IER)
        IF(IER .NE. 0) GO TO 80350
C
C.......DISPLAY MIN AND MAX ELEVATIONS AND GET CONTOURING INTERVAL
    2   INTRVL = 0
c        WRITE(NPRNT,90002) VMIN,VMAX
c90002   FORMAT(' Map minimum',F13.4,' maximum',F13.4,/
c     +    ' Enter contouring interval [, Minimum, Maximum ] '\)
c        call readin(ICARD,80,ICARDP,LENICD)
c        CALL INUM(ICARD,INTRVL,ICARDP)
         intrvl=ci(iddr)
C
C.......LOOK FOR USER SPECIFIED MINIMUM - BE CAREFUL OF "0.0" VERSES RETURN
C.......IF K = KK THEN ONLY A SPACE FOLLOWED INTERVAL, NOT "0"
c        KK = ICARDP + 1
c        CALL FNUM(ICARD,80,WMIN,ICARDP)
        wmin=smin(iddr)
        IF ( WMIN.EQ.0.0 .OR. WMIN.GT.VMIN/2. )
     +        WMIN = VMIN
C
C.......LOOK FOR USER SPECIFIED MAXIMUM - BE CAREFUL OF "0.0" VERSES RETURN
C.......IF K = KK THEN ONLY A SPACE FOLLOWED INTERVAL, NOT "0"
C        KK = ICARDP + 1
C        CALL FNUM(ICARD,80,WMAX,ICARDP)
         wmax=smax(iddr)
        IF ( WMAX.EQ.0.0 .OR. WMAX.LT.VMAX/2. )
     +        WMAX = VMAX
        LINES=LINES+2
        IF (INTRVL .GT. 0) GO TO 3
        WRITE(NPRNT,90003)IBEL,INTRVL
90003   FORMAT(A2,' NOT A REASONABLE INTERVAL - ',I5)
        LINES=LINES+1
        GO TO 2
C
C.......REPLACE MAPS MIN AND MAX WITH USER SPECIFED VALUES
    3 CONTINUE
      IF ( WMIN.GE.VMIN .AND. WMIN.LE.VMAX ) VMIN = WMIN
      IF ( WMAX.GE.VMIN .AND. WMAX.LE.VMAX ) VMAX = WMAX
C
C.....START PLOTTING ....
C  TASK AND CONSOLE MONITOR
C
       CALL CONPLT
C
C
C.....CLOSE THE GRAPHICS DEVICE ......
      call flsh
    8 continue
C
C.....CLOSE TYPE 8 MAP ......
      CALL DSCLS (ICHAN,IER)
      IF (IER .NE. 0)  GO TO 80700
C
C.....NORMAL RETURN ......
      GO TO 90000
C
C.....ERROR RETURN .......
C
80100 CONTINUE
      WRITE (NPRNT,98101)
98101 FORMAT (' *MCONTPR* ERROR WITH WINDOW')
      GO TO 90000
C
80150 CONTINUE
      WRITE(NPRNT,98151) IUNIT,IFILE
98151 FORMAT(' *MCONTPR* ERROR OPENING UNIT',I3,', ',5A2)
      GO TO 90000
C
80160 CONTINUE
      WRITE(NPRNT,98161) NREC,IER
98161 FORMAT(' *MCONTPR* rdblk ERROR READING REC',I3,' ERROR ',I5)
      GO TO 90000
C
80300 CONTINUE
      WRITE (NPRNT,98301) IDD, IDDT
98301 FORMAT (' *MCONTPR* ERROR WRONG DATA TYPE ',2I5)
      GO TO 90000
C
80350 CONTINUE
      WRITE(NPRNT,98351)ICHAN,NBYTES,LEN,MAP
98351 FORMAT(' *MCONTPR* ERROR DSOPN - ICHAN,NBYTES,LEN,MAP =',3I5,2X,
     +        5A2)
      GO TO 90000
C
80400 CONTINUE
      WRITE (NPRNT,98401) MAP, IER
98401 FORMAT (' *MCONTPR* ERROR ACCESSING MAP ',5A2,' = ',I5)
      GO TO 90000
C
80700 CONTINUE
C      CALL GETERR (IER)
      WRITE (NPRNT,98701)  IER
98701 FORMAT (' *MCONTPR* ERROR FROM DSCLS',I5)
C
C.....RETURN ......
90000 CONTINUE
      END
