      SUBROUTINE jkgtls(iunit,ir,chrid,loc,x,chia,m,ierr)
C***
C***  REPLACES SUBROUTINES PUTLST AND GETLST FROM MULTICS.
C***  THIS MODULE WAS WRITTEN BY J. O. KORK, USGS, DENVER AND
C***  MODIFIED AND COMMENTED BY W. D. GRUNDY.
C***  ADAPTED FOR DG BY GEORGE W. HEINE, 1985.
C***
C***  NOTE: THE STATPAC FILES CREATED BY THESE SUBPROGRAMS ARE NOT
C***  COMPATIBLE WITH STATPAC FILES CREATED BY THE ORIGINAL
C***  SUBROUTINES PUTLST AND GETLST, BECAUSE OF DIFFERING WAYS
C***  IN WHICH THE QUALIFYING CODES ARE PACKED.
C***
C***  THIS ROUTINE READS ONE STATPAC RECORD AND UNPACKS THE QUALIFY-
C***  ING CODES.
C***
C***  ARGUMENTS
C***   IUNIT  - INPUT UNIT NO.
C***   IR     - SEQUENCE NUMBER OF THE ROW.
C***   CHRID  - 4-WORD ALPHAMERIC ROW IDENTIFIER AS 2 PARTS
C***            WORDS 1&2- PRIMARY ROW ID
C***                  3&4- SECONDARY ROW ID
C***   LOC    - LATITUDE AND LONGITUDE FOUR-BYTE INTEGERS
C***            OF DEGREES, MINUTES, AND SECONDS.
C***   X      - ARRAY OF DATA VALUES.
C***   CHIA   - ARRAY OF ONE-CHARACTER ALPHABETIC QUALIFYING
C***            CODES.
C***   M      - NUMBER OF STATPAC DATA COLUMNS IN THE DATA SET.
C***   IERR   - NON-ZERO RETURN FLAGS UNEXPECTED END OF FILE.
C***
C***       CONTENTS
C***      NO. NAME       DESCRIPTION
C***       1. JKGTLS   - READS A STATPAC RECORD FROM A FILE
C***       2. JKGET    - (USED BY GETLST)
C***       3. JKPACK   - (USED BY JKPTLS)
C***       4. JKPTLS   - WRITES ONE STATPAC RECORD INTO A FILE
C***       5. JKPUT    - (USED BY JKPTLS)
C***       6. JKUNPK   - (USED BY JKGTLS)
C***
C
      INTEGER*4 loc
      INTEGER*2 ir , iy
      DIMENSION loc(2) , x(200) , iy(99)
      CHARACTER*4 chrid(4)
      CHARACTER*1 chia(m)
C
      ierr = 0
      n = (m+4)/5
      CALL jkget(iunit,ir,chrid,loc,x,m,iy,n,iend,ierr)
      CALL jkunpk(chia,m,iy,n)
      IF ( iend.EQ.1 ) ierr = 0
      RETURN
      END
